package aa14a.ui.portal;

import javax.servlet.http.HttpServlet;

import aa14a.ui.servlet.AA14CalendarPrintServlet;
import aa14a.ui.servlet.AA14ControllerServlet;
import aa14a.ui.servlet.AA14ModelObjectsLoadServlet;
import r01f.locale.Language;
import r01f.util.types.Strings;
import r01hp.portal.appembed.R01HPortalPageAppEmbedContextDefaults;
import r01hp.portal.appembed.R01HPortalPageAppEmbedServletFilter;
import r01hp.portal.appembed.config.R01HPortalPageAppEmbedServletFilterConfig;
import r01hp.portal.common.R01HPortalOIDs.R01HPortalID;
import r01hp.portal.common.R01HPortalOIDs.R01HPortalPageID;

public class AA14AppEmbedServletFilter
     extends R01HPortalPageAppEmbedServletFilter {
/////////////////////////////////////////////////////////////////////////////////////////
//    CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
    public AA14AppEmbedServletFilter() {
        super(_createAppEmbedConfig());
        // optionally set the portal page loader 
        // ..by default the filesystem page loader is used
        //   where:
        //		- pages working copy root path: /datos/r01hp/file/aplic/
        //		- pages live copy path root path: /datos/r01hp/file/aplic/
        //		- container pages rel path: /html/pages/portal
    }
/////////////////////////////////////////////////////////////////////////////////////////
//    
/////////////////////////////////////////////////////////////////////////////////////////
    private static R01HPortalPageAppEmbedServletFilterConfig _createAppEmbedConfig() {
    	R01HPortalID defPortal = R01HPortalID.forId("web01");
    	R01HPortalPageID defPage = R01HPortalPageID.forId("ejeduki");
    	Language defLang = Language.DEFAULT;
    	R01HPortalPageAppEmbedContextDefaults defs = new R01HPortalPageAppEmbedContextDefaults(defPortal,defPage,defLang,
                                                                                               "r01hpPortalCookie");
        return new R01HPortalPageAppEmbedServletFilterConfig(defs)
                                // not portal-page embedded urls
                                .withNotPortalEmbeddedUrlPatterns(_notPortalEmbeddedUrlPatternFor(AA14ControllerServlet.class),
                                								  _notPortalEmbeddedUrlPatternFor(AA14CalendarPrintServlet.class),
                                                                  _notPortalEmbeddedUrlPatternFor(AA14ModelObjectsLoadServlet.class));
    }
    private static <S extends HttpServlet> String _notPortalEmbeddedUrlPatternFor(final Class<S> servletType) {
    	return Strings.customized("^/aa14aUIWar/{}/?.*",
    							  servletType.getSimpleName());
    }
}
