<%@ page pageEncoding="UTF-8" %>

<%@page import="com.google.inject.Injector"%>
<%@page import="com.google.common.base.Function"%>
<%@page import="r01f.locale.Language"%>
<%@page import="r01f.util.types.locale.Languages"%>
<%@page import="r01f.util.types.Strings"%>
<%@page import="aa14f.model.oids.AA14IDs.AA14ScheduleID" %>

<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>

<%
    // Get the injector
	Injector injector = (Injector)pageContext.getServletContext()
    									     .getAttribute(Injector.class.getName());

	// Get the api
	AA14ClientAPI api = injector.getInstance(AA14ClientAPI.class);

	// Get the language
	String langStr = request.getParameter("lang");
	
	if (Strings.isNullOrEmpty(langStr)) {
		langStr = Languages.getLocale(Language.DEFAULT).getLanguage();	
	}
	
	Language lang = Languages.fromLanguageCode(langStr);
						
	String langCode = Languages.language(lang);
	
	// Set requests attributes
	request.setAttribute("lang",lang);
	request.setAttribute("langCode",langCode);
	
	// authenticated (see instance aa14aGlobal.inc)		
	boolean authenticated = false;
	boolean hasScheduleAccess = false;
%>

<%-- language resource bundle: aa14a_{lang}.properties --%>
<fmt:setLocale value="<%= Languages.getLocale(lang) %>" />
<fmt:setBundle basename="aa14a" />