/*
 * Decompiled with CFR 0.152.
 */
package w11.com.ejie.y31.util.trace.manager;

import com.ejie.y31.exception.Y31JanoServiceMongoDbGenericException;
import com.ejie.y31.exception.Y31JanoServiceOracleGenericException;
import com.ejie.y31.vo.Y31JanoServiceTrace;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import w11.com.ejie.y31.util.trace.manager.Y31JanoServiceOracleDBConnectionManager;

public class Y31JanoServiceOracleTrazeCRUDManager {
    private static String TABLE_TRACES = "Y31OracleTrace";

    private static String buildQuery(Connection connection, Y31JanoServiceTrace item, int limit, int offset) {
        Boolean where = false;
        StringBuffer query = new StringBuffer();
        int desde = (offset - 1) * limit + 1;
        int hasta = offset * limit;
        query.append("SELECT * FROM ( SELECT a.*, ROWNUM r  FROM ( SELECT * FROM " + TABLE_TRACES);
        if (item.getOperationType() != null && !item.getOperationType().equals("Todos")) {
            if (!where.booleanValue()) {
                query.append(" WHERE ");
                where = true;
            } else {
                query.append(" AND ");
            }
            query.append("operationType").append(" LIKE '%" + item.getOperationType().toLowerCase() + "%'");
        }
        if (item.getPathFrom() != null && !item.getPathFrom().equals("")) {
            if (!where.booleanValue()) {
                query.append(" WHERE ");
                where = true;
            } else {
                query.append(" AND ");
            }
            query.append("pathFrom").append(" LIKE '%" + item.getPathFrom() + "%'");
        }
        if (item.getPathTo() != null && !item.getPathTo().equals("")) {
            if (!where.booleanValue()) {
                query.append(" WHERE ");
                where = true;
            } else {
                query.append(" AND ");
            }
            query.append("pathTo").append(" LIKE '%" + item.getPathTo() + "%'");
        }
        if (item.getSize() != -1L) {
            if (!where.booleanValue()) {
                query.append(" WHERE ");
                where = true;
            } else {
                query.append(" AND ");
            }
            query.append("sizez").append(" >= ").append(item.getSize());
        }
        if (item.getTstart() != -1L && item.getTend() != -1L) {
            if (!where.booleanValue()) {
                query.append(" WHERE ");
                where = true;
            } else {
                query.append(" AND ");
            }
            query.append("(tstart").append(" BETWEEN " + item.getTstart() + " AND " + item.getTend() + ")");
        } else if (item.getTstart() != -1L) {
            if (!where.booleanValue()) {
                query.append(" WHERE ");
                where = true;
            } else {
                query.append(" AND ");
            }
            query.append("tstart").append(" >= ").append(item.getTstart());
        } else if (item.getTend() != -1L) {
            if (!where.booleanValue()) {
                query.append(" WHERE ");
                where = true;
            } else {
                query.append(" AND ");
            }
            query.append("tstart").append(" <= ").append(item.getTend());
        }
        if (item.getDuration() != -1L) {
            if (!where.booleanValue()) {
                query.append(" WHERE ");
                where = true;
            } else {
                query.append(" AND ");
            }
            query.append("duration").append(" >= ").append(item.getDuration());
        }
        if (item.getTtl() != -1L) {
            if (!where.booleanValue()) {
                query.append(" WHERE ");
                where = true;
            } else {
                query.append(" AND ");
            }
            query.append("ttl").append(" >= ").append(item.getTtl());
        }
        if (item.getFileOriginalName() != null && !item.getFileOriginalName().equals("")) {
            if (!where.booleanValue()) {
                query.append(" WHERE ");
                where = true;
            } else {
                query.append(" AND ");
            }
            query.append("name").append(" LIKE '%" + item.getFileOriginalName() + "%'");
        }
        if (item.isSuccess() != null) {
            if (!where.booleanValue()) {
                query.append(" WHERE ");
                where = true;
            } else {
                query.append(" AND ");
            }
            query.append("success").append(" = '" + String.valueOf(item.isSuccess() == false) + "'");
        }
        if (item.getErrorMessage() != null && !item.getErrorMessage().equals("")) {
            if (!where.booleanValue()) {
                query.append(" WHERE ");
                where = true;
            } else {
                query.append(" AND ");
            }
            query.append("errorMessage").append(" LIKE '%" + item.getErrorMessage() + "%'");
        }
        if (item.getImplType() != null && !item.getImplType().equals("Todos")) {
            if (!where.booleanValue()) {
                query.append(" WHERE ");
                where = true;
            } else {
                query.append(" AND ");
            }
            query.append("implType").append(" = '" + item.getImplType().toLowerCase() + "'");
        }
        if (item.getOriginId() != null && !item.getOriginId().equals("")) {
            if (!where.booleanValue()) {
                query.append(" WHERE ");
                where = true;
            } else {
                query.append(" AND ");
            }
            query.append("originId").append(" LIKE '%" + item.getOriginId() + "%'");
        }
        query.append(" ORDER BY tstart DESC");
        query.append(") a WHERE ROWNUM <= ").append(hasta).append(") ");
        query.append("WHERE r >= ").append(desde);
        return query.toString();
    }

    public static void insert(Y31JanoServiceTrace item) throws Y31JanoServiceOracleGenericException {
        String a7;
        String a6;
        String a5;
        String a4;
        String a3;
        String a2;
        Connection connection = null;
        String a1 = item.getOperationType();
        if (a1 != null) {
            a1 = "'" + a1 + "'";
        }
        if ((a2 = item.getPathFrom()) != null) {
            a2 = "'" + a2 + "'";
        }
        if ((a3 = item.getPathTo()) != null) {
            a3 = "'" + a3 + "'";
        }
        if ((a4 = item.getFileOriginalName()) != null) {
            a4 = "'" + a4 + "'";
        }
        if ((a5 = item.getImplType()) != null) {
            a5 = "'" + a5 + "'";
        }
        if ((a6 = item.getErrorMessage()) != null) {
            a6 = "'" + a6 + "'";
        }
        if ((a7 = item.getOriginId()) != null) {
            a7 = "'" + a7 + "'";
        }
        String querySIII = "INSERT INTO " + TABLE_TRACES + " (" + "operationType, pathFrom, pathTo, sizez, tstart, tend, duration, ttl, name, implType, success, errorMessage, originId" + ") VALUES (" + a1 + ", " + a2 + ", " + a3 + "," + item.getSize() + " ," + item.getTstart() + " ," + item.getTend() + " ," + item.getDuration() + " ," + item.getTtl() + " , " + a4 + ", " + a5 + ", '" + String.valueOf(item.isSuccess()) + "', " + a6 + ", " + a7 + ")";
        try {
            connection = Y31JanoServiceOracleDBConnectionManager.getConnection();
            Statement st = connection.createStatement();
            st.execute(querySIII);
            st.close();
            connection.close();
        }
        catch (SQLException e) {
            System.out.println("Y31JanoServiceOracleTrazeCRUDManager - insert: " + e.getMessage());
            throw new Y31JanoServiceOracleGenericException((Throwable)e);
        }
        catch (Y31JanoServiceOracleGenericException e) {
            System.out.println("Y31JanoServiceOracleTrazeCRUDManager - insert: " + e.getMessage());
            throw new Y31JanoServiceOracleGenericException((Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new Y31JanoServiceOracleGenericException((Throwable)e);
                }
            }
        }
    }

    public static List<Y31JanoServiceTrace> findByExample(Y31JanoServiceTrace item, int limit, int offset, String orderBy) throws Y31JanoServiceOracleGenericException {
        ArrayList<Y31JanoServiceTrace> result = new ArrayList<Y31JanoServiceTrace>();
        Connection connection = null;
        ResultSet rs = null;
        try {
            connection = Y31JanoServiceOracleDBConnectionManager.getConnection();
            String query = Y31JanoServiceOracleTrazeCRUDManager.buildQuery(connection, item, limit, offset);
            PreparedStatement pstmt = connection.prepareStatement(query.toString());
            rs = pstmt.executeQuery(query.toString());
            StringTokenizer st = null;
            String originId = "";
            while (rs.next()) {
                Y31JanoServiceTrace trace = new Y31JanoServiceTrace();
                trace.setOperationType(rs.getString("operationType"));
                trace.setPathFrom(rs.getString("pathFrom"));
                trace.setPathTo(rs.getString("pathTo"));
                trace.setSize(Long.valueOf(rs.getLong("sizez")));
                trace.setTstart(rs.getLong("tstart"));
                trace.setTend(rs.getLong("tend"));
                trace.setDuration(rs.getLong("duration"));
                trace.setTtl(Long.valueOf(rs.getLong("ttl")));
                trace.setFileOriginalName(rs.getString("name"));
                trace.setImplType(rs.getString("implType"));
                trace.setSuccess(Boolean.valueOf(rs.getString("success")));
                trace.setErrorMessage(rs.getString("errorMessage"));
                st = new StringTokenizer(rs.getString("originId"), ":");
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    originId = new String(st.nextToken());
                }
                trace.setOriginId(st.nextToken());
                originId = null;
                result.add(trace);
            }
            connection.close();
        }
        catch (Y31JanoServiceOracleGenericException e) {
            System.out.println("Y31JanoServiceOracleTrazeCRUDManager - findByExample: " + e.getMessage());
            throw e;
        }
        catch (SQLException e) {
            System.out.println("Y31JanoServiceOracleTrazeCRUDManager - findByExample: " + e.getMessage());
            throw new Y31JanoServiceOracleGenericException((Throwable)e);
        }
        return result;
    }

    public static void main(String[] args) throws Y31JanoServiceMongoDbGenericException {
    }
}

