/*
 * Decompiled with CFR 0.152.
 */
package w11.com.ejie.y31.util.events.manager;

import com.ejie.y31.exception.Y31JanoServiceTraceJmsException;
import com.ejie.y31.vo.Y31JanoServiceTrace;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class Y31JanoServiceTraceJMSMangerWL11 {
    private static String QUEUE_TRACE_PROVIDER_URL = "t3://wl11mngd35.ejiedes.net:7039,wl11mngd36.ejiedes.net:7039";
    private static String QUEUE_TRACE_SECURITY_PRINCIPAL = "weblogic11";
    private static String QUEUE_TRACE_SECURITY_CREDENTIALS = "xxxxx";

    public static void publish(Y31JanoServiceTrace item) throws Y31JanoServiceTraceJmsException {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        ht.put("java.naming.provider.url", QUEUE_TRACE_PROVIDER_URL);
        ht.put("java.naming.security.principal", QUEUE_TRACE_SECURITY_PRINCIPAL);
        ht.put("java.naming.security.credentials", QUEUE_TRACE_SECURITY_CREDENTIALS);
        InitialContext jnidContext = null;
        ConnectionFactory connectionFactory = null;
        Destination destinationMongo = null;
        try {
            jnidContext = new InitialContext(ht);
            connectionFactory = (ConnectionFactory)jnidContext.lookup("y31.y31ConnectionFactory");
            destinationMongo = (Destination)jnidContext.lookup("y31.y31TrazasMongoQueue");
        }
        catch (NamingException e1) {
            throw new Y31JanoServiceTraceJmsException((Throwable)e1);
        }
        if (item == null) {
            throw new Y31JanoServiceTraceJmsException("Item a registrar en la cola JMS null..");
        }
        if (connectionFactory == null || destinationMongo == null) {
            throw new Y31JanoServiceTraceJmsException("Factoria, destinationMongo Queue or destinationHBase Queue are null");
        }
        Connection connection = null;
        Session session = null;
        MessageProducer producerMongo = null;
        try {
            connection = connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            producerMongo = session.createProducer(destinationMongo);
            producerMongo.send((Message)session.createObjectMessage((Serializable)item));
        }
        catch (Exception e) {
            throw new Y31JanoServiceTraceJmsException((Throwable)e);
        }
        finally {
            try {
                if (producerMongo != null) {
                    producerMongo.close();
                }
                if (session != null) {
                    session.close();
                }
                if (connection != null) {
                    connection.close();
                }
                if (jnidContext != null) {
                    jnidContext.close();
                }
            }
            catch (JMSException e) {
                throw new Y31JanoServiceTraceJmsException((Throwable)e);
            }
            catch (NamingException e) {
                throw new Y31JanoServiceTraceJmsException((Throwable)e);
            }
        }
    }

    static {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = Y31JanoServiceTraceJMSMangerWL11.class.getClassLoader();
        }
        InputStream inputStream = null;
        inputStream = cl.getResourceAsStream("w11/com/ejie/y31/service/impl/y31.properties");
        if (inputStream == null) {
            inputStream = cl.getResourceAsStream("y31/y31.properties");
        }
        Properties properties = new Properties();
        try {
            if (inputStream != null) {
                properties.load(inputStream);
                if (properties.getProperty("QUEUE_TRACE_PROVIDER_URL") != null && properties.getProperty("QUEUE_TRACE_PROVIDER_URL").length() > 0) {
                    QUEUE_TRACE_PROVIDER_URL = properties.getProperty("QUEUE_TRACE_PROVIDER_URL");
                }
                if (properties.getProperty("QUEUE_TRACE_SECURITY_PRINCIPAL") != null && properties.getProperty("QUEUE_TRACE_SECURITY_PRINCIPAL").length() > 0) {
                    QUEUE_TRACE_SECURITY_PRINCIPAL = properties.getProperty("QUEUE_TRACE_SECURITY_PRINCIPAL");
                }
                if (properties.getProperty("QUEUE_TRACE_SECURITY_CREDENTIALS") != null && properties.getProperty("QUEUE_TRACE_SECURITY_CREDENTIALS").length() > 0) {
                    QUEUE_TRACE_SECURITY_CREDENTIALS = properties.getProperty("QUEUE_TRACE_SECURITY_CREDENTIALS");
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

