/*
 * Decompiled with CFR 0.152.
 */
package w11.com.ejie.y31.util.events.manager;

import com.ejie.y31.exception.Y31JanoServiceEventJmsException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import w11.com.ejie.y31.util.events.manager.NotificationBody;
import w11.com.ejie.y31.util.events.manager.ObjectFactory;
import w11.com.ejie.y31.util.events.manager.Property;

public class Y31JanoServiceEventsJMSManger {
    private static Context jndiContext;
    private static ConnectionFactory connectionFactory;
    private static final String EVENT_TIPOLOGY_NAME = "EventTipology";
    private static final String EVENT_TIPOLOGY_VALUE = "INTEGRACION";
    private static final String EVENT_WHO_NAME = "EventWho";
    private static final String EVENT_WHO_VALUE = "Y31";
    private static final String EVENT_WHAT_NAME = "EventWhat";
    private static String EVENT_WHAT_VALUE;
    public static final String D_FOLDER_NAME = "folder";
    public static final String D_FILE_NAME_NAME = "fileName";
    public static final String D_ORIGIN_NAME = "origin";
    public static final String D_OPERATION_NAME = "operation";
    private static String QUEUE_EVENTS_PROVIDER_URL;
    private static String QUEUE_EVENTS_SECURITY_PRINCIPAL;
    private static String QUEUE_EVENTS_SECURITY_CREDENTIALS;

    public static void publish(String folder, String fileName, String origin, EventWhat operation) throws Y31JanoServiceEventJmsException {
        InitialContext jnidContext = null;
        Destination destinationEvent = null;
        Session session = null;
        MessageProducer producerEvent = null;
        try {
            Hashtable<String, String> ht = new Hashtable<String, String>();
            ht.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
            ht.put("java.naming.provider.url", QUEUE_EVENTS_PROVIDER_URL);
            ht.put("java.naming.security.principal", QUEUE_EVENTS_SECURITY_PRINCIPAL);
            ht.put("java.naming.security.credentials", QUEUE_EVENTS_SECURITY_CREDENTIALS);
            jnidContext = new InitialContext(ht);
            connectionFactory = (ConnectionFactory)jnidContext.lookup("w43ea.w43eaConnectionFactory");
            destinationEvent = (Destination)jnidContext.lookup("w43ea.w43eaEntradaQueue");
        }
        catch (NamingException e) {
            throw new Y31JanoServiceEventJmsException((Throwable)e);
        }
        if (connectionFactory == null || destinationEvent == null) {
            throw new Y31JanoServiceEventJmsException("Factoria, destinationOracle o destinationMongo Queue null");
        }
        Connection connection = null;
        try {
            connection = connectionFactory.createConnection();
            session = connection.createSession(false, 1);
            TextMessage tm = session.createTextMessage();
            tm.setStringProperty(EVENT_TIPOLOGY_NAME, EVENT_TIPOLOGY_VALUE);
            tm.setStringProperty(EVENT_WHO_NAME, EVENT_WHO_VALUE);
            tm.setStringProperty(EVENT_WHAT_NAME, EVENT_WHAT_VALUE);
            ObjectFactory oo = new ObjectFactory();
            NotificationBody notificationBody = oo.createNotificationBody();
            List<Property> properties = notificationBody.getProperty();
            Property p = new Property();
            p.setName(D_FOLDER_NAME);
            p.setValue(folder);
            properties.add(p);
            p = new Property();
            p.setName(D_FILE_NAME_NAME);
            p.setValue(fileName);
            properties.add(p);
            p = new Property();
            p.setName(D_ORIGIN_NAME);
            p.setValue(origin);
            properties.add(p);
            p = new Property();
            p.setName(D_OPERATION_NAME);
            p.setValue(operation.toString());
            properties.add(p);
            tm.setText(Y31JanoServiceEventsJMSManger.unmarshall(notificationBody));
            producerEvent = session.createProducer(destinationEvent);
            producerEvent.send((Message)tm);
        }
        catch (Exception e) {
            throw new Y31JanoServiceEventJmsException((Throwable)e);
        }
        finally {
            try {
                if (producerEvent != null) {
                    producerEvent.close();
                }
                if (session != null) {
                    session.close();
                }
                if (connection != null) {
                    connection.close();
                }
                if (jnidContext != null) {
                    jnidContext.close();
                }
            }
            catch (JMSException e) {
                throw new Y31JanoServiceEventJmsException((Throwable)e);
            }
            catch (NamingException e) {
                throw new Y31JanoServiceEventJmsException((Throwable)e);
            }
        }
    }

    private static String unmarshall(NotificationBody nb) throws Y31JanoServiceEventJmsException {
        StringWriter oout;
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"w11.com.ejie.y31.util.events.manager");
            Marshaller m = jc.createMarshaller();
            oout = new StringWriter();
            m.marshal((Object)nb, (Writer)oout);
            oout.flush();
            oout.close();
        }
        catch (JAXBException e) {
            throw new Y31JanoServiceEventJmsException((Throwable)e);
        }
        catch (IOException e) {
            throw new Y31JanoServiceEventJmsException((Throwable)e);
        }
        return oout.getBuffer().toString();
    }

    public static void main(String[] args) {
    }

    static {
        EVENT_WHAT_VALUE = "WRITE";
        QUEUE_EVENTS_PROVIDER_URL = "t3://wl11mngd13.ejiedes.net:7022,wl11mngd14.ejiedes.net:7022";
        QUEUE_EVENTS_SECURITY_PRINCIPAL = "weblogic11";
        QUEUE_EVENTS_SECURITY_CREDENTIALS = "XXXX";
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = Y31JanoServiceEventsJMSManger.class.getClassLoader();
        }
        InputStream inputStream = null;
        inputStream = cl.getResourceAsStream("w11/com/ejie/y31/service/impl/y31.properties");
        if (inputStream == null) {
            inputStream = cl.getResourceAsStream("y31/y31.properties");
        }
        Properties properties = new Properties();
        try {
            if (inputStream != null) {
                properties.load(inputStream);
                if (properties.getProperty("EVENT_WHAT_VALUE") != null && properties.getProperty("EVENT_WHAT_VALUE").length() > 0) {
                    EVENT_WHAT_VALUE = properties.getProperty("EVENT_WHAT_VALUE");
                }
                if (properties.getProperty("QUEUE_EVENTS_PROVIDER_URL") != null && properties.getProperty("QUEUE_EVENTS_PROVIDER_URL").length() > 0) {
                    QUEUE_EVENTS_PROVIDER_URL = properties.getProperty("QUEUE_EVENTS_PROVIDER_URL");
                }
                if (properties.getProperty("QUEUE_EVENTS_SECURITY_PRINCIPAL") != null && properties.getProperty("QUEUE_EVENTS_SECURITY_PRINCIPAL").length() > 0) {
                    QUEUE_EVENTS_SECURITY_PRINCIPAL = properties.getProperty("QUEUE_EVENTS_SECURITY_PRINCIPAL");
                }
                if (properties.getProperty("QUEUE_EVENTS_SECURITY_CREDENTIALS") != null && properties.getProperty("QUEUE_EVENTS_SECURITY_CREDENTIALS").length() > 0) {
                    QUEUE_EVENTS_SECURITY_CREDENTIALS = properties.getProperty("QUEUE_EVENTS_SECURITY_CREDENTIALS");
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static enum EventWhat {
        PUT,
        GET,
        LIST,
        INFO,
        COPY,
        MOVE;

    }
}

