/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.w43ta.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.ejie.w43ta.clients.W43taMomoTraceClient;
import com.ejie.w43ta.exceptions.MomoClientAvroMarshallerException;
import com.ejie.w43ta.metrics.W43taMetricHttpClient;
import com.ejie.w43ta.pojo.avro.utils.SerializerUtil;
import com.ejie.w43ta.pojo.decorators.avro.auto.MomoMetricsCounter;
import com.ejie.w43ta.pojo.decorators.avro.auto.MomoMetricsCounterList;
import com.ejie.w43ta.pojo.decorators.avro.auto.MomoMetricsGauge;
import com.ejie.w43ta.pojo.decorators.avro.auto.MomoMetricsGaugeList;
import com.ejie.w43ta.pojo.decorators.avro.auto.MomoMetricsHistogram;
import com.ejie.w43ta.pojo.decorators.avro.auto.MomoMetricsHistogramList;
import com.ejie.w43ta.pojo.decorators.avro.auto.MomoMetricsMeter;
import com.ejie.w43ta.pojo.decorators.avro.auto.MomoMetricsMeterList;
import com.ejie.w43ta.pojo.decorators.avro.auto.MomoMetricsTimer;
import com.ejie.w43ta.pojo.decorators.avro.auto.MomoMetricsTimerList;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.avro.specific.SpecificRecordBase;

public class W43taMetricsReporter
extends ScheduledReporter {
    private String service;
    private String token;
    private String serviceEndPoint;
    private Integer port;
    private Boolean islocal;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private W43taMetricsReporter(MetricRegistry registry, Locale locale, Clock clock, TimeZone timeZone, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter, String service, String token, String serviceEndPoint, Integer port, Boolean islocal) {
        super(registry, "w43t-reporter", filter, rateUnit, durationUnit);
        this.service = service;
        this.token = token;
        this.serviceEndPoint = serviceEndPoint;
        this.port = port;
        this.islocal = islocal;
    }

    private MomoMetricsMeter toAvroMeter(Meter meter, String name) {
        MomoMetricsMeter a = new MomoMetricsMeter();
        a.setName(name);
        a.setCount(meter.getCount());
        a.setMeanRate(meter.getMeanRate());
        a.setOneMinuteRate(meter.getOneMinuteRate());
        a.setFiveMinuteRate(meter.getFiveMinuteRate());
        a.setFifteenMinuteRate(meter.getFifteenMinuteRate());
        return a;
    }

    private MomoMetricsCounter toAvroCounter(Map.Entry<String, Counter> entry, String name) {
        MomoMetricsCounter a = new MomoMetricsCounter();
        a.setName(name);
        a.setValue(entry.getValue().getCount());
        return a;
    }

    private MomoMetricsGauge toAvroGauge(Map.Entry<String, Gauge> entry, String name) {
        MomoMetricsGauge a = new MomoMetricsGauge();
        a.setName(name);
        a.setValue(entry.getValue().getValue().toString());
        return a;
    }

    private MomoMetricsHistogram toAvroHistogram(Histogram histogram, String name) {
        MomoMetricsHistogram a = new MomoMetricsHistogram();
        a.setName(name);
        a.setCount(histogram.getCount());
        Snapshot snapshot = histogram.getSnapshot();
        a.setMin(snapshot.getMin());
        a.setMax(snapshot.getMax());
        a.setMean(snapshot.getMean());
        a.setStdDev(snapshot.getStdDev());
        a.setMedian(snapshot.getMedian());
        a.setPercentile75th(snapshot.get75thPercentile());
        a.setPercentile95th(snapshot.get95thPercentile());
        a.setPercentile98th(snapshot.get98thPercentile());
        a.setPercentile99th(snapshot.get99thPercentile());
        a.setPercentile999th(snapshot.get999thPercentile());
        return a;
    }

    private MomoMetricsTimer toAvroTimer(Timer timer, String name) {
        MomoMetricsTimer a = new MomoMetricsTimer();
        a.setName(name);
        a.setCount(timer.getCount());
        a.setMeanRate(timer.getMeanRate());
        a.setOneMinuteRate(timer.getOneMinuteRate());
        a.setFiveMinuteRate(timer.getFiveMinuteRate());
        a.setFifteenMinuteRate(timer.getFifteenMinuteRate());
        Snapshot snapshot = timer.getSnapshot();
        a.setMin(snapshot.getMin());
        a.setMax(snapshot.getMax());
        a.setMean(snapshot.getMean());
        a.setStdDev(snapshot.getStdDev());
        a.setMedian(snapshot.getMedian());
        a.setPercentile75th(snapshot.get75thPercentile());
        a.setPercentile95th(snapshot.get95thPercentile());
        a.setPercentile98th(snapshot.get98thPercentile());
        a.setPercentile99th(snapshot.get99thPercentile());
        a.setPercentile999th(snapshot.get999thPercentile());
        return a;
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        Object b;
        SpecificRecordBase a;
        ArrayList<MomoMetricsGauge> l;
        if (!gauges.isEmpty()) {
            l = new ArrayList<MomoMetricsGauge>();
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                a = this.toAvroGauge(entry, entry.getKey());
                l.add((MomoMetricsGauge)a);
            }
            b = new MomoMetricsGaugeList(W43taMomoTraceClient.METRIC_TYPE.GAUGE.toString(), l);
            try {
                byte[] byArray = SerializerUtil.avro2byteArray((MomoMetricsGaugeList)((Object)b));
                W43taMetricHttpClient.getInstance(this.service, this.token, this.serviceEndPoint, this.port, this.islocal).asyncSend(byArray, W43taMomoTraceClient.METRIC_TYPE.GAUGE);
            }
            catch (MomoClientAvroMarshallerException momoClientAvroMarshallerException) {
                System.out.println("ta Error al serializar las metricas en avro para su envio " + momoClientAvroMarshallerException.getMessage());
            }
            catch (Throwable throwable) {
                System.out.println("ta Error al enviar las metricas en avro al endpoint " + throwable.getMessage());
            }
        }
        if (!counters.isEmpty()) {
            l = new ArrayList();
            for (Map.Entry<String, Counter> entry : counters.entrySet()) {
                a = this.toAvroCounter(entry, entry.getKey());
                l.add((MomoMetricsGauge)a);
            }
            b = new MomoMetricsCounterList(W43taMomoTraceClient.METRIC_TYPE.COUNTER.toString(), l);
            try {
                byte[] byArray = SerializerUtil.avro2byteArray((MomoMetricsCounterList)((Object)b));
                W43taMetricHttpClient.getInstance(this.service, this.token, this.serviceEndPoint, this.port, this.islocal).asyncSend(byArray, W43taMomoTraceClient.METRIC_TYPE.COUNTER);
            }
            catch (MomoClientAvroMarshallerException momoClientAvroMarshallerException) {
                System.out.println("ta Error al serializar las metricas en avro para su envio " + momoClientAvroMarshallerException.getMessage());
            }
            catch (Throwable throwable) {
                System.out.println("ta Error al enviar las metricas en avro al endpoint " + throwable.getMessage());
            }
        }
        if (!meters.isEmpty()) {
            l = new ArrayList();
            for (Map.Entry entry : meters.entrySet()) {
                a = this.toAvroMeter((Meter)entry.getValue(), (String)entry.getKey());
                l.add((MomoMetricsGauge)a);
            }
            b = new MomoMetricsMeterList(W43taMomoTraceClient.METRIC_TYPE.METER.toString(), l);
            try {
                byte[] byArray = SerializerUtil.avro2byteArray((MomoMetricsMeterList)((Object)b));
                W43taMetricHttpClient.getInstance(this.service, this.token, this.serviceEndPoint, this.port, this.islocal).asyncSend(byArray, W43taMomoTraceClient.METRIC_TYPE.METER);
            }
            catch (MomoClientAvroMarshallerException momoClientAvroMarshallerException) {
                System.out.println("ta Error al serializar las metricas en avro para su envio " + momoClientAvroMarshallerException.getMessage());
            }
            catch (Throwable throwable) {
                System.out.println("ta Error al enviar las metricas en avro al endpoint " + throwable.getMessage());
            }
        }
        if (!histograms.isEmpty()) {
            l = new ArrayList();
            for (Map.Entry entry : histograms.entrySet()) {
                a = this.toAvroHistogram((Histogram)entry.getValue(), (String)entry.getKey());
                l.add((MomoMetricsGauge)a);
            }
            b = new MomoMetricsHistogramList(W43taMomoTraceClient.METRIC_TYPE.HISTOGRAM.toString(), l);
            try {
                byte[] byArray = SerializerUtil.avro2byteArray(b);
                W43taMetricHttpClient.getInstance(this.service, this.token, this.serviceEndPoint, this.port, this.islocal).asyncSend(byArray, W43taMomoTraceClient.METRIC_TYPE.HISTOGRAM);
            }
            catch (MomoClientAvroMarshallerException momoClientAvroMarshallerException) {
                System.out.println("ta Error al serializar las metricas en avro para su envio " + momoClientAvroMarshallerException.getMessage());
            }
            catch (Throwable throwable) {
                System.out.println("ta Error al enviar las metricas en avro al endpoint " + throwable.getMessage());
            }
        }
        if (!timers.isEmpty()) {
            l = new ArrayList();
            for (Map.Entry entry : timers.entrySet()) {
                a = this.toAvroTimer((Timer)entry.getValue(), (String)entry.getKey());
                l.add((MomoMetricsGauge)a);
            }
            b = new MomoMetricsTimerList(W43taMomoTraceClient.METRIC_TYPE.TIMER.toString(), l);
            try {
                byte[] byArray = SerializerUtil.avro2byteArray(b);
                W43taMetricHttpClient.getInstance(this.service, this.token, this.serviceEndPoint, this.port, this.islocal).asyncSend(byArray, W43taMomoTraceClient.METRIC_TYPE.TIMER);
            }
            catch (MomoClientAvroMarshallerException momoClientAvroMarshallerException) {
                System.out.println("ta Error al serializar las metricas en avro para su envio " + momoClientAvroMarshallerException.getMessage());
            }
            catch (Throwable throwable) {
                System.out.println("ta Error al enviar las metricas en avro al endpoint " + throwable.getMessage());
            }
        }
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Locale locale;
        private Clock clock;
        private TimeZone timeZone;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private String service;
        private String token;
        private String serviceEndPoint;
        private Integer port;
        private Boolean islocal;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.locale = Locale.getDefault();
            this.clock = Clock.defaultClock();
            this.timeZone = TimeZone.getDefault();
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public Builder setToken(String token) {
            this.token = token;
            return this;
        }

        public Builder setServiceEndPoint(String serviceEndPoint) {
            this.serviceEndPoint = serviceEndPoint;
            return this;
        }

        public Builder setPort(Integer port) {
            this.port = port;
            return this;
        }

        public Builder setIsLocal(Boolean islocal) {
            this.islocal = islocal;
            return this;
        }

        public Builder formattedFor(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder formattedFor(TimeZone timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public W43taMetricsReporter build() {
            return new W43taMetricsReporter(this.registry, this.locale, this.clock, this.timeZone, this.rateUnit, this.durationUnit, this.filter, this.service, this.token, this.serviceEndPoint, this.port, this.islocal);
        }
    }
}

