/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.w43ta.metrics;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.ejie.w43ta.metrics.W43taMetricsReporter;
import java.util.concurrent.TimeUnit;

public class MomoMetricsRegistryFactory {
    private static MetricRegistry w43tbigdata;
    private static JmxReporter reporterJMX;
    private static ConsoleReporter reporterConsole;
    private static W43taMetricsReporter reporterMomo;

    public static MetricRegistry getInstance(String service, String application, String token, String server, int port, boolean islocal) {
        if (!islocal) {
            return MomoMetricsRegistryFactory.getInstance("momo", service, application, token, server, port, islocal);
        }
        return MomoMetricsRegistryFactory.getInstance("jmx", service, application, token, server, port, islocal);
    }

    private static MetricRegistry getInstance(String consumerType, String service, String application, String token, String server, int port, boolean islocal) {
        if (w43tbigdata == null) {
            w43tbigdata = new MetricRegistry();
            if (consumerType.equalsIgnoreCase("jmx")) {
                reporterJMX = JmxReporter.forRegistry((MetricRegistry)w43tbigdata).build();
                reporterJMX.start();
            } else if (consumerType.equalsIgnoreCase("console")) {
                reporterConsole = ConsoleReporter.forRegistry((MetricRegistry)w43tbigdata).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                reporterConsole.start(5L, TimeUnit.MINUTES);
            } else if (consumerType.equalsIgnoreCase("momo")) {
                reporterMomo = W43taMetricsReporter.forRegistry(w43tbigdata).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).setPort(port).setIsLocal(islocal).setServiceEndPoint(server).setService(service).setToken(token).build();
                reporterMomo.start(10L, TimeUnit.SECONDS);
            }
        }
        return w43tbigdata;
    }

    public static void stop() {
        if (reporterJMX != null) {
            reporterJMX.stop();
        }
        if (reporterConsole != null) {
            reporterConsole.stop();
        }
        if (reporterMomo != null) {
            reporterMomo.stop();
        }
    }

    static {
        reporterJMX = null;
        reporterConsole = null;
        reporterMomo = null;
    }
}

