/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.w43ta.clients;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.ejie.w43ta.clients.W43taMomoCustomMap;
import com.ejie.w43ta.exceptions.MomoClientAvroMarshallerException;
import com.ejie.w43ta.exceptions.MomoClientRuntimeException;
import com.ejie.w43ta.metrics.MomoMetricsRegistryFactory;
import com.ejie.w43ta.pojo.avro.utils.SerializerUtil;
import com.ejie.w43ta.pojo.decorators.avro.auto.LEVEL;
import com.ejie.w43ta.pojo.decorators.avro.auto.MomoTrace;
import com.ejie.w43ta.pojo.decorators.avro.auto.TYPE;
import com.ejie.w43ta.pojo.httpclient.utils.AvroBinaryHttpEntity;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class W43taMomoTraceClient
implements Closeable {
    private ExecutorService pool;
    private String server;
    private int port;
    private int poolSize;
    private CloseableHttpClient httpClient;
    private static final String SERVICE_PATH = "/w43taLogApiWAR/traceservice/sync/avro/add";
    private static final String SERVICE_PROTOCOL = "http";
    private MomoTrace momotrace;
    private static final ThreadLocal<String> threadLocalclientUUID = new ThreadLocal();
    private static final ThreadLocal<String> threadLocalrequestUUID = new ThreadLocal();
    private static final ThreadLocal<String> threadLocalDesktop = new ThreadLocal();
    private String token;
    private TYPE type;
    private String service;
    private String app;
    private String node;
    private String host;
    private LEVEL minimunLevel = LEVEL.DEBUG;
    private String encoding = "UTF-8";
    private static Map<String, W43taMomoTraceClient> loggersPool = new HashMap<String, W43taMomoTraceClient>();
    private boolean islocal = true;

    private String toLowerCase(String s) {
        if (s != null) {
            return s.toLowerCase();
        }
        return s;
    }

    public W43taMomoCustomMap getNewCustomDataMap() {
        return W43taMomoCustomMap.getInstance();
    }

    public LEVEL getMinimunLevel() {
        return this.minimunLevel;
    }

    public void setMinimunLevel(LEVEL minimunLevel) {
        this.minimunLevel = minimunLevel;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getPortableContext() {
        String result = "{";
        result = this.service != null ? result + "'service':'" + this.toLowerCase(this.service) + "'," : result + "'service':'',";
        result = this.app != null ? result + "'app':'" + this.toLowerCase(this.app) + "'," : result + "'app':'',";
        result = this.getCliContext() != null ? result + "'clicontext':'" + this.getCliContext() + "'," : result + "'clicontext':'',";
        result = this.getReqContext() != null ? result + "'reqcontext':'" + this.getReqContext() + "'," : result + "'reqcontext':'',";
        result = this.getDesktop() != null ? result + "'desktop':'" + this.getDesktop() + "'}" : result + "'desktop':''}";
        return result;
    }

    public void cleanPortableContext() {
        if (this.getThreadLocalCliContext().get() != null) {
            this.getThreadLocalCliContext().set(null);
            this.getThreadLocalCliContext().remove();
        }
        if (this.getThreadLocalDesktop().get() != null) {
            this.getThreadLocalDesktop().set(null);
            this.getThreadLocalDesktop().remove();
        }
        if (this.getThreadLocalReqContext() != null) {
            this.getThreadLocalReqContext().set(null);
            this.getThreadLocalReqContext().remove();
        }
    }

    public void setPortableContext(String serializedPortableContext) {
        if (serializedPortableContext != null && serializedPortableContext.compareTo("") != 0) {
            if (serializedPortableContext.indexOf("'clicontext':'") > 0) {
                String cc = serializedPortableContext.substring(serializedPortableContext.indexOf("'clicontext':'") + 14, serializedPortableContext.indexOf("','reqcontext':"));
                if (cc != null && cc.length() > 0) {
                    threadLocalclientUUID.set(cc);
                } else {
                    threadLocalclientUUID.set(null);
                }
            }
            if (serializedPortableContext.indexOf("'reqcontext':'") > 0) {
                String rq = serializedPortableContext.substring(serializedPortableContext.indexOf("'reqcontext':'") + 14, serializedPortableContext.indexOf("','desktop':"));
                if (rq != null && rq.length() > 0) {
                    threadLocalrequestUUID.set(rq);
                } else {
                    threadLocalrequestUUID.set(null);
                }
            }
            if (serializedPortableContext.indexOf("'desktop':'") > 0) {
                String de = serializedPortableContext.substring(serializedPortableContext.indexOf("'desktop':'") + 11, serializedPortableContext.indexOf("'}"));
                if (de != null && de.length() > 0) {
                    threadLocalDesktop.set(de);
                } else {
                    threadLocalDesktop.set(null);
                }
            }
        } else {
            this.cleanPortableContext();
        }
    }

    private static boolean isReqContext(String s) {
        try {
            String pattern = "[A-Za-z0-9]{8}-[A-Za-z0-9]{4}-[A-Za-z0-9]{4}-[A-Za-z0-9]{4}-[A-Za-z0-9]{12}";
            Pattern p = Pattern.compile(pattern);
            return p.matcher(s).matches();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isCliContext(String s) {
        try {
            String pattern = "^[0-9]{10}$";
            Pattern p = Pattern.compile(pattern);
            return p.matcher(s).matches();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isDesktopContext(String s) {
        try {
            String pattern = "^[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}$";
            Pattern p = Pattern.compile(pattern);
            return p.matcher(s).matches();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String[] zkHack() {
        String cli = null;
        String req = null;
        String dek = null;
        try {
            WeakReference[] kkk2;
            Thread thread = Thread.currentThread();
            Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
            Class<?> threadLocalMapKlazz = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            Field tableField = threadLocalMapKlazz.getDeclaredField("table");
            tableField.setAccessible(true);
            Object tableEntry = tableField.get(threadLocalsField.get(thread));
            for (WeakReference weakReference : kkk2 = (WeakReference[])tableEntry) {
                if (weakReference == null || weakReference.get() == null || ((ThreadLocal)weakReference.get()).get() == null || !((ThreadLocal)weakReference.get()).getClass().equals(ThreadLocal.class) || !((ThreadLocal)weakReference.get()).get().getClass().equals(String.class)) continue;
                if (W43taMomoTraceClient.isReqContext(((ThreadLocal)weakReference.get()).get().toString())) {
                    req = ((ThreadLocal)weakReference.get()).get().toString();
                    continue;
                }
                if (W43taMomoTraceClient.isCliContext(((ThreadLocal)weakReference.get()).get().toString())) {
                    cli = ((ThreadLocal)weakReference.get()).get().toString();
                    continue;
                }
                if (!W43taMomoTraceClient.isDesktopContext(((ThreadLocal)weakReference.get()).get().toString())) continue;
                dek = ((ThreadLocal)weakReference.get()).get().toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] a = new String[]{cli, req, dek};
        return a;
    }

    protected ThreadLocal<String> getThreadLocalCliContext() {
        return threadLocalclientUUID;
    }

    protected ThreadLocal<String> getThreadLocalReqContext() {
        return threadLocalrequestUUID;
    }

    protected ThreadLocal<String> getThreadLocalDesktop() {
        return threadLocalDesktop;
    }

    private String getCliContext() {
        if (threadLocalclientUUID.get() != null && threadLocalclientUUID.get().length() > 0) {
            return threadLocalclientUUID.get();
        }
        if (threadLocalclientUUID.get() == null) {
            return W43taMomoTraceClient.zkHack()[0];
        }
        return null;
    }

    private String getDesktop() {
        if (threadLocalDesktop.get() != null && threadLocalDesktop.get().length() > 0) {
            return threadLocalDesktop.get();
        }
        if (threadLocalDesktop.get() == null) {
            return W43taMomoTraceClient.zkHack()[2];
        }
        return null;
    }

    private String getReqContext() {
        if (threadLocalrequestUUID.get() != null && threadLocalrequestUUID.get().length() > 0) {
            return threadLocalrequestUUID.get();
        }
        if (threadLocalrequestUUID.get() == null) {
            return W43taMomoTraceClient.zkHack()[1];
        }
        return null;
    }

    public String getMetricName(METRIC_TYPE metricType, String app, String description) {
        return this.toLowerCase(this.service) + "." + this.node + "." + app + "." + (Object)((Object)metricType) + "." + description;
    }

    public String getMetricName(METRIC_TYPE metricType, String description) {
        return this.toLowerCase(this.service) + "." + this.node + "." + this.toLowerCase(this.app) + "." + (Object)((Object)metricType) + "." + description;
    }

    public MetricRegistry getMetricsInstance() {
        return MomoMetricsRegistryFactory.getInstance(this.toLowerCase(this.service), this.toLowerCase(this.app), this.token, this.server, this.port, this.islocal);
    }

    private void startCPUMemoryMetrics() {
        Gauge<Long> usedMemory = new Gauge<Long>(){

            public Long getValue() {
                Runtime runtime = Runtime.getRuntime();
                return new Double((1.0 - (double)runtime.freeMemory() * 1.0 / (double)runtime.totalMemory() * 1.0) * 100.0).longValue();
            }
        };
        Gauge<Long> loadAverage = new Gauge<Long>(){

            public Long getValue() {
                OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
                int cores = Runtime.getRuntime().availableProcessors();
                return new Double(osBean.getSystemLoadAverage() * 100.0 / (double)cores).longValue();
            }
        };
        if (!this.getMetricsInstance().getMetrics().containsKey(this.getMetricName(METRIC_TYPE.GAUGE, "all", "memory.used"))) {
            this.getMetricsInstance().register(this.getMetricName(METRIC_TYPE.GAUGE, "all", "memory.used"), (Metric)usedMemory);
        }
        if (!this.getMetricsInstance().getMetrics().containsKey(this.getMetricName(METRIC_TYPE.GAUGE, "all", "load.average"))) {
            this.getMetricsInstance().register(this.getMetricName(METRIC_TYPE.GAUGE, "all", "load.average"), (Metric)loadAverage);
        }
    }

    private W43taMomoTraceClient(TYPE type, String service, String application, String token, String server, int port, boolean islocal) {
        this.islocal = islocal;
        this.poolSize = 10;
        if (islocal) {
            this.poolSize = 2;
        }
        this.token = token;
        this.type = type;
        this.service = this.toLowerCase(service);
        this.app = this.toLowerCase(application);
        if (System.getProperty("weblogic.Name") != null && System.getProperty("weblogic.Name").length() > 0) {
            this.node = System.getProperty("weblogic.Name");
        }
        try {
            String s;
            this.host = s = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e1) {
            // empty catch block
        }
        try {
            this.setPool(server, port);
        }
        catch (MalformedURLException e) {
            throw new MomoClientRuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new MomoClientRuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new MomoClientRuntimeException(e);
        }
        this.startCPUMemoryMetrics();
    }

    public static W43taMomoTraceClient getInstance(String service, String application, String token, String serviceEndPoint, int port, boolean islocal) {
        return W43taMomoTraceClient.getInstance(service + application + "logger", service, application, token, serviceEndPoint, port, islocal);
    }

    public static W43taMomoTraceClient getInstance(String name, String service, String application, String token, String serviceEndPoint, int port, boolean islocal) {
        if (loggersPool.get(name) != null) {
            return loggersPool.get(name);
        }
        loggersPool.put(name, new W43taMomoTraceClient(TYPE.TRACE, service, application, token, serviceEndPoint, port, islocal));
        return loggersPool.get(name);
    }

    private void basePopulate(String message, Long duration, Long timestamp, W43taMomoCustomMap customData) {
        this.momotrace = new MomoTrace();
        this.momotrace.setToken(this.token);
        this.momotrace.setType(this.type);
        this.momotrace.setService(this.toLowerCase(this.service));
        this.momotrace.setApp(this.toLowerCase(this.app));
        if (this.node != null) {
            this.momotrace.setNode(System.getProperty("weblogic.Name"));
        }
        if (this.host != null) {
            this.momotrace.setHost(this.host);
        }
        if (timestamp == null) {
            this.momotrace.setTsclient(System.currentTimeMillis());
        } else {
            this.momotrace.setTsclient((long)timestamp);
        }
        this.momotrace.setReqcontext(this.getReqContext());
        this.momotrace.setClicontext(this.getCliContext());
        this.momotrace.setDesktop(this.getDesktop());
        try {
            this.momotrace.setMessage(new String(message.getBytes(this.encoding), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            this.momotrace.setMessage(message);
        }
        if (duration != null && duration > 0L) {
            this.momotrace.setDuration(duration);
        }
        if (customData != null && customData.getMap() != null && customData.getMap().size() > 0) {
            this.momotrace.setCustomdata(customData.getMap());
        }
    }

    public void debug(String message, Long duration, W43taMomoCustomMap customData) {
        this.debug(message, duration, customData, null, null, false);
    }

    public void debug(String message, String group, W43taMomoCustomMap customData) {
        this.debug(message, null, customData, group, null, false);
    }

    public void debug(String message, W43taMomoCustomMap customData) {
        this.debug(message, null, customData, null, null, false);
    }

    public void debug(String message, Long duration) {
        this.debug(message, duration, null, null, null, false);
    }

    public void debug(String message, String group) {
        this.debug(message, null, null, group, null, false);
    }

    public void debug(String message) {
        this.debug(message, null, null, null, null, false);
    }

    public void debug(String message, W43taMomoCustomMap customData, Long timestamp) {
        this.debug(message, null, customData, null, timestamp, false);
    }

    public void debug(String message, Long duration, W43taMomoCustomMap customData, String group, Long timestamp) {
        this.debug(message, duration, customData, group, timestamp, false);
    }

    private void debug(String message, Long duration, W43taMomoCustomMap customData, String group, Long timestamp, boolean isEnabledCodeInfo) {
        try {
            this.basePopulate(message, duration, timestamp, customData);
            this.momotrace.setEvent(LEVEL.DEBUG);
            if (group != null) {
                this.momotrace.setGroup(group);
            }
            if (isEnabledCodeInfo) {
                String[] a = W43taMomoTraceClient.getRuntimeClassNameMethodNameAndLineNumber();
                this.momotrace.setClassName(a[0]);
                this.momotrace.setMethodName(a[1]);
                this.momotrace.setLine(a[2]);
            }
            this.asyncSend(this.momotrace, LEVEL.DEBUG);
        }
        catch (RejectedExecutionException e) {
            System.out.println("-----------------> capturando error y cerrando momo instance");
            try {
                this.close();
                this.setPool(this.server, this.port);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public void info(String message, Long duration, W43taMomoCustomMap customData) {
        this.info(message, duration, customData, null, null);
    }

    public void info(String message, String group, W43taMomoCustomMap customData) {
        this.info(message, null, customData, group, null);
    }

    public void info(String message, W43taMomoCustomMap customData) {
        this.info(message, null, customData, null, null);
    }

    public void info(String message, Long duration) {
        this.info(message, duration, null, null, null);
    }

    public void info(String message, String group) {
        this.info(message, null, null, group, null);
    }

    public void info(String message) {
        this.info(message, null, null, null, null);
    }

    public void info(String message, W43taMomoCustomMap customData, Long timestamp) {
        this.info(message, null, customData, null, timestamp);
    }

    public void info(String message, Long duration, W43taMomoCustomMap customData, String group, Long timestamp) {
        try {
            this.basePopulate(message, duration, timestamp, customData);
            this.momotrace.setEvent(LEVEL.INFO);
            if (group != null) {
                this.momotrace.setGroup(group);
            }
            this.asyncSend(this.momotrace, LEVEL.INFO);
        }
        catch (RejectedExecutionException e) {
            System.out.println("-----------------> capturando error y cerrando momo instance");
            try {
                this.close();
                this.setPool(this.server, this.port);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public void warning(String message, Long duration, W43taMomoCustomMap customData) {
        this.warning(message, duration, customData, null, null);
    }

    public void warning(String message, String group, W43taMomoCustomMap customData) {
        this.warning(message, null, customData, group, null);
    }

    public void warning(String message, W43taMomoCustomMap customData) {
        this.warning(message, null, customData, null, null);
    }

    public void warning(String message, Long duration) {
        this.warning(message, duration, null, null, null);
    }

    public void warning(String message, String group) {
        this.warning(message, null, null, group, null);
    }

    public void warning(String message) {
        this.warning(message, null, null, null, null);
    }

    public void warning(String message, W43taMomoCustomMap customData, Long timestamp) {
        this.warning(message, null, customData, null, timestamp);
    }

    public void warning(String message, Long duration, W43taMomoCustomMap customData, String group, Long timestamp) {
        try {
            this.basePopulate(message, duration, timestamp, customData);
            this.momotrace.setEvent(LEVEL.WARNING);
            if (group != null) {
                this.momotrace.setGroup(group);
            }
            this.asyncSend(this.momotrace, LEVEL.WARNING);
        }
        catch (RejectedExecutionException e) {
            System.out.println("-----------------> capturando error y cerrando momo instance");
            try {
                this.close();
                this.setPool(this.server, this.port);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public void error(String message, Throwable e, Long duration, W43taMomoCustomMap customData) {
        this.error(message, e, duration, customData, null, null);
    }

    public void error(String message, Throwable e, String group, W43taMomoCustomMap customData) {
        this.error(message, e, null, customData, group, null);
    }

    public void error(String message, Throwable e, W43taMomoCustomMap customData) {
        this.error(message, e, null, customData, null, null);
    }

    public void error(String message, Throwable e, Long duration) {
        this.error(message, e, duration, null, null, null);
    }

    public void error(String message, Throwable e, String group) {
        this.error(message, e, null, null, group, null);
    }

    public void error(String message, Throwable e) {
        this.error(message, e, null, null, null, null);
    }

    public void error(String message) {
        this.error(message, null, null, null, null, null);
    }

    public void error(String message, Throwable e, W43taMomoCustomMap customData, Long timestamp) {
        this.error(message, e, null, customData, null, timestamp);
    }

    public void error(String message, Throwable e, Long duration, W43taMomoCustomMap customData, String group, Long timestamp) {
        try {
            this.basePopulate(message, duration, timestamp, customData);
            this.momotrace.setEvent(LEVEL.ERROR);
            if (group != null) {
                this.momotrace.setGroup(group);
            }
            if (e != null) {
                this.momotrace.setStacktrace(W43taMomoTraceClient.stacktrace2String(e));
            }
            this.asyncSend(this.momotrace, LEVEL.ERROR);
        }
        catch (RejectedExecutionException exception) {
            System.out.println("-----------------> capturando error y cerrando momo instance");
            try {
                this.close();
                this.setPool(this.server, this.port);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private static String stacktrace2String(Throwable t) {
        StringWriter sw = new StringWriter();
        if (t != null) {
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
        }
        return sw.toString();
    }

    private static String[] getRuntimeClassNameMethodNameAndLineNumber() {
        StackTraceElement stackTraceElement = new Throwable().getStackTrace()[3];
        String[] r = new String[]{stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getLineNumber() + ""};
        return r;
    }

    private void setPool(String server, int port) throws MalformedURLException, InterruptedException, ExecutionException {
        this.pool = Executors.newFixedThreadPool(this.poolSize);
        this.server = server;
        this.port = port;
        if (!this.islocal) {
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
            SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(false).setSoTimeout(1000).setSoKeepAlive(true).setSoLinger(1000).setSoReuseAddress(true).build();
            cm.setMaxTotal(20);
            cm.setDefaultMaxPerRoute(15);
            cm.setDefaultSocketConfig(socketConfig);
            HttpHost serverHost = new HttpHost(this.server, port);
            cm.setMaxPerRoute(new HttpRoute(serverHost), 15);
            this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        }
    }

    private boolean isGreater(LEVEL currentLevel, LEVEL referenceLevel) {
        int cl = 0;
        switch (currentLevel) {
            case DEBUG: {
                cl = 0;
                break;
            }
            case INFO: {
                cl = 1;
                break;
            }
            case WARNING: {
                cl = 2;
                break;
            }
            case ERROR: {
                cl = 3;
                break;
            }
        }
        int rl = 0;
        switch (referenceLevel) {
            case DEBUG: {
                rl = 0;
                break;
            }
            case INFO: {
                rl = 1;
                break;
            }
            case WARNING: {
                rl = 2;
                break;
            }
            case ERROR: {
                rl = 3;
                break;
            }
        }
        return cl >= rl;
    }

    private void asyncSend(MomoTrace trace, LEVEL level) {
        try {
            byte[] avroMessageBytes = SerializerUtil.avro2byteArray(trace);
            if (this.islocal) {
                if (this.getMinimunLevel() == null) {
                    this.futureSendSystemOut(avroMessageBytes);
                } else if (this.isGreater(level, this.getMinimunLevel())) {
                    this.futureSendSystemOut(avroMessageBytes);
                }
            } else {
                this.futureSendApacheHttp(avroMessageBytes);
            }
        }
        catch (MomoClientAvroMarshallerException e) {
            throw new MomoClientRuntimeException(e);
        }
        catch (IOException e) {
            throw new MomoClientRuntimeException(e);
        }
    }

    private Future<Integer> futureSendApacheHttp(final byte[] avroMessageBytes) throws IOException {
        return this.pool.submit(new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws Exception {
                CloseableHttpResponse response;
                int i;
                block9: {
                    i = -1;
                    response = null;
                    HttpEntity entity = null;
                    HttpPost httpost = new HttpPost("http://" + W43taMomoTraceClient.this.server + ":" + W43taMomoTraceClient.this.port + W43taMomoTraceClient.SERVICE_PATH);
                    HttpClientContext context = HttpClientContext.create();
                    try {
                        httpost.setEntity((HttpEntity)new AvroBinaryHttpEntity(avroMessageBytes));
                        response = W43taMomoTraceClient.this.httpClient.execute((HttpUriRequest)httpost, (HttpContext)context);
                        entity = response.getEntity();
                        i = response.getStatusLine().getStatusCode();
                        if (i != 200) {
                            System.out.println("Error al realizar el env\u00c3\u00ado de la petci\u00c3\u00b3n al servicio de trazas httpcode=" + i);
                        }
                        if (entity == null) break block9;
                    }
                    catch (Exception e) {
                        block10: {
                            try {
                                System.out.println("Error al realizar el env\u00c3\u00ado de la petci\u00c3\u00b3n al servicio de trazas " + e.getMessage());
                                if (entity == null) break block10;
                            }
                            catch (Throwable throwable) {
                                if (entity != null) {
                                    EntityUtils.consume(entity);
                                }
                                if (response != null) {
                                    response.close();
                                }
                                throw throwable;
                            }
                            EntityUtils.consume((HttpEntity)entity);
                        }
                        if (response != null) {
                            response.close();
                        }
                    }
                    EntityUtils.consume((HttpEntity)entity);
                }
                if (response != null) {
                    response.close();
                }
                return i;
            }
        });
    }

    private Future<Integer> futureSendSystemOut(final byte[] avroMessageBytes) throws IOException {
        return this.pool.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int i = 200;
                try {
                    System.out.println(W43taMomoTraceClient.avro2String(null, SerializerUtil.byteArray2AvroTrace(avroMessageBytes)));
                }
                catch (Exception e) {
                    System.out.println("Error al escribir el mensaje en la consola " + e.getMessage());
                    i = 500;
                }
                return i;
            }
        });
    }

    private static String avro2String(String pattern, MomoTrace ae) {
        StringWriter sw = new StringWriter();
        sw.append("[" + new Date(ae.getTsclient()) + "] " + ae.getEvent().toString());
        if (ae.getReqcontext() != null || ae.getClicontext() != null) {
            sw.append(" [");
            if (ae.getReqcontext() != null) {
                sw.append("reqcontext: " + ae.getReqcontext());
            }
            if (ae.getClicontext() != null) {
                sw.append(" clicontext: " + ae.getClicontext());
            }
            sw.append("]");
        }
        sw.append(" [");
        sw.append(ae.getService());
        sw.append("-");
        sw.append(ae.getApp());
        if (ae.getGroup() != null) {
            sw.append("-");
            sw.append(ae.getGroup());
        }
        sw.append("]");
        sw.append(" ");
        sw.append(ae.getMessage());
        if (ae.getStacktrace() != null) {
            sw.append("\n");
            sw.append(ae.getStacktrace());
        }
        return sw.toString();
    }

    @Override
    public void close() throws IOException {
        try {
            this.pool.shutdown();
            boolean result = this.pool.awaitTermination(5L, TimeUnit.SECONDS);
            MomoMetricsRegistryFactory.stop();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static enum METRIC_TYPE {
        GAUGE,
        HISTOGRAM,
        METER,
        TIMER,
        COUNTER;

    }
}

