/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.w43ta.clients;

import com.ejie.w43ta.clients.W43taMomoTraceClient;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class W43taMomoAbstractPortableContextSOAPHandler
implements SOAPHandler<SOAPMessageContext> {
    public abstract W43taMomoTraceClient getLoggerInstance();

    private String getW43taid(Map<String, List<String>> headers) {
        if (headers != null) {
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                String name = entry.getKey();
                if (!name.equalsIgnoreCase("w43taid") || entry.getValue() == null || entry.getValue().size() <= 0) continue;
                return entry.getValue().get(0);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleMessage(SOAPMessageContext mc) {
        Boolean outboundProperty = (Boolean)mc.get((Object)"javax.xml.ws.handler.message.outbound");
        if (!outboundProperty.booleanValue()) {
            try {
                String portablecontext = this.getW43taid((Map)mc.get((Object)"javax.xml.ws.http.request.headers"));
                if (portablecontext != null && portablecontext.length() > 0) {
                    this.getLoggerInstance().setPortableContext(portablecontext);
                    return true;
                }
                SOAPHeader header = mc.getMessage().getSOAPHeader();
                NodeList e = header.getElementsByTagName("W43TAID");
                if (e == null || e.getLength() == 0) {
                    e = header.getElementsByTagName("w43taid");
                }
                if (e == null || e.getLength() == 0) {
                    e = header.getElementsByTagName("W43taid");
                }
                if (e.getLength() <= 0) return true;
                for (int i = 0; i < e.getLength(); ++i) {
                    Node pn = e.item(i);
                    String p = pn.getTextContent();
                    if (p != null && p.length() > 0) {
                        this.getLoggerInstance().setPortableContext(p);
                        this.getLoggerInstance().debug("se ha encontrado el siguiente portable context " + p);
                        continue;
                    }
                    this.getLoggerInstance().debug(i + "-No se ha encontrado un valor valido para el portable context " + p);
                }
                return true;
            }
            catch (SOAPException e) {
                this.getLoggerInstance().error("ERROR la recoger el valor de la cabecera SOAP con el portablecontext ", e);
                return true;
            }
        } else {
            this.cleanThreadLocal();
        }
        return true;
    }

    public boolean handleFault(SOAPMessageContext context) {
        return false;
    }

    public void close(MessageContext context) {
    }

    public Set<QName> getHeaders() {
        return null;
    }

    private void cleanThreadLocal() {
        if (this.getLoggerInstance().getThreadLocalCliContext().get() != null) {
            this.getLoggerInstance().getThreadLocalCliContext().set(null);
            this.getLoggerInstance().getThreadLocalCliContext().remove();
        }
        if (this.getLoggerInstance().getThreadLocalDesktop().get() != null) {
            this.getLoggerInstance().getThreadLocalDesktop().set(null);
            this.getLoggerInstance().getThreadLocalDesktop().remove();
        }
        if (this.getLoggerInstance().getThreadLocalReqContext() != null) {
            this.getLoggerInstance().getThreadLocalReqContext().set(null);
            this.getLoggerInstance().getThreadLocalReqContext().remove();
        }
    }
}

