/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.IaikSecurity;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;

public class KeyAgreement {
    private boolean c = false;
    KeyAgreementSpi b;
    Provider a;
    String d;

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.b.engineInit(key, algorithmParameterSpec, secureRandom);
        this.c = true;
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.b.engineInit(key, algorithmParameterSpec, null);
        this.c = true;
    }

    public final void init(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.b.engineInit(key, secureRandom);
        this.c = true;
    }

    public final void init(Key key) throws InvalidKeyException {
        this.b.engineInit(key, null);
        this.c = true;
    }

    public final Provider getProvider() {
        return this.a;
    }

    public static final KeyAgreement getInstance(String string, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        IaikSecurity iaikSecurity = new IaikSecurity(string, "KeyAgreement", string2);
        KeyAgreementSpi keyAgreementSpi = (KeyAgreementSpi)iaikSecurity.getImplementation();
        return new KeyAgreement(keyAgreementSpi, iaikSecurity.getProvider(), string);
    }

    public static final KeyAgreement getInstance(String string) throws NoSuchAlgorithmException {
        try {
            return KeyAgreement.getInstance(string, null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            noSuchProviderException.printStackTrace();
            throw new RuntimeException("InternalError!");
        }
    }

    public final String getAlgorithm() {
        return this.d;
    }

    public final int generateSecret(byte[] byArray, int n2) throws ShortBufferException, IllegalStateException {
        if (!this.c) {
            throw new IllegalStateException("KeyAgreement not initialized yet!");
        }
        return this.b.engineGenerateSecret(byArray, n2);
    }

    public final SecretKey generateSecret(String string) throws InvalidKeyException, NoSuchAlgorithmException, IllegalStateException {
        if (!this.c) {
            throw new IllegalStateException("KeyAgreement not initialized yet!");
        }
        return this.b.engineGenerateSecret(string);
    }

    public final byte[] generateSecret() throws IllegalStateException {
        if (!this.c) {
            throw new IllegalStateException("KeyAgreement not initialized yet!");
        }
        return this.b.engineGenerateSecret();
    }

    public final Key doPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (!this.c) {
            throw new IllegalStateException("KeyAgreement not initialized yet!");
        }
        return this.b.engineDoPhase(key, bl);
    }

    protected KeyAgreement(KeyAgreementSpi keyAgreementSpi, Provider provider, String string) {
        this.b = keyAgreementSpi;
        this.a = provider;
        this.d = string;
    }
}

