/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.ExemptionMechanism;
import javax.crypto.IaikSecurity;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class Cipher {
    public static final int SECRET_KEY = 3;
    public static final int PRIVATE_KEY = 2;
    public static final int PUBLIC_KEY = 1;
    public static final int UNWRAP_MODE = 4;
    public static final int WRAP_MODE = 3;
    public static final int DECRYPT_MODE = 2;
    public static final int ENCRYPT_MODE = 1;
    private int c;
    private boolean d = false;
    private String a;
    private CipherSpi e;
    private Provider b;

    public final byte[] wrap(Key key) throws InvalidKeyException, IllegalBlockSizeException, IllegalStateException {
        if (!this.d || this.c != 3) {
            throw new IllegalStateException("Cipher not initialized for key wrapping!");
        }
        return this.e.engineWrap(key);
    }

    public final int update(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException, IllegalStateException {
        if (!this.d) {
            throw new IllegalStateException("Cipher not initialized yet!");
        }
        return this.e.engineUpdate(byArray, n2, n3, byArray2, n4);
    }

    public final int update(byte[] byArray, int n2, int n3, byte[] byArray2) throws ShortBufferException, IllegalStateException {
        if (!this.d) {
            throw new IllegalStateException("Cipher not initialized yet!");
        }
        return this.e.engineUpdate(byArray, n2, n3, byArray2, 0);
    }

    public final byte[] update(byte[] byArray, int n2, int n3) throws IllegalStateException {
        if (!this.d) {
            throw new IllegalStateException("Cipher not initialized yet!");
        }
        return this.e.engineUpdate(byArray, n2, n3);
    }

    public final byte[] update(byte[] byArray) throws IllegalStateException {
        if (!this.d) {
            throw new IllegalStateException("Cipher not initialized yet!");
        }
        return this.e.engineUpdate(byArray, 0, byArray.length);
    }

    public final Key unwrap(byte[] byArray, String string, int n2) throws NoSuchAlgorithmException, InvalidKeyException, IllegalStateException {
        if (!this.d || this.c != 4) {
            throw new IllegalStateException("Cipher not initialized for key unwrapping!");
        }
        switch (n2) {
            default: {
                throw new InvalidParameterException("Invalid key type " + n2 + "!");
            }
            case 1: 
            case 2: 
            case 3: 
        }
        return this.e.engineUnwrap(byArray, string, n2);
    }

    public String toString() {
        return this.e.toString();
    }

    private void a(int n2) throws InvalidParameterException {
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.c = n2;
                return;
            }
        }
        throw new InvalidParameterException("Invalid opmode " + n2 + "!");
    }

    public final void init(int n2, Certificate certificate, SecureRandom secureRandom) throws InvalidKeyException {
        X509Certificate x509Certificate;
        boolean[] blArray;
        this.a(n2);
        if (certificate instanceof X509Certificate && (blArray = (x509Certificate = (X509Certificate)certificate).getKeyUsage()) != null) {
            if (n2 == 1 && !blArray[3]) {
                throw new InvalidKeyException("Certificate may not be used for data encipherment!");
            }
            if (n2 == 3 && !blArray[2]) {
                throw new InvalidKeyException("Certificate may not be used for key encipherment!");
            }
        }
        this.e.engineInit(n2, certificate.getPublicKey(), null);
        this.d = true;
    }

    public final void init(int n2, Certificate certificate) throws InvalidKeyException {
        this.init(n2, certificate, null);
    }

    public final void init(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.a(n2);
        this.e.engineInit(n2, key, algorithmParameterSpec, secureRandom);
        this.d = true;
    }

    public final void init(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.a(n2);
        this.e.engineInit(n2, key, algorithmParameterSpec, null);
        this.d = true;
    }

    public final void init(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.a(n2);
        this.e.engineInit(n2, key, secureRandom);
        this.d = true;
    }

    public final void init(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.a(n2);
        this.e.engineInit(n2, key, algorithmParameters, secureRandom);
        this.d = true;
    }

    public final void init(int n2, Key key, AlgorithmParameters algorithmParameters) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.a(n2);
        this.e.engineInit(n2, key, algorithmParameters, null);
        this.d = true;
    }

    public final void init(int n2, Key key) throws InvalidKeyException {
        this.a(n2);
        this.e.engineInit(n2, key, null);
        this.d = true;
    }

    public final Provider getProvider() {
        return this.b;
    }

    public final AlgorithmParameters getParameters() {
        return this.e.engineGetParameters();
    }

    public final int getOutputSize(int n2) throws IllegalStateException {
        if (!this.d) {
            throw new IllegalStateException("Cipher not initialized yet!");
        }
        return this.e.engineGetOutputSize(n2);
    }

    public static Cipher getInstance(String string, String string2) throws NoSuchPaddingException, NoSuchProviderException, NoSuchAlgorithmException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        String string3 = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            IaikSecurity iaikSecurity = new IaikSecurity(string3, "Cipher", string2);
            CipherSpi cipherSpi = (CipherSpi)iaikSecurity.getImplementation();
            return new Cipher(cipherSpi, iaikSecurity.getProvider(), string);
        }
        String string4 = stringTokenizer.nextToken();
        String string5 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string5 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            throw new NoSuchAlgorithmException("Invalid cipher transform: " + string);
        }
        try {
            IaikSecurity iaikSecurity = new IaikSecurity(string, "Cipher", string2);
            CipherSpi cipherSpi = (CipherSpi)iaikSecurity.getImplementation();
            return new Cipher(cipherSpi, iaikSecurity.getProvider(), string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                IaikSecurity iaikSecurity = new IaikSecurity(String.valueOf(string3) + "/" + string4, "Cipher", string2);
                CipherSpi cipherSpi = (CipherSpi)iaikSecurity.getImplementation();
                if (string5 != null) {
                    cipherSpi.engineSetPadding(string5);
                }
                return new Cipher(cipherSpi, iaikSecurity.getProvider(), string);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                if (string5 != null) {
                    try {
                        IaikSecurity iaikSecurity = new IaikSecurity(String.valueOf(string3) + "//" + string5, "Cipher", string2);
                        CipherSpi cipherSpi = (CipherSpi)iaikSecurity.getImplementation();
                        cipherSpi.engineSetMode(string4);
                        return new Cipher(cipherSpi, iaikSecurity.getProvider(), string);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException3) {}
                }
                IaikSecurity iaikSecurity = new IaikSecurity(string3, "Cipher", string2);
                CipherSpi cipherSpi = (CipherSpi)iaikSecurity.getImplementation();
                cipherSpi.engineSetMode(string4);
                if (string5 != null) {
                    cipherSpi.engineSetPadding(string5);
                }
                return new Cipher(cipherSpi, iaikSecurity.getProvider(), string);
            }
        }
    }

    public static Cipher getInstance(String string) throws NoSuchPaddingException, NoSuchAlgorithmException {
        try {
            return Cipher.getInstance(string, null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            noSuchProviderException.printStackTrace();
            throw new RuntimeException("InternalError!");
        }
    }

    public final byte[] getIV() {
        return this.e.engineGetIV();
    }

    public final ExemptionMechanism getExemptionMechanism() {
        return null;
    }

    public final int getBlockSize() {
        return this.e.engineGetBlockSize();
    }

    public final String getAlgorithm() {
        return this.a;
    }

    public final int doFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException, IllegalStateException {
        if (!this.d) {
            throw new IllegalStateException("Cipher not initialized yet!");
        }
        return this.e.engineDoFinal(byArray, n2, n3, byArray2, n4);
    }

    public final int doFinal(byte[] byArray, int n2, int n3, byte[] byArray2) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException, IllegalStateException {
        if (!this.d) {
            throw new IllegalStateException("Cipher not initialized yet!");
        }
        return this.e.engineDoFinal(byArray, n2, n3, byArray2, 0);
    }

    public final byte[] doFinal(byte[] byArray, int n2, int n3) throws BadPaddingException, IllegalBlockSizeException, IllegalStateException {
        if (!this.d) {
            throw new IllegalStateException("Cipher not initialized yet!");
        }
        return this.e.engineDoFinal(byArray, n2, n3);
    }

    public final int doFinal(byte[] byArray, int n2) throws BadPaddingException, ShortBufferException, IllegalBlockSizeException, IllegalStateException {
        if (!this.d) {
            throw new IllegalStateException("Cipher not initialized yet!");
        }
        return this.e.engineDoFinal(null, 0, 0, byArray, n2);
    }

    public final byte[] doFinal(byte[] byArray) throws BadPaddingException, IllegalBlockSizeException, IllegalStateException {
        if (!this.d) {
            throw new IllegalStateException("Cipher not initialized yet!");
        }
        return this.e.engineDoFinal(byArray, 0, byArray.length);
    }

    public final byte[] doFinal() throws BadPaddingException, IllegalBlockSizeException, IllegalStateException {
        if (!this.d) {
            throw new IllegalStateException("Cipher not initialized yet!");
        }
        return this.e.engineDoFinal(null, 0, 0);
    }

    protected Cipher(CipherSpi cipherSpi, Provider provider, String string) {
        this.e = cipherSpi;
        this.b = provider;
        this.a = string;
    }
}

