/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.NULL;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.util.Hashtable;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;

public class AlgorithmID
implements ASN1Type {
    private boolean c = true;
    private ASN1Object a = null;
    private ObjectID b = null;
    public static AlgorithmID cms_cast5_wrap;
    public static AlgorithmID cms_idea_wrap;
    public static AlgorithmID cms_rc2_wrap;
    public static AlgorithmID cms_3DES_wrap;
    public static AlgorithmID hMAC_RIPEMD160;
    public static AlgorithmID hMAC_SHA1;
    public static AlgorithmID hMAC_SHA1_;
    public static AlgorithmID hMAC_MD5;
    public static AlgorithmID ripeMd128;
    public static AlgorithmID ripeMd160;
    public static AlgorithmID sha512;
    public static AlgorithmID sha384;
    public static AlgorithmID sha256;
    public static AlgorithmID sha1;
    public static AlgorithmID sha;
    public static AlgorithmID md5;
    public static AlgorithmID md4;
    public static AlgorithmID md2;
    public static AlgorithmID rc5_CBC;
    public static AlgorithmID cast5_CBC;
    public static AlgorithmID aes256_CBC;
    public static AlgorithmID aes192_CBC;
    public static AlgorithmID aes128_CBC;
    public static AlgorithmID idea_CBC;
    public static AlgorithmID des_CBC;
    public static AlgorithmID des_EDE3_CBC;
    public static AlgorithmID rc4;
    public static AlgorithmID rc2_CBC;
    public static AlgorithmID rsa;
    public static AlgorithmID pbkdf2;
    public static AlgorithmID pbeWithSHAAnd40BitRC2_CBC;
    public static AlgorithmID pbeWithSHAAnd128BitRC2_CBC;
    public static AlgorithmID pbeWithSHAAnd2_KeyTripleDES_CBC;
    public static AlgorithmID pbeWithSHAAnd3_KeyTripleDES_CBC;
    public static AlgorithmID pbeWithSHAAnd40BitRC4;
    public static AlgorithmID pbeWithSHAAnd128BitRC4;
    public static AlgorithmID pbeWithMD5AndDES_CBC;
    public static AlgorithmID rsaSignatureWithRipemd128;
    public static AlgorithmID rsaSignatureWithRipemd160;
    public static AlgorithmID ecdsa_With_SHA1;
    public static AlgorithmID ecdsa;
    public static AlgorithmID dsaWithSHA1;
    public static AlgorithmID dsaWithSHA;
    public static AlgorithmID dsa_With_SHA1;
    public static AlgorithmID dsa;
    public static AlgorithmID dsa_;
    public static AlgorithmID sha512WithRSAEncryption;
    public static AlgorithmID sha384WithRSAEncryption;
    public static AlgorithmID sha256WithRSAEncryption;
    public static AlgorithmID sha1WithRSAEncryption;
    public static AlgorithmID sha1WithRSAEncryption_;
    public static AlgorithmID md5WithRSAEncryption;
    public static AlgorithmID md4WithRSAEncryption;
    public static AlgorithmID md2WithRSAEncryption;
    public static AlgorithmID rsaEncryption;
    public static AlgorithmID ssdhKeyAgreement;
    public static AlgorithmID esdh;
    public static AlgorithmID esdhKeyAgreement;
    public static AlgorithmID dhKeyAgreement;
    protected static Hashtable algorithms;
    protected static Hashtable implementations;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.b.getNameAndID()) + " ");
        if (this.a != null && !this.a.isA(ASN.NULL)) {
            stringBuffer.append(" with parameter");
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object(boolean bl) {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.b);
        if (this.a != null && !this.a.isA(ASN.NULL)) {
            sEQUENCE.addComponent(this.a);
        } else if (bl) {
            this.a = new NULL();
            sEQUENCE.addComponent(this.a);
        }
        return sEQUENCE;
    }

    public ASN1Object toASN1Object() {
        return this.toASN1Object(this.c);
    }

    public void setParameter(ASN1Object aSN1Object) {
        this.a = aSN1Object;
    }

    public void setAlgorithmParameters(AlgorithmParameters algorithmParameters) {
        try {
            this.a = DerCoder.decode(algorithmParameters.getEncoded());
            return;
        }
        catch (CodingException codingException) {
            throw new RuntimeException(codingException.toString());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public static void register(String string, String string2, String string3) {
        new AlgorithmID(string, string2, string3);
    }

    public int hashCode() {
        return this.b.hashCode();
    }

    public Signature getSignatureInstance(String string) throws NoSuchAlgorithmException {
        try {
            if (string == null) {
                return Signature.getInstance(this.getImplementationName());
            }
            return Signature.getInstance(this.getImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                if (string == null) {
                    return Signature.getInstance(this.b.getID());
                }
                return Signature.getInstance(this.b.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    if (string == null) {
                        return Signature.getInstance(this.b.getName());
                    }
                    return Signature.getInstance(this.b.getName(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementaion for " + this.b.getName());
                }
            }
        }
    }

    public Signature getSignatureInstance() throws NoSuchAlgorithmException {
        return this.getSignatureInstance(null);
    }

    public SecretKeyFactory getSecretKeyFactoryInstance(String string) throws NoSuchAlgorithmException {
        try {
            if (string == null) {
                return SecretKeyFactory.getInstance(this.getRawImplementationName());
            }
            return SecretKeyFactory.getInstance(this.getRawImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                if (string == null) {
                    return SecretKeyFactory.getInstance(this.b.getID());
                }
                return SecretKeyFactory.getInstance(this.b.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    if (string == null) {
                        return SecretKeyFactory.getInstance(this.b.getName());
                    }
                    return SecretKeyFactory.getInstance(this.b.getName(), string);
                }
                catch (Exception exception3) {
                    try {
                        if (string == null) {
                            return SecretKeyFactory.getInstance(this.getImplementationName());
                        }
                        return SecretKeyFactory.getInstance(this.getImplementationName(), string);
                    }
                    catch (Exception exception4) {
                        throw new NoSuchAlgorithmException("No implementaion for " + this.b.getName());
                    }
                }
            }
        }
    }

    public SecretKeyFactory getSecretKeyFactoryInstance() throws NoSuchAlgorithmException {
        return this.getSecretKeyFactoryInstance(null);
    }

    public String getRawImplementationName() throws NoSuchAlgorithmException {
        String string = this.getImplementationName();
        int n2 = string.indexOf("/");
        if (n2 == -1) {
            return string;
        }
        return string.substring(0, n2);
    }

    public ASN1Object getParameter() {
        return this.a;
    }

    public String getName() {
        return this.b.getName();
    }

    public MessageDigest getMessageDigestInstance(String string) throws NoSuchAlgorithmException {
        try {
            if (string == null) {
                return MessageDigest.getInstance(this.getImplementationName());
            }
            return MessageDigest.getInstance(this.getImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                if (string == null) {
                    return MessageDigest.getInstance(this.b.getID());
                }
                return MessageDigest.getInstance(this.b.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    if (string == null) {
                        return MessageDigest.getInstance(this.b.getName());
                    }
                    return MessageDigest.getInstance(this.b.getName(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementaion for " + this.b.getName());
                }
            }
        }
    }

    public MessageDigest getMessageDigestInstance() throws NoSuchAlgorithmException {
        return this.getMessageDigestInstance(null);
    }

    public Mac getMacInstance(String string) throws NoSuchAlgorithmException {
        try {
            if (string == null) {
                return Mac.getInstance(this.getImplementationName());
            }
            return Mac.getInstance(this.getImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                if (string == null) {
                    return Mac.getInstance(this.b.getID());
                }
                return Mac.getInstance(this.b.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    if (string == null) {
                        return Mac.getInstance(this.b.getName());
                    }
                    return Mac.getInstance(this.b.getName(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementaion for " + this.b.getName());
                }
            }
        }
    }

    public Mac getMacInstance() throws NoSuchAlgorithmException {
        return this.getMacInstance(null);
    }

    public KeyPairGenerator getKeyPairGeneratorInstance(String string) throws NoSuchAlgorithmException {
        try {
            if (string == null) {
                return KeyPairGenerator.getInstance(this.getImplementationName());
            }
            return KeyPairGenerator.getInstance(this.getImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                if (string == null) {
                    return KeyPairGenerator.getInstance(this.b.getID());
                }
                return KeyPairGenerator.getInstance(this.b.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    if (string == null) {
                        return KeyPairGenerator.getInstance(this.b.getName());
                    }
                    return KeyPairGenerator.getInstance(this.b.getName(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementaion for " + this.b.getName());
                }
            }
        }
    }

    public KeyPairGenerator getKeyPairGeneratorInstance() throws NoSuchAlgorithmException {
        return this.getKeyPairGeneratorInstance(null);
    }

    public KeyGenerator getKeyGeneratorInstance(String string) throws NoSuchAlgorithmException {
        try {
            if (string == null) {
                return KeyGenerator.getInstance(this.getRawImplementationName());
            }
            return KeyGenerator.getInstance(this.getRawImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                if (string == null) {
                    return KeyGenerator.getInstance(this.b.getID());
                }
                return KeyGenerator.getInstance(this.b.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    if (string == null) {
                        return KeyGenerator.getInstance(this.b.getName());
                    }
                    return KeyGenerator.getInstance(this.b.getName(), string);
                }
                catch (Exception exception3) {
                    try {
                        if (string == null) {
                            return KeyGenerator.getInstance(this.getImplementationName());
                        }
                        return KeyGenerator.getInstance(this.getImplementationName(), string);
                    }
                    catch (Exception exception4) {
                        throw new NoSuchAlgorithmException("No implementaion for " + this.b.getName());
                    }
                }
            }
        }
    }

    public KeyGenerator getKeyGeneratorInstance() throws NoSuchAlgorithmException {
        return this.getKeyGeneratorInstance(null);
    }

    public KeyFactory getKeyFactoryInstance(String string) throws NoSuchAlgorithmException {
        try {
            if (string == null) {
                return KeyFactory.getInstance(this.getImplementationName());
            }
            return KeyFactory.getInstance(this.getImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                if (string == null) {
                    return KeyFactory.getInstance(this.b.getID());
                }
                return KeyFactory.getInstance(this.b.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    if (string == null) {
                        return KeyFactory.getInstance(this.b.getName());
                    }
                    return KeyFactory.getInstance(this.b.getName(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementaion for " + this.b.getName());
                }
            }
        }
    }

    public KeyFactory getKeyFactoryInstance() throws NoSuchAlgorithmException {
        return this.getKeyFactoryInstance(null);
    }

    public KeyAgreement getKeyAgreementInstance(String string) throws NoSuchAlgorithmException {
        try {
            if (string == null) {
                return KeyAgreement.getInstance(this.getImplementationName());
            }
            return KeyAgreement.getInstance(this.getImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                if (string == null) {
                    return KeyAgreement.getInstance(this.b.getID());
                }
                return KeyAgreement.getInstance(this.b.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    if (string == null) {
                        return KeyAgreement.getInstance(this.b.getName());
                    }
                    return KeyAgreement.getInstance(this.b.getName(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementaion for " + this.b.getName());
                }
            }
        }
    }

    public KeyAgreement getKeyAgreementInstance() throws NoSuchAlgorithmException {
        return this.getKeyAgreementInstance(null);
    }

    public Object getInstance(String string) throws NoSuchAlgorithmException {
        try {
            if (string == null) {
                return this.getMessageDigestInstance();
            }
            return this.getMessageDigestInstance(string);
        }
        catch (Exception exception) {
            try {
                if (string == null) {
                    return this.getSignatureInstance();
                }
                return this.getSignatureInstance(string);
            }
            catch (Exception exception2) {
                try {
                    if (string == null) {
                        return this.getCipherInstance();
                    }
                    return this.getCipherInstance(string);
                }
                catch (Exception exception3) {
                    try {
                        if (string == null) {
                            return this.getKeyAgreementInstance();
                        }
                        return this.getKeyAgreementInstance(string);
                    }
                    catch (Exception exception4) {
                        try {
                            if (string == null) {
                                return this.getKeyFactoryInstance();
                            }
                            return this.getKeyFactoryInstance(string);
                        }
                        catch (Exception exception5) {
                            throw new NoSuchAlgorithmException("No implementaion for " + this.b.getName());
                        }
                    }
                }
            }
        }
    }

    public Object getInstance() throws NoSuchAlgorithmException {
        return this.getInstance(null);
    }

    public String getImplementationName() throws NoSuchAlgorithmException {
        String string = (String)implementations.get(this.b);
        if (string == null) {
            throw new NoSuchAlgorithmException("No implementation for: " + this.getName());
        }
        return string;
    }

    public Cipher getCipherInstance(String string) throws NoSuchAlgorithmException {
        try {
            if (string == null) {
                return Cipher.getInstance(this.getImplementationName());
            }
            return Cipher.getInstance(this.getImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                if (string == null) {
                    return Cipher.getInstance(this.b.getID());
                }
                return Cipher.getInstance(this.b.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    if (string == null) {
                        return Cipher.getInstance(this.b.getName());
                    }
                    return Cipher.getInstance(this.b.getName(), string);
                }
                catch (Exception exception3) {
                    throw new NoSuchAlgorithmException("No implementaion for " + this.b.getName());
                }
            }
        }
    }

    public Cipher getCipherInstance() throws NoSuchAlgorithmException {
        return this.getCipherInstance(null);
    }

    private AlgorithmParameters a(String string) throws NoSuchAlgorithmException {
        try {
            if (string == null) {
                return AlgorithmParameters.getInstance(this.getRawImplementationName());
            }
            return AlgorithmParameters.getInstance(this.getRawImplementationName(), string);
        }
        catch (Exception exception) {
            try {
                if (string == null) {
                    return AlgorithmParameters.getInstance(this.b.getID());
                }
                return AlgorithmParameters.getInstance(this.b.getID(), string);
            }
            catch (Exception exception2) {
                try {
                    if (string == null) {
                        return AlgorithmParameters.getInstance(this.b.getName());
                    }
                    return AlgorithmParameters.getInstance(this.b.getName(), string);
                }
                catch (Exception exception3) {
                    try {
                        if (string == null) {
                            return AlgorithmParameters.getInstance(this.getImplementationName());
                        }
                        return AlgorithmParameters.getInstance(this.getImplementationName(), string);
                    }
                    catch (Exception exception4) {
                        throw new NoSuchAlgorithmException("No implementaion for " + this.b.getName());
                    }
                }
            }
        }
    }

    private AlgorithmParameters a() throws NoSuchAlgorithmException {
        return this.a(null);
    }

    public AlgorithmParameters getAlgorithmParameters(String string, String string2) throws NoSuchAlgorithmException {
        try {
            if (this.a == null || this.a.isA(ASN.NULL)) {
                throw new NoSuchAlgorithmException("No algorithm parameters.");
            }
            AlgorithmParameters algorithmParameters = null;
            algorithmParameters = string != null ? (string2 == null ? AlgorithmParameters.getInstance(string) : AlgorithmParameters.getInstance(string, string2)) : this.a(string2);
            algorithmParameters.init(DerCoder.encode(this.a));
            return algorithmParameters;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException("No such provider: " + string2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public AlgorithmParameters getAlgorithmParameters(String string) throws NoSuchAlgorithmException {
        return this.getAlgorithmParameters(string, null);
    }

    public AlgorithmParameters getAlgorithmParameters() throws NoSuchAlgorithmException {
        if (this.a == null || this.a.isA(ASN.NULL)) {
            return null;
        }
        return this.getAlgorithmParameters(null, null);
    }

    public static AlgorithmID getAlgorithmID(String string) {
        AlgorithmID algorithmID = (AlgorithmID)algorithms.get(string);
        if (algorithmID == null) {
            return null;
        }
        return (AlgorithmID)algorithmID.clone();
    }

    public ObjectID getAlgorithm() {
        return this.b;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AlgorithmID)) {
            return false;
        }
        return this.b.equals(((AlgorithmID)object).b);
    }

    public void encodeAbsentParametersAsNull(boolean bl) {
        this.c = bl;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        try {
            this.b = (ObjectID)aSN1Object.getComponentAt(0);
            if (aSN1Object.countComponents() == 2) {
                this.a = aSN1Object.getComponentAt(1);
                return;
            }
        }
        catch (Exception exception) {
            throw new CodingException("No ASN.1 AlgorithmID type!");
        }
    }

    public Object clone() {
        AlgorithmID algorithmID = new AlgorithmID();
        algorithmID.b = this.b;
        algorithmID.a = this.a;
        algorithmID.c = this.c;
        return algorithmID;
    }

    public static boolean changeObjectID(AlgorithmID algorithmID, ObjectID objectID) {
        try {
            String string = (String)implementations.get(algorithmID.b);
            algorithmID.b = objectID;
            implementations.put(objectID, string);
            algorithms.put(string, algorithmID);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean changeOIDString(AlgorithmID algorithmID, String string) {
        try {
            String string2 = algorithmID.b.getID();
            String string3 = algorithmID.b.getName();
            String string4 = algorithmID.b.getShortName();
            String string5 = (String)implementations.get(algorithmID.b);
            ObjectID objectID = null;
            objectID = string3.equals(string2) ? (string4.equals(string2) ? new ObjectID(string) : new ObjectID(string, "", string4)) : (string4.equals(string2) ? new ObjectID(string, string3) : new ObjectID(string, string3, string4));
            algorithmID.b = objectID;
            implementations.put(objectID, string5);
            algorithms.put(string5, algorithmID);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public AlgorithmID(String string, String string2, String string3, boolean bl) {
        this(string, string2, string3);
        this.c = bl;
    }

    public AlgorithmID(String string, String string2, String string3) {
        this();
        this.b = new ObjectID(string, string2);
        implementations.put(this.b, string3);
        algorithms.put(string3, this);
    }

    public AlgorithmID(String string, String string2) {
        this();
        this.b = new ObjectID(string, string2);
    }

    public AlgorithmID(ObjectID objectID, ASN1Object aSN1Object) {
        this();
        this.b = objectID;
        this.a = aSN1Object;
    }

    public AlgorithmID(ObjectID objectID) {
        this();
        this.b = objectID;
        this.a = null;
    }

    public AlgorithmID(DerInputStream derInputStream) throws IOException {
        this();
        DerInputStream derInputStream2 = derInputStream.readSequence();
        this.b = derInputStream2.readObjectID();
        try {
            if (derInputStream2.nextTag() != -1) {
                this.a = DerCoder.decode(derInputStream2);
                return;
            }
        }
        catch (CodingException codingException) {
            throw new IOException("Error decoding algorithm parameter.");
        }
    }

    public AlgorithmID(ASN1Object aSN1Object) throws CodingException {
        this();
        this.decode(aSN1Object);
    }

    public AlgorithmID() {
    }

    static {
        implementations = new Hashtable();
        algorithms = new Hashtable();
        dhKeyAgreement = new AlgorithmID("1.2.840.113549.1.3.1", "DH Key Agreement", "DH");
        esdhKeyAgreement = new AlgorithmID("1.2.840.113549.1.9.16.3.5", "ESDH Key Agreement", "ESDH");
        esdh = new AlgorithmID("1.2.840.10046.2.1", "ESDH", "ESDH");
        ssdhKeyAgreement = new AlgorithmID("1.2.840.113549.1.9.16.3.10", "SSDH Key Agreement", "SSDH");
        rsaEncryption = new AlgorithmID("1.2.840.113549.1.1.1", "rsaEncryption", "RSA");
        md2WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.2", "md2WithRSAEncryption", "MD2/RSA");
        md4WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.3", "md4WithRSAEncryption");
        md5WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.4", "md5WithRSAEncryption", "MD5/RSA");
        sha1WithRSAEncryption_ = new AlgorithmID("1.3.14.3.2.29", "sha1WithRSAEncryption", "SHA/RSA");
        sha1WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.5", "sha1WithRSAEncryption", "SHA/RSA");
        sha256WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.11", "sha256WithRSAEncryption", "SHA256/RSA");
        sha384WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.12", "sha384WithRSAEncryption", "SHA384/RSA");
        sha512WithRSAEncryption = new AlgorithmID("1.2.840.113549.1.1.13", "sha512WithRSAEncryption", "SHA512/RSA");
        dsa_ = new AlgorithmID("1.3.14.3.2.12", "DSA", "DSA");
        dsa = new AlgorithmID("1.2.840.10040.4.1", "DSA", "DSA");
        dsa_With_SHA1 = new AlgorithmID("1.3.14.3.2.13", "dsaWithSHA1", "SHA-1/DSA", false);
        dsaWithSHA = new AlgorithmID("1.2.840.10040.4.3", "dsaWithSHA", "SHA/DSA", false);
        dsaWithSHA1 = new AlgorithmID("1.3.14.3.2.27", "dsaWithSHA1", "SHA-1/DSA", false);
        ecdsa = new AlgorithmID("1.2.840.10045.2.1", "ECPublicKey", "ECDSA");
        ecdsa_With_SHA1 = new AlgorithmID("1.2.840.10045.4.1", "ecdsaWithSHA1", "ECDSA", false);
        rsaSignatureWithRipemd160 = new AlgorithmID("1.3.36.3.3.1.2", "rsaSignatureWithRipemd160", "RSA/RIPEMD160");
        rsaSignatureWithRipemd128 = new AlgorithmID("1.3.36.3.3.1.3", "rsaSignatureWithRipemd128", "RSA/RIPEMD128");
        pbeWithMD5AndDES_CBC = new AlgorithmID("1.2.840.113549.1.5.3", "PbeWithMD5AndDES-CBC", "PbeWithMD5AndDES_CBC");
        pbeWithSHAAnd128BitRC4 = new AlgorithmID("1.2.840.113549.1.12.1.1", "PbeWithSHAAnd128BitRC4");
        pbeWithSHAAnd40BitRC4 = new AlgorithmID("1.2.840.113549.1.12.1.2", "PbeWithSHAAnd40BitRC4");
        pbeWithSHAAnd3_KeyTripleDES_CBC = new AlgorithmID("1.2.840.113549.1.12.1.3", "PbeWithSHAAnd3-KeyTripleDES-CBC", "PbeWithSHAAnd3_KeyTripleDES_CBC");
        pbeWithSHAAnd2_KeyTripleDES_CBC = new AlgorithmID("1.2.840.113549.1.12.1.4", "PbeWithSHAAnd2-KeyTripleDES-CBC");
        pbeWithSHAAnd128BitRC2_CBC = new AlgorithmID("1.2.840.113549.1.12.1.5", "PbeWithSHAAnd128BitRC2-CBC");
        pbeWithSHAAnd40BitRC2_CBC = new AlgorithmID("1.2.840.113549.1.12.1.6", "PbeWithSHAAnd40BitRC2-CBC", "PbeWithSHAAnd40BitRC2_CBC");
        pbkdf2 = new AlgorithmID("1.2.840.113549.1.5.12", "PBKDF2", "PBKDF2");
        rsa = new AlgorithmID("2.5.8.1.1", "RSA", "RSA");
        rc2_CBC = new AlgorithmID("1.2.840.113549.3.2", "RC2-CBC", "RC2/CBC/PKCS5Padding");
        rc4 = new AlgorithmID("1.2.840.113549.3.4", "RC4", "RC4/ECB/NoPadding");
        des_EDE3_CBC = new AlgorithmID("1.2.840.113549.3.7", "DES-EDE3-CBC", "3DES/CBC/PKCS5Padding");
        des_CBC = new AlgorithmID("1.3.14.3.2.7", "DES-CBC", "DES/CBC/PKCS5Padding");
        idea_CBC = new AlgorithmID("1.3.6.1.4.1.188.7.1.1.2", "IDEA-CBC", "IDEA/CBC/PKCS5Padding");
        aes128_CBC = new AlgorithmID("2.16.840.1.101.3.4.1.2", "AES128-CBC", "AES/CBC/PKCS5Padding");
        aes192_CBC = new AlgorithmID("2.16.840.1.101.3.4.1.22", "AES192-CBC", "AES-192/CBC/PKCS5Padding");
        aes256_CBC = new AlgorithmID("2.16.840.1.101.3.4.1.42", "AES256-CBC", "Rijndael-256/CBC/PKCS5Padding");
        cast5_CBC = new AlgorithmID("1.2.840.113533.7.66.10", "CAST5-CBC", "CAST5/CBC/PKCS5Padding");
        rc5_CBC = new AlgorithmID("1.2.840.113549.3.8", "RC5-CBC", "RC5/CBC/PKCS5Padding");
        md2 = new AlgorithmID("1.2.840.113549.2.2", "MD2", "MD2");
        md4 = new AlgorithmID("1.2.840.113549.2.4", "MD4");
        md5 = new AlgorithmID("1.2.840.113549.2.5", "MD5", "MD5");
        sha1 = sha = new AlgorithmID("1.3.14.3.2.26", "SHA", "SHA");
        sha256 = new AlgorithmID("2.16.840.1.101.3.4.2.1", "SHA256", "SHA256");
        sha384 = new AlgorithmID("2.16.840.1.101.3.4.2.2", "SHA384", "SHA384");
        sha512 = new AlgorithmID("2.16.840.1.101.3.4.2.3", "SHA512", "SHA512");
        ripeMd160 = new AlgorithmID("1.3.36.3.2.1", "RipeMd160", "RIPEMD160");
        ripeMd128 = new AlgorithmID("1.3.36.3.2.2", "RipeMd128", "RIPEMD128");
        hMAC_MD5 = new AlgorithmID("1.3.6.1.5.5.8.1.1", "hMAC-MD5", "HMAC/MD5");
        hMAC_SHA1_ = new AlgorithmID("1.2.840.113549.2.7", "hMAC-SHA1", "HMAC/SHA-1");
        hMAC_SHA1 = new AlgorithmID("1.3.6.1.5.5.8.1.2", "hMAC-SHA1", "HMAC/SHA-1");
        hMAC_RIPEMD160 = new AlgorithmID("1.3.6.1.5.5.8.1.4", "hMAC-RIPEMD160", "HMAC/RIPEMD160");
        cms_3DES_wrap = new AlgorithmID("1.2.840.113549.1.9.16.3.6", "CMS-3DES-Wrap", "3DESWrap3DES");
        cms_rc2_wrap = new AlgorithmID("1.2.840.113549.1.9.16.3.7", "CMS-RC2-Wrap", "RC2WrapRC2");
        cms_idea_wrap = new AlgorithmID("1.3.6.1.4.1.188.7.1.1.6", "CMS-IDEA-Wrap", "IDEAWrapIDEA");
        cms_cast5_wrap = new AlgorithmID("1.2.840.113533.7.66.15", "CMS-CAST128-Wrap", "CAST128WrapCAST128");
    }
}

