/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.procesarreconocidos;

import com.izenpe.accesoocsp.AccesoOCSP;
import com.izenpe.constanteserrores.ConstantesErrores;
import com.izenpe.gestioncontenedorseguro.GestionContenedorSeguro;
import iaik.pkcs.PKCS7CertList;
import iaik.pkcs.PKCSParsingException;
import iaik.security.provider.IAIK;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.qualified.QCStatements;
import iaik.x509.extensions.qualified.structures.QCStatement;
import iaik.x509.extensions.qualified.structures.etsi.QcEuCompliance;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Vector;

public class ProcesarReconocidos {
    public ProcesarReconocidos() {
        IAIK iaik = new IAIK();
        IAIK.addAsJDK14Provider();
        IAIK.addAsProvider((boolean)false);
    }

    public int verifyQualifiedCertDER(byte[] certIn, ByteArrayOutputStream euComplianceOut) {
        boolean euCompliance;
        int error;
        block7: {
            error = ConstantesErrores.OK;
            QCStatements qcs = null;
            euCompliance = false;
            try {
                X509Certificate cert = new X509Certificate(certIn);
                qcs = (QCStatements)cert.getExtension(QCStatements.oid);
                if (qcs != null) {
                    QCStatement[] qcss = qcs.getQCStatements();
                    boolean encontrado = false;
                    for (int i = 0; i < qcss.length && !encontrado; ++i) {
                        if (!qcss[i].getStatementID().equals((Object)QcEuCompliance.statementID)) continue;
                        euCompliance = true;
                        encontrado = true;
                    }
                    break block7;
                }
                error = ConstantesErrores.NO_EUCOMPLIANCE;
                return error;
            }
            catch (CertificateException ce) {
                error = ConstantesErrores.CERT_IN_INCORRECT;
                return error;
            }
            catch (X509ExtensionInitException xeie) {
                error = ConstantesErrores.NO_EUCOMPLIANCE;
                return error;
            }
        }
        try {
            Boolean aux = new Boolean(euCompliance);
            euComplianceOut.write(aux.toString().getBytes("ISO8859_1"));
        }
        catch (IOException ioe) {
            error = ConstantesErrores.NO_EUCOMPLIANCE;
            return error;
        }
        return error;
    }

    public int verifyCertDER_OCSP(byte[] certIn, String pathCS, String passCS, ByteArrayOutputStream responseOCSPOut, ByteArrayOutputStream responseValueOut) {
        int error = ConstantesErrores.OK;
        try {
            X509Certificate cert = new X509Certificate(certIn);
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, passCS);
            AccesoOCSP ao = new AccesoOCSP();
            ByteArrayOutputStream responseDateOut = new ByteArrayOutputStream();
            error = ao.requestOCSP(cert.toByteArray(), pathCS, passCS, responseOCSPOut, responseDateOut, responseValueOut);
            if (error != ConstantesErrores.OK) {
                return error;
            }
            Vector vChain = new Vector();
            error = cs.getCertificateChain(cert, vChain);
            if (error != ConstantesErrores.OK) {
                return error;
            }
            Object[] chain = new X509Certificate[vChain.size()];
            vChain.copyInto(chain);
            X509Certificate[] chainSinUser = new X509Certificate[vChain.size() - 1];
            for (int i = 1; i < vChain.size(); ++i) {
                chainSinUser[i - 1] = (X509Certificate)vChain.elementAt(i);
            }
            error = this.comprobar((X509Certificate[])chain);
            if (error != ConstantesErrores.OK) {
                return error;
            }
            error = cs.comprobar(chainSinUser);
            if (error != ConstantesErrores.OK) {
                return error;
            }
            responseDateOut.close();
        }
        catch (CertificateException ce) {
            error = ConstantesErrores.CERT_IN_INCORRECT;
            return error;
        }
        catch (IOException ioe) {
            error = ConstantesErrores.CERT_IN_INCORRECT;
            return error;
        }
        return error;
    }

    public int verifyQualifiedCertPKCS7(byte[] P7In, ByteArrayOutputStream euComplianceOut) {
        int error = ConstantesErrores.OK;
        boolean euCompliance = false;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(P7In);
            PKCS7CertList plist = new PKCS7CertList((InputStream)bais);
            X509Certificate[] x = plist.getCertificateList();
            QCStatements qcs = null;
            qcs = (QCStatements)x[0].getExtension(QCStatements.oid);
            if (qcs != null) {
                QCStatement[] qcss = qcs.getQCStatements();
                boolean encontrado = false;
                for (int i = 0; i < qcss.length && !encontrado; ++i) {
                    if (!qcss[i].getStatementID().equals((Object)QcEuCompliance.statementID)) continue;
                    euCompliance = true;
                    encontrado = true;
                }
            } else {
                error = ConstantesErrores.NO_EUCOMPLIANCE;
                return error;
            }
            bais.close();
        }
        catch (X509ExtensionInitException xeie) {
            error = ConstantesErrores.NO_EUCOMPLIANCE;
            return error;
        }
        catch (IOException ioe) {
            error = ConstantesErrores.CERT_IN_INCORRECT;
            return error;
        }
        catch (PKCSParsingException pkcspe) {
            error = ConstantesErrores.CERT_IN_INCORRECT;
            return error;
        }
        try {
            Boolean aux = new Boolean(euCompliance);
            euComplianceOut.write(aux.toString().getBytes("ISO8859_1"));
        }
        catch (IOException ioe) {
            error = ConstantesErrores.NO_EUCOMPLIANCE;
            return error;
        }
        return error;
    }

    public int verifyCertPKCS7_OCSP(byte[] P7In, String pathCS, String passCS, ByteArrayOutputStream responseOCSPOut, ByteArrayOutputStream responseValueOut) {
        int error = ConstantesErrores.OK;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(P7In);
            PKCS7CertList plist = new PKCS7CertList((InputStream)bais);
            X509Certificate[] x = plist.getCertificateList();
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, passCS);
            Vector<String> issuerBorrar = new Vector<String>();
            Vector<String> snBorrar = new Vector<String>();
            String alias = null;
            for (int i = x.length - 1; i >= 0; --i) {
                BasicConstraints bc;
                ByteArrayOutputStream aliasBaos = new ByteArrayOutputStream();
                error = cs.getCertificateAlias(((Object)x[i].getIssuerDN()).toString(), x[i].getSerialNumber().toString(), aliasBaos);
                alias = aliasBaos.toString("ISO8859_1");
                if (alias.length() == 0 && (bc = (BasicConstraints)x[i].getExtension(BasicConstraints.oid)) != null && bc.ca() && !((Object)x[i].getIssuerDN()).equals(x[i].getSubjectDN()) && (error = cs.insertRootCertificate(x[i].toByteArray())) == 0) {
                    issuerBorrar.addElement(((Object)x[i].getIssuerDN()).toString());
                    snBorrar.addElement(x[i].getSerialNumber().toString());
                }
                aliasBaos.close();
            }
            Vector vChain = new Vector();
            error = cs.getCertificateChain(x[0], vChain);
            if (error == ConstantesErrores.OK) {
                Object[] chain = new X509Certificate[vChain.size()];
                vChain.copyInto(chain);
                X509Certificate[] chainSinUser = new X509Certificate[vChain.size() - 1];
                for (int k = 1; k < vChain.size(); ++k) {
                    chainSinUser[k - 1] = (X509Certificate)vChain.elementAt(k);
                }
                AccesoOCSP ao = new AccesoOCSP();
                ByteArrayOutputStream responseDateOut = new ByteArrayOutputStream();
                error = ao.requestOCSP(x[0].toByteArray(), pathCS, passCS, responseOCSPOut, responseDateOut, responseValueOut);
                if (error == ConstantesErrores.OK && (error = this.comprobar((X509Certificate[])chain)) == ConstantesErrores.OK) {
                    error = cs.comprobar(chainSinUser);
                }
                responseDateOut.close();
            }
            for (int j = 0; j < issuerBorrar.size(); ++j) {
                cs.removeCertCS((String)issuerBorrar.elementAt(j), (String)snBorrar.elementAt(j));
            }
            bais.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (X509ExtensionInitException xeie) {
            xeie.printStackTrace();
        }
        catch (PKCSParsingException ppe) {
            ppe.printStackTrace();
        }
        return error;
    }

    public int extractQCStatements(byte[] certIn, ByteArrayOutputStream euComplianceOut) {
        int error = ConstantesErrores.OK;
        QCStatements qcs = null;
        boolean euCompliance = false;
        try {
            X509Certificate cert = new X509Certificate(certIn);
            qcs = (QCStatements)cert.getExtension(QCStatements.oid);
            if (qcs != null) {
                QCStatement[] qcss = qcs.getQCStatements();
                boolean encontrado = false;
                for (int i = 0; i < qcss.length && !encontrado; ++i) {
                    if (!qcss[i].getStatementID().equals((Object)QcEuCompliance.statementID)) continue;
                    euCompliance = true;
                    encontrado = true;
                }
            } else {
                error = ConstantesErrores.NO_EUCOMPLIANCE;
            }
        }
        catch (CertificateException ce) {
            ce.printStackTrace();
        }
        catch (X509ExtensionInitException xeie) {
            error = ConstantesErrores.NO_EUCOMPLIANCE;
        }
        try {
            Boolean aux = new Boolean(euCompliance);
            euComplianceOut.write(aux.toString().getBytes("ISO8859_1"));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    private boolean isNonRepudiation(X509Certificate certificado) {
        boolean nonRepudiation = false;
        int error = 0;
        ByteArrayOutputStream euCompliance = new ByteArrayOutputStream();
        error = this.extractQCStatements(certificado.toByteArray(), euCompliance);
        if (error == ConstantesErrores.OK) {
            try {
                Boolean b = new Boolean(euCompliance.toString("ISO8859_1"));
                nonRepudiation = b;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return nonRepudiation;
    }

    private int comprobar(X509Certificate[] certChain) {
        int error = 0;
        for (int i = 0; i < 1; ++i) {
            try {
                certChain[i].checkValidity();
            }
            catch (CertificateExpiredException cee) {
                error = 32;
            }
            catch (CertificateNotYetValidException cnyve) {
                error = 33;
            }
            try {
                if (i < certChain.length - 1) {
                    certChain[i].verify(certChain[i + 1].getPublicKey());
                    continue;
                }
                certChain[i].verify();
                continue;
            }
            catch (CertificateException ce) {
                error = 28;
                return 28;
            }
            catch (NoSuchAlgorithmException nsae) {
                error = 27;
                return 27;
            }
            catch (InvalidKeyException ike) {
                error = 35;
                return 35;
            }
            catch (NoSuchProviderException nspe) {
                error = 25;
                return 25;
            }
            catch (SignatureException se) {
                error = 34;
                return 34;
            }
        }
        return error;
    }
}

