/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.firmaelectronica;

import com.izenpe.autenticacionfuerte.AutenticacionFuerte;
import com.izenpe.autenticacionfuerte.CtesAutenticacion;
import com.izenpe.gestioncontenedorseguro.GestionContenedorSeguro;
import com.izenpe.miscelanea.Miscelanea;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Name;
import iaik.pkcs.PKCS7CertList;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.ContentInfoStream;
import iaik.pkcs.pkcs7.ContentStream;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.pkcs.pkcs7.RSACipherProvider;
import iaik.pkcs.pkcs7.SignedDataStream;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.security.provider.IAIK;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.BasicConstraints;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.util.Vector;

public class FirmaElectronica {
    public FirmaElectronica() {
        IAIK iaik = new IAIK();
        IAIK.addAsJDK14Provider();
        IAIK.addAsProvider((boolean)false);
    }

    public int signHashDettached(String issuerIn, String sN_dN, AlgorithmID signAlgorithm, byte[] data, String pathCS, String password, byte[] p7In, ByteArrayOutputStream p7, boolean bDN) {
        return this.signDettached(issuerIn, sN_dN, signAlgorithm, data, pathCS, password, p7In, p7, bDN);
    }

    public int signDettached(String issuerIn, String sN_dN, AlgorithmID signAlgorithm, byte[] data, String pathCS, String password, byte[] p7In, ByteArrayOutputStream p7, boolean bDN) {
        int error = 0;
        if (!bDN) {
            error = this.signDettached(issuerIn, sN_dN, signAlgorithm, data, pathCS, password, p7In, p7);
        } else {
            ByteArrayOutputStream certArray;
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            error = cs.getCertIssuerSubjectCS(issuerIn, sN_dN, certArray = new ByteArrayOutputStream());
            if (error != 0) {
                return error;
            }
            String snIn = "";
            try {
                X509Certificate cert0 = new X509Certificate(certArray.toByteArray());
                snIn = cert0.getSerialNumber().toString();
            }
            catch (CertificateException ce) {
                error = 413;
                return 413;
            }
            if (snIn.equals("")) {
                error = 413;
                return 413;
            }
            error = this.signDettached(issuerIn, snIn, signAlgorithm, data, pathCS, password, p7In, p7);
        }
        return error;
    }

    public int signHashDettached(String issuerIn, String snIn, AlgorithmID signAlgorithm, byte[] data, String pathCS, String password, byte[] p7In, ByteArrayOutputStream p7) {
        return this.signDettached(issuerIn, snIn, signAlgorithm, data, pathCS, password, p7In, p7);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int signDettached(String issuerIn, String snIn, AlgorithmID signAlgorithm, byte[] data, String pathCS, String password, byte[] p7In, ByteArrayOutputStream p7) {
        int error = 0;
        try {
            if (p7In == null) return this.sign(issuerIn, snIn, signAlgorithm, data, pathCS, password, p7, 2);
            ByteArrayInputStream p7Signed = new ByteArrayInputStream(data);
            ByteArrayInputStream p7In2 = new ByteArrayInputStream(p7In);
            ContentInfoStream cis2 = new ContentInfoStream((InputStream)p7In2);
            AlgorithmID[] aids = new AlgorithmID[]{AlgorithmID.sha1, AlgorithmID.md2, AlgorithmID.md5};
            SignedDataStream sds = new SignedDataStream((InputStream)p7Signed, aids);
            InputStream data2 = sds.getInputStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            StreamCopier sc = new StreamCopier(data2, (OutputStream)os);
            sc.copyStream();
            sds.decode(cis2.getContentInputStream());
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            Vector<Object> v = new Vector<Object>();
            X509Certificate[] certAux2 = sds.getCertificates();
            ByteArrayInputStream is3 = new ByteArrayInputStream(os.toByteArray());
            sds.setInputStream((InputStream)is3);
            for (int i = 0; i < certAux2.length; ++i) {
                v.addElement(certAux2[i]);
            }
            ByteArrayInputStream is = new ByteArrayInputStream(data);
            ByteArrayOutputStream auxiliar = new ByteArrayOutputStream();
            error = cs.getCertCS(issuerIn, snIn, auxiliar);
            if (error != 0) {
                return error;
            }
            PrivateKey pk = cs.getPrivateKeyFromKeyStore(issuerIn, snIn);
            if (pk == null) return 407;
            X509Certificate cert0 = new X509Certificate(auxiliar.toByteArray());
            if (!this.isDigitalSignature(cert0.toByteArray())) return 401;
            Vector vChain = new Vector();
            error = cs.getCertificateChain(cert0, vChain);
            if (error != 0) {
                return error;
            }
            Object[] certAux = new X509Certificate[vChain.size()];
            vChain.copyInto(certAux);
            if (certAux == null) return 404;
            IssuerAndSerialNumber iasn = new IssuerAndSerialNumber((java.security.cert.X509Certificate)cert0);
            SignerInfo si = new SignerInfo(iasn, signAlgorithm, pk);
            sds.addSignerInfo(si);
            for (int j = 0; j < certAux.length - 1; ++j) {
                if (v.contains(certAux[j])) continue;
                v.addElement(certAux[j]);
            }
            Object[] certsFinal = new X509Certificate[v.size()];
            v.copyInto(certsFinal);
            sds.setCertificates((X509Certificate[])certsFinal);
            ByteArrayOutputStream textoPlano = new ByteArrayOutputStream();
            InputStream is2 = sds.getInputStream();
            StreamCopier sc2 = new StreamCopier(is2, (OutputStream)textoPlano);
            sc2.copyStream();
            p7.reset();
            ContentInfoStream cis = new ContentInfoStream((ContentStream)sds);
            cis.writeTo((OutputStream)p7);
            textoPlano.close();
            is2.close();
            auxiliar.close();
            p7Signed.close();
            p7In2.close();
            os.close();
            is3.close();
            is.close();
            return error;
        }
        catch (NoSuchAlgorithmException nsae) {
            return 403;
        }
        catch (IOException ioe) {
            return 412;
        }
        catch (CertificateException ce) {
            return 413;
        }
        catch (PKCSParsingException pe) {
            return 411;
        }
        catch (PKCSException pkcse) {
            return 411;
        }
    }

    public int signHashDettached(String issuerIn, String sN_dN, AlgorithmID signAlgorithm, InputStream data, String pathCS, String password, InputStream p7In, OutputStream p7, boolean bDN) {
        return this.signDettached(issuerIn, sN_dN, signAlgorithm, data, pathCS, password, p7In, p7, bDN);
    }

    public int signDettached(String issuerIn, String sN_dN, AlgorithmID signAlgorithm, InputStream data, String pathCS, String password, InputStream p7In, OutputStream p7, boolean bDN) {
        int error = 0;
        if (!bDN) {
            error = this.signDettached(issuerIn, sN_dN, signAlgorithm, data, pathCS, password, p7In, p7);
        } else {
            ByteArrayOutputStream certArray;
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            error = cs.getCertIssuerSubjectCS(issuerIn, sN_dN, certArray = new ByteArrayOutputStream());
            if (error != 0) {
                return error;
            }
            String snIn = "";
            try {
                X509Certificate cert0 = new X509Certificate(certArray.toByteArray());
                snIn = cert0.getSerialNumber().toString();
            }
            catch (CertificateException ce) {
                error = 413;
            }
            if (snIn.equals("")) {
                error = 413;
                return 413;
            }
            error = this.signDettached(issuerIn, snIn, signAlgorithm, data, pathCS, password, p7In, p7);
        }
        return error;
    }

    public int signHashDettached(String issuerIn, String snIn, AlgorithmID signAlgorithm, InputStream data, String pathCS, String password, InputStream p7In, OutputStream p7) {
        return this.signDettached(issuerIn, snIn, signAlgorithm, data, pathCS, password, p7In, p7);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int signDettached(String issuerIn, String snIn, AlgorithmID signAlgorithm, InputStream data, String pathCS, String password, InputStream p7In, OutputStream p7) {
        int error = 0;
        try {
            if (p7In == null) return this.sign(issuerIn, snIn, signAlgorithm, data, pathCS, password, p7, 2);
            ContentInfoStream cis2 = new ContentInfoStream(p7In);
            AlgorithmID[] aids = new AlgorithmID[]{AlgorithmID.sha1, AlgorithmID.md2, AlgorithmID.md5};
            SignedDataStream sds = new SignedDataStream(data, aids);
            InputStream data2 = sds.getInputStream();
            sds.decode(cis2.getContentInputStream());
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            Vector<Object> v = new Vector<Object>();
            X509Certificate[] certAux2 = sds.getCertificates();
            sds.setInputStream(data2);
            for (int i = 0; i < certAux2.length; ++i) {
                v.addElement(certAux2[i]);
            }
            ByteArrayOutputStream auxiliar = new ByteArrayOutputStream();
            error = cs.getCertCS(issuerIn, snIn, auxiliar);
            if (error != 0) {
                return error;
            }
            PrivateKey pk = cs.getPrivateKeyFromKeyStore(issuerIn, snIn);
            if (pk == null) return 407;
            X509Certificate cert0 = new X509Certificate(auxiliar.toByteArray());
            if (!this.isDigitalSignature(cert0.toByteArray())) return 401;
            Vector vChain = new Vector();
            error = cs.getCertificateChain(cert0, vChain);
            if (error != 0) {
                return error;
            }
            Object[] certAux = new X509Certificate[vChain.size()];
            vChain.copyInto(certAux);
            if (certAux == null) return 404;
            IssuerAndSerialNumber iasn = new IssuerAndSerialNumber((java.security.cert.X509Certificate)cert0);
            SignerInfo si = new SignerInfo(iasn, signAlgorithm, pk);
            sds.addSignerInfo(si);
            for (int j = 0; j < certAux.length - 1; ++j) {
                if (v.contains(certAux[j])) continue;
                v.addElement(certAux[j]);
            }
            Object[] certsFinal = new X509Certificate[v.size()];
            v.copyInto(certsFinal);
            sds.setCertificates((X509Certificate[])certsFinal);
            ByteArrayOutputStream textoPlano = new ByteArrayOutputStream();
            InputStream is2 = sds.getInputStream();
            ContentInfoStream cis = new ContentInfoStream((ContentStream)sds);
            cis.writeTo(p7);
            textoPlano.close();
            is2.close();
            auxiliar.close();
            return error;
        }
        catch (NoSuchAlgorithmException nsae) {
            return 403;
        }
        catch (IOException ioe) {
            return 412;
        }
        catch (CertificateException ce) {
            return 413;
        }
        catch (PKCSParsingException pe) {
            return 411;
        }
        catch (PKCSException pkcse) {
            return 411;
        }
    }

    public int signAttached(String issuerIn, String sN_dN, AlgorithmID signAlgorithm, byte[] data, String pathCS, String password, ByteArrayOutputStream p7, boolean bDN) {
        int error = 0;
        if (!bDN) {
            error = this.signAttached(issuerIn, sN_dN, signAlgorithm, data, pathCS, password, p7);
        } else {
            ByteArrayOutputStream certArray;
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            error = cs.getCertIssuerSubjectCS(issuerIn, sN_dN, certArray = new ByteArrayOutputStream());
            if (error != 0) {
                return error;
            }
            String snIn = "";
            try {
                X509Certificate cert0 = new X509Certificate(certArray.toByteArray());
                snIn = cert0.getSerialNumber().toString();
            }
            catch (CertificateException ce) {
                error = 413;
            }
            if (snIn.equals("")) {
                error = 413;
                return 413;
            }
            error = this.signAttached(issuerIn, snIn, signAlgorithm, data, pathCS, password, p7);
        }
        return error;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int signAttached(String issuerIn, String snIn, AlgorithmID signAlgorithm, byte[] data, String pathCS, String password, ByteArrayOutputStream p7) {
        int error = 0;
        try {
            ByteArrayOutputStream auxiliar;
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ContentInfoStream cis2 = new ContentInfoStream((InputStream)bais);
            SignedDataStream sds = (SignedDataStream)cis2.getContent();
            ByteArrayOutputStream contenido = new ByteArrayOutputStream();
            StreamCopier sc2 = new StreamCopier(sds.getInputStream(), (OutputStream)contenido);
            sc2.copyStream();
            X509Certificate[] certAux = sds.getCertificates();
            ByteArrayInputStream is2 = new ByteArrayInputStream(contenido.toByteArray());
            sds.setInputStream((InputStream)is2);
            Vector<Object> v = new Vector<Object>();
            for (int i = 0; i < certAux.length; ++i) {
                v.addElement(certAux[i]);
            }
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            error = cs.getCertCS(issuerIn, snIn, auxiliar = new ByteArrayOutputStream());
            if (error != 0) {
                return error;
            }
            PrivateKey pk = cs.getPrivateKeyFromKeyStore(issuerIn, snIn);
            if (pk == null) return 407;
            X509Certificate cert0 = new X509Certificate(auxiliar.toByteArray());
            if (!this.isDigitalSignature(cert0.toByteArray())) return 401;
            Vector vChain = new Vector();
            error = cs.getCertificateChain(cert0, vChain);
            if (error != 0) {
                return error;
            }
            Object[] chain = new X509Certificate[vChain.size()];
            vChain.copyInto(chain);
            if (chain == null) return 404;
            for (int j = 0; j < chain.length - 1; ++j) {
                if (v.contains(chain[j])) continue;
                v.addElement(chain[j]);
            }
            Object[] certsFinal = new X509Certificate[v.size()];
            v.copyInto(certsFinal);
            sds.setCertificates((X509Certificate[])certsFinal);
            IssuerAndSerialNumber isn = new IssuerAndSerialNumber((java.security.cert.X509Certificate)cert0);
            SignerInfo si = new SignerInfo(isn, signAlgorithm, pk);
            sds.addSignerInfo(si);
            p7.reset();
            ContentInfoStream cis = new ContentInfoStream((ContentStream)sds);
            cis.writeTo((OutputStream)p7);
            bais.close();
            contenido.close();
            is2.close();
            auxiliar.close();
            return error;
        }
        catch (CertificateException ce) {
            return 413;
        }
        catch (PKCSParsingException pe) {
            return 411;
        }
        catch (IOException ioe) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                SignedDataStream sds4 = new SignedDataStream((InputStream)bais);
                bais.close();
                return error;
            }
            catch (PKCSParsingException ppe) {
                return 411;
            }
            catch (IOException ioe2) {
                return this.sign(issuerIn, snIn, signAlgorithm, data, pathCS, password, p7, 1);
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            return 403;
        }
        catch (PKCSException pkcse) {
            return 411;
        }
    }

    public int signAttached(String issuerIn, String sN_dN, AlgorithmID signAlgorithm, InputStream data, String pathCS, String password, OutputStream p7, boolean bDN) {
        int error = 0;
        if (!bDN) {
            error = this.signAttached(issuerIn, sN_dN, signAlgorithm, data, pathCS, password, p7);
        } else {
            ByteArrayOutputStream certArray;
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            error = cs.getCertIssuerSubjectCS(issuerIn, sN_dN, certArray = new ByteArrayOutputStream());
            if (error != 0) {
                return error;
            }
            String snIn = "";
            try {
                X509Certificate cert0 = new X509Certificate(certArray.toByteArray());
                snIn = cert0.getSerialNumber().toString();
            }
            catch (CertificateException ce) {
                error = 413;
            }
            if (snIn.equals("")) {
                error = 413;
                return 413;
            }
            error = this.signAttached(issuerIn, snIn, signAlgorithm, data, pathCS, password, p7);
        }
        return error;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int sign(String issuerIn, String snIn, AlgorithmID signAlgorithm, byte[] data, String pathCS, String password, ByteArrayOutputStream p7, int mode) {
        int error = 0;
        try {
            Vector vChain;
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            ByteArrayInputStream is = new ByteArrayInputStream(data);
            SignedDataStream sds = new SignedDataStream((InputStream)is, mode);
            ByteArrayOutputStream aux = new ByteArrayOutputStream();
            error = cs.getCertCS(issuerIn, snIn, aux);
            if (error != 0) {
                return error;
            }
            PrivateKey pk = cs.getPrivateKeyFromKeyStore(issuerIn, snIn);
            if (pk == null) return 407;
            X509Certificate cert0 = new X509Certificate(aux.toByteArray());
            error = cs.getCertificateChain(cert0, vChain = new Vector());
            if (error != 0) {
                return error;
            }
            Object[] certAux = new X509Certificate[vChain.size()];
            vChain.copyInto(certAux);
            if (certAux == null) return 404;
            X509Certificate[] cert = new X509Certificate[certAux.length - 1];
            for (int i = 0; i < cert.length; ++i) {
                cert[i] = certAux[i];
            }
            if (!this.isDigitalSignature(cert[0].toByteArray())) return 401;
            sds.setCertificates(cert);
            IssuerAndSerialNumber iasn = new IssuerAndSerialNumber((java.security.cert.X509Certificate)cert[0]);
            SignerInfo si = new SignerInfo(iasn, signAlgorithm, pk);
            sds.addSignerInfo(si);
            if (mode == 2) {
                InputStream is2 = sds.getInputStream();
                ByteArrayOutputStream textoPlano = new ByteArrayOutputStream();
                StreamCopier sc3 = new StreamCopier(is2, (OutputStream)textoPlano);
                sc3.copyStream();
                is2.close();
                textoPlano.close();
            }
            ContentInfoStream cis = new ContentInfoStream((ContentStream)sds);
            cis.writeTo((OutputStream)p7);
            aux.close();
            is.close();
            return error;
        }
        catch (NoSuchAlgorithmException nsae) {
            return 403;
        }
        catch (IOException ioe) {
            return 411;
        }
        catch (CertificateException ce) {
            return 413;
        }
        catch (PKCSException pkcse) {
            return 411;
        }
    }

    public int verifySignHashDettached(byte[] p7, byte[] data, String pathCS, String password, Vector certOut, Vector certErrores) {
        return this.verifySignDettached(p7, data, pathCS, password, certOut, certErrores);
    }

    public int verifySignDettached(byte[] p7, byte[] data, String pathCS, String password, Vector certOut, Vector certErrores) {
        int error = 0;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ByteArrayInputStream p7Signed = new ByteArrayInputStream(p7);
            ContentInfoStream cis = new ContentInfoStream((InputStream)p7Signed);
            AlgorithmID[] aids = new AlgorithmID[]{AlgorithmID.sha1, AlgorithmID.md2, AlgorithmID.md5};
            SignedDataStream sds = new SignedDataStream((InputStream)bais, aids);
            ByteArrayOutputStream datosFirmados = new ByteArrayOutputStream();
            StreamCopier sc2 = new StreamCopier(sds.getInputStream(), (OutputStream)datosFirmados);
            sc2.copyStream();
            sds.decode(cis.getContentInputStream());
            SignerInfo[] signerInfos = sds.getSignerInfos();
            X509Certificate cert = null;
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            X509Certificate[] certP7 = sds.getCertificates();
            int errorC = 0;
            RSACipherProvider rsaProv = new RSACipherProvider("IAIK", "IAIK");
            for (int i = 0; i < signerInfos.length; ++i) {
                try {
                    signerInfos[i].setRSACipherProvider(rsaProv);
                    cert = sds.verify(i);
                    if (this.isDigitalSignature(cert.toByteArray())) {
                        X509Certificate[] certSigner = this.getCertificateChain(certP7, cert);
                        BasicConstraints BC = (BasicConstraints)cert.getExtension(BasicConstraints.oid);
                        if (certSigner.length == 1 && BC == null) {
                            Vector vChain = new Vector();
                            errorC = cs.getCertificateChain(cert, vChain);
                            if (errorC == 0) {
                                Object[] chain = new X509Certificate[vChain.size()];
                                vChain.copyInto(chain);
                                if (chain != null) {
                                    errorC = cs.comprobar((X509Certificate[])chain);
                                    if (errorC != 0) {
                                        certOut.addElement(cert);
                                        error = 420;
                                    }
                                } else {
                                    errorC = 404;
                                    error = 420;
                                }
                            } else {
                                error = 420;
                            }
                        } else {
                            X509Certificate[] certSignerPlusRaiz = new X509Certificate[certSigner.length + 1];
                            for (int j = 0; j < certSigner.length; ++j) {
                                certSignerPlusRaiz[j] = certSigner[j];
                            }
                            ByteArrayOutputStream baosRoot = new ByteArrayOutputStream();
                            errorC = cs.getRoot(certSigner[certSigner.length - 1], baosRoot);
                            if (errorC == 0) {
                                X509Certificate aliasRoot = new X509Certificate(baosRoot.toByteArray());
                                if (aliasRoot != null) {
                                    certSignerPlusRaiz[certSignerPlusRaiz.length - 1] = aliasRoot;
                                    errorC = cs.comprobar(certSignerPlusRaiz);
                                    if (errorC != 0) {
                                        error = 420;
                                    }
                                } else {
                                    errorC = 405;
                                    error = 420;
                                }
                            } else {
                                error = 420;
                            }
                            baosRoot.close();
                        }
                    } else {
                        errorC = 401;
                        error = 420;
                    }
                    certOut.addElement(cert);
                }
                catch (SignatureException se) {
                    IssuerAndSerialNumber ias = signerInfos[i].getIssuerAndSerialNumber();
                    Name is = ias.getIssuer();
                    BigInteger sn = ias.getSerialNumber();
                    X509Certificate falled = this.getCertificate((Principal)is, sn, certP7);
                    certOut.addElement(falled);
                    error = 420;
                    errorC = 402;
                }
                catch (X509ExtensionInitException eie) {
                    eie.printStackTrace();
                }
                catch (CertificateException ce) {
                    error = 413;
                }
                certErrores.addElement(new Integer(errorC));
            }
            bais.close();
            p7Signed.close();
            datosFirmados.close();
        }
        catch (IOException ioe) {
            error = 409;
        }
        catch (PKCSParsingException ppe) {
            error = 411;
        }
        return error;
    }

    public int verifySignHashDettached(InputStream p7, InputStream data, String pathCS, String password, Vector certOut, Vector certErrores) {
        return this.verifySignDettached(p7, data, pathCS, password, certOut, certErrores);
    }

    public int verifySignDettached(InputStream p7, InputStream data, String pathCS, String password, Vector certOut, Vector certErrores) {
        int error = 0;
        try {
            ContentInfoStream cis = new ContentInfoStream(p7);
            AlgorithmID[] aids = new AlgorithmID[]{AlgorithmID.sha1, AlgorithmID.md2, AlgorithmID.md5};
            SignedDataStream sds = new SignedDataStream(data, aids);
            ByteArrayOutputStream datosFirmados = new ByteArrayOutputStream();
            StreamCopier sc2 = new StreamCopier(sds.getInputStream(), (OutputStream)datosFirmados);
            sc2.copyStream();
            sds.decode(cis.getContentInputStream());
            SignerInfo[] signerInfos = sds.getSignerInfos();
            X509Certificate cert = null;
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            X509Certificate[] certP7 = sds.getCertificates();
            int errorC = 0;
            RSACipherProvider rsaProv = new RSACipherProvider("IAIK", "IAIK");
            for (int i = 0; i < signerInfos.length; ++i) {
                try {
                    signerInfos[i].setRSACipherProvider(rsaProv);
                    cert = sds.verify(i);
                    if (this.isDigitalSignature(cert.toByteArray())) {
                        X509Certificate[] certSigner = this.getCertificateChain(certP7, cert);
                        BasicConstraints BC = (BasicConstraints)cert.getExtension(BasicConstraints.oid);
                        if (certSigner.length == 1 && BC == null) {
                            Vector vChain = new Vector();
                            errorC = cs.getCertificateChain(cert, vChain);
                            if (errorC == 0) {
                                Object[] chain = new X509Certificate[vChain.size()];
                                vChain.copyInto(chain);
                                if (chain != null) {
                                    errorC = cs.comprobar((X509Certificate[])chain);
                                    if (errorC != 0) {
                                        certOut.addElement(cert);
                                        error = 420;
                                    }
                                } else {
                                    errorC = 404;
                                    error = 420;
                                }
                            } else {
                                error = 420;
                            }
                        } else {
                            X509Certificate[] certSignerPlusRaiz = new X509Certificate[certSigner.length + 1];
                            for (int j = 0; j < certSigner.length; ++j) {
                                certSignerPlusRaiz[j] = certSigner[j];
                            }
                            ByteArrayOutputStream baosRoot = new ByteArrayOutputStream();
                            errorC = cs.getRoot(certSigner[certSigner.length - 1], baosRoot);
                            if (errorC == 0) {
                                X509Certificate aliasRoot = new X509Certificate(baosRoot.toByteArray());
                                if (aliasRoot != null) {
                                    certSignerPlusRaiz[certSignerPlusRaiz.length - 1] = aliasRoot;
                                    errorC = cs.comprobar(certSignerPlusRaiz);
                                    if (errorC != 0) {
                                        error = 420;
                                    }
                                } else {
                                    errorC = 405;
                                    error = 420;
                                }
                            } else {
                                error = 420;
                            }
                            baosRoot.close();
                        }
                    } else {
                        errorC = 401;
                        error = 420;
                    }
                    certOut.addElement(cert);
                }
                catch (SignatureException se) {
                    IssuerAndSerialNumber ias = signerInfos[i].getIssuerAndSerialNumber();
                    Name is = ias.getIssuer();
                    BigInteger sn = ias.getSerialNumber();
                    X509Certificate falled = this.getCertificate((Principal)is, sn, certP7);
                    certOut.addElement(falled);
                    error = 420;
                    errorC = 402;
                }
                catch (X509ExtensionInitException eie) {
                    eie.printStackTrace();
                }
                catch (CertificateException ce) {
                    error = 413;
                }
                certErrores.addElement(new Integer(errorC));
            }
        }
        catch (IOException ioe) {
            error = 409;
        }
        catch (PKCSParsingException ppe) {
            error = 411;
        }
        return error;
    }

    public int verifySignAttached(byte[] p7, String pathCS, String password, ByteArrayOutputStream datosFirmados, Vector certOut, Vector certErrores) {
        int error = 0;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(p7);
            ContentInfoStream cis = new ContentInfoStream((InputStream)bais);
            SignedDataStream sds = (SignedDataStream)cis.getContent();
            StreamCopier sc2 = new StreamCopier(sds.getInputStream(), (OutputStream)datosFirmados);
            sc2.copyStream();
            SignerInfo[] signerInfos = sds.getSignerInfos();
            X509Certificate cert = null;
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            X509Certificate[] certP7 = sds.getCertificates();
            int errorC = 0;
            RSACipherProvider rsaProv = new RSACipherProvider("IAIK", "IAIK");
            for (int i = 0; i < signerInfos.length; ++i) {
                try {
                    signerInfos[i].setRSACipherProvider(rsaProv);
                    cert = sds.verify(i);
                    if (this.isDigitalSignature(cert.toByteArray())) {
                        X509Certificate[] certSigner = this.getCertificateChain(certP7, cert);
                        BasicConstraints BC = (BasicConstraints)cert.getExtension(BasicConstraints.oid);
                        if (certSigner.length == 1 && BC == null) {
                            Vector vChain = new Vector();
                            errorC = cs.getCertificateChain(cert, vChain);
                            if (errorC == 0) {
                                Object[] chain = new X509Certificate[vChain.size()];
                                vChain.copyInto(chain);
                                if (chain != null) {
                                    errorC = cs.comprobar((X509Certificate[])chain);
                                    if (errorC != 0) {
                                        error = 420;
                                    }
                                } else {
                                    error = 420;
                                    errorC = 404;
                                }
                            } else {
                                error = 420;
                            }
                        } else {
                            ByteArrayOutputStream baosRoot = new ByteArrayOutputStream();
                            errorC = cs.getRoot(certSigner[certSigner.length - 1], baosRoot);
                            if (errorC == 0) {
                                X509Certificate aliasRoot = new X509Certificate(baosRoot.toByteArray());
                                if (aliasRoot != null) {
                                    X509Certificate[] certSignerPlusRaiz = new X509Certificate[certSigner.length + 1];
                                    for (int j = 0; j < certSigner.length; ++j) {
                                        certSignerPlusRaiz[j] = certSigner[j];
                                    }
                                    certSignerPlusRaiz[certSignerPlusRaiz.length - 1] = aliasRoot;
                                    errorC = cs.comprobar(certSignerPlusRaiz);
                                    if (errorC != 0) {
                                        error = 420;
                                    }
                                } else {
                                    errorC = 405;
                                    error = 420;
                                }
                            } else {
                                error = 420;
                            }
                            baosRoot.close();
                        }
                    } else {
                        error = 420;
                        errorC = 401;
                    }
                    certOut.addElement(cert);
                }
                catch (SignatureException se) {
                    se.printStackTrace();
                    IssuerAndSerialNumber ias = signerInfos[i].getIssuerAndSerialNumber();
                    Name is = ias.getIssuer();
                    BigInteger sn = ias.getSerialNumber();
                    X509Certificate falled = this.getCertificate((Principal)is, sn, certP7);
                    certOut.addElement(falled);
                    error = 420;
                    errorC = 402;
                }
                catch (X509ExtensionInitException eie) {
                    eie.printStackTrace();
                }
                catch (CertificateException ce) {
                    error = 413;
                }
                certErrores.addElement(new Integer(errorC));
            }
            bais.close();
        }
        catch (PKCSParsingException ppe) {
            error = 411;
        }
        catch (IOException ioe) {
            error = 409;
        }
        return error;
    }

    public int extractCertsPKCS7(byte[] p7, Vector certificados) {
        int error = 0;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(p7);
            bais.close();
            PKCS7CertList p7List = new PKCS7CertList((InputStream)bais);
            X509Certificate[] certList = p7List.getCertificateList();
            BasicConstraints bc = null;
            for (int i = 0; i < certList.length; ++i) {
                bc = (BasicConstraints)certList[i].getExtension(BasicConstraints.oid);
                if (bc != null && bc.ca()) continue;
                certificados.addElement(certList[i]);
            }
        }
        catch (X509ExtensionInitException xeie) {
            xeie.printStackTrace();
        }
        catch (IOException ioe) {
            error = 409;
        }
        catch (PKCSParsingException pkcspe) {
            error = 411;
        }
        return error;
    }

    public int extractHead(byte[] headDataIn, ByteArrayOutputStream dataOut, ByteArrayOutputStream headOut) {
        int error = 0;
        try {
            boolean encontrado = false;
            for (int i = 0; i < headDataIn.length; ++i) {
                char letra = (char)headDataIn[i];
                if (letra == '#') {
                    encontrado = true;
                    continue;
                }
                if (encontrado) {
                    dataOut.write(headDataIn[i]);
                    continue;
                }
                headOut.write(headDataIn[i]);
            }
            dataOut.close();
            headOut.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    public int appendHead(byte[] dataIn, byte[] headIn, ByteArrayOutputStream headDataOut) {
        int error = 0;
        try {
            ByteArrayOutputStream salidaDatos = new ByteArrayOutputStream();
            ByteArrayOutputStream salidaCabecera = new ByteArrayOutputStream();
            salidaDatos.write(dataIn);
            salidaCabecera.write(headIn);
            salidaDatos.close();
            salidaCabecera.close();
            String todo = salidaCabecera.toString("ISO8859_1") + "#" + salidaDatos.toString("ISO8859_1");
            headDataOut.write(todo.getBytes("ISO8859_1"));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    private boolean isDigitalSignature(byte[] certificado) {
        boolean digitalSignature = false;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            boolean[] b = cert.getKeyUsage();
            ByteArrayOutputStream politicaOID = new ByteArrayOutputStream();
            ByteArrayOutputStream userNotice = new ByteArrayOutputStream();
            AutenticacionFuerte af = new AutenticacionFuerte();
            int error = af.extractPolicy(certificado, politicaOID, userNotice);
            String politica = politicaOID.toString("ISO8859_1");
            if (error == 0) {
                digitalSignature = politica.equals(CtesAutenticacion.OID_POLITICA_eDNI_A) || politica.equals(CtesAutenticacion.OID_POLITICA_eDNI_F) ? b[1] : b[0];
            }
        }
        catch (CertificateException ce) {
            System.err.println(ce);
            return false;
        }
        catch (Exception e) {
            System.err.println(e);
            return false;
        }
        return digitalSignature;
    }

    private X509Certificate[] getCertificateChain(X509Certificate[] cadenaIn, X509Certificate cert) {
        Vector<X509Certificate> v = new Vector<X509Certificate>();
        v.addElement(cert);
        try {
            int i = 0;
            while (i < cadenaIn.length) {
                X509Certificate certificado = new X509Certificate(cadenaIn[i].toByteArray());
                if (((Object)cert.getIssuerDN()).equals(certificado.getSubjectDN())) {
                    v.addElement(new X509Certificate(certificado.toByteArray()));
                    if (((Object)certificado.getSubjectDN()).equals(certificado.getIssuerDN())) {
                        v.removeElementAt(v.size() - 1);
                        break;
                    }
                    i = 0;
                    cert = new X509Certificate(certificado.toByteArray());
                    continue;
                }
                ++i;
            }
        }
        catch (CertificateException ce) {
            System.err.println(ce);
        }
        X509Certificate[] cadenaSalida = new X509Certificate[v.size()];
        for (int z = 0; z < v.size(); ++z) {
            cadenaSalida[z] = (X509Certificate)v.elementAt(z);
        }
        return cadenaSalida;
    }

    private X509Certificate getCertificate(Principal is, BigInteger sn, X509Certificate[] certP7) {
        boolean encontrado = false;
        X509Certificate salida = null;
        for (int i = 0; i < certP7.length && !encontrado; ++i) {
            salida = certP7[i];
            if (!((Object)salida.getIssuerDN()).equals(is) || !salida.getSerialNumber().equals(sn)) continue;
            encontrado = true;
        }
        if (encontrado) {
            return salida;
        }
        return null;
    }

    private void saltarReturns(String entrada, ByteArrayOutputStream salida) {
        String temporal = "";
        int indice = 0;
        int i = 0;
        for (i = 0; i < entrada.length(); ++i) {
            if (entrada.charAt(i) != '\r') continue;
            temporal = temporal + entrada.substring(indice, i);
            indice = i + 2;
        }
        temporal = temporal + entrada.substring(indice, i);
        try {
            salida.write(temporal.getBytes("ISO8859_1"));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int sign(String issuerIn, String snIn, AlgorithmID signAlgorithm, InputStream data, String pathCS, String password, OutputStream p7, int mode) {
        int error = 0;
        try {
            Vector vChain;
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            ByteArrayOutputStream textoPlano_pru = new ByteArrayOutputStream();
            StreamCopier sc4 = new StreamCopier(data, (OutputStream)textoPlano_pru);
            sc4.copyStream();
            ByteArrayInputStream is = new ByteArrayInputStream(textoPlano_pru.toByteArray());
            SignedDataStream sds = new SignedDataStream((InputStream)is, mode);
            ByteArrayOutputStream aux = new ByteArrayOutputStream();
            error = cs.getCertCS(issuerIn, snIn, aux);
            if (error != 0) {
                return error;
            }
            PrivateKey pk = cs.getPrivateKeyFromKeyStore(issuerIn, snIn);
            if (pk == null) return 407;
            X509Certificate cert0 = new X509Certificate(aux.toByteArray());
            error = cs.getCertificateChain(cert0, vChain = new Vector());
            if (error != 0) {
                return error;
            }
            Object[] certAux = new X509Certificate[vChain.size()];
            vChain.copyInto(certAux);
            if (certAux == null) return 404;
            X509Certificate[] cert = new X509Certificate[certAux.length - 1];
            for (int i = 0; i < cert.length; ++i) {
                cert[i] = certAux[i];
            }
            if (!this.isDigitalSignature(cert[0].toByteArray())) return 401;
            sds.setCertificates(cert);
            IssuerAndSerialNumber iasn = new IssuerAndSerialNumber((java.security.cert.X509Certificate)cert[0]);
            SignerInfo si = new SignerInfo(iasn, signAlgorithm, pk);
            sds.addSignerInfo(si);
            if (mode == 2) {
                InputStream is2 = sds.getInputStream();
                is2.close();
            }
            ContentInfoStream cis = new ContentInfoStream((ContentStream)sds);
            cis.writeTo(p7);
            aux.close();
            return error;
        }
        catch (NoSuchAlgorithmException nsae) {
            return 403;
        }
        catch (IOException ioe) {
            System.err.println(ioe);
            return error;
        }
        catch (CertificateException ce) {
            return 413;
        }
        catch (PKCSException pkcse) {
            pkcse.printStackTrace();
        }
        return error;
    }

    public int verifySignAttached(InputStream p7, String pathCS, String password, OutputStream datosFirmados, Vector certOut, Vector certErrores) {
        int error = 0;
        try {
            ContentInfoStream cis = new ContentInfoStream(p7);
            SignedDataStream sds = (SignedDataStream)cis.getContent();
            StreamCopier sc2 = new StreamCopier(sds.getInputStream(), datosFirmados);
            sc2.copyStream();
            SignerInfo[] signerInfos = sds.getSignerInfos();
            X509Certificate cert = null;
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            X509Certificate[] certP7 = sds.getCertificates();
            int errorC = 0;
            RSACipherProvider rsaProv = new RSACipherProvider("IAIK", "IAIK");
            for (int i = 0; i < signerInfos.length; ++i) {
                try {
                    signerInfos[i].setRSACipherProvider(rsaProv);
                    cert = sds.verify(i);
                    if (this.isDigitalSignature(cert.toByteArray())) {
                        X509Certificate[] certSigner = this.getCertificateChain(certP7, cert);
                        BasicConstraints BC = (BasicConstraints)cert.getExtension(BasicConstraints.oid);
                        if (certSigner.length == 1 && BC == null) {
                            Vector vChain = new Vector();
                            errorC = cs.getCertificateChain(cert, vChain);
                            if (errorC == 0) {
                                Object[] chain = new X509Certificate[vChain.size()];
                                vChain.copyInto(chain);
                                if (chain != null) {
                                    errorC = cs.comprobar((X509Certificate[])chain);
                                    if (errorC != 0) {
                                        error = 420;
                                    }
                                } else {
                                    error = 420;
                                    errorC = 404;
                                }
                            } else {
                                error = 420;
                            }
                        } else {
                            ByteArrayOutputStream baosRoot = new ByteArrayOutputStream();
                            errorC = cs.getRoot(certSigner[certSigner.length - 1], baosRoot);
                            if (errorC == 0) {
                                X509Certificate aliasRoot = new X509Certificate(baosRoot.toByteArray());
                                if (aliasRoot != null) {
                                    X509Certificate[] certSignerPlusRaiz = new X509Certificate[certSigner.length + 1];
                                    for (int j = 0; j < certSigner.length; ++j) {
                                        certSignerPlusRaiz[j] = certSigner[j];
                                    }
                                    certSignerPlusRaiz[certSignerPlusRaiz.length - 1] = aliasRoot;
                                    errorC = cs.comprobar(certSignerPlusRaiz);
                                    if (errorC != 0) {
                                        error = 420;
                                    }
                                } else {
                                    errorC = 405;
                                    error = 420;
                                }
                            } else {
                                error = 420;
                            }
                            baosRoot.close();
                        }
                    } else {
                        error = 420;
                        errorC = 401;
                    }
                    certOut.addElement(cert);
                }
                catch (SignatureException se) {
                    se.printStackTrace();
                    IssuerAndSerialNumber ias = signerInfos[i].getIssuerAndSerialNumber();
                    Name is = ias.getIssuer();
                    BigInteger sn = ias.getSerialNumber();
                    X509Certificate falled = this.getCertificate((Principal)is, sn, certP7);
                    certOut.addElement(falled);
                    error = 420;
                    errorC = 402;
                }
                catch (X509ExtensionInitException eie) {
                    eie.printStackTrace();
                }
                catch (CertificateException ce) {
                    error = 413;
                }
                certErrores.addElement(new Integer(errorC));
            }
        }
        catch (PKCSParsingException ppe) {
            error = 411;
        }
        catch (IOException ioe) {
            error = 409;
        }
        return error;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int signAttached(String issuerIn, String snIn, AlgorithmID signAlgorithm, InputStream data, String pathCS, String password, OutputStream p7) {
        int error = 0;
        Object var9_9 = null;
        byte[] data_2 = null;
        try {
            ByteArrayOutputStream auxiliar;
            Miscelanea m = new Miscelanea();
            data_2 = m.inputStreamToBytes(data);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStream outputStream = p7;
            ByteArrayInputStream bais = new ByteArrayInputStream(data_2);
            ContentInfoStream cis2 = new ContentInfoStream((InputStream)bais);
            SignedDataStream sds = (SignedDataStream)cis2.getContent();
            ByteArrayOutputStream contenido = new ByteArrayOutputStream();
            StreamCopier sc2 = new StreamCopier(sds.getInputStream(), (OutputStream)contenido);
            sc2.copyStream();
            X509Certificate[] certAux = sds.getCertificates();
            ByteArrayInputStream is2 = new ByteArrayInputStream(contenido.toByteArray());
            sds.setInputStream((InputStream)is2);
            Vector<Object> v = new Vector<Object>();
            for (int i = 0; i < certAux.length; ++i) {
                v.addElement(certAux[i]);
            }
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            error = cs.getCertCS(issuerIn, snIn, auxiliar = new ByteArrayOutputStream());
            if (error != 0) {
                return error;
            }
            PrivateKey pk = cs.getPrivateKeyFromKeyStore(issuerIn, snIn);
            if (pk == null) return 407;
            X509Certificate cert0 = new X509Certificate(auxiliar.toByteArray());
            if (!this.isDigitalSignature(cert0.toByteArray())) return 401;
            Vector vChain = new Vector();
            error = cs.getCertificateChain(cert0, vChain);
            if (error != 0) {
                return error;
            }
            Object[] chain = new X509Certificate[vChain.size()];
            vChain.copyInto(chain);
            if (chain == null) return 404;
            for (int j = 0; j < chain.length - 1; ++j) {
                if (v.contains(chain[j])) continue;
                v.addElement(chain[j]);
            }
            Object[] certsFinal = new X509Certificate[v.size()];
            v.copyInto(certsFinal);
            sds.setCertificates((X509Certificate[])certsFinal);
            IssuerAndSerialNumber isn = new IssuerAndSerialNumber((java.security.cert.X509Certificate)cert0);
            SignerInfo si = new SignerInfo(isn, signAlgorithm, pk);
            sds.addSignerInfo(si);
            ContentInfoStream cis = new ContentInfoStream((ContentStream)sds);
            cis.writeTo(p7);
            bais.close();
            contenido.close();
            is2.close();
            auxiliar.close();
            return error;
        }
        catch (CertificateException ce) {
            return 413;
        }
        catch (PKCSParsingException pe) {
            return 411;
        }
        catch (IOException ioe) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(data_2);
                SignedDataStream sds4 = new SignedDataStream((InputStream)bais);
                bais.close();
                return error;
            }
            catch (PKCSParsingException ppe) {
                return 411;
            }
            catch (IOException ioe2) {
                return this.sign(issuerIn, snIn, signAlgorithm, data, pathCS, password, p7, 1);
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            return 403;
        }
        catch (PKCSException pkcse) {
            return 411;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int sign(String issuerIn, String snIn, AlgorithmID signAlgorithm, byte[] data, String pathCS, String password, OutputStream p7_2, int mode) {
        int error = 0;
        try {
            Vector vChain;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStream outputStream = p7_2;
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            ByteArrayInputStream is = new ByteArrayInputStream(data);
            SignedDataStream sds = new SignedDataStream((InputStream)is, mode);
            ByteArrayOutputStream aux = new ByteArrayOutputStream();
            error = cs.getCertCS(issuerIn, snIn, aux);
            if (error != 0) {
                return error;
            }
            PrivateKey pk = cs.getPrivateKeyFromKeyStore(issuerIn, snIn);
            if (pk == null) return 407;
            X509Certificate cert0 = new X509Certificate(aux.toByteArray());
            error = cs.getCertificateChain(cert0, vChain = new Vector());
            if (error != 0) {
                return error;
            }
            Object[] certAux = new X509Certificate[vChain.size()];
            vChain.copyInto(certAux);
            if (certAux == null) return 404;
            X509Certificate[] cert = new X509Certificate[certAux.length - 1];
            for (int i = 0; i < cert.length; ++i) {
                cert[i] = certAux[i];
            }
            if (!this.isDigitalSignature(cert[0].toByteArray())) return 401;
            sds.setCertificates(cert);
            IssuerAndSerialNumber iasn = new IssuerAndSerialNumber((java.security.cert.X509Certificate)cert[0]);
            SignerInfo si = new SignerInfo(iasn, signAlgorithm, pk);
            sds.addSignerInfo(si);
            if (mode == 2) {
                InputStream is2 = sds.getInputStream();
                ByteArrayOutputStream textoPlano = new ByteArrayOutputStream();
                StreamCopier sc3 = new StreamCopier(is2, (OutputStream)textoPlano);
                sc3.copyStream();
                is2.close();
                textoPlano.close();
            }
            ContentInfoStream cis = new ContentInfoStream((ContentStream)sds);
            cis.writeTo(outputStream);
            aux.close();
            is.close();
            return error;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return 403;
        }
        catch (IOException iOException) {
            return 411;
        }
        catch (CertificateException certificateException) {
            return 413;
        }
        catch (PKCSException pKCSException) {
            return 411;
        }
    }
}

