/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.autenticacionfuerte;

import com.izenpe.autenticacionfuerte.CtesAutenticacion;
import iaik.asn1.CodingException;
import iaik.asn1.GeneralizedTime;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AccessDescription;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.DistributionPoint;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.asn1.structures.PolicyInformation;
import iaik.asn1.structures.PolicyQualifierInfo;
import iaik.security.provider.IAIK;
import iaik.utils.RFC2253NameParser;
import iaik.utils.RFC2253NameParserException;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.AuthorityInfoAccess;
import iaik.x509.extensions.AuthorityKeyIdentifier;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.CRLDistributionPoints;
import iaik.x509.extensions.CertificatePolicies;
import iaik.x509.extensions.ExtendedKeyUsage;
import iaik.x509.extensions.IssuerAltName;
import iaik.x509.extensions.KeyUsage;
import iaik.x509.extensions.SubjectAltName;
import iaik.x509.extensions.SubjectDirectoryAttributes;
import iaik.x509.extensions.SubjectInfoAccess;
import iaik.x509.extensions.SubjectKeyIdentifier;
import iaik.x509.extensions.netscape.NetscapeCertType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class AutenticacionFuerte {
    static boolean critical;

    public AutenticacionFuerte() {
        IAIK iaik = new IAIK();
        IAIK.addAsJDK14Provider();
        IAIK.addAsProvider((boolean)false);
    }

    public int extractKeyUsage(byte[] certificado, ByteArrayOutputStream keyUsage) {
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            KeyUsage ku = (KeyUsage)cert.getExtension(KeyUsage.oid);
            if (ku != null) {
                critical = ku.isCritical();
                ByteArrayInputStream bais = new ByteArrayInputStream(ku.toString().getBytes("ISO8859_1"));
                StreamCopier sc = new StreamCopier((InputStream)bais, (OutputStream)keyUsage);
                sc.copyStream();
                bais.close();
            } else {
                error = 301;
            }
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        return error;
    }

    public int extractExtendedKeyUsage(byte[] certificado, ByteArrayOutputStream extendedKeyUsage) {
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            String result = "";
            ExtendedKeyUsage eku = (ExtendedKeyUsage)cert.getExtension(ExtendedKeyUsage.oid);
            if (eku != null) {
                critical = eku.isCritical();
                ObjectID[] purposes = eku.getKeyPurposeIDs();
                for (int i = 0; i < purposes.length; ++i) {
                    result = result + purposes[i].getName() + ",";
                }
                result = result.substring(0, result.length() - 1);
                ByteArrayInputStream bais = new ByteArrayInputStream(result.getBytes("ISO8859_1"));
                StreamCopier sc = new StreamCopier((InputStream)bais, (OutputStream)extendedKeyUsage);
                sc.copyStream();
                bais.close();
            } else {
                error = 301;
            }
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (IOException ioe) {
        }
        catch (X509ExtensionInitException ei) {
            // empty catch block
        }
        return error;
    }

    public int extractPolicy(byte[] certificado, ByteArrayOutputStream politicaOID, ByteArrayOutputStream userNotice) {
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            String result = "";
            String result1 = "";
            CertificatePolicies cp = (CertificatePolicies)cert.getExtension(CertificatePolicies.oid);
            if (cp != null) {
                critical = cp.isCritical();
                PolicyInformation[] pi = cp.getPolicyInformation();
                if (pi != null) {
                    ObjectID oid = pi[0].getPolicyIdentifier();
                    result1 = oid.getName();
                    PolicyQualifierInfo[] pq = pi[0].getPolicyQualifiers();
                    if (pq != null) {
                        for (int i = 0; i < pq.length; ++i) {
                            if (!pq[i].getPolicyQualifier().equals((Object)ObjectID.id_pkix_unotice)) continue;
                            result = pq[i].getExplicitTest().getValue().toString();
                            break;
                        }
                    }
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(result.getBytes("ISO8859_1"));
                StreamCopier sc = new StreamCopier((InputStream)bais, (OutputStream)userNotice);
                sc.copyStream();
                ByteArrayInputStream bais2 = new ByteArrayInputStream(result1.getBytes("ISO8859_1"));
                StreamCopier sc2 = new StreamCopier((InputStream)bais2, (OutputStream)politicaOID);
                sc2.copyStream();
                bais.close();
                bais2.close();
            } else {
                error = 301;
            }
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        return error;
    }

    public int extractSubject(byte[] certificado, ByteArrayOutputStream subject) {
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            Principal p = cert.getSubjectDN();
            ByteArrayInputStream bais = new ByteArrayInputStream(p.getName().getBytes("ISO8859_1"));
            StreamCopier sc = new StreamCopier((InputStream)bais, (OutputStream)subject);
            sc.copyStream();
            bais.close();
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
        return error;
    }

    public int parseSubject(byte[] certificado, String nombreA, ByteArrayOutputStream valorA) {
        int error = 0;
        try {
            ByteArrayOutputStream subjectC = new ByteArrayOutputStream();
            error = this.extractSubject(certificado, subjectC);
            StringTokenizer st = new StringTokenizer(subjectC.toString("ISO8859_1"), ",");
            boolean encontrado = false;
            String resultado = "";
            while (st.hasMoreTokens() && !encontrado) {
                StringTokenizer st2 = new StringTokenizer(st.nextToken(), "=");
                if (!st2.nextToken().equals(nombreA)) continue;
                resultado = st2.nextToken();
                encontrado = true;
            }
            if (!encontrado) {
                error = 303;
            } else {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(resultado.getBytes("ISO8859_1"));
                    StreamCopier sc = new StreamCopier((InputStream)bais, (OutputStream)valorA);
                    sc.copyStream();
                    bais.close();
                }
                catch (IOException ioe) {
                    System.err.println(ioe);
                }
            }
            subjectC.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    public int extractSubjectAltName(byte[] certificado, ByteArrayOutputStream subjectAlt) {
        int error = 0;
        X509Certificate cert = null;
        SubjectAltName san = null;
        try {
            cert = new X509Certificate(certificado);
            san = (SubjectAltName)cert.getExtension(SubjectAltName.oid);
            if (san != null) {
                critical = san.isCritical();
                String resultado = "";
                GeneralNames gn = san.getGeneralNames();
                Enumeration enu = gn.getNames();
                while (enu.hasMoreElements()) {
                    GeneralName gn1 = (GeneralName)enu.nextElement();
                    resultado = resultado + gn1.getName() + ",";
                }
                resultado = resultado.substring(0, resultado.length() - 1);
                ByteArrayInputStream bais = new ByteArrayInputStream(resultado.getBytes("ISO8859_1"));
                StreamCopier sc = new StreamCopier((InputStream)bais, (OutputStream)subjectAlt);
                sc.copyStream();
                bais.close();
            } else {
                error = 301;
            }
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        catch (IOException ce) {
            System.err.println(ce);
        }
        return error;
    }

    public int extractIssuerSerialNumber(byte[] certificado, ByteArrayOutputStream issuer, ByteArrayOutputStream serial) {
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            String p = cert.getIssuerDN().getName();
            String sn = cert.getSerialNumber().toString();
            ByteArrayInputStream bais1 = new ByteArrayInputStream(p.getBytes("ISO8859_1"));
            ByteArrayInputStream bais2 = new ByteArrayInputStream(sn.getBytes("ISO8859_1"));
            StreamCopier sc1 = new StreamCopier((InputStream)bais1, (OutputStream)issuer);
            StreamCopier sc2 = new StreamCopier((InputStream)bais2, (OutputStream)serial);
            sc1.copyStream();
            sc2.copyStream();
            bais1.close();
            bais2.close();
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
        return error;
    }

    public int parseCert(byte[] certificado, String oid, ByteArrayOutputStream valor, ByteArrayOutputStream criticidad) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectID ext = new ObjectID(oid);
        int resultado = 0;
        if (ext.equals((Object)ExtendedKeyUsage.oid)) {
            resultado = this.extractExtendedKeyUsage(certificado, valor);
        } else if (ext.equals((Object)CertificatePolicies.oid)) {
            resultado = this.extractPolicy(certificado, valor, baos);
        } else if (ext.equals((Object)SubjectAltName.oid)) {
            resultado = this.extractSubjectAltName(certificado, valor);
        } else if (ext.equals((Object)KeyUsage.oid)) {
            resultado = this.extractKeyUsage(certificado, valor);
        } else if (ext.equals((Object)AuthorityKeyIdentifier.oid)) {
            resultado = this.getAuthorityKeyIdentifier(certificado, valor);
        } else if (ext.equals((Object)SubjectKeyIdentifier.oid)) {
            resultado = this.getSubjectKeyIdentifier(certificado, valor);
        } else if (ext.equals((Object)BasicConstraints.oid)) {
            resultado = this.getBasicConstraints(certificado, valor);
        } else if (ext.equals((Object)IssuerAltName.oid)) {
            resultado = this.getIssuerAltName(certificado, valor);
        } else if (ext.equals((Object)CRLDistributionPoints.oid)) {
            resultado = this.getCrlDP(certificado, valor);
        } else if (ext.equals((Object)NetscapeCertType.oid)) {
            resultado = this.getNetscapeCertType(certificado, valor);
        } else if (ext.equals((Object)AuthorityInfoAccess.oid)) {
            resultado = this.getAuthorityInfoAccess(certificado, valor);
        } else if (ext.equals((Object)SubjectDirectoryAttributes.oid)) {
            resultado = this.getSubjectDirectoryAttributes(certificado, valor);
        } else if (ext.equals((Object)SubjectInfoAccess.oid)) {
            resultado = this.getSubjectInfoAccess(certificado, valor);
        }
        try {
            Boolean b = new Boolean(critical);
            ByteArrayInputStream bais = new ByteArrayInputStream(b.toString().getBytes("ISO8859_1"));
            StreamCopier sc = new StreamCopier((InputStream)bais, (OutputStream)criticidad);
            sc.copyStream();
            bais.close();
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
        return resultado;
    }

    public int extractIdentificativo(byte[] certificado, String cadena, String extensionOID, ByteArrayOutputStream salida) {
        int error = 0;
        ObjectID ext = null;
        String[] tipos = new String[]{"-DNI", "-TIS", "-TISR", "-NIE", "-dni", "-tis", "-tisr", "-nie"};
        ext = extensionOID == null || extensionOID.equals("") ? ObjectID.dnQualifier : new ObjectID(extensionOID);
        if (cadena == null) {
            cadena = "";
        }
        try {
            String restoSalida;
            X509Certificate cert = new X509Certificate(certificado);
            Principal subject = cert.getSubjectDN();
            String rcf2253Name = subject.getName();
            RFC2253NameParser nameParser = new RFC2253NameParser(rcf2253Name);
            RFC2253NameParser.register((String)"dnQualifier", (ObjectID)ext);
            RFC2253NameParser.register((String)"givenName", (ObjectID)ObjectID.givenName);
            Name sdn = nameParser.parse();
            String salidaString = sdn.getRDN(ext);
            int valorRestoSalida = salidaString.indexOf(cadena);
            if (valorRestoSalida != -1 || cadena.equals("")) {
                restoSalida = "";
                restoSalida = salidaString.substring(valorRestoSalida + cadena.length(), salidaString.length());
                int valorfinRestoSalida = 0;
                if (!cadena.equals("")) {
                    for (int x = 0; x < 8; ++x) {
                        valorfinRestoSalida = restoSalida.indexOf(tipos[x]);
                        if (valorfinRestoSalida != -1) {
                            restoSalida = restoSalida.substring(0, valorfinRestoSalida);
                            break;
                        }
                        valorfinRestoSalida = 0;
                    }
                }
            } else {
                error = 305;
                return 305;
            }
            salida.write(restoSalida.trim().getBytes());
        }
        catch (CertificateException ce) {
            error = 305;
        }
        catch (IOException ioe) {
            error = 302;
        }
        catch (RFC2253NameParserException ce) {
            error = 303;
        }
        catch (NullPointerException npe) {
            error = 304;
        }
        return error;
    }

    protected String extractDatos(byte[] certificado, String cadenaAExtraer) {
        String cadenaDeSalida = "-1";
        X509Certificate cert = null;
        String valorSubject = "";
        try {
            cert = new X509Certificate(certificado);
            Principal p = cert.getSubjectDN();
            valorSubject = p.getName();
        }
        catch (CertificateException ce) {
            cadenaDeSalida = "-1";
            return "-1";
        }
        if (cadenaAExtraer != null && cadenaAExtraer != "") {
            try {
                int valorCargo = 0;
                Vector<String> listaStrings = new Vector<String>();
                StringTokenizer st1 = new StringTokenizer(valorSubject, ",");
                while (st1.hasMoreTokens()) {
                    listaStrings.addElement(st1.nextToken());
                }
                Object[] arrayString = new String[listaStrings.size()];
                listaStrings.copyInto(arrayString);
                for (int i = 0; i < arrayString.length; ++i) {
                    int valorRestoSalida = -1;
                    String tempcadenaAExtraer = cadenaAExtraer;
                    if (cadenaAExtraer.equals("1.3.6.1.4.1.17326.30.3")) {
                        cadenaAExtraer = cadenaAExtraer + "=E";
                        valorRestoSalida = ((String)arrayString[i]).indexOf(cadenaAExtraer);
                    } else if (cadenaAExtraer.equals("OUCargo")) {
                        if (((String)arrayString[i]).indexOf("OU") != -1) {
                            ++valorCargo;
                        }
                        if (valorCargo == 4) {
                            valorRestoSalida = ((String)arrayString[i]).indexOf("OU");
                            cadenaAExtraer = "OU";
                        }
                    } else {
                        valorRestoSalida = ((String)arrayString[i]).indexOf(cadenaAExtraer + "=");
                    }
                    if (valorRestoSalida != -1 || cadenaAExtraer.equals("")) {
                        cadenaDeSalida = ((String)arrayString[i]).substring(valorRestoSalida + cadenaAExtraer.length() + 1, ((String)arrayString[i]).length());
                    }
                    cadenaAExtraer = tempcadenaAExtraer;
                }
            }
            catch (NullPointerException npe) {
                cadenaDeSalida = "-1";
                return "-1";
            }
        } else {
            cadenaDeSalida = "-1";
            return "-1";
        }
        return cadenaDeSalida;
    }

    private boolean existePolitica(String politica) {
        boolean encontrada = false;
        if (politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PEP_PREV) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PEP) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_PREV) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_1_PREV) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_1) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PE_PREV) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PE) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ASSE_PREV) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ASSE) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CR_PREV) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CR) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_2_PREV) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_2) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CP_PREV) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CP) || politica.equals(CtesAutenticacion.OID_POLITICA_eDNI_A) || politica.equals(CtesAutenticacion.OID_POLITICA_eDNI_F) || politica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPF_S) || politica.equals(CtesAutenticacion.OID_POLITICA_ANCERT_FEREN) || politica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPF_T) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_OA_PREV) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_OA) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_1_PREV) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_1) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_2_PREV) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_2) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_SPJ_PREV) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_SPJ) || politica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPJ_S) || politica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPJ_T) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ARSSE_PREV) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ARSSE) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_EE_PREV) || politica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_EE) || politica.equals(CtesAutenticacion.OID_POLITICA_ANCERT_CCP) || politica.equals(CtesAutenticacion.OID_POLITICA_FNMT)) {
            encontrada = true;
        }
        return encontrada;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int extractIDPersona(byte[] certificado, ByteArrayOutputStream salida) {
        int error = 0;
        ByteArrayOutputStream politica = new ByteArrayOutputStream();
        ByteArrayOutputStream usernotice = new ByteArrayOutputStream();
        error = this.extractPolicy(certificado, politica, usernotice);
        String cadenaSubject = "";
        if (error != 0) return 306;
        String tempPolitica = "";
        try {
            tempPolitica = politica.toString("ISO8859_1");
        }
        catch (UnsupportedEncodingException e1) {
            return 306;
        }
        if (!this.existePolitica(tempPolitica)) {
            return 307;
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PEP_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PEP) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_1_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_1) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PE) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ASSE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ARSSE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ARSSE) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ASSE)) {
            cadenaSubject = "dnQualifier";
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CR_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CR) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_2_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_2) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CP_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CP) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_eDNI_A) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_eDNI_F) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPF_S) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_ANCERT_FEREN) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPF_T)) {
            cadenaSubject = "serialNumber";
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_OA_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_OA) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_1_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_1) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_2_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_2) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_SPJ_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_SPJ) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPJ_S) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPJ_T)) {
            cadenaSubject = "1.3.6.1.4.1.18838.1.1";
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_EE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_EE)) {
            cadenaSubject = "1.3.6.1.4.1.14777.100.2";
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_FNMT)) {
            cadenaSubject = "CN";
        }
        if (cadenaSubject == null) return 306;
        if (cadenaSubject.equals("")) return 306;
        String restoSalida = this.extractDatos(certificado, cadenaSubject);
        if (restoSalida != null && !restoSalida.equals("") && !restoSalida.equals("-1")) {
            try {
                if (restoSalida.lastIndexOf("-DNI") != -1) {
                    restoSalida = restoSalida.substring(restoSalida.indexOf("-DNI") + "-DNI".length()).trim();
                }
                if (restoSalida.lastIndexOf("-dni") != -1) {
                    restoSalida = restoSalida.substring(restoSalida.indexOf("-dni") + "-dni".length()).trim();
                }
                if (restoSalida.lastIndexOf("-NIE") != -1) {
                    restoSalida = restoSalida.substring(restoSalida.indexOf("-NIE") + "-NIE".length()).trim();
                }
                if (restoSalida.lastIndexOf("-nie") != -1) {
                    restoSalida = restoSalida.substring(restoSalida.indexOf("-nie") + "-nie".length()).trim();
                }
                if (restoSalida.indexOf("-TIS") != -1) {
                    restoSalida = restoSalida.substring(0, restoSalida.indexOf("-TIS")).trim();
                }
                if (restoSalida.indexOf("-tis") != -1) {
                    restoSalida = restoSalida.substring(0, restoSalida.indexOf("-tis")).trim();
                }
                if (restoSalida.indexOf("-TISR") != -1) {
                    restoSalida = restoSalida.substring(0, restoSalida.indexOf("-TISR")).trim();
                }
                if (restoSalida.indexOf("-tisr") != -1) {
                    restoSalida = restoSalida.substring(0, restoSalida.indexOf("-tisr")).trim();
                }
                salida.write(restoSalida.trim().getBytes());
                return error;
            }
            catch (IOException e) {
                return 306;
            }
        } else {
            salida.reset();
        }
        return error;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int extractTIS(byte[] certificado, ByteArrayOutputStream salida) {
        int error = 0;
        ByteArrayOutputStream politica = new ByteArrayOutputStream();
        ByteArrayOutputStream usernotice = new ByteArrayOutputStream();
        error = this.extractPolicy(certificado, politica, usernotice);
        String cadenaSubject = "";
        if (error != 0) return 306;
        String tempPolitica = "";
        try {
            tempPolitica = politica.toString("ISO8859_1");
        }
        catch (UnsupportedEncodingException e1) {
            return 306;
        }
        if (!this.existePolitica(tempPolitica)) {
            return 307;
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ASSE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ASSE) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ARSSE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ARSSE)) {
            cadenaSubject = "dnQualifier";
        }
        if (cadenaSubject == null) return 306;
        if (cadenaSubject.equals("")) return 306;
        String restoSalida = this.extractDatos(certificado, cadenaSubject);
        if (restoSalida != null && !restoSalida.equals("") && !restoSalida.equals("-1")) {
            try {
                if (restoSalida.lastIndexOf("-TIS") != -1) {
                    restoSalida = restoSalida.substring(restoSalida.indexOf("-TIS") + "-TIS".length()).trim();
                }
                if (restoSalida.lastIndexOf("-tis") != -1) {
                    restoSalida = restoSalida.substring(restoSalida.indexOf("-tis") + "-tis".length()).trim();
                }
                if (restoSalida.indexOf("-TISR") != -1) {
                    restoSalida = restoSalida.substring(0, restoSalida.indexOf("-TISR")).trim();
                }
                if (restoSalida.indexOf("-tisr") != -1) {
                    restoSalida = restoSalida.substring(0, restoSalida.indexOf("-tisr")).trim();
                }
                salida.write(restoSalida.trim().getBytes());
                return error;
            }
            catch (IOException e) {
                return 306;
            }
        } else {
            salida.reset();
        }
        return error;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int extractTISR(byte[] certificado, ByteArrayOutputStream salida) {
        int error = 0;
        ByteArrayOutputStream politica = new ByteArrayOutputStream();
        ByteArrayOutputStream usernotice = new ByteArrayOutputStream();
        error = this.extractPolicy(certificado, politica, usernotice);
        String cadenaSubject = "";
        if (error != 0) return 306;
        String tempPolitica = "";
        try {
            tempPolitica = politica.toString("ISO8859_1");
        }
        catch (UnsupportedEncodingException e1) {
            return 306;
        }
        if (!this.existePolitica(tempPolitica)) {
            return 307;
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ARSSE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ARSSE)) {
            cadenaSubject = "dnQualifier";
        }
        if (cadenaSubject == null) return 306;
        if (cadenaSubject.equals("")) return 306;
        String restoSalida = this.extractDatos(certificado, cadenaSubject);
        if (restoSalida != null && !restoSalida.equals("") && !restoSalida.equals("-1")) {
            try {
                if (restoSalida.lastIndexOf("-TISR") != -1) {
                    restoSalida = restoSalida.substring(restoSalida.indexOf("-TISR") + "-TISR".length()).trim();
                }
                if (restoSalida.lastIndexOf("-tisr") != -1) {
                    restoSalida = restoSalida.substring(restoSalida.indexOf("-tisr") + "-tisr".length()).trim();
                }
                salida.write(restoSalida.trim().getBytes());
                return error;
            }
            catch (IOException e) {
                return 306;
            }
        } else {
            salida.reset();
        }
        return error;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int extractIdentidad(byte[] certificado, ByteArrayOutputStream salida) {
        int error = 0;
        ByteArrayOutputStream politica = new ByteArrayOutputStream();
        ByteArrayOutputStream usernotice = new ByteArrayOutputStream();
        error = this.extractPolicy(certificado, politica, usernotice);
        String cadenaSubject = "";
        if (error != 0) return 306;
        String tempPolitica = "";
        try {
            tempPolitica = politica.toString("ISO8859_1");
        }
        catch (UnsupportedEncodingException e1) {
            return 306;
        }
        if (!this.existePolitica(tempPolitica)) {
            return 307;
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_OA_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_OA) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_1_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_1) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_2_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_2) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_SPJ_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_SPJ) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPJ_S) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPJ_T) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_EE_PREV)) {
            cadenaSubject = "serialNumber";
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PE_PREV)) {
            cadenaSubject = "dnQualifier";
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPF_S) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPF_T)) {
            cadenaSubject = "1.3.6.1.4.1.17326.30.3";
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_ANCERT_CCP)) {
            cadenaSubject = "O";
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_FNMT)) {
            cadenaSubject = "CN";
        }
        if (cadenaSubject == null) return 306;
        if (cadenaSubject.equals("")) return 306;
        String restoSalida = this.extractDatos(certificado, cadenaSubject);
        if (restoSalida != null && !restoSalida.equals("") && !restoSalida.equals("-1")) {
            try {
                salida.write(restoSalida.trim().getBytes());
                return error;
            }
            catch (IOException e) {
                return 306;
            }
        } else {
            salida.reset();
        }
        return error;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int extractNombre(byte[] certificado, ByteArrayOutputStream salida) {
        int error = 0;
        ByteArrayOutputStream politica = new ByteArrayOutputStream();
        ByteArrayOutputStream usernotice = new ByteArrayOutputStream();
        error = this.extractPolicy(certificado, politica, usernotice);
        String cadenaSubject = "";
        if (error != 0) return 306;
        String tempPolitica = "";
        try {
            tempPolitica = politica.toString("ISO8859_1");
        }
        catch (UnsupportedEncodingException e1) {
            return 306;
        }
        if (!this.existePolitica(tempPolitica)) {
            return 307;
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PEP_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PEP) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CR_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CR) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_OA_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_OA) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_2_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_2) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PE) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_1_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_1) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_2_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_2) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ASSE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ASSE) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ARSSE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ARSSE) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_EE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_EE) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CP_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CP) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_eDNI_A) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_eDNI_F) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPF_S) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPJ_S) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPF_T) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPJ_T) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_ANCERT_FEREN)) {
            cadenaSubject = "givenName";
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_1_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_1) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_FNMT)) {
            cadenaSubject = "CN";
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_SPJ_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_SPJ)) {
            cadenaSubject = "serialNumber";
        }
        if (cadenaSubject == null) return 306;
        if (cadenaSubject.equals("")) return 306;
        String restoSalida = this.extractDatos(certificado, cadenaSubject);
        if (restoSalida != null && !restoSalida.equals("") && !restoSalida.equals("-1")) {
            try {
                salida.write(restoSalida.trim().getBytes());
                return error;
            }
            catch (IOException e) {
                return 306;
            }
        } else {
            salida.reset();
        }
        return error;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int extractApellidos(byte[] certificado, ByteArrayOutputStream salida) {
        int error = 0;
        ByteArrayOutputStream politica = new ByteArrayOutputStream();
        ByteArrayOutputStream usernotice = new ByteArrayOutputStream();
        error = this.extractPolicy(certificado, politica, usernotice);
        String cadenaSubject = "";
        if (error != 0) return 306;
        String tempPolitica = "";
        try {
            tempPolitica = politica.toString("ISO8859_1");
        }
        catch (UnsupportedEncodingException e1) {
            return 306;
        }
        if (!this.existePolitica(tempPolitica)) {
            return 307;
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PEP_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PEP) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CR_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CR) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_OA_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_OA) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_2_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_2) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PE) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_1_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_1) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_2_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_2) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_SPJ_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_SPJ) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ASSE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ASSE) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ARSSE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ARSSE) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_EE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_EE) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CP_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CP) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPF_S) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPJ_S) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPF_T) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPJ_T) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_ANCERT_FEREN)) {
            cadenaSubject = "SN";
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_1_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_1) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_eDNI_A) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_eDNI_F) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_FNMT)) {
            cadenaSubject = "CN";
        }
        if (cadenaSubject == null) return 306;
        if (cadenaSubject.equals("")) return 306;
        String restoSalida = this.extractDatos(certificado, cadenaSubject);
        if (restoSalida != null && !restoSalida.equals("") && !restoSalida.equals("-1")) {
            try {
                salida.write(restoSalida.trim().getBytes());
                return error;
            }
            catch (IOException e) {
                return 306;
            }
        } else {
            salida.reset();
        }
        return error;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int extractEntidad(byte[] certificado, ByteArrayOutputStream salida) {
        int error = 0;
        ByteArrayOutputStream politica = new ByteArrayOutputStream();
        ByteArrayOutputStream usernotice = new ByteArrayOutputStream();
        error = this.extractPolicy(certificado, politica, usernotice);
        String cadenaSubject = "";
        if (error != 0) return 306;
        String tempPolitica = "";
        try {
            tempPolitica = politica.toString("ISO8859_1");
        }
        catch (UnsupportedEncodingException e1) {
            return 306;
        }
        if (!this.existePolitica(tempPolitica)) {
            return 307;
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PEP_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PEP) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CR_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CR) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_OA_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_OA) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PE) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_1_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_1) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_2_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_2) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_SPJ_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_SPJ) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_EE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_EE) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CP_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CP) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPF_S) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPF_T)) {
            cadenaSubject = "O";
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPJ_S) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPJ_T) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_ANCERT_CCP)) {
            cadenaSubject = "CN";
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_ANCERT_FEREN)) {
            cadenaSubject = "OU";
        }
        if (cadenaSubject == null) return 306;
        if (cadenaSubject.equals("")) return 306;
        String restoSalida = this.extractDatos(certificado, cadenaSubject);
        if (restoSalida != null && !restoSalida.equals("") && !restoSalida.equals("-1")) {
            try {
                salida.write(restoSalida.trim().getBytes());
                return error;
            }
            catch (IOException e) {
                return 306;
            }
        } else {
            salida.reset();
        }
        return error;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int extractEmail(byte[] certificado, ByteArrayOutputStream salida) {
        int error = 0;
        ByteArrayOutputStream politica = new ByteArrayOutputStream();
        ByteArrayOutputStream usernotice = new ByteArrayOutputStream();
        error = this.extractPolicy(certificado, politica, usernotice);
        String cadenaSubject = "";
        if (error != 0) return 306;
        String tempPolitica = "";
        try {
            tempPolitica = politica.toString("ISO8859_1");
        }
        catch (UnsupportedEncodingException e1) {
            return 306;
        }
        if (!this.existePolitica(tempPolitica)) {
            return 307;
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PEP_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PEP) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CR_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CR) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PE) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_1_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_1) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_SPJ_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_SPJ) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_EE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_EE) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CP_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CP) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPF_S) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPJ_S) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPF_T) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_CAMERFIRMA_CCPJ_T) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_ANCERT_CCP) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_ANCERT_FEREN) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_FNMT)) {
            cadenaSubject = "EmailAddressAlternative";
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_OA_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_OA)) {
            cadenaSubject = "EMAIL";
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_FNMT)) {
            cadenaSubject = "CN";
        }
        if (cadenaSubject == null) return 306;
        if (cadenaSubject.equals("")) return 306;
        Object restoSalida = "";
        if (cadenaSubject.equals("EmailAddressAlternative")) {
            ByteArrayOutputStream altName = new ByteArrayOutputStream();
            error = this.extractSubjectAltName(certificado, altName);
            if (error == 0) {
                try {
                    Vector<String> listaStrings = new Vector<String>();
                    StringTokenizer st1 = new StringTokenizer(altName.toString("ISO8859_1"), ",");
                    while (st1.hasMoreTokens()) {
                        listaStrings.addElement(st1.nextToken());
                    }
                    Object[] tempSalida = new String[listaStrings.size()];
                    listaStrings.copyInto(tempSalida);
                    restoSalida = tempSalida[0];
                }
                catch (UnsupportedEncodingException e) {
                    return 306;
                }
            }
        } else {
            restoSalida = this.extractDatos(certificado, cadenaSubject);
        }
        if (restoSalida != null && !((String)restoSalida).equals("") && !((String)restoSalida).equals("-1")) {
            try {
                salida.write(((String)restoSalida).trim().getBytes());
                return error;
            }
            catch (IOException e) {
                return 306;
            }
        } else {
            salida.reset();
        }
        return error;
    }

    public int extractFechaNac(byte[] certificado, ByteArrayOutputStream salida) {
        int error = 0;
        error = this.getSubjectDirectoryAttributes(certificado, salida);
        return error;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int extractTitle(byte[] certificado, ByteArrayOutputStream salida) {
        int error = 0;
        ByteArrayOutputStream politica = new ByteArrayOutputStream();
        ByteArrayOutputStream usernotice = new ByteArrayOutputStream();
        error = this.extractPolicy(certificado, politica, usernotice);
        String cadenaSubject = "";
        if (error != 0) return 306;
        String tempPolitica = "";
        try {
            tempPolitica = politica.toString("ISO8859_1");
        }
        catch (UnsupportedEncodingException e1) {
            return 306;
        }
        if (!this.existePolitica(tempPolitica)) {
            return 307;
        }
        if (tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PEP_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PEP) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_1_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_1) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_PE) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ASSE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ASSE) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CR_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CR) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_2_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_C_2) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CP_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_CP) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_OA_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_OA) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_1_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_1) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_2_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_E_2) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_SPJ_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_SPJ) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ARSSE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_ARSSE) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_EE_PREV) || tempPolitica.equals(CtesAutenticacion.OID_POLITICA_IZENPE_EE)) {
            cadenaSubject = "OUCargo";
        }
        if (cadenaSubject == null) return 306;
        if (cadenaSubject.equals("")) return 306;
        String restoSalida = this.extractDatos(certificado, cadenaSubject);
        if (restoSalida != null && !restoSalida.equals("") && !restoSalida.equals("-1")) {
            try {
                salida.write(restoSalida.trim().getBytes());
                return error;
            }
            catch (IOException e) {
                return 306;
            }
        } else {
            salida.reset();
        }
        return error;
    }

    public int getAuthorityInfoAccessOCSP(byte[] certi, ByteArrayOutputStream baos) {
        AuthorityInfoAccess aia = null;
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certi);
            aia = (AuthorityInfoAccess)cert.getExtension(AuthorityInfoAccess.oid);
            if (aia != null) {
                Enumeration enu = aia.getAccessDescriptions();
                String loc = null;
                while (enu.hasMoreElements()) {
                    AccessDescription ad = (AccessDescription)enu.nextElement();
                    loc = ad.getAccessLocation().getName().toString();
                    if (!ad.getAccessMethod().equals((Object)ObjectID.ocsp)) continue;
                    StreamCopier sc = new StreamCopier((InputStream)new ByteArrayInputStream(loc.getBytes("ISO8859_1")), (OutputStream)baos);
                    sc.copyStream();
                }
            } else {
                error = 307;
            }
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (X509ExtensionInitException ei) {
            error = 302;
        }
        catch (IOException ioe) {
            error = 301;
        }
        return error;
    }

    private int getCrlDP(byte[] certificado, ByteArrayOutputStream baos) {
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            CRLDistributionPoints dp = (CRLDistributionPoints)cert.getExtension(CRLDistributionPoints.oid);
            String uri = null;
            if (dp != null) {
                critical = dp.isCritical();
                Enumeration e = dp.getDistributionPoints();
                DistributionPoint dp1 = null;
                for (int i = 0; e.hasMoreElements() && i < 1; ++i) {
                    dp1 = (DistributionPoint)e.nextElement();
                    String uriC = dp1.getDistributionPointName().toString();
                    StringTokenizer st = new StringTokenizer(uriC, " ");
                    st.nextToken();
                    uri = st.nextToken();
                }
            } else {
                error = 301;
            }
            if (uri != null) {
                StreamCopier sc = new StreamCopier((InputStream)new ByteArrayInputStream(uri.getBytes("ISO8859_1")), (OutputStream)baos);
                sc.copyStream();
            } else {
                baos = null;
            }
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (X509ExtensionInitException pe) {
            System.err.println((Object)pe);
        }
        return error;
    }

    private int getAuthorityKeyIdentifier(byte[] certi, ByteArrayOutputStream baos) {
        AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier();
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certi);
            aki = (AuthorityKeyIdentifier)cert.getExtension(AuthorityKeyIdentifier.oid);
            if (aki != null) {
                critical = aki.isCritical();
                SubjectKeyIdentifier ski = new SubjectKeyIdentifier(aki.getKeyIdentifier());
                StreamCopier sc = new StreamCopier((InputStream)new ByteArrayInputStream(ski.toString().getBytes("ISO8859_1")), (OutputStream)baos);
                sc.copyStream();
            } else {
                error = 301;
            }
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (CertificateException ce) {
            error = 302;
        }
        return error;
    }

    private int getSubjectKeyIdentifier(byte[] certi, ByteArrayOutputStream baos) {
        SubjectKeyIdentifier ski = new SubjectKeyIdentifier();
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certi);
            ski = (SubjectKeyIdentifier)cert.getExtension(SubjectKeyIdentifier.oid);
            if (ski != null) {
                StreamCopier sc = new StreamCopier((InputStream)new ByteArrayInputStream(ski.toString().getBytes("ISO8859_1")), (OutputStream)baos);
                sc.copyStream();
                critical = ski.isCritical();
            } else {
                error = 301;
            }
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (CertificateException ce) {
            error = 302;
        }
        return error;
    }

    private int getBasicConstraints(byte[] certi, ByteArrayOutputStream baos) {
        BasicConstraints bc = null;
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certi);
            bc = (BasicConstraints)cert.getExtension(BasicConstraints.oid);
            if (bc != null) {
                critical = bc.isCritical();
                Boolean b = new Boolean(bc.ca());
                StreamCopier sc = new StreamCopier((InputStream)new ByteArrayInputStream(b.toString().getBytes("ISO8859_1")), (OutputStream)baos);
                sc.copyStream();
            } else {
                error = 301;
            }
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    private int getIssuerAltName(byte[] certi, ByteArrayOutputStream baos) {
        IssuerAltName ian = null;
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certi);
            ian = (IssuerAltName)cert.getExtension(IssuerAltName.oid);
            if (ian != null) {
                StreamCopier sc = new StreamCopier((InputStream)new ByteArrayInputStream(ian.getName().getBytes("ISO8859_1")), (OutputStream)baos);
                sc.copyStream();
                critical = ian.isCritical();
            } else {
                error = 301;
            }
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    private int getNetscapeCertType(byte[] certi, ByteArrayOutputStream baos) {
        int error = 0;
        NetscapeCertType nct = null;
        try {
            X509Certificate cert = new X509Certificate(certi);
            nct = (NetscapeCertType)cert.getExtension(NetscapeCertType.oid);
            if (nct != null) {
                critical = nct.isCritical();
                StringTokenizer st = new StringTokenizer(nct.toString(), ":");
                Vector<String> v = new Vector<String>();
                while (st.hasMoreTokens()) {
                    v.addElement(st.nextToken());
                }
                String def = (String)v.elementAt(1);
                String salida = def.substring(1, def.length());
                StreamCopier sc = new StreamCopier((InputStream)new ByteArrayInputStream(salida.getBytes("ISO8859_1")), (OutputStream)baos);
                sc.copyStream();
            } else {
                error = 301;
            }
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    private int getAuthorityInfoAccess(byte[] certi, ByteArrayOutputStream baos) {
        AuthorityInfoAccess aia = null;
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certi);
            aia = (AuthorityInfoAccess)cert.getExtension(AuthorityInfoAccess.oid);
            if (aia != null) {
                critical = aia.isCritical();
                Enumeration enu = aia.getAccessDescriptions();
                String loc = null;
                while (enu.hasMoreElements()) {
                    AccessDescription ad = (AccessDescription)enu.nextElement();
                    loc = ad.getAccessLocation().getName().toString();
                }
                StreamCopier sc = new StreamCopier((InputStream)new ByteArrayInputStream(loc.getBytes("ISO8859_1")), (OutputStream)baos);
                sc.copyStream();
            } else {
                error = 301;
            }
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    private int getSubjectDirectoryAttributes(byte[] certi, ByteArrayOutputStream dateOfBirth) {
        int error = 0;
        SubjectDirectoryAttributes sda = null;
        try {
            X509Certificate cert = new X509Certificate(certi);
            sda = (SubjectDirectoryAttributes)cert.getExtension(SubjectDirectoryAttributes.oid);
            if (sda != null) {
                critical = sda.isCritical();
                Attribute[] atribs = sda.getAttributes();
                GeneralizedTime gt = null;
                if (atribs != null) {
                    AttributeValue atribV = null;
                    for (int i = 0; i < atribs.length; ++i) {
                        atribV = atribs[i].getAttributeValue();
                        if (!atribV.getAttributeType().equals((Object)ObjectID.dateOfBirth)) continue;
                        gt = new GeneralizedTime(atribV.toASN1Object().getValue().toString());
                    }
                }
                if (gt != null) {
                    dateOfBirth.write(gt.getValue().toString().getBytes("ISO8859_1"));
                } else {
                    error = 301;
                }
            } else {
                error = 301;
            }
        }
        catch (CertificateException ce) {
            error = 302;
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (CodingException coe) {
            coe.printStackTrace();
        }
        return error;
    }

    private int getSubjectInfoAccess(byte[] certIn, ByteArrayOutputStream sia) {
        int error = 0;
        SubjectInfoAccess subjectInfoAccess = null;
        try {
            X509Certificate cert = new X509Certificate(certIn);
            subjectInfoAccess = (SubjectInfoAccess)cert.getExtension(SubjectInfoAccess.oid);
            GeneralName gn = null;
            if (subjectInfoAccess != null) {
                critical = subjectInfoAccess.isCritical();
                Enumeration accessDs = subjectInfoAccess.getAccessDescriptions();
                AccessDescription ad = null;
                while (accessDs.hasMoreElements()) {
                    ad = (AccessDescription)accessDs.nextElement();
                    gn = ad.getAccessLocation();
                }
                sia.write(gn.getName().toString().getBytes("ISO8859_1"));
            } else {
                error = 301;
            }
        }
        catch (CertificateException ce) {
            error = 302;
            ce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (X509ExtensionInitException xeie) {
            xeie.printStackTrace();
        }
        return error;
    }
}

