/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import java.io.IOException;
import java.io.StringReader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.Window;
import org.apache.batik.script.rhino.RhinoInterpreter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;
import org.w3c.dom.Document;

public class WindowWrapper
extends ScriptableObject {
    private static final Object[] EMPTY_ARGUMENTS = new Object[0];
    protected RhinoInterpreter interpreter;
    protected Window window;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$w3c$dom$Document;

    public static Object jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        WindowWrapper result = new WindowWrapper();
        result.window = (Window)((Wrapper)args[0]).unwrap();
        return result;
    }

    public String getClassName() {
        return "Window";
    }

    public String toString() {
        return "[object Window]";
    }

    public static void jsFunction_eval(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws JavaScriptException {
        int len = args.length;
        WindowWrapper ww = (WindowWrapper)thisObj;
        Window window = ww.window;
        if (len >= 1) {
            String code = (String)NativeJavaObject.coerceType((Class)(class$java$lang$String == null ? (class$java$lang$String = WindowWrapper.class$("java.lang.String")) : class$java$lang$String), (Object)args[0]);
            RhinoInterpreter interp = (RhinoInterpreter)window.getInterpreter();
            try {
                interp.evaluate(code);
            }
            catch (InterpreterException e) {
                throw new JavaScriptException((Object)e);
            }
        }
    }

    public static Object jsFunction_setInterval(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws JavaScriptException {
        int len = args.length;
        WindowWrapper ww = (WindowWrapper)thisObj;
        Window window = ww.window;
        if (len < 2) {
            throw Context.reportRuntimeError((String)"invalid argument count");
        }
        long to = (Long)NativeJavaObject.coerceType(Long.TYPE, (Object)args[1]);
        if (args[0] instanceof Function) {
            RhinoInterpreter interp = (RhinoInterpreter)window.getInterpreter();
            FunctionWrapper fw = new FunctionWrapper(interp, (Function)args[0], EMPTY_ARGUMENTS);
            return window.setInterval(fw, to);
        }
        String script = (String)NativeJavaObject.coerceType((Class)(class$java$lang$String == null ? (class$java$lang$String = WindowWrapper.class$("java.lang.String")) : class$java$lang$String), (Object)args[0]);
        return window.setInterval(script, to);
    }

    public static Object jsFunction_setTimeout(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws JavaScriptException {
        int len = args.length;
        WindowWrapper ww = (WindowWrapper)thisObj;
        Window window = ww.window;
        if (len < 2) {
            throw Context.reportRuntimeError((String)"invalid argument count");
        }
        long to = (Long)NativeJavaObject.coerceType(Long.TYPE, (Object)args[1]);
        if (args[0] instanceof Function) {
            RhinoInterpreter interp = (RhinoInterpreter)window.getInterpreter();
            FunctionWrapper fw = new FunctionWrapper(interp, (Function)args[0], EMPTY_ARGUMENTS);
            return window.setTimeout(fw, to);
        }
        String script = (String)NativeJavaObject.coerceType((Class)(class$java$lang$String == null ? (class$java$lang$String = WindowWrapper.class$("java.lang.String")) : class$java$lang$String), (Object)args[0]);
        return window.setTimeout(script, to);
    }

    public static void jsFunction_clearInterval(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws JavaScriptException {
        int len = args.length;
        WindowWrapper ww = (WindowWrapper)thisObj;
        Window window = ww.window;
        if (len >= 1) {
            window.clearInterval(NativeJavaObject.coerceType((Class)(class$java$lang$Object == null ? (class$java$lang$Object = WindowWrapper.class$("java.lang.Object")) : class$java$lang$Object), (Object)args[0]));
        }
    }

    public static void jsFunction_clearTimeout(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws JavaScriptException {
        int len = args.length;
        WindowWrapper ww = (WindowWrapper)thisObj;
        Window window = ww.window;
        if (len >= 1) {
            window.clearTimeout(NativeJavaObject.coerceType((Class)(class$java$lang$Object == null ? (class$java$lang$Object = WindowWrapper.class$("java.lang.Object")) : class$java$lang$Object), (Object)args[0]));
        }
    }

    public static Object jsFunction_parseXML(Context cx, Scriptable thisObj, final Object[] args, Function funObj) throws JavaScriptException {
        int len = args.length;
        WindowWrapper ww = (WindowWrapper)thisObj;
        final Window window = ww.window;
        if (len < 2) {
            throw Context.reportRuntimeError((String)"invalid argument count");
        }
        AccessControlContext acc = ((RhinoInterpreter)window.getInterpreter()).getAccessControlContext();
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return window.parseXML((String)NativeJavaObject.coerceType((Class)(class$java$lang$String == null ? (class$java$lang$String = WindowWrapper.class$("java.lang.String")) : class$java$lang$String), (Object)args[0]), (Document)NativeJavaObject.coerceType((Class)(class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = WindowWrapper.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document), (Object)args[1]));
            }
        }, acc);
    }

    public static void jsFunction_getURL(Context cx, Scriptable thisObj, final Object[] args, Function funObj) throws JavaScriptException {
        int len = args.length;
        WindowWrapper ww = (WindowWrapper)thisObj;
        final Window window = ww.window;
        if (len < 2) {
            throw Context.reportRuntimeError((String)"invalid argument count");
        }
        RhinoInterpreter interp = (RhinoInterpreter)window.getInterpreter();
        final String uri = (String)NativeJavaObject.coerceType((Class)(class$java$lang$String == null ? (class$java$lang$String = WindowWrapper.class$("java.lang.String")) : class$java$lang$String), (Object)args[0]);
        final GetURLFunctionWrapper fw = new GetURLFunctionWrapper(interp, (Function)args[1], ww);
        AccessControlContext acc = ((RhinoInterpreter)window.getInterpreter()).getAccessControlContext();
        if (len == 2) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    window.getURL(uri, fw);
                    return null;
                }
            }, acc);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    window.getURL(uri, fw, (String)NativeJavaObject.coerceType((Class)(class$java$lang$String == null ? (class$java$lang$String = WindowWrapper.class$("java.lang.String")) : class$java$lang$String), (Object)args[2]));
                    return null;
                }
            }, acc);
        }
    }

    public static void jsFunction_alert(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws JavaScriptException {
        int len = args.length;
        WindowWrapper ww = (WindowWrapper)thisObj;
        Window window = ww.window;
        if (len >= 1) {
            String message = (String)NativeJavaObject.coerceType((Class)(class$java$lang$String == null ? (class$java$lang$String = WindowWrapper.class$("java.lang.String")) : class$java$lang$String), (Object)args[0]);
            window.alert(message);
        }
    }

    public static boolean jsFunction_confirm(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws JavaScriptException {
        int len = args.length;
        WindowWrapper ww = (WindowWrapper)thisObj;
        Window window = ww.window;
        if (len >= 1) {
            String message = (String)NativeJavaObject.coerceType((Class)(class$java$lang$String == null ? (class$java$lang$String = WindowWrapper.class$("java.lang.String")) : class$java$lang$String), (Object)args[0]);
            return window.confirm(message);
        }
        return false;
    }

    public static String jsFunction_prompt(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws JavaScriptException {
        int len = args.length;
        WindowWrapper ww = (WindowWrapper)thisObj;
        Window window = ww.window;
        switch (len) {
            case 0: {
                return "";
            }
            case 1: {
                String message = (String)NativeJavaObject.coerceType((Class)(class$java$lang$String == null ? (class$java$lang$String = WindowWrapper.class$("java.lang.String")) : class$java$lang$String), (Object)args[0]);
                return window.prompt(message);
            }
        }
        String message = (String)NativeJavaObject.coerceType((Class)(class$java$lang$String == null ? (class$java$lang$String = WindowWrapper.class$("java.lang.String")) : class$java$lang$String), (Object)args[0]);
        String defVal = (String)NativeJavaObject.coerceType((Class)(class$java$lang$String == null ? (class$java$lang$String = WindowWrapper.class$("java.lang.String")) : class$java$lang$String), (Object)args[1]);
        return window.prompt(message, defVal);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class GetURLFunctionWrapper
    implements Window.GetURLHandler {
        protected RhinoInterpreter interpreter;
        protected Function function;
        protected WindowWrapper windowWrapper;

        public GetURLFunctionWrapper(RhinoInterpreter ri, Function fct, WindowWrapper ww) {
            this.interpreter = ri;
            this.function = fct;
            this.windowWrapper = ww;
        }

        public void getURLDone(boolean success, String mime, String content) {
            try {
                this.interpreter.callHandler(this.function, new RhinoInterpreter.ArgumentsBuilder(this, success, mime, content){
                    private final /* synthetic */ boolean val$success;
                    private final /* synthetic */ String val$mime;
                    private final /* synthetic */ String val$content;
                    private final /* synthetic */ GetURLFunctionWrapper this$0;
                    {
                        this.this$0 = this$0;
                        this.val$success = val$success;
                        this.val$mime = val$mime;
                        this.val$content = val$content;
                    }

                    public Object[] buildArguments() {
                        try {
                            Object[] arguments = new Object[1];
                            ScriptableObject so = (ScriptableObject)this.this$0.interpreter.evaluate(new StringReader("new Object()"));
                            so.put("success", (Scriptable)so, (Object)(this.val$success ? Boolean.TRUE : Boolean.FALSE));
                            if (this.val$mime != null) {
                                so.put("contentType", (Scriptable)so, (Object)Context.toObject((Object)this.val$mime, (Scriptable)this.this$0.windowWrapper));
                            }
                            if (this.val$content != null) {
                                so.put("content", (Scriptable)so, (Object)Context.toObject((Object)this.val$content, (Scriptable)this.this$0.windowWrapper));
                            }
                            arguments[0] = so;
                            return arguments;
                        }
                        catch (IOException e) {
                            throw new WrappedException((Throwable)e);
                        }
                        catch (InterpreterException e) {
                            throw new WrappedException((Throwable)e);
                        }
                    }
                });
            }
            catch (JavaScriptException e) {
                throw new WrappedException((Throwable)e);
            }
        }
    }

    protected static class FunctionWrapper
    implements Runnable {
        protected RhinoInterpreter interpreter;
        protected Function function;
        protected Object[] arguments;

        public FunctionWrapper(RhinoInterpreter ri, Function f, Object[] args) {
            this.interpreter = ri;
            this.function = f;
            this.arguments = args;
        }

        public void run() {
            try {
                this.interpreter.callHandler(this.function, this.arguments);
            }
            catch (JavaScriptException e) {
                throw new WrappedException((Throwable)e);
            }
        }
    }
}

