/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.gvt.text.TextPath;
import org.apache.batik.parser.AWTPathProducer;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathParser;
import org.apache.batik.util.UnitProcessor;
import org.w3c.dom.Element;

public class SVGTextPathElementBridge
extends AbstractSVGBridge
implements ErrorConstants {
    public String getLocalName() {
        return "textPath";
    }

    public TextPath createTextPath(BridgeContext ctx, Element textPathElement) {
        Shape pathShape;
        String s;
        Element pathElement;
        block13: {
            String uri = XLinkSupport.getXLinkHref(textPathElement);
            pathElement = ctx.getReferencedElement(textPathElement, uri);
            if (pathElement == null || !pathElement.getTagName().equals("path")) {
                throw new BridgeException(textPathElement, "uri.badTarget", new Object[]{uri});
            }
            s = pathElement.getAttributeNS(null, "d");
            pathShape = null;
            if (s.length() != 0) {
                AWTPathProducer app = new AWTPathProducer();
                app.setWindingRule(CSSUtilities.convertFillRule(pathElement));
                try {
                    try {
                        PathParser pathParser = new PathParser();
                        pathParser.setPathHandler(app);
                        pathParser.parse(s);
                    }
                    catch (ParseException ex) {
                        throw new BridgeException(pathElement, "attribute.malformed", new Object[]{"d"});
                    }
                    Object var10_11 = null;
                    pathShape = app.getShape();
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    pathShape = app.getShape();
                    throw throwable;
                }
            }
            throw new BridgeException(pathElement, "attribute.missing", new Object[]{"d"});
        }
        s = pathElement.getAttributeNS(null, "transform");
        if (s.length() != 0) {
            AffineTransform tr = SVGUtilities.convertTransform(pathElement, "transform", s);
            pathShape = tr.createTransformedShape(pathShape);
        }
        TextPath textPath = new TextPath(new GeneralPath(pathShape));
        s = textPathElement.getAttributeNS(null, "startOffset");
        if (s.length() > 0) {
            float startOffset = 0.0f;
            int percentIndex = s.indexOf("%");
            if (percentIndex != -1) {
                float pathLength = textPath.lengthOfPath();
                String percentString = s.substring(0, percentIndex);
                float startOffsetPercent = 0.0f;
                try {
                    startOffsetPercent = SVGUtilities.convertSVGNumber(percentString);
                }
                catch (NumberFormatException e) {
                    startOffsetPercent = -1.0f;
                }
                if (startOffsetPercent < 0.0f) {
                    throw new BridgeException(textPathElement, "attribute.malformed", new Object[]{"startOffset", s});
                }
                startOffset = (float)((double)(startOffsetPercent * pathLength) / 100.0);
            } else {
                UnitProcessor.Context uctx = UnitProcessor.createContext(ctx, textPathElement);
                startOffset = UnitProcessor.svgOtherLengthToUserSpace(s, "startOffset", uctx);
            }
            textPath.setStartOffset(startOffset);
        }
        return textPath;
    }
}

