/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.IaikSecurity;
import javax.crypto.MacSpi;
import javax.crypto.ShortBufferException;

public class Mac
implements Cloneable {
    private boolean c = false;
    MacSpi b;
    String d;
    Provider a;

    public final void update(byte[] byArray, int n2, int n3) throws IllegalStateException {
        if (!this.c) {
            throw new IllegalStateException("MAC not initialized yet!");
        }
        this.b.engineUpdate(byArray, n2, n3);
    }

    public final void update(byte[] byArray) throws IllegalStateException {
        if (!this.c) {
            throw new IllegalStateException("MAC not initialized yet!");
        }
        this.b.engineUpdate(byArray, 0, byArray.length);
    }

    public final void update(byte by) throws IllegalStateException {
        if (!this.c) {
            throw new IllegalStateException("MAC not initialized yet!");
        }
        this.b.engineUpdate(by);
    }

    public final void reset() {
        this.b.engineReset();
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.b.engineInit(key, algorithmParameterSpec);
        this.c = true;
    }

    public final void init(Key key) throws InvalidKeyException {
        try {
            this.b.engineInit(key, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.toString());
        }
        this.c = true;
    }

    public final Provider getProvider() {
        return this.a;
    }

    public final int getMacLength() {
        return this.b.engineGetMacLength();
    }

    public static final Mac getInstance(String string, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        IaikSecurity iaikSecurity = new IaikSecurity(string, "Mac", string2);
        MacSpi macSpi = (MacSpi)iaikSecurity.getImplementation();
        return new Mac(macSpi, iaikSecurity.getProvider(), string);
    }

    public static final Mac getInstance(String string) throws NoSuchAlgorithmException {
        try {
            return Mac.getInstance(string, null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            noSuchProviderException.printStackTrace();
            throw new RuntimeException("InternalError!");
        }
    }

    public final String getAlgorithm() {
        return this.d;
    }

    public final void doFinal(byte[] byArray, int n2) throws IllegalStateException, ShortBufferException {
        if (!this.c) {
            throw new IllegalStateException("MAC not initialized yet!");
        }
        byte[] byArray2 = this.b.engineDoFinal();
        try {
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            return;
        }
        catch (Exception exception) {
            throw new ShortBufferException(exception.toString());
        }
    }

    public final byte[] doFinal(byte[] byArray) throws IllegalStateException {
        if (!this.c) {
            throw new IllegalStateException("MAC not initialized yet!");
        }
        this.b.engineUpdate(byArray, 0, byArray.length);
        return this.b.engineDoFinal();
    }

    public final byte[] doFinal() throws IllegalStateException {
        if (!this.c) {
            throw new IllegalStateException("MAC not initialized yet!");
        }
        return this.b.engineDoFinal();
    }

    public final Object clone() throws CloneNotSupportedException {
        if (this.b instanceof Cloneable) {
            MacSpi macSpi = (MacSpi)this.b.clone();
            return new Mac(macSpi, this.a, this.d);
        }
        throw new CloneNotSupportedException();
    }

    protected Mac(MacSpi macSpi, Provider provider, String string) {
        this.b = macSpi;
        this.a = provider;
        this.d = string;
    }
}

