/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.ExemptionMechanismException;
import javax.crypto.ExemptionMechanismSpi;
import javax.crypto.IaikSecurity;
import javax.crypto.ShortBufferException;

public class ExemptionMechanism {
    private boolean b;
    private Key d;
    private boolean e;
    private String c;
    private ExemptionMechanismSpi f;
    private Provider a;

    public final boolean isCryptoAllowed(Key key) throws ExemptionMechanismException {
        if (!this.b || this.d == null) {
            return false;
        }
        return this.d.equals(key);
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws ExemptionMechanismException, InvalidAlgorithmParameterException, InvalidKeyException {
        this.e = false;
        this.b = false;
        this.d = key;
        this.f.engineInit(key, algorithmParameterSpec);
        this.e = true;
    }

    public final void init(Key key, AlgorithmParameters algorithmParameters) throws ExemptionMechanismException, InvalidAlgorithmParameterException, InvalidKeyException {
        this.e = false;
        this.b = false;
        this.d = key;
        this.f.engineInit(key, algorithmParameters);
        this.e = true;
    }

    public final void init(Key key) throws ExemptionMechanismException, InvalidKeyException {
        this.e = false;
        this.b = false;
        this.d = key;
        this.f.engineInit(key);
        this.e = true;
    }

    public final Provider getProvider() {
        return this.a;
    }

    public final int getOutputSize(int n2) throws IllegalStateException {
        if (!this.e) {
            throw new IllegalStateException("ExemptionMechanism not initialized!");
        }
        return this.f.engineGetOutputSize(n2);
    }

    public final String getName() {
        return this.c;
    }

    public static final ExemptionMechanism getInstance(String string, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        IaikSecurity iaikSecurity = new IaikSecurity(string, "Exemption", string2);
        ExemptionMechanismSpi exemptionMechanismSpi = (ExemptionMechanismSpi)iaikSecurity.getImplementation();
        return new ExemptionMechanism(exemptionMechanismSpi, iaikSecurity.getProvider(), string);
    }

    public static final ExemptionMechanism getInstance(String string) throws NoSuchAlgorithmException {
        try {
            return ExemptionMechanism.getInstance(string, null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(noSuchProviderException.toString());
        }
    }

    public final int genExemptionBlob(byte[] byArray, int n2) throws ExemptionMechanismException, ShortBufferException, IllegalStateException {
        if (!this.e) {
            throw new IllegalStateException("ExemptionMechanism not initialized!");
        }
        int n3 = this.f.engineGenExemptionBlob(byArray, n2);
        this.b = true;
        return n3;
    }

    public final int genExemptionBlob(byte[] byArray) throws ExemptionMechanismException, ShortBufferException, IllegalStateException {
        if (!this.e) {
            throw new IllegalStateException("ExemptionMechanism not initialized!");
        }
        int n2 = this.f.engineGenExemptionBlob(byArray, 0);
        this.b = true;
        return n2;
    }

    public final byte[] genExemptionBlob() throws ExemptionMechanismException, IllegalStateException {
        if (!this.e) {
            throw new IllegalStateException("ExemptionMechanism not initialized!");
        }
        byte[] byArray = this.f.engineGenExemptionBlob();
        this.b = true;
        return byArray;
    }

    protected void finalize() {
        this.d = null;
    }

    protected ExemptionMechanism(ExemptionMechanismSpi exemptionMechanismSpi, Provider provider, String string) {
        this.f = exemptionMechanismSpi;
        this.a = provider;
        this.c = string;
    }
}

