/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.IOException;
import java.util.HashMap;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGDocumentFactory;
import org.apache.batik.dom.util.DocumentDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class DocumentLoader {
    protected SVGDocumentFactory documentFactory;
    protected HashMap cacheMap = new HashMap();
    protected UserAgent userAgent;
    protected BridgeContext bridgeContext;

    protected DocumentLoader() {
    }

    public DocumentLoader(UserAgent userAgent) {
        this.userAgent = userAgent;
        this.documentFactory = new SAXSVGDocumentFactory(userAgent.getXMLParserClassName(), true);
        this.documentFactory.setValidating(userAgent.isXMLParserValidating());
    }

    public Document loadDocument(String uri) throws IOException {
        DocumentState state;
        int n = uri.indexOf(35);
        if (n != -1) {
            uri = uri.substring(0, n);
        }
        if ((state = (DocumentState)this.cacheMap.get(uri)) == null) {
            SVGDocument document = this.documentFactory.createSVGDocument(uri);
            if (this.bridgeContext != null) {
                this.bridgeContext.initializeDocument(document);
            }
            DocumentDescriptor desc = this.documentFactory.getDocumentDescriptor();
            state = new DocumentState(uri, document, desc);
            this.cacheMap.put(uri, state);
        }
        return state.document;
    }

    public void setBridgeContext(BridgeContext bc) {
        this.bridgeContext = bc;
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    public void dispose() {
        this.cacheMap.clear();
    }

    public int getLineNumber(Element e) {
        String uri = ((SVGDocument)e.getOwnerDocument()).getURL();
        DocumentState state = (DocumentState)this.cacheMap.get(uri);
        if (state == null) {
            return -1;
        }
        return state.desc.getLocationLine(e);
    }

    private static class DocumentState {
        private String uri;
        private Document document;
        private DocumentDescriptor desc;

        public DocumentState(String uri, Document document, DocumentDescriptor desc) {
            this.uri = uri;
            this.document = document;
            this.desc = desc;
        }

        public DocumentDescriptor getDocumentDescriptor() {
            return this.desc;
        }

        public String getURI() {
            return this.uri;
        }

        public Document getDocument() {
            return this.document;
        }
    }
}

