/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.tsp;

import com.izenpe.AlgoritmosHash;
import com.izenpe.gestioncontenedorseguro.GestionContenedorSeguro;
import com.izenpe.miscelanea.Miscelanea;
import com.izenpe.tsp.HttpTSPRequest;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.cms.CMSException;
import iaik.cms.SignedData;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.SignedDataStream;
import iaik.security.provider.IAIK;
import iaik.tsa.asn1.MessageImprint;
import iaik.tsa.asn1.TSTInfo;
import iaik.tsa.asn1.TimeStampReq;
import iaik.tsa.asn1.TimeStampResp;
import iaik.tsa.request.TimeStampClientManager;
import iaik.utils.ASN1InputStream;
import iaik.utils.StreamCopier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Random;

public class TSP {
    public TSP() {
        IAIK iaik = new IAIK();
        IAIK.addAsJDK14Provider();
        IAIK.addAsProvider((boolean)false);
    }

    public int requestTSP(byte[] dataIn, ByteArrayOutputStream responseTST, ByteArrayOutputStream stampingDataOut, ByteArrayOutputStream snTSTOut, String path, String pass) {
        int error = 0;
        try {
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(path, pass);
            ByteArrayOutputStream uri = new ByteArrayOutputStream();
            int errortsa = cs.getURLTSA(uri);
            if (errortsa != 0) {
                error = errortsa;
                return error;
            }
            URL url = new URL(uri.toString("ISO8859_1"));
            uri.close();
            TimeStampClientManager tscm = new TimeStampClientManager();
            TimeStampReq time_stamp_req = tscm.generateTimeStampReq(dataIn);
            time_stamp_req.setCertReq(true);
            HttpTSPRequest con = new HttpTSPRequest(url);
            ByteArrayOutputStream errorsalida = new ByteArrayOutputStream();
            error = con.postRequest(time_stamp_req, path, pass, errorsalida);
            if (error != 0) {
                return error;
            }
            Integer errorint = new Integer(errorsalida.toString("ISO8859_1"));
            if (errorint != 0) {
                error = errorint;
                return error;
            }
            TimeStampResp response = con.getTSPResponse();
            responseTST.write(response.getEncoded());
            responseTST.close();
            snTSTOut.write(con.getSerialNumber().toString().getBytes("ISO8859_1"));
            snTSTOut.close();
            stampingDataOut.write(con.getGenTime().getBytes("ISO8859_1"));
            stampingDataOut.close();
        }
        catch (UnknownHostException uhe) {
            error = 1101;
            return 1101;
        }
        catch (NoRouteToHostException nrthe) {
            error = 1101;
            return 1101;
        }
        catch (MalformedURLException mue) {
            error = 1102;
            return 1102;
        }
        catch (CMSException cmse) {
            error = 1103;
            return 1103;
        }
        catch (IOException ioe) {
            error = 1104;
            return 1104;
        }
        return error;
    }

    public int requestTSP(InputStream dataIn, OutputStream responseTST, OutputStream stampingDataOut, OutputStream snTSTOut, String path, String pass) {
        int error = 0;
        try {
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(path, pass);
            ByteArrayOutputStream uri = new ByteArrayOutputStream();
            int errortsa = cs.getURLTSA(uri);
            if (errortsa != 0) {
                error = errortsa;
                return error;
            }
            URL url = new URL(uri.toString("ISO8859_1"));
            uri.close();
            AlgoritmosHash alg = new AlgoritmosHash();
            alg.setAlgorithm("SHA");
            Miscelanea funciones = new Miscelanea();
            byte[] bufferTemp = new byte[1024];
            ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
            int errorHash = funciones.newHash(alg.getAlgorithm(), bufferTemp, dataIn, dataOut);
            if (errorHash != 0) {
                error = errorHash;
                return error;
            }
            ByteArrayOutputStream hashBin = new ByteArrayOutputStream();
            errorHash = funciones.base64Bin(dataOut.toString("ISO8859_1"), hashBin);
            MessageImprint mssgIm = new MessageImprint(alg.getAlgorithm(), hashBin.toByteArray());
            TimeStampReq time_stamp_req = new TimeStampReq(mssgIm);
            time_stamp_req.setMessageImprint(mssgIm);
            Random rand = new Random();
            time_stamp_req.setNonce(new BigInteger(64, rand));
            time_stamp_req.setCertReq(true);
            HttpTSPRequest con = new HttpTSPRequest(url);
            ByteArrayOutputStream errorsalida = new ByteArrayOutputStream();
            error = con.postRequest(time_stamp_req, path, pass, errorsalida);
            if (error != 0) {
                return error;
            }
            Integer errorint = new Integer(errorsalida.toString("ISO8859_1"));
            if (errorint != 0) {
                error = errorint;
                return error;
            }
            TimeStampResp response = con.getTSPResponse();
            responseTST.write(response.getEncoded());
            responseTST.close();
            snTSTOut.write(con.getSerialNumber().toString().getBytes("ISO8859_1"));
            snTSTOut.close();
            stampingDataOut.write(con.getGenTime().getBytes("ISO8859_1"));
            stampingDataOut.close();
        }
        catch (UnknownHostException uhe) {
            error = 1101;
            return 1101;
        }
        catch (NoRouteToHostException nrthe) {
            error = 1101;
            return 1101;
        }
        catch (MalformedURLException mue) {
            error = 1102;
            return 1102;
        }
        catch (CMSException cmse) {
            error = 1103;
            return 1103;
        }
        catch (IOException ioe) {
            error = 1104;
            return 1104;
        }
        return error;
    }

    public int requestTSP_NoVerify(byte[] dataIn, ByteArrayOutputStream responseTST, ByteArrayOutputStream stampingDataOut, ByteArrayOutputStream snTSTOut, String path, String pass) {
        int error = 0;
        try {
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(path, pass);
            ByteArrayOutputStream uri = new ByteArrayOutputStream();
            int errortsa = cs.getURLTSA(uri);
            if (errortsa != 0) {
                error = errortsa;
                return error;
            }
            URL url = new URL(uri.toString("ISO8859_1"));
            uri.close();
            TimeStampClientManager tscm = new TimeStampClientManager();
            TimeStampReq time_stamp_req = tscm.generateTimeStampReq(dataIn);
            time_stamp_req.setCertReq(true);
            HttpTSPRequest con = new HttpTSPRequest(url);
            ByteArrayOutputStream errorsalida = new ByteArrayOutputStream();
            error = con.postRequest_NoVerify(time_stamp_req, path, pass, errorsalida);
            if (error != 0) {
                return error;
            }
            Integer errorint = new Integer(errorsalida.toString("ISO8859_1"));
            if (errorint != 0) {
                error = errorint;
                return error;
            }
            TimeStampResp response = con.getTSPResponse();
            responseTST.write(response.getEncoded());
            responseTST.close();
            snTSTOut.write(con.getSerialNumber().toString().getBytes("ISO8859_1"));
            snTSTOut.close();
            stampingDataOut.write(con.getGenTime().getBytes("ISO8859_1"));
            stampingDataOut.close();
        }
        catch (UnknownHostException uhe) {
            error = 1101;
            return 1101;
        }
        catch (NoRouteToHostException nrthe) {
            error = 1101;
            return 1101;
        }
        catch (MalformedURLException mue) {
            error = 1102;
            return 1102;
        }
        catch (CMSException cmse) {
            error = 1103;
            return 1103;
        }
        catch (IOException ioe) {
            error = 1104;
            return 1104;
        }
        return error;
    }

    public int requestTSP_NoVerify(InputStream dataIn, OutputStream responseTST, OutputStream stampingDataOut, OutputStream snTSTOut, String path, String pass) {
        int error = 0;
        try {
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(path, pass);
            ByteArrayOutputStream uri = new ByteArrayOutputStream();
            int errortsa = cs.getURLTSA(uri);
            if (errortsa != 0) {
                error = errortsa;
                return error;
            }
            URL url = new URL(uri.toString("ISO8859_1"));
            uri.close();
            AlgoritmosHash alg = new AlgoritmosHash();
            alg.setAlgorithm("SHA");
            Miscelanea funciones = new Miscelanea();
            byte[] bufferTemp = new byte[1024];
            ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
            int errorHash = funciones.newHash(alg.getAlgorithm(), bufferTemp, dataIn, dataOut);
            if (errorHash != 0) {
                error = errorHash;
                return error;
            }
            ByteArrayOutputStream hashBin = new ByteArrayOutputStream();
            errorHash = funciones.base64Bin(dataOut.toString("ISO8859_1"), hashBin);
            MessageImprint mssgIm = new MessageImprint(alg.getAlgorithm(), hashBin.toByteArray());
            TimeStampReq time_stamp_req = new TimeStampReq(mssgIm);
            time_stamp_req.setMessageImprint(mssgIm);
            Random rand = new Random();
            time_stamp_req.setNonce(new BigInteger(64, rand));
            time_stamp_req.setCertReq(true);
            HttpTSPRequest con = new HttpTSPRequest(url);
            ByteArrayOutputStream errorsalida = new ByteArrayOutputStream();
            error = con.postRequest_NoVerify(time_stamp_req, path, pass, errorsalida);
            if (error != 0) {
                return error;
            }
            Integer errorint = new Integer(errorsalida.toString("ISO8859_1"));
            if (errorint != 0) {
                error = errorint;
                return error;
            }
            TimeStampResp response = con.getTSPResponse();
            responseTST.write(response.getEncoded());
            responseTST.close();
            snTSTOut.write(con.getSerialNumber().toString().getBytes("ISO8859_1"));
            snTSTOut.close();
            stampingDataOut.write(con.getGenTime().getBytes("ISO8859_1"));
            stampingDataOut.close();
        }
        catch (UnknownHostException uhe) {
            error = 1101;
            return 1101;
        }
        catch (NoRouteToHostException nrthe) {
            error = 1101;
            return 1101;
        }
        catch (MalformedURLException mue) {
            error = 1102;
            return 1102;
        }
        catch (CMSException cmse) {
            error = 1103;
            return 1103;
        }
        catch (IOException ioe) {
            error = 1104;
            return 1104;
        }
        return error;
    }

    public int parseTSP(byte[] responseTST, ByteArrayOutputStream dataHashOut, ByteArrayOutputStream hashAlgorithmOut, ByteArrayOutputStream stampingDateOut, ByteArrayOutputStream snTSTOut) {
        int error = 0;
        try {
            ByteArrayInputStream baistemp = new ByteArrayInputStream(responseTST);
            ASN1 respuestaasn1 = new ASN1((InputStream)new ASN1InputStream((InputStream)baistemp));
            TimeStampResp response = new TimeStampResp(respuestaasn1.toASN1Object());
            ASN1 timeStampans1 = new ASN1((InputStream)new ASN1InputStream(response.getTimeStampToken().getContentInputStream()));
            ByteArrayInputStream bais = new ByteArrayInputStream(timeStampans1.toByteArray());
            ByteArrayOutputStream certstream = new ByteArrayOutputStream();
            try {
                SignedDataStream p7 = new SignedDataStream((InputStream)bais);
                InputStream is = p7.getInputStream();
                StreamCopier scp = new StreamCopier(is, (OutputStream)certstream);
                scp.copyStream();
            }
            catch (IOException ioe) {
                SignedData signed_data = (SignedData)response.getTimeStampToken().getContent();
                InputStream is = signed_data.getInputStream();
                StreamCopier scp = new StreamCopier(is, (OutputStream)certstream);
                scp.copyStream();
            }
            ByteArrayInputStream certificado = new ByteArrayInputStream(certstream.toByteArray());
            ASN1InputStream tstinfostream = new ASN1InputStream((InputStream)certificado);
            ASN1Object tstinfoasn1 = DerCoder.decode((InputStream)tstinfostream);
            TSTInfo tstinfo = new TSTInfo(tstinfoasn1);
            dataHashOut.write(tstinfo.getMessageImprint().getHashedMessage());
            dataHashOut.close();
            hashAlgorithmOut.write(tstinfo.getMessageImprint().getHashAlgorithm().getName().getBytes("ISO8859_1"));
            hashAlgorithmOut.close();
            BigInteger serialnumber = tstinfo.getSerialNumber();
            stampingDateOut.write(tstinfo.getGenTime().getBytes("ISO8859_1"));
            stampingDateOut.close();
            snTSTOut.write(serialnumber.toString().getBytes("ISO8859_1"));
            snTSTOut.close();
        }
        catch (CodingException ce) {
            error = 1105;
            return 1105;
        }
        catch (PKCSParsingException pkcspe) {
            error = 1106;
            return 1106;
        }
        catch (IOException ioe) {
            error = 1104;
            return 1104;
        }
        return error;
    }

    public int checkTSPResponse(byte[] tspresponse, byte[] pkcs7, ByteArrayOutputStream dateOut) {
        int error = 0;
        ByteArrayOutputStream dataHash = new ByteArrayOutputStream();
        ByteArrayOutputStream algHash = new ByteArrayOutputStream();
        ByteArrayOutputStream dateSalida = new ByteArrayOutputStream();
        ByteArrayOutputStream snOut = new ByteArrayOutputStream();
        error = this.parseTSP(tspresponse, dataHash, algHash, dateSalida, snOut);
        if (error != 0) {
            return error;
        }
        AlgoritmosHash alg = new AlgoritmosHash();
        alg.setAlgorithm(algHash.toString().trim());
        Miscelanea funciones = new Miscelanea();
        ByteArrayOutputStream hashSalida = new ByteArrayOutputStream();
        error = funciones.newHash(alg.getAlgorithm(), pkcs7, hashSalida);
        if (error != 0) {
            return error;
        }
        ByteArrayOutputStream dataHashB64 = new ByteArrayOutputStream();
        error = funciones.binBase64(dataHash.toByteArray(), dataHashB64);
        if (error != 0) {
            return error;
        }
        try {
            dateOut.write(dateSalida.toByteArray());
            hashSalida.close();
            dataHash.close();
            algHash.close();
            dateSalida.close();
            snOut.close();
            if (!hashSalida.toString("ISO8859_1").equals(dataHashB64.toString("ISO8859_1"))) {
                error = 1122;
                return 1122;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    public int isTSPResponseRFCStandar(byte[] tspresponse) {
        int error = 0;
        try {
            ByteArrayInputStream baistemp = new ByteArrayInputStream(tspresponse);
            ASN1 respuestaasn1 = new ASN1((InputStream)new ASN1InputStream((InputStream)baistemp));
            TimeStampResp response = new TimeStampResp(respuestaasn1.toASN1Object());
            ASN1 timeStampans1 = new ASN1((InputStream)new ASN1InputStream(response.getTimeStampToken().getContentInputStream()));
            ByteArrayInputStream bais = new ByteArrayInputStream(timeStampans1.toByteArray());
            try {
                SignedDataStream p7 = new SignedDataStream((InputStream)bais);
                error = 1124;
                return 1124;
            }
            catch (IOException ioe) {
                return error;
            }
        }
        catch (CodingException ce) {
            error = 1105;
            return 1105;
        }
        catch (PKCSParsingException pkcspe) {
            error = 1106;
            return 1106;
        }
        catch (IOException ioe) {
            error = 1104;
            return 1104;
        }
    }
}

