/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.smime;

import com.izenpe.autenticacionfuerte.AutenticacionFuerte;
import com.izenpe.autenticacionfuerte.CtesAutenticacion;
import com.izenpe.gestioncontenedorseguro.GestionContenedorSeguro;
import iaik.asn1.CodingException;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSParsingException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.ContentInfo;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.KeyIdentifier;
import iaik.cms.RecipientInfo;
import iaik.cms.SignerInfo;
import iaik.security.provider.IAIK;
import iaik.smime.SMimeBodyPart;
import iaik.smime.SMimeEncrypted;
import iaik.smime.SMimeException;
import iaik.smime.SMimeMultipart;
import iaik.smime.SMimeSigned;
import iaik.smime.SignedContent;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.BasicConstraints;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.MailcapCommandMap;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;

public class SMime {
    public SMime() {
        IAIK iaik = new IAIK();
        IAIK.addAsJDK14Provider();
        IAIK.addAsProvider((boolean)false);
    }

    public int SMIME_SignDettached(String issuerIn, String snIn, byte[] mimeIn, AlgorithmID algoritmoIn, String pathCS, String password, ByteArrayOutputStream smimeOut) {
        return this.smimeSign(issuerIn, snIn, mimeIn, algoritmoIn, pathCS, password, smimeOut, 2);
    }

    public int SMIME_SignAttached(String issuerIn, String snIn, byte[] mimeIn, AlgorithmID algoritmoIn, String pathCS, String password, ByteArrayOutputStream smimeOut) {
        return this.smimeSign(issuerIn, snIn, mimeIn, algoritmoIn, pathCS, password, smimeOut, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int smimeSign(String issuerIn, String snIn, byte[] mimeIn, AlgorithmID algoritmoIn, String pathCS, String password, ByteArrayOutputStream smimeOut, int mode) {
        int error = 0;
        IAIK iaik = new IAIK();
        Security.insertProviderAt((Provider)iaik, 2);
        IAIK.addAsProvider((boolean)false);
        X509Certificate cert0 = null;
        try {
            BufferedOutputStream os = new BufferedOutputStream(smimeOut);
            ByteArrayInputStream is = new ByteArrayInputStream(mimeIn);
            SMimeSigned sds = new SMimeSigned((InputStream)is, mode);
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            PrivateKey pk = cs.getPrivateKeyFromKeyStore(issuerIn, snIn);
            if (pk == null) return 707;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            cs.getCertCS(issuerIn, snIn, baos);
            cert0 = new X509Certificate(baos.toByteArray());
            if (!this.isDigitalSignature(cert0.toByteArray())) return 701;
            Vector vChain = new Vector();
            error = cs.getCertificateChain(cert0, vChain);
            if (error != 0) {
                return error;
            }
            Object[] certAux = new X509Certificate[vChain.size()];
            vChain.copyInto(certAux);
            if (certAux == null) return 705;
            X509Certificate[] cert = new X509Certificate[certAux.length - 1];
            for (int i = 0; i < cert.length; ++i) {
                cert[i] = certAux[i];
            }
            sds.setCertificates((Certificate[])cert);
            IssuerAndSerialNumber isn = new IssuerAndSerialNumber(cert[0]);
            SignerInfo si = new SignerInfo((CertificateIdentifier)isn, algoritmoIn, pk);
            sds.addSignerInfo(si);
            if (mode == 2) {
                InputStream is2 = sds.getInputStream();
                ByteArrayOutputStream datosFirmados = new ByteArrayOutputStream();
                StreamCopier sc = new StreamCopier(is2, (OutputStream)datosFirmados);
                sc.copyStream();
                is2.close();
                datosFirmados.close();
            }
            sds.writeTo((OutputStream)os);
            ((OutputStream)os).close();
            baos.close();
            ((InputStream)is).close();
            return error;
        }
        catch (NoSuchAlgorithmException nsae) {
            return 702;
        }
        catch (IOException ioe) {
            return 706;
        }
        catch (CertificateException ce) {
            return 706;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int SMIME_verifySignDettached(byte[] smimeIn, byte[] mimeIn, String pathCS, String password, ByteArrayOutputStream signerOut) throws CertificateEncodingException {
        int error = 0;
        X509Certificate certSalida = null;
        try {
            AlgorithmID[] aids = new AlgorithmID[]{AlgorithmID.sha1, AlgorithmID.md2, AlgorithmID.md5};
            ByteArrayInputStream p7mime = new ByteArrayInputStream(smimeIn);
            ByteArrayInputStream mimeData = new ByteArrayInputStream(mimeIn);
            SMimeSigned sds = new SMimeSigned((InputStream)mimeData, aids);
            ByteArrayOutputStream datosFirmados = new ByteArrayOutputStream();
            StreamCopier sc2 = new StreamCopier(sds.getInputStream(), (OutputStream)datosFirmados);
            sc2.copyStream();
            sds.decode((InputStream)p7mime);
            Certificate[] certs = sds.getCertificates();
            SignerInfo[] si = sds.getSignerInfos();
            Vector certOut = new Vector();
            try {
                certSalida = sds.verify(0);
            }
            catch (SignatureException se) {
                for (int h = 0; h < certs.length; ++h) {
                    X509Certificate xcert = new X509Certificate(certs[h].getEncoded());
                    for (int j = 0; j < si.length; ++j) {
                        if (!si[j].getSignerIdentifier().identifiesCert(xcert)) continue;
                        signerOut.write(certs[h].getEncoded());
                    }
                }
                return 706;
            }
            signerOut.write(certSalida.toByteArray());
            X509Certificate[] certsP7 = new X509Certificate[certs.length];
            for (int s = 0; s < certs.length; ++s) {
                certsP7[s] = (X509Certificate)certs[s];
            }
            if (!this.isDigitalSignature(certSalida.toByteArray())) return 701;
            X509Certificate[] chain = this.getCertificateChain(certsP7, certSalida);
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            if (chain.length == 1 && !((BasicConstraints)certSalida.getExtension(BasicConstraints.oid)).ca()) {
                Vector vChain = new Vector();
                error = cs.getCertificateChain(certSalida, vChain);
                if (error != 0) {
                    return error;
                }
                Object[] chain2 = new X509Certificate[vChain.size()];
                vChain.copyInto(chain2);
                if (chain2 == null) return 704;
                error = cs.comprobar((X509Certificate[])chain2);
                if (error == 0) {
                    StreamCopier sc = new StreamCopier((InputStream)new ByteArrayInputStream(certSalida.toByteArray()), (OutputStream)signerOut);
                    sc.copyStream();
                }
            } else {
                if (chain == null) return 711;
                ByteArrayOutputStream baosRoot = new ByteArrayOutputStream();
                error = cs.getRoot(chain[chain.length - 1], baosRoot);
                if (error != 0) {
                    return error;
                }
                X509Certificate root = new X509Certificate(baosRoot.toByteArray());
                if (root == null) return 710;
                X509Certificate[] certPlusRoot = new X509Certificate[chain.length + 1];
                for (int i = 0; i < chain.length; ++i) {
                    certPlusRoot[i] = chain[i];
                }
                certPlusRoot[certPlusRoot.length - 1] = root;
                error = cs.comprobar(certPlusRoot);
                if (error == 0) {
                    StreamCopier sc = new StreamCopier((InputStream)new ByteArrayInputStream(certSalida.toByteArray()), (OutputStream)signerOut);
                    sc.copyStream();
                }
                baosRoot.close();
            }
            p7mime.close();
            mimeData.close();
            datosFirmados.close();
        }
        catch (IOException ioe) {
            return 709;
        }
        catch (X509ExtensionInitException eie) {
            return 706;
        }
        catch (CertificateException ce) {
            return 706;
        }
        if (error != 0) return error;
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int SMIME_verifySignAttached(byte[] smimeIn, String pathCS, String password, ByteArrayOutputStream mimeOut, ByteArrayOutputStream signerOut) {
        int error = 0;
        X509Certificate certSalida = null;
        try {
            ByteArrayInputStream p7smime = new ByteArrayInputStream(smimeIn);
            SMimeSigned sds = new SMimeSigned((InputStream)p7smime);
            StreamCopier sc2 = new StreamCopier(sds.getInputStream(), (OutputStream)mimeOut);
            sc2.copyStream();
            SignerInfo[] si = sds.getSignerInfos();
            Certificate[] certs = sds.getCertificates();
            try {
                certSalida = sds.verify(0);
            }
            catch (SignatureException se) {
                for (int h = 0; h < certs.length; ++h) {
                    X509Certificate xcert = new X509Certificate(certs[h].getEncoded());
                    for (int j = 0; j < si.length; ++j) {
                        if (!si[j].getSignerIdentifier().identifiesCert(xcert)) continue;
                        signerOut.write(certs[h].getEncoded());
                    }
                }
                return 706;
            }
            signerOut.write(certSalida.toByteArray());
            X509Certificate[] certsP7 = new X509Certificate[certs.length];
            for (int s = 0; s < certs.length; ++s) {
                certsP7[s] = (X509Certificate)certs[s];
            }
            if (!this.isDigitalSignature(certSalida.toByteArray())) return 701;
            X509Certificate[] chain = this.getCertificateChain(certsP7, certSalida);
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            if (chain.length == 1 && !((BasicConstraints)certSalida.getExtension(BasicConstraints.oid)).ca()) {
                Vector vChain = new Vector();
                error = cs.getCertificateChain(certSalida, vChain);
                if (error != 0) {
                    return error;
                }
                Object[] chain2 = new X509Certificate[vChain.size()];
                vChain.copyInto(chain2);
                if (chain2 == null) return 705;
                error = cs.comprobar((X509Certificate[])chain2);
                if (error == 0) {
                    StreamCopier sc = new StreamCopier((InputStream)new ByteArrayInputStream(certSalida.toByteArray()), (OutputStream)signerOut);
                    sc.copyStream();
                }
            } else {
                if (chain == null) return 711;
                ByteArrayOutputStream baosRoot = new ByteArrayOutputStream();
                error = cs.getRoot(chain[chain.length - 1], baosRoot);
                if (error != 0) {
                    return error;
                }
                X509Certificate root = new X509Certificate(baosRoot.toByteArray());
                if (root == null) return 710;
                X509Certificate[] certPlusRoot = new X509Certificate[chain.length + 1];
                for (int i = 0; i < chain.length; ++i) {
                    certPlusRoot[i] = chain[i];
                }
                certPlusRoot[certPlusRoot.length - 1] = root;
                error = cs.comprobar(certPlusRoot);
                if (error == 0) {
                    StreamCopier sc = new StreamCopier((InputStream)new ByteArrayInputStream(certSalida.toByteArray()), (OutputStream)signerOut);
                    sc.copyStream();
                }
                baosRoot.close();
            }
            p7smime.close();
        }
        catch (IOException ioe) {
            return 709;
        }
        catch (X509ExtensionInitException eie) {
            return 706;
        }
        catch (CertificateException ce) {
            return 706;
        }
        if (error != 0) return error;
        return 0;
    }

    public int SMIME_encrypt(byte[] mimeIn, X509Certificate[] certsIn, AlgorithmID algoritmoSimIn, String pathCS, String password, ByteArrayOutputStream smimeOut, ByteArrayOutputStream destError) {
        int error = 0;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(mimeIn);
            SMimeEncrypted sme = new SMimeEncrypted((InputStream)bais, algoritmoSimIn, -1);
            for (int i = 0; i < certsIn.length; ++i) {
                if (!this.isDataEncipherment(certsIn[i].toByteArray())) {
                    ByteArrayInputStream destFalla = new ByteArrayInputStream(certsIn[i].toByteArray());
                    StreamCopier sc = new StreamCopier((InputStream)destFalla, (OutputStream)destError);
                    sc.copyStream();
                    error = 715;
                    destFalla.close();
                    break;
                }
                sme.addRecipient(certsIn[i], AlgorithmID.rsaEncryption);
            }
            sme.writeTo((OutputStream)smimeOut);
            bais.close();
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 703;
            return 703;
        }
        catch (SMimeException sme) {
            error = 713;
            return 713;
        }
        catch (IOException ioe) {
            error = 706;
            return 706;
        }
        if (error != 0) {
            smimeOut.reset();
            return error;
        }
        return error;
    }

    public int SMIME_Decrypt(byte[] smimeIn, String pathCS, String password, ByteArrayOutputStream mimeOut) {
        int error = 0;
        try {
            PrivateKey pk = null;
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            ByteArrayInputStream smime = new ByteArrayInputStream(smimeIn);
            SMimeEncrypted sme = new SMimeEncrypted((InputStream)smime);
            RecipientInfo[] ri = sme.getRecipientInfos();
            int i = 0;
            boolean encontrado = false;
            while (i < ri.length && !encontrado) {
                String serial;
                IssuerAndSerialNumber iasn = null;
                KeyIdentifier[] ki = ri[i].getRecipientIdentifiers();
                boolean encontrado2 = false;
                for (int j = 0; j < ki.length && !encontrado2; ++j) {
                    if (ki[j].getKeyIdType() != 0) continue;
                    iasn = new IssuerAndSerialNumber(ki[j].toASN1Object());
                    encontrado2 = true;
                }
                String issuer = iasn.getIssuer().toString();
                pk = cs.getPrivateKeyFromKeyStore(issuer, serial = iasn.getSerialNumber().toString());
                if (pk != null) {
                    encontrado = true;
                    continue;
                }
                ++i;
            }
            if (pk == null) {
                error = 707;
                return 707;
            }
            sme.decryptSymmetricKey(pk, i);
            StreamCopier sc = new StreamCopier(sme.getInputStream(), (OutputStream)mimeOut);
            sc.copyStream();
            smime.close();
        }
        catch (IOException ioe) {
            error = 709;
            return 709;
        }
        catch (SMimeException sme) {
            error = 704;
            return 704;
        }
        catch (InvalidKeyException ike) {
            error = 714;
            return 714;
        }
        catch (CodingException ce) {
            error = 715;
            return 715;
        }
        return error;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int SMIME_SignAndEncrypt(String issuerIn, String snIn, byte[] mimeIn, AlgorithmID algoritmoFirmaIn, AlgorithmID algoritmoCifradoIn, X509Certificate[] certsIn, String pathCS, String password, ByteArrayOutputStream smimeOut, ByteArrayOutputStream destError) {
        int error = 0;
        X509Certificate cert0 = null;
        try {
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            ByteArrayInputStream bais = new ByteArrayInputStream(mimeIn);
            SMimeSigned sms = new SMimeSigned((InputStream)bais, 1);
            PrivateKey pk = cs.getPrivateKeyFromKeyStore(issuerIn, snIn);
            if (pk == null) return 707;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            cs.getCertCS(issuerIn, snIn, baos);
            cert0 = new X509Certificate(baos.toByteArray());
            if (!this.isDigitalSignature(cert0.toByteArray())) return 701;
            Vector vChain = new Vector();
            error = cs.getCertificateChain(cert0, vChain);
            if (error != 0) {
                return error;
            }
            Object[] certAux = new X509Certificate[vChain.size()];
            vChain.copyInto(certAux);
            if (certAux == null) return 705;
            X509Certificate[] cert = new X509Certificate[certAux.length - 1];
            for (int i = 0; i < cert.length; ++i) {
                cert[i] = certAux[i];
            }
            sms.setCertificates((Certificate[])cert);
            IssuerAndSerialNumber iasn = new IssuerAndSerialNumber(cert[0]);
            SignerInfo si = new SignerInfo((CertificateIdentifier)iasn, algoritmoFirmaIn, pk);
            sms.addSignerInfo(si);
            sms.writeTo((OutputStream)bas);
            SMimeEncrypted sme = new SMimeEncrypted((InputStream)new ByteArrayInputStream(bas.toByteArray()), algoritmoCifradoIn, -1);
            for (int i = 0; i < certsIn.length; ++i) {
                if (!this.isDataEncipherment(certsIn[i].toByteArray())) {
                    ByteArrayInputStream destFalla = new ByteArrayInputStream(certsIn[i].toByteArray());
                    StreamCopier sc = new StreamCopier((InputStream)destFalla, (OutputStream)destError);
                    sc.copyStream();
                    destFalla.close();
                    return 715;
                }
                sme.addRecipient(certsIn[i], AlgorithmID.rsaEncryption);
            }
            sme.writeTo((OutputStream)smimeOut);
            baos.close();
            bas.close();
            bais.close();
        }
        catch (NoSuchAlgorithmException nsae) {
            return 702;
        }
        catch (SMimeException sme) {
            return 713;
        }
        catch (IOException ioe) {
            return 706;
        }
        catch (CertificateException ce) {
            return 706;
        }
        if (error == 0) return error;
        smimeOut.reset();
        return error;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int SMIME_verifySignAndEncrypt(byte[] smimeIn, String pathCS, String password, ByteArrayOutputStream mimeOut, ByteArrayOutputStream signerOut) {
        int error = 0;
        PrivateKey pk = null;
        try {
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            ByteArrayInputStream smime = new ByteArrayInputStream(smimeIn);
            SMimeEncrypted sme = new SMimeEncrypted((InputStream)smime);
            RecipientInfo[] ri = sme.getRecipientInfos();
            int i = 0;
            boolean encontrado = false;
            while (i < ri.length && !encontrado) {
                String serial;
                IssuerAndSerialNumber iasn = null;
                KeyIdentifier[] ki = ri[i].getRecipientIdentifiers();
                boolean encontrado2 = false;
                for (int j = 0; j < ki.length && !encontrado2; ++j) {
                    if (ki[j].getKeyIdType() != 0) continue;
                    iasn = new IssuerAndSerialNumber(ki[j].toASN1Object());
                    encontrado2 = true;
                }
                String issuer = iasn.getIssuer().toString();
                pk = cs.getPrivateKeyFromKeyStore(issuer, serial = iasn.getSerialNumber().toString());
                if (pk != null) {
                    encontrado = true;
                    continue;
                }
                ++i;
            }
            if (!encontrado) return 707;
            sme.decryptSymmetricKey(pk, i);
            SMimeSigned sms = new SMimeSigned(sme.getInputStream());
            StreamCopier sc = new StreamCopier(sms.getInputStream(), (OutputStream)mimeOut);
            sc.copyStream();
            SignerInfo[] sis = sms.getSignerInfos();
            X509Certificate cert = null;
            cert = sms.verify(0);
            if (!this.isDigitalSignature(cert.toByteArray())) return 701;
            Certificate[] certs = sms.getCertificates();
            X509Certificate[] certP7 = new X509Certificate[certs.length];
            for (int s = 0; s < certs.length; ++s) {
                certP7[s] = (X509Certificate)certs[s];
            }
            if (certP7.length == 1 && !((BasicConstraints)cert.getExtension(BasicConstraints.oid)).ca()) {
                Vector vChain = new Vector();
                error = cs.getCertificateChain(cert, vChain);
                if (error != 0) {
                    return error;
                }
                Object[] chain = new X509Certificate[vChain.size()];
                vChain.copyInto(chain);
                if (chain == null) return 705;
                error = cs.comprobar((X509Certificate[])chain);
                if (error == 0) {
                    StreamCopier sc2 = new StreamCopier((InputStream)new ByteArrayInputStream(cert.toByteArray()), (OutputStream)signerOut);
                    sc2.copyStream();
                }
            } else {
                X509Certificate[] chain = this.getCertificateChain(certP7, cert);
                if (chain == null) return 711;
                ByteArrayOutputStream baosRoot = new ByteArrayOutputStream();
                error = cs.getRoot(chain[chain.length - 1], baosRoot);
                if (error != 0) {
                    return error;
                }
                X509Certificate root = new X509Certificate(baosRoot.toByteArray());
                if (root == null) return 710;
                X509Certificate[] chainPlusRoot = new X509Certificate[chain.length + 1];
                for (int j = 0; j < chain.length; ++j) {
                    chainPlusRoot[j] = chain[j];
                }
                chainPlusRoot[chainPlusRoot.length - 1] = root;
                error = cs.comprobar(chainPlusRoot);
                if (error == 0) {
                    StreamCopier sc2 = new StreamCopier((InputStream)new ByteArrayInputStream(cert.toByteArray()), (OutputStream)signerOut);
                    sc2.copyStream();
                }
                baosRoot.close();
            }
            smime.close();
            return error;
        }
        catch (IOException ioe) {
            return 709;
        }
        catch (SMimeException sme) {
            return 704;
        }
        catch (InvalidKeyException ike) {
            return 714;
        }
        catch (SignatureException se) {
            return 706;
        }
        catch (X509ExtensionInitException eie) {
            return 706;
        }
        catch (CertificateException ce) {
            return 706;
        }
        catch (CodingException ce) {
            return 715;
        }
    }

    public int SMIME_TypeSMime(byte[] smimeIn, ByteArrayOutputStream tipoSmime) {
        int error = 0;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(smimeIn);
            ContentInfo ci = new ContentInfo((InputStream)bais);
            StreamCopier sc = new StreamCopier((InputStream)new ByteArrayInputStream(ci.getContentType().toString().getBytes("ISO8859_1")), (OutputStream)tipoSmime);
            sc.copyStream();
            bais.close();
        }
        catch (IOException ioe) {
            error = 706;
            return 706;
        }
        catch (CMSParsingException cmspe) {
            error = 716;
            return 716;
        }
        return error;
    }

    private boolean isDigitalSignature(byte[] certificado) {
        boolean digitalSignature = false;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            boolean[] b = cert.getKeyUsage();
            ByteArrayOutputStream politicaOID = new ByteArrayOutputStream();
            ByteArrayOutputStream userNotice = new ByteArrayOutputStream();
            AutenticacionFuerte af = new AutenticacionFuerte();
            int error = af.extractPolicy(certificado, politicaOID, userNotice);
            String politica = politicaOID.toString("ISO8859_1");
            if (error == 0) {
                digitalSignature = politica.equals(CtesAutenticacion.OID_POLITICA_eDNI_A) || politica.equals(CtesAutenticacion.OID_POLITICA_eDNI_F) ? b[1] : b[0];
            }
        }
        catch (CertificateException ce) {
            System.err.println(ce);
            return false;
        }
        catch (Exception e) {
            System.err.println(e);
            return false;
        }
        return digitalSignature;
    }

    private boolean isDataEncipherment(byte[] certificado) {
        boolean dataEncipherment = false;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            boolean[] b = cert.getKeyUsage();
            dataEncipherment = b[3];
        }
        catch (CertificateException ce) {
            System.err.println(ce);
        }
        return dataEncipherment;
    }

    private X509Certificate[] getCertificateChain(X509Certificate[] cadenaIn, X509Certificate cert) {
        Vector<X509Certificate> v = new Vector<X509Certificate>();
        v.addElement(cert);
        try {
            int i = 0;
            while (i < cadenaIn.length) {
                X509Certificate certificado = new X509Certificate(cadenaIn[i].toByteArray());
                if (((Object)cert.getIssuerDN()).equals(certificado.getSubjectDN())) {
                    v.addElement(new X509Certificate(certificado.toByteArray()));
                    if (!((Object)certificado.getSubjectDN()).equals(certificado.getIssuerDN())) {
                        i = 0;
                        cert = new X509Certificate(certificado.toByteArray());
                        continue;
                    }
                    break;
                }
                ++i;
            }
        }
        catch (CertificateException ce) {
            System.err.println(ce);
        }
        X509Certificate[] cadenaSalida = new X509Certificate[v.size()];
        for (int z = 0; z < v.size(); ++z) {
            cadenaSalida[z] = (X509Certificate)v.elementAt(z);
        }
        return cadenaSalida;
    }

    public static int SMIME_sendAttached(String servidorIn, String fromIn, String toIn, String subjectIn, String textoIn, String issuerIn, String serialNumberIn, String pathCS, String password) {
        IAIK.addAsJDK14Provider();
        int error = 0;
        error = SMime.SMIME_sendAttached_html(servidorIn, fromIn, toIn, subjectIn, textoIn, issuerIn, serialNumberIn, pathCS, password, null, false);
        return error;
    }

    public static int SMIME_sendAttached(String servidorIn, String fromIn, String toIn, String subjectIn, String textoIn, String issuerIn, String sn_dnIn, String pathCS, String password, boolean html, boolean bDN) {
        int error = 0;
        if (bDN) {
            ByteArrayOutputStream certArray;
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            error = cs.getCertIssuerSubjectCS(issuerIn, sn_dnIn, certArray = new ByteArrayOutputStream());
            if (error != 0) {
                return error;
            }
            String snIn = "";
            try {
                X509Certificate cert0 = new X509Certificate(certArray.toByteArray());
                snIn = cert0.getSerialNumber().toString();
            }
            catch (CertificateException ce) {
                error = 717;
                return 717;
            }
            if (snIn.equals("")) {
                error = 717;
                return 717;
            }
            error = SMime.SMIME_sendAttached(servidorIn, fromIn, toIn, subjectIn, textoIn, issuerIn, snIn, pathCS, password, html);
        } else {
            error = SMime.SMIME_sendAttached(servidorIn, fromIn, toIn, subjectIn, textoIn, issuerIn, sn_dnIn, pathCS, password, html);
        }
        return error;
    }

    public static int SMIME_sendAttached(String servidorIn, String fromIn, String toIn, String subjectIn, String textoIn, String issuerIn, String serialNumberIn, String pathCS, String password, boolean html) {
        IAIK.addAsJDK14Provider();
        int error = 0;
        error = SMime.SMIME_sendAttached_html(servidorIn, fromIn, toIn, subjectIn, textoIn, issuerIn, serialNumberIn, pathCS, password, null, html);
        return error;
    }

    public static int SMIME_sendAttached(String servidorIn, String fromIn, String toIn, String subjectIn, String textoIn, String issuerIn, String serialNumberIn, String pathCS, String password, String attachment) {
        IAIK.addAsJDK14Provider();
        int error = 0;
        error = SMime.SMIME_sendAttached_html(servidorIn, fromIn, toIn, subjectIn, textoIn, issuerIn, serialNumberIn, pathCS, password, attachment, false);
        return error;
    }

    public static int SMIME_sendAttached(String servidorIn, String fromIn, String toIn, String subjectIn, String textoIn, String issuerIn, String sn_dnIn, String pathCS, String password, String attachment, boolean html, boolean bDN) {
        int error = 0;
        if (bDN) {
            ByteArrayOutputStream certArray;
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            error = cs.getCertIssuerSubjectCS(issuerIn, sn_dnIn, certArray = new ByteArrayOutputStream());
            if (error != 0) {
                return error;
            }
            String snIn = "";
            try {
                X509Certificate cert0 = new X509Certificate(certArray.toByteArray());
                snIn = cert0.getSerialNumber().toString();
            }
            catch (CertificateException ce) {
                error = 717;
            }
            if (snIn.equals("")) {
                error = 717;
                return 717;
            }
            error = SMime.SMIME_sendAttached(servidorIn, fromIn, toIn, subjectIn, textoIn, issuerIn, snIn, pathCS, password, attachment, html);
        } else {
            error = SMime.SMIME_sendAttached(servidorIn, fromIn, toIn, subjectIn, textoIn, issuerIn, sn_dnIn, pathCS, password, attachment, html);
        }
        return error;
    }

    public static int SMIME_sendAttached(String servidorIn, String fromIn, String toIn, String subjectIn, String textoIn, String issuerIn, String serialNumberIn, String pathCS, String password, String attachment, boolean html) {
        IAIK.addAsJDK14Provider();
        int error = 0;
        error = SMime.SMIME_sendAttached_html(servidorIn, fromIn, toIn, subjectIn, textoIn, issuerIn, serialNumberIn, pathCS, password, attachment, html);
        return error;
    }

    private static int SMIME_sendAttached_html(String servidorIn, String fromIn, String toIn, String subjectIn, String textoIn, String issuerIn, String serialNumberIn, String pathCS, String password, String attachment, boolean html) {
        int error = 0;
        try {
            Vector lista;
            MailcapCommandMap mc = new MailcapCommandMap();
            mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
            mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
            mc.addMailcap("message/*;; x-java-content-handler=com.sun.mail.handlers.message_rfc822");
            mc.addMailcap("multipart/signed;; x-java-content-handler=iaik.smime.signed_content");
            mc.addMailcap("application/x-pkcs7-signature;; x-java-content-handler=iaik.smime.signed_content");
            mc.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=iaik.smime.encrypted_content");
            mc.addMailcap("application/pkcs7-signature;; x-java-content-handler=iaik.smime.signed_content");
            mc.addMailcap("application/pkcs7-mime;; x-java-content-handler=iaik.smime.signed_content");
            CommandMap.setDefaultCommandMap((CommandMap)mc);
            Properties mailProps = new Properties();
            mailProps.put("mail.smtp.host", servidorIn);
            Session mailSession = Session.getInstance((Properties)mailProps, null);
            int numAttachments = 0;
            if (attachment != null) {
                StringTokenizer st2 = new StringTokenizer(attachment, ",");
                while (st2.hasMoreTokens()) {
                    ++numAttachments;
                    st2.nextToken();
                }
            }
            String[] adjuntos = new String[numAttachments];
            String[] ficheros_adjuntos = new String[numAttachments];
            int j = 0;
            int posicion1 = 0;
            int posicion2 = 0;
            if (attachment != null) {
                StringTokenizer st = new StringTokenizer(attachment, ",");
                while (st.hasMoreTokens()) {
                    String resultado;
                    adjuntos[j] = resultado = st.nextToken();
                    posicion1 = resultado.lastIndexOf(47);
                    ficheros_adjuntos[j] = posicion1 <= (posicion2 = resultado.lastIndexOf(92)) ? resultado.substring(posicion2 + 1) : resultado.substring(posicion1 + 1);
                    ++j;
                }
            }
            int num_adjuntos = j;
            int num_bodyPart = num_adjuntos + 1;
            MimeBodyPart[] mimeBodyParts = new MimeBodyPart[num_bodyPart];
            mimeBodyParts[0] = new SMimeBodyPart();
            if (!html) {
                mimeBodyParts[0].setContent((Object)textoIn, "text/plain; charset=\"ISO-8859-1\"");
            } else {
                mimeBodyParts[0].setContent((Object)textoIn, "text/html; charset=\"ISO-8859-1\"");
            }
            int hh = 0;
            for (int h = 0; h < num_adjuntos; ++h) {
                hh = h + 1;
                mimeBodyParts[hh] = new SMimeBodyPart();
                mimeBodyParts[hh].setDataHandler(new DataHandler((DataSource)new FileDataSource(adjuntos[h])));
                mimeBodyParts[hh].setFileName(ficheros_adjuntos[h]);
            }
            SMimeMultipart mp = new SMimeMultipart();
            mp.addBodyPart((BodyPart)mimeBodyParts[0]);
            for (int k = 1; k < mimeBodyParts.length; ++k) {
                mp.addBodyPart((BodyPart)mimeBodyParts[k]);
            }
            DataHandler multipart = new DataHandler((Object)mp, mp.getContentType());
            MimeMessage msg = new MimeMessage(mailSession);
            msg.setFrom((Address)new InternetAddress(fromIn));
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)toIn, (boolean)false));
            msg.setSentDate(new Date());
            SignedContent sc = new SignedContent(true, "signed-data");
            msg.setSubject(subjectIn);
            sc.setDataHandler(multipart);
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            ByteArrayOutputStream x509Byte = new ByteArrayOutputStream();
            error = cs.getCertCS(issuerIn, serialNumberIn, x509Byte);
            if (error != 0) {
                return error;
            }
            X509Certificate x509cert = new X509Certificate(x509Byte.toByteArray());
            error = cs.getCertificateChain(x509cert, lista = new Vector());
            if (error != 0) {
                return error;
            }
            X509Certificate[] cadenaCert = new X509Certificate[lista.size()];
            for (int i = 0; i < lista.size(); ++i) {
                cadenaCert[i] = (X509Certificate)lista.elementAt(i);
            }
            sc.setCertificates((Certificate[])cadenaCert);
            PrivateKey pk = cs.getPrivateKeyFromKeyStore(issuerIn, serialNumberIn);
            if (pk == null) {
                error = 41;
                return 41;
            }
            sc.addSigner(pk, x509cert, null, false);
            msg.setContent((Object)sc, sc.getContentType());
            Transport.send((Message)msg);
        }
        catch (MessagingException me) {
            error = 716;
            return 716;
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 702;
            return 702;
        }
        catch (CertificateException ce) {
            error = 717;
            return 717;
        }
        return error;
    }
}

