/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.gestioncontenedorseguro;

import com.izenpe.AlgoritmosAsimetricos;
import com.izenpe.AlgoritmosHash;
import com.izenpe.accesoocsp.AccesoOCSP;
import com.izenpe.autenticacionfuerte.AutenticacionFuerte;
import com.izenpe.gestioncontenedorseguro.ConstantesContenedorSeguro;
import com.izenpe.miscelanea.Miscelanea;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AccessDescription;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.Name;
import iaik.pkcs.PKCS7CertList;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs10.CertificateRequest;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.pkcs.pkcs9.ExtensionRequest;
import iaik.security.provider.IAIK;
import iaik.utils.StreamCopier;
import iaik.x509.V3Extension;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.AuthorityKeyIdentifier;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.ExtendedKeyUsage;
import iaik.x509.extensions.KeyUsage;
import iaik.x509.extensions.SubjectInfoAccess;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class GestionContenedorSeguro
implements ConstantesContenedorSeguro {
    String pathContenedorSeguro = "";
    String passContenedorSeguro = "";
    KeyStore repositorio = null;
    public int error_keystore = 0;
    private String hash_repositorio = "";
    private static Hashtable contenedor_instancias = new Hashtable();
    protected String urlOCSP = "";
    private String urlOCSPDes = "http://172.19.10.193:8094";
    private String urlOCSPProd = "http://ocsp.izenpe.com:8094";

    protected GestionContenedorSeguro(String path, String pass) {
        try {
            if (!pass.equals("")) {
                this.repositorio = KeyStore.getInstance("IAIKKeyStore", "IAIK");
                this.pathContenedorSeguro = path.trim();
                if (!this.pathContenedorSeguro.endsWith(File.separator)) {
                    this.pathContenedorSeguro = this.pathContenedorSeguro + File.separator;
                }
                this.passContenedorSeguro = pass.trim();
                int errorOpen = this.openKeyStore();
                if (errorOpen != 0) {
                    this.error_keystore = errorOpen;
                    this.repositorio = null;
                }
            } else {
                this.repositorio = null;
            }
            contenedor_instancias.put(path, this);
            Miscelanea funciones = new Miscelanea();
            AlgoritmosHash alg = new AlgoritmosHash();
            alg.setAlgorithm("sha");
            ByteArrayOutputStream hashPath = new ByteArrayOutputStream();
            ByteArrayOutputStream hashPass = new ByteArrayOutputStream();
            funciones.newHash(alg.getAlgorithm(), path.getBytes("ISO8859_1"), hashPath);
            funciones.newHash(alg.getAlgorithm(), pass.getBytes("ISO8859_1"), hashPass);
            contenedor_instancias.put(hashPath.toString("ISO8859_1"), hashPass.toString("ISO8859_1"));
            hashPath.close();
            hashPass.close();
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (NoSuchProviderException nspe) {
            nspe.printStackTrace();
        }
        catch (KeyStoreException kse) {
            kse.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static GestionContenedorSeguro getInstance(String path, String pass) {
        IAIK iaik = new IAIK();
        IAIK.addAsJDK14Provider();
        IAIK.addAsProvider((boolean)false);
        GestionContenedorSeguro instancia = null;
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        if (contenedor_instancias.isEmpty()) {
            instancia = new GestionContenedorSeguro(path, pass);
        } else if (contenedor_instancias.containsKey(path)) {
            File ficheroks = new File(path + "jce.keystore");
            if (!ficheroks.exists()) {
                instancia = new GestionContenedorSeguro(path, pass);
            } else {
                try {
                    instancia = (GestionContenedorSeguro)contenedor_instancias.get(path);
                    BufferedInputStream buffer = new BufferedInputStream(new FileInputStream(ficheroks));
                    byte[] temp = new byte[buffer.available()];
                    buffer.read(temp);
                    Miscelanea funciones = new Miscelanea();
                    AlgoritmosHash alg = new AlgoritmosHash();
                    alg.setAlgorithm("sha");
                    ByteArrayOutputStream temphash = new ByteArrayOutputStream();
                    ByteArrayOutputStream temphashpath = new ByteArrayOutputStream();
                    ByteArrayOutputStream temphashpass = new ByteArrayOutputStream();
                    funciones.newHash(alg.getAlgorithm(), temp, temphash);
                    funciones.newHash(alg.getAlgorithm(), path.getBytes("ISO8859_1"), temphashpath);
                    funciones.newHash(alg.getAlgorithm(), pass.getBytes("ISO8859_1"), temphashpass);
                    if (!temphash.toString("ISO8859_1").equals(instancia.hash_repositorio)) {
                        instancia = new GestionContenedorSeguro(path, pass);
                    } else {
                        String hashdelPass = (String)contenedor_instancias.get(temphashpath.toString("ISO8859_1"));
                        if (!hashdelPass.equals(temphashpass.toString("ISO8859_1"))) {
                            instancia = new GestionContenedorSeguro(path, pass);
                        }
                    }
                    temphash.close();
                    buffer.close();
                }
                catch (FileNotFoundException fnfe) {
                }
                catch (IOException e) {}
            }
        } else {
            instancia = new GestionContenedorSeguro(path, pass);
        }
        return instancia;
    }

    private synchronized void recordKeyStore() {
        try {
            FileOutputStream grabarks = new FileOutputStream(this.pathContenedorSeguro + "jce.keystore");
            this.repositorio.store(grabarks, this.passContenedorSeguro.toCharArray());
            grabarks.close();
            FileInputStream ff = new FileInputStream(this.pathContenedorSeguro + "jce.keystore");
            byte[] temp = new byte[ff.available()];
            ff.read(temp);
            Miscelanea funciones = new Miscelanea();
            AlgoritmosHash alg = new AlgoritmosHash();
            alg.setAlgorithm("sha");
            ByteArrayOutputStream temphash = new ByteArrayOutputStream();
            funciones.newHash(alg.getAlgorithm(), temp, temphash);
            this.hash_repositorio = temphash.toString("ISO8859_1");
            ff.close();
            temphash.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (CertificateException ce) {
            ce.printStackTrace();
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
        }
        catch (KeyStoreException kse) {
            kse.printStackTrace();
        }
    }

    public int newKeyStore() {
        int error = 0;
        Miscelanea funciones = new Miscelanea();
        AlgoritmosHash alg = new AlgoritmosHash();
        alg.setAlgorithm("sha");
        ByteArrayOutputStream hashPath = new ByteArrayOutputStream();
        try {
            funciones.newHash(alg.getAlgorithm(), this.pathContenedorSeguro.getBytes("ISO8859_1"), hashPath);
            this.repositorio = KeyStore.getInstance("IAIKKeyStore", "IAIK");
            File ficheroks = new File(this.pathContenedorSeguro + "jce.keystore");
            File dir = new File(this.pathContenedorSeguro);
            if (dir.isDirectory()) {
                if (!ficheroks.exists()) {
                    this.repositorio.load(null, null);
                    this.recordKeyStore();
                    contenedor_instancias.remove(hashPath.toString("ISO8859_1"));
                    contenedor_instancias.remove(this.pathContenedorSeguro);
                    return error;
                }
                error = 1;
                return 1;
            }
            if (dir.mkdir()) {
                if (!ficheroks.exists()) {
                    this.repositorio.load(null, null);
                    this.recordKeyStore();
                    contenedor_instancias.remove(hashPath.toString("ISO8859_1"));
                    return error;
                }
                error = 1;
                return 1;
            }
            error = 46;
            return 46;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (CertificateException ce) {
            error = 6;
            return 6;
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 27;
            return 27;
        }
        catch (KeyStoreException kse) {
            error = 27;
            return 27;
        }
        catch (NoSuchProviderException kse) {
            error = 27;
            return 27;
        }
        return error;
    }

    public int deleteKeyStore() {
        int error = 0;
        try {
            File ficheroks = new File(this.pathContenedorSeguro + "jce.keystore");
            FileInputStream is = new FileInputStream(ficheroks);
            this.repositorio.load(is, this.passContenedorSeguro.toCharArray());
            is.close();
            if (!ficheroks.exists()) {
                error = 4;
                return 4;
            }
            ficheroks.delete();
            if (ficheroks.exists()) {
                error = 44;
                return 44;
            }
            return error;
        }
        catch (IOException ioe) {
            error = 29;
            return 29;
        }
        catch (CertificateException ce) {
            error = 28;
            return 28;
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 27;
            return 27;
        }
    }

    public int insertCertificateFile(String pathFichero, String nombreFichero) {
        int error = 0;
        try {
            File fcertificado;
            if (!pathFichero.endsWith(File.separator)) {
                pathFichero = pathFichero + File.separator;
            }
            if (!(fcertificado = new File(pathFichero + nombreFichero)).exists()) {
                error = 5;
            } else {
                X509Certificate x509cert = new X509Certificate((InputStream)new FileInputStream(fcertificado));
                error = this.insertCertificate(x509cert.toByteArray());
            }
        }
        catch (IOException ioe) {
            error = 29;
            return 29;
        }
        catch (CertificateException ce) {
            error = 16;
            return 16;
        }
        return error;
    }

    public int insertCACertificateFile(String pathFichero, String nombreFichero) {
        int error = 0;
        try {
            File fcertificado;
            if (!pathFichero.endsWith(File.separator)) {
                pathFichero = pathFichero + File.separator;
            }
            if (!(fcertificado = new File(pathFichero + nombreFichero)).exists()) {
                error = 5;
            } else {
                X509Certificate x509cert = new X509Certificate((InputStream)new FileInputStream(fcertificado));
                error = this.insertRootCertificate(x509cert.toByteArray());
            }
        }
        catch (IOException ioe) {
            error = 29;
            return 29;
        }
        catch (CertificateException ce) {
            error = 6;
            return 6;
        }
        return error;
    }

    public int insertCertificate(byte[] certificado) {
        int error = 0;
        try {
            if (this.repositorio == null) {
                error = this.error_keystore != 0 ? this.error_keystore : 63;
                return error;
            }
            X509Certificate cert = new X509Certificate(certificado);
            SubjectInfoAccess SIA = (SubjectInfoAccess)cert.getExtension(SubjectInfoAccess.oid);
            if (SIA != null) {
                error = 59;
                return 59;
            }
            String alias = ((Object)cert.getIssuerDN()).toString() + cert.getSerialNumber().toString();
            BasicConstraints BC = (BasicConstraints)cert.getExtension(BasicConstraints.oid);
            if (BC != null && BC.ca()) {
                error = 60;
                return 60;
            }
            try {
                cert.checkValidity();
            }
            catch (CertificateExpiredException cee) {
                error = 32;
                return 32;
            }
            catch (CertificateNotYetValidException cnyve) {
                // empty catch block
            }
            int revocado = 0;
            if (revocado == 0) {
                boolean encontrado = false;
                Vector listaAlias = new Vector();
                error = this.getAliasKeyStore(listaAlias);
                for (int i = 0; i < listaAlias.size(); ++i) {
                    if (!alias.equals((String)listaAlias.elementAt(i))) continue;
                    encontrado = true;
                    break;
                }
                if (!encontrado) {
                    this.repositorio.setCertificateEntry(alias, (Certificate)cert);
                } else {
                    error = 14;
                }
            } else {
                error = revocado;
                return error;
            }
            this.recordKeyStore();
        }
        catch (CertificateException ce) {
            error = 6;
            return 6;
        }
        catch (X509ExtensionInitException xeie) {
            error = 30;
            return 30;
        }
        catch (KeyStoreException kse) {
            error = 12;
            return 12;
        }
        return error;
    }

    public int insertCert_PKCS7(byte[] p7) {
        int error = 0;
        try {
            if (this.repositorio == null) {
                error = this.error_keystore != 0 ? this.error_keystore : 63;
                return error;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(p7);
            PKCS7CertList plist = new PKCS7CertList((InputStream)bais);
            X509Certificate[] x = plist.getCertificateList();
            for (int i = 0; i < x.length; ++i) {
                X509Certificate x509cert = x[i];
                error = this.insertCertificate(x509cert.toByteArray());
            }
            this.recordKeyStore();
            bais.close();
        }
        catch (IOException ioe) {
            error = 29;
            return 29;
        }
        catch (PKCSParsingException ppe) {
            error = 31;
            return 31;
        }
        return error;
    }

    public int insertRoot_PKCS7(byte[] p7) {
        int error = 0;
        try {
            if (this.repositorio == null) {
                error = this.error_keystore != 0 ? this.error_keystore : 63;
                return error;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(p7);
            PKCS7CertList plist = new PKCS7CertList((InputStream)bais);
            X509Certificate[] x = plist.getCertificateList();
            for (int i = 0; i < x.length; ++i) {
                X509Certificate x509cert = x[i];
                BasicConstraints BC = (BasicConstraints)x509cert.getExtension(BasicConstraints.oid);
                if (BC == null) {
                    error = 52;
                    return 52;
                }
                if (!BC.ca()) continue;
                error = this.insertRootCertificate(x509cert.toByteArray());
            }
            this.recordKeyStore();
            bais.close();
        }
        catch (IOException ioe) {
            error = 29;
            return 29;
        }
        catch (X509ExtensionInitException xeie) {
            error = 30;
            return 30;
        }
        catch (PKCSParsingException ppe) {
            error = 31;
            return 31;
        }
        return error;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int insertRootCertificate(byte[] certificado) {
        int error = 0;
        try {
            if (this.repositorio == null) {
                if (this.error_keystore == 0) return 63;
                return this.error_keystore;
            }
            X509Certificate cert = new X509Certificate(certificado);
            String alias = ((Object)cert.getIssuerDN()).toString() + cert.getSerialNumber().toString();
            BasicConstraints BC = (BasicConstraints)cert.getExtension(BasicConstraints.oid);
            if (BC == null) {
                return 52;
            }
            if (BC.ca()) {
                cert.checkValidity();
                int revocado = 0;
                if (revocado != 0) return revocado;
                boolean encontrado = false;
                Vector listaAlias = new Vector();
                error = this.getAliasKeyStore(listaAlias);
                for (int i = 0; i < listaAlias.size(); ++i) {
                    if (!alias.equals((String)listaAlias.elementAt(i))) continue;
                    encontrado = true;
                    break;
                }
                if (!encontrado) {
                    this.repositorio.setCertificateEntry(alias, (Certificate)cert);
                } else {
                    error = 14;
                }
            } else {
                error = 8;
            }
            this.recordKeyStore();
            return error;
        }
        catch (CertificateExpiredException cee) {
            return 32;
        }
        catch (CertificateNotYetValidException cnyve) {
            return 33;
        }
        catch (CertificateException ce) {
            return 6;
        }
        catch (KeyStoreException kse) {
            return 12;
        }
        catch (X509ExtensionInitException xeie) {
            return 30;
        }
    }

    public int insertKeyEntry(byte[] p12In, String passP12) {
        int error = 0;
        try {
            if (this.repositorio == null) {
                error = this.error_keystore != 0 ? this.error_keystore : 63;
                return error;
            }
            ByteArrayInputStream pkcs12 = new ByteArrayInputStream(p12In);
            PKCS12 p12 = new PKCS12((InputStream)pkcs12);
            p12.decrypt(passP12.toCharArray());
            CertificateBag[] certBag = new CertificateBag[1];
            certBag = p12.getCertificateBags();
            X509Certificate cert = new X509Certificate();
            cert = certBag[0].getCertificate();
            String alias = ((Object)cert.getIssuerDN()).toString() + cert.getSerialNumber().toString();
            X509Certificate[] chain = new X509Certificate[]{cert};
            cert.checkValidity();
            int revocado = this.isRevoked(cert);
            if (revocado == 0) {
                boolean encontrado = false;
                Vector listaAlias = new Vector();
                error = this.getAliasKeyStore(listaAlias);
                for (int i = 0; i < listaAlias.size(); ++i) {
                    if (!alias.equals((String)listaAlias.elementAt(i))) continue;
                    encontrado = true;
                    break;
                }
                if (!encontrado) {
                    KeyBag kB = p12.getKeyBag();
                    PrivateKey pKey = kB.getPrivateKey();
                    this.repositorio.setKeyEntry(alias, pKey, this.passContenedorSeguro.toCharArray(), (Certificate[])chain);
                    this.recordKeyStore();
                } else {
                    error = 14;
                }
            } else {
                error = revocado;
                return error;
            }
            pkcs12.close();
            this.recordKeyStore();
        }
        catch (KeyStoreException kse) {
            error = 12;
            return 12;
        }
        catch (PKCSException pkcse) {
            error = 47;
            return 47;
        }
        catch (CertificateExpiredException cee) {
            error = 32;
            return 32;
        }
        catch (CertificateNotYetValidException cnyve) {
            error = 33;
            return 33;
        }
        catch (FileNotFoundException fnfe) {
            error = 40;
            return 40;
        }
        catch (IOException ioe) {
            error = 29;
            return 29;
        }
        return error;
    }

    public int enumCertsCS(Vector issuerOut, Vector snOut) {
        int error = 0;
        if (this.repositorio == null) {
            error = this.error_keystore != 0 ? this.error_keystore : 63;
            return error;
        }
        Vector aliases = new Vector();
        error = this.getAliasKeyStore(aliases);
        if (aliases.size() == 0) {
            error = 10;
            return 10;
        }
        try {
            for (int i = 0; i < aliases.size(); ++i) {
                ByteArrayOutputStream certOut = new ByteArrayOutputStream();
                int getcert = this.getCertificate((String)aliases.elementAt(i), certOut);
                if (getcert != 0) {
                    error = getcert;
                    return error;
                }
                X509Certificate x509cert = new X509Certificate(certOut.toByteArray());
                if (x509cert != null) {
                    Principal is = x509cert.getIssuerDN();
                    BigInteger sn = x509cert.getSerialNumber();
                    issuerOut.addElement(is);
                    snOut.addElement(sn);
                }
                certOut.close();
            }
        }
        catch (CertificateException ce) {
            error = 42;
            return 42;
        }
        catch (IOException ce) {
            error = 56;
            return 56;
        }
        return error;
    }

    public synchronized int openKeyStore() {
        int error = 0;
        if (this.repositorio == null) {
            error = 11;
            return 11;
        }
        try {
            File ficheroks = new File(this.pathContenedorSeguro + "jce.keystore");
            if (!ficheroks.exists()) {
                error = 2;
                return 2;
            }
            FileInputStream ff = new FileInputStream(ficheroks);
            this.repositorio.load(new BufferedInputStream(new FileInputStream(ficheroks)), this.passContenedorSeguro.toCharArray());
            byte[] temp = new byte[ff.available()];
            ff.read(temp);
            Miscelanea funciones = new Miscelanea();
            AlgoritmosHash alg = new AlgoritmosHash();
            alg.setAlgorithm("sha");
            ByteArrayOutputStream temphash = new ByteArrayOutputStream();
            funciones.newHash(alg.getAlgorithm(), temp, temphash);
            this.hash_repositorio = temphash.toString("ISO8859_1");
            ff.close();
            temphash.close();
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
        }
        catch (CertificateException ce) {
            error = 28;
            return 28;
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 27;
            return 27;
        }
        catch (IOException ioe) {
            error = 11;
            return 11;
        }
        return error;
    }

    public int getCertCS(String issuerIn, String snIn, ByteArrayOutputStream certOut) {
        int error = 0;
        try {
            if (this.repositorio == null) {
                error = this.error_keystore != 0 ? this.error_keystore : 63;
                return error;
            }
            boolean encontrado = false;
            Vector aliases = new Vector();
            error = this.getAliasKeyStore(aliases);
            for (int i = 0; i < aliases.size(); ++i) {
                ByteArrayOutputStream certSalida = new ByteArrayOutputStream();
                int getcert = this.getCertificate((String)aliases.elementAt(i), certSalida);
                if (getcert != 0) {
                    error = getcert;
                    return error;
                }
                X509Certificate x509cert = new X509Certificate(certSalida.toByteArray());
                if (((Object)x509cert.getIssuerDN()).toString().equals(issuerIn) && x509cert.getSerialNumber().toString().equals(snIn)) {
                    certOut.write(x509cert.toByteArray());
                    encontrado = true;
                    break;
                }
                certSalida.close();
            }
            if (!encontrado) {
                error = 13;
                return 13;
            }
        }
        catch (IOException ioe) {
            error = 56;
            return 56;
        }
        catch (CertificateException ce) {
            error = 42;
            return 42;
        }
        return error;
    }

    public int getCertIssuerSubjectCS(String issuerIn, String subjectIn, ByteArrayOutputStream certOut) {
        int error = 0;
        try {
            if (this.repositorio == null) {
                error = this.error_keystore != 0 ? this.error_keystore : 63;
                return error;
            }
            boolean encontrado = false;
            Vector aliases = new Vector();
            error = this.getAliasKeyStore(aliases);
            for (int i = 0; i < aliases.size(); ++i) {
                ByteArrayOutputStream certSalida = new ByteArrayOutputStream();
                int getcert = this.getCertificate((String)aliases.elementAt(i), certSalida);
                if (getcert != 0) {
                    error = getcert;
                    return error;
                }
                X509Certificate x509cert = new X509Certificate(certSalida.toByteArray());
                if (((Object)x509cert.getIssuerDN()).toString().equals(issuerIn) && ((Object)x509cert.getSubjectDN()).toString().equals(subjectIn)) {
                    certOut.write(x509cert.toByteArray());
                    encontrado = true;
                    break;
                }
                certSalida.close();
            }
            if (!encontrado) {
                error = 13;
                return 13;
            }
        }
        catch (IOException ioe) {
            error = 56;
            return 56;
        }
        catch (CertificateException ce) {
            error = 42;
            return 42;
        }
        return error;
    }

    public int getCAFromKeyStore(String issuerIn, byte[] authorityIn, ByteArrayOutputStream certOut) {
        int error = 0;
        try {
            if (this.repositorio == null) {
                error = this.error_keystore != 0 ? this.error_keystore : 63;
                return error;
            }
            boolean encontrado = false;
            Vector aliases = new Vector();
            error = this.getAliasKeyStore(aliases);
            for (int i = 0; i < aliases.size(); ++i) {
                ByteArrayOutputStream certSalida = new ByteArrayOutputStream();
                int getcert = this.getCertificate((String)aliases.elementAt(i), certSalida);
                if (getcert != 0) {
                    error = getcert;
                    return error;
                }
                X509Certificate x509cert = new X509Certificate(certSalida.toByteArray());
                BasicConstraints BC = (BasicConstraints)x509cert.getExtension(BasicConstraints.oid);
                if (BC != null && BC.ca()) {
                    if (authorityIn != null) {
                        SubjectKeyIdentifier ski = new SubjectKeyIdentifier();
                        SubjectKeyIdentifier ski2 = new SubjectKeyIdentifier(authorityIn);
                        ski = (SubjectKeyIdentifier)x509cert.getExtension(SubjectKeyIdentifier.oid);
                        byte[] subjectKI = ski.get();
                        if (((Object)x509cert.getSubjectDN()).toString().equals(issuerIn) && ski.toString().equals(ski2.toString())) {
                            encontrado = true;
                            certOut.write(x509cert.toByteArray());
                            break;
                        }
                    } else if (((Object)x509cert.getSubjectDN()).toString().equals(issuerIn)) {
                        certOut.write(x509cert.toByteArray());
                        encontrado = true;
                        certOut.write(x509cert.toByteArray());
                        break;
                    }
                }
                certSalida.close();
            }
            if (!encontrado) {
                error = 13;
                return 13;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (CertificateException ce) {
            error = 42;
            return 42;
        }
        catch (X509ExtensionInitException xeie) {
            error = 30;
            return 30;
        }
        return error;
    }

    public int isRevoked(X509Certificate x509cert) {
        int error;
        block25: {
            error = 0;
            if (this.repositorio == null) {
                error = this.error_keystore != 0 ? this.error_keystore : 63;
                return error;
            }
            try {
                SubjectInfoAccess SIA = (SubjectInfoAccess)x509cert.getExtension(SubjectInfoAccess.oid);
                if (((Object)x509cert.getIssuerDN()).equals(x509cert.getSubjectDN()) || SIA != null) break block25;
                String issuer = ((Object)x509cert.getIssuerDN()).toString();
                AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier();
                aki = (AuthorityKeyIdentifier)x509cert.getExtension(AuthorityKeyIdentifier.oid);
                ByteArrayOutputStream cacert = new ByteArrayOutputStream();
                if (aki != null) {
                    byte[] authority = aki.getKeyIdentifier();
                    error = this.getCAFromKeyStore(issuer, authority, cacert);
                } else {
                    error = this.getCAFromKeyStore(issuer, null, cacert);
                }
                if (cacert.size() > 0) {
                    X509Certificate CACert = new X509Certificate(cacert.toByteArray());
                    ByteArrayOutputStream hash = new ByteArrayOutputStream();
                    ByteArrayOutputStream nuevohash64 = new ByteArrayOutputStream();
                    String nombrecrl = ((Object)CACert.getIssuerDN()).toString() + CACert.getSerialNumber().toString();
                    Miscelanea funciones = new Miscelanea();
                    AlgoritmosHash alg = new AlgoritmosHash();
                    alg.setAlgorithm("sha");
                    funciones.newHash(alg.getAlgorithm(), nombrecrl.getBytes("ISO8859_1"), hash, true);
                    funciones.binBase64(hash.toByteArray(), nuevohash64);
                    String htemporal = nuevohash64.toString("ISO8859_1");
                    htemporal = htemporal.replace('/', '_');
                    String pathcompleto = this.pathContenedorSeguro + htemporal + ".crl";
                    File crl = new File(pathcompleto);
                    if (!crl.exists()) {
                        BasicConstraints BC = (BasicConstraints)x509cert.getExtension(BasicConstraints.oid);
                        if (!(BC != null && BC.ca() || this.isOCSP(x509cert.getEncoded()))) {
                            AccesoOCSP ao = new AccesoOCSP();
                            if (this.urlOCSP == null || this.urlOCSP.equals("")) {
                                ao.setResponderTSA(this.pathContenedorSeguro, this.passContenedorSeguro);
                            } else {
                                ao.setResponder(this.urlOCSP);
                            }
                            ByteArrayOutputStream responseOCSPOut = new ByteArrayOutputStream();
                            ByteArrayOutputStream responseDateOut = new ByteArrayOutputStream();
                            ByteArrayOutputStream responseValue = new ByteArrayOutputStream();
                            error = ao.requestOCSP_NoVerify(x509cert.getEncoded(), this.pathContenedorSeguro, this.passContenedorSeguro, responseOCSPOut, responseDateOut, responseValue);
                            if (error != 0) {
                                return error;
                            }
                            if (!responseValue.toString("ISO8859_1").equalsIgnoreCase("good")) {
                                error = 64;
                                return 64;
                            }
                        }
                        break block25;
                    }
                    X509CRL x509crl = new X509CRL((InputStream)new BufferedInputStream(new FileInputStream(crl)));
                    x509crl.verify(CACert.getPublicKey());
                    if (!((Object)CACert.getIssuerDN()).equals(CACert.getSubjectDN())) {
                        Vector listacerts = new Vector();
                        int erroropen = this.getCertificateChain(x509crl, listacerts);
                        if (erroropen != 0) {
                            error = erroropen;
                            return error;
                        }
                        X509Certificate[] cadena = new X509Certificate[listacerts.size()];
                        for (int i = 0; i < listacerts.size(); ++i) {
                            cadena[i] = (X509Certificate)listacerts.elementAt(i);
                        }
                        if (cadena != null) {
                            error = this.comprobar(cadena);
                        }
                    }
                    cacert.close();
                    hash.close();
                    nuevohash64.close();
                    if (x509crl.isRevoked((Certificate)x509cert)) {
                        error = 21;
                        return 21;
                    }
                    error = 0;
                    return 0;
                }
                error = 22;
                return 22;
            }
            catch (X509ExtensionInitException xeie) {
                error = 30;
                return 30;
            }
            catch (SignatureException se) {
                error = 34;
                return 34;
            }
            catch (InvalidKeyException ike) {
                error = 35;
                return 35;
            }
            catch (NoSuchAlgorithmException nsae) {
                error = 27;
                return 27;
            }
            catch (NoSuchProviderException nspe) {
                error = 25;
                return 25;
            }
            catch (CertificateException ce) {
                error = 28;
                return 28;
            }
            catch (CRLException crle) {
                error = 37;
                return 37;
            }
            catch (FileNotFoundException fnfe) {
                error = 23;
                return 23;
            }
            catch (IOException ioe) {
                error = 56;
                return 56;
            }
        }
        return error;
    }

    public int comprobar(X509Certificate[] certChain) {
        int error = 0;
        for (int z = 0; z < certChain.length; ++z) {
            error = this.isRevoked(certChain[z]);
            if (error == 0) continue;
            return error;
        }
        if (error == 0) {
            for (int i = 0; i < certChain.length; ++i) {
                try {
                    certChain[i].checkValidity();
                }
                catch (CertificateExpiredException cee) {
                    error = 32;
                }
                catch (CertificateNotYetValidException cnyve) {
                    error = 33;
                }
                try {
                    if (i < certChain.length - 1) {
                        certChain[i].verify(certChain[i + 1].getPublicKey());
                        continue;
                    }
                    certChain[i].verify();
                    continue;
                }
                catch (CertificateException ce) {
                    error = 28;
                    return 28;
                }
                catch (NoSuchAlgorithmException nsae) {
                    error = 27;
                    return 27;
                }
                catch (InvalidKeyException ike) {
                    error = 35;
                    return 35;
                }
                catch (NoSuchProviderException nspe) {
                    error = 25;
                    return 25;
                }
                catch (SignatureException se) {
                    error = 34;
                    return 34;
                }
            }
        }
        return error;
    }

    public PrivateKey getPrivateKeyFromKeyStore(String issuerIn, String snIn) {
        PrivateKey pk = null;
        boolean encontrado = false;
        String comparar = issuerIn + snIn;
        Vector aliases = new Vector();
        this.getAliasKeyStore(aliases);
        for (int i = 0; i < aliases.size(); ++i) {
            if (!comparar.equals((String)aliases.elementAt(i))) continue;
            pk = this.getPrivateKey(comparar);
            encontrado = true;
            break;
        }
        if (!encontrado) {
            pk = null;
        }
        return pk;
    }

    public int removeCertCS(String issuerIn, String snIn) {
        int error = 0;
        try {
            if (this.repositorio == null) {
                error = this.error_keystore != 0 ? this.error_keystore : 63;
                return error;
            }
            boolean encontrado = false;
            String alias = issuerIn + snIn;
            Vector aliases = new Vector();
            error = this.getAliasKeyStore(aliases);
            for (int i = 0; i < aliases.size(); ++i) {
                if (!alias.equals((String)aliases.elementAt(i))) continue;
                encontrado = true;
                break;
            }
            if (encontrado) {
                this.repositorio.deleteEntry(alias);
            }
            this.recordKeyStore();
            if (!encontrado) {
                error = 13;
                return 13;
            }
        }
        catch (KeyStoreException kse) {
            error = 12;
            return 12;
        }
        return error;
    }

    public synchronized int changePasswordCS(String oldPassword, String newPassword) {
        int error = 0;
        try {
            FileInputStream fic;
            File ficheroks;
            if (oldPassword.equals(this.passContenedorSeguro)) {
                ficheroks = new File(this.pathContenedorSeguro + "jce.keystore");
                fic = new FileInputStream(ficheroks);
                if (!ficheroks.exists()) {
                    error = 2;
                    return 2;
                }
                this.repositorio.load(fic, this.passContenedorSeguro.toCharArray());
                Enumeration<String> conjunto = this.repositorio.aliases();
                while (conjunto.hasMoreElements()) {
                    String aliasTemporal = conjunto.nextElement();
                    if (!this.repositorio.isKeyEntry(aliasTemporal)) continue;
                    Key keyTemporal = this.repositorio.getKey(aliasTemporal, oldPassword.toCharArray());
                    X509Certificate certTemporal = (X509Certificate)this.repositorio.getCertificate(aliasTemporal);
                    X509Certificate[] cadenaTemporal = new X509Certificate[]{certTemporal};
                    this.repositorio.deleteEntry(aliasTemporal);
                    this.repositorio.setKeyEntry(aliasTemporal, keyTemporal, newPassword.toCharArray(), (Certificate[])cadenaTemporal);
                }
            } else {
                error = 11;
                return 11;
            }
            fic.close();
            FileOutputStream foc = new FileOutputStream(ficheroks);
            this.repositorio.store(foc, newPassword.toCharArray());
            foc.close();
            FileInputStream ff = new FileInputStream(this.pathContenedorSeguro + "jce.keystore");
            byte[] temp = new byte[ff.available()];
            ff.read(temp);
            Miscelanea funciones = new Miscelanea();
            AlgoritmosHash alg = new AlgoritmosHash();
            alg.setAlgorithm("sha");
            ByteArrayOutputStream temphash = new ByteArrayOutputStream();
            funciones.newHash(alg.getAlgorithm(), temp, temphash);
            this.hash_repositorio = temphash.toString("ISO8859_1");
            ff.close();
            temphash.close();
        }
        catch (IOException ioe) {
            error = 15;
            return 15;
        }
        catch (UnrecoverableKeyException urke) {
            error = 41;
            return 41;
        }
        catch (NullPointerException ioe) {
            error = 11;
            return 11;
        }
        catch (CertificateException ce) {
            error = 28;
            return 28;
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 27;
            return 27;
        }
        catch (KeyStoreException kse) {
            error = 12;
            return 12;
        }
        return error;
    }

    public int importPKCS12(byte[] pkcs12, String passIn, PrivateKey pkOut, ByteArrayOutputStream certOut) {
        int error = 0;
        try {
            if (this.repositorio == null) {
                error = this.error_keystore != 0 ? this.error_keystore : 63;
                return error;
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(pkcs12);
            PKCS12 p12 = new PKCS12((InputStream)bis);
            p12.decrypt(passIn.toCharArray());
            CertificateBag[] certBag = p12.getCertificateBags();
            CertificateBag cert = certBag[0];
            X509Certificate x509cert = new X509Certificate();
            x509cert = cert.getCertificate();
            KeyBag kB = p12.getKeyBag();
            pkOut = kB.getPrivateKey();
            certOut.write(x509cert.toByteArray());
            bis.close();
            certOut.close();
        }
        catch (IOException ioe) {
            error = 56;
            return 56;
        }
        catch (PKCSParsingException ppe) {
            error = 31;
            return 31;
        }
        catch (PKCSException pe) {
            error = 38;
            return 38;
        }
        return error;
    }

    private int exportPKCS12(byte[] certIn, PrivateKey pkeyin, String pass12, ByteArrayOutputStream pfx) {
        int error = 0;
        try {
            ByteArrayInputStream cert = new ByteArrayInputStream(certIn);
            KeyBag keyBag = new KeyBag(pkeyin);
            CertificateBag[] certBags = new CertificateBag[1];
            X509Certificate x509cert = new X509Certificate(certIn);
            certBags[0] = new CertificateBag(x509cert);
            PKCS12 p12 = new PKCS12(keyBag, certBags);
            p12.encrypt(pass12.toCharArray());
            p12.writeTo((OutputStream)pfx);
            cert.close();
        }
        catch (CertificateException ce) {
            error = 28;
            return 28;
        }
        catch (IOException ioe) {
            error = 56;
            return 56;
        }
        catch (PKCSParsingException ppe) {
            error = 31;
            return 31;
        }
        catch (PKCSException pe) {
            error = 38;
            return 38;
        }
        return error;
    }

    public int exportPKCS12(String issuerIn, String snIn, String pass12, ByteArrayOutputStream pfx) {
        int error = 0;
        if (this.repositorio == null) {
            error = this.error_keystore != 0 ? this.error_keystore : 63;
            return error;
        }
        try {
            PrivateKey pkeyin = this.getPrivateKeyFromKeyStore(issuerIn, snIn);
            if (pkeyin == null) {
                error = 19;
                return 19;
            }
            ByteArrayOutputStream cert = new ByteArrayOutputStream();
            int errorcert = this.getCertCS(issuerIn, snIn, cert);
            if (error != 0) {
                error = errorcert;
                return error;
            }
            X509Certificate x509cert = new X509Certificate(cert.toByteArray());
            String aliasPkcs12 = ((Object)x509cert.getIssuerDN()).toString() + x509cert.getSerialNumber().toString();
            byte[] keyId = new byte[]{1, 2, 3, 4};
            KeyBag keyBag = new KeyBag(pkeyin, aliasPkcs12, keyId);
            CertificateBag[] certBags = new CertificateBag[]{new CertificateBag(x509cert)};
            certBags[0].setFriendlyName(aliasPkcs12);
            certBags[0].setLocalKeyID(keyId);
            PKCS12 p12 = new PKCS12(keyBag, certBags);
            p12.encrypt(pass12.toCharArray());
            p12.writeTo((OutputStream)pfx);
            pfx.close();
            cert.close();
        }
        catch (CertificateException ce) {
            error = 28;
            return 28;
        }
        catch (IOException ioe) {
            error = 56;
            return 56;
        }
        catch (PKCSParsingException ppe) {
            error = 31;
            return 31;
        }
        catch (PKCSException pe) {
            error = 38;
            return 38;
        }
        return error;
    }

    public int extractCert_LDAP(String servidor, int puerto, String login, String ldappass, String rama, String nombreat, String valorat, ByteArrayOutputStream certOut) {
        int error = 0;
        try {
            boolean encontrado = false;
            LDAPConnection ldap = new LDAPConnection();
            ldap.connect(servidor, puerto, login, ldappass);
            String ramanombre = rama + "=" + nombreat;
            LDAPSearchResults res = ldap.search(valorat, 2, ramanombre, null, false);
            while (res.hasMoreElements()) {
                LDAPEntry findEntry = null;
                findEntry = res.next();
                LDAPAttributeSet findAttrs = findEntry.getAttributeSet();
                Enumeration enumAttrs = findAttrs.getAttributes();
                LDAPAttribute anAttr = null;
                while (enumAttrs.hasMoreElements()) {
                    anAttr = (LDAPAttribute)enumAttrs.nextElement();
                    String attrName = anAttr.getName();
                    if (!attrName.equalsIgnoreCase("cACertificate")) continue;
                    Enumeration enumVals = anAttr.getByteValues();
                    while (enumVals.hasMoreElements()) {
                        encontrado = true;
                        byte[] aVal = (byte[])enumVals.nextElement();
                        certOut.write(aVal);
                    }
                }
            }
            certOut.close();
            ldap.disconnect();
            if (!encontrado) {
                error = 51;
                return 51;
            }
        }
        catch (LDAPException ldape) {
            error = 36;
            return 36;
        }
        catch (IOException ioe) {
            error = 56;
            return 56;
        }
        return error;
    }

    public int extractCrl_LDAP(String servidor, int puerto, String login, String ldappass, String rama, String nombreat, String valorat, ByteArrayOutputStream crlOut) {
        int error = 0;
        try {
            boolean encontrado = false;
            LDAPConnection ldap = new LDAPConnection();
            ldap.connect(servidor, puerto, login, ldappass);
            String ramanombre = rama + "=" + nombreat;
            LDAPSearchResults res = ldap.search(valorat, 2, ramanombre, null, false);
            while (res.hasMoreElements()) {
                LDAPEntry findEntry = null;
                findEntry = res.next();
                LDAPAttributeSet findAttrs = findEntry.getAttributeSet();
                Enumeration enumAttrs = findAttrs.getAttributes();
                LDAPAttribute anAttr = null;
                while (enumAttrs.hasMoreElements()) {
                    byte[] aVal;
                    Enumeration enumVals;
                    anAttr = (LDAPAttribute)enumAttrs.nextElement();
                    String attrName = anAttr.getName();
                    if (attrName.equalsIgnoreCase("certificateRevocationList")) {
                        enumVals = anAttr.getByteValues();
                        while (enumVals.hasMoreElements()) {
                            encontrado = true;
                            aVal = (byte[])enumVals.nextElement();
                            crlOut.write(aVal);
                        }
                    }
                    if (!attrName.equalsIgnoreCase("certificaterevocationlist")) continue;
                    enumVals = anAttr.getByteValues();
                    while (enumVals.hasMoreElements()) {
                        encontrado = true;
                        aVal = (byte[])enumVals.nextElement();
                        crlOut.write(aVal);
                    }
                }
            }
            crlOut.close();
            ldap.disconnect();
            if (!encontrado) {
                error = 51;
                return 51;
            }
        }
        catch (LDAPException ldape) {
            error = 36;
            return 36;
        }
        catch (IOException ioe) {
            error = 56;
            return 56;
        }
        return error;
    }

    public int extractArl_LDAP(String servidor, int puerto, String login, String ldappass, String rama, String nombreat, String valorat, ByteArrayOutputStream crlOut) {
        int error = 0;
        try {
            boolean encontrado = false;
            LDAPConnection ldap = new LDAPConnection();
            ldap.connect(servidor, puerto, login, ldappass);
            String ramanombre = rama + "=" + nombreat;
            LDAPSearchResults res = ldap.search(valorat, 2, ramanombre, null, false);
            while (res.hasMoreElements()) {
                LDAPEntry findEntry = null;
                findEntry = res.next();
                LDAPAttributeSet findAttrs = findEntry.getAttributeSet();
                Enumeration enumAttrs = findAttrs.getAttributes();
                LDAPAttribute anAttr = null;
                while (enumAttrs.hasMoreElements()) {
                    anAttr = (LDAPAttribute)enumAttrs.nextElement();
                    String attrName = anAttr.getName();
                    if (!attrName.equalsIgnoreCase("authorityRevocationList")) continue;
                    Enumeration enumVals = anAttr.getByteValues();
                    while (enumVals.hasMoreElements()) {
                        encontrado = true;
                        byte[] aVal = (byte[])enumVals.nextElement();
                        crlOut.write(aVal);
                    }
                }
            }
            crlOut.close();
            ldap.disconnect();
            if (!encontrado) {
                error = 51;
                return 51;
            }
        }
        catch (LDAPException ldape) {
            error = 36;
            return 36;
        }
        catch (IOException ioe) {
            error = 56;
            return 56;
        }
        return error;
    }

    public int extractUserCertificate_LDAP(String servidor, int puerto, String login, String ldappass, String rama, String nombreat, String valorat, ByteArrayOutputStream certOut) {
        int error = 0;
        try {
            boolean encontrado = false;
            LDAPConnection ldap = new LDAPConnection();
            ldap.connect(servidor, puerto, login, ldappass);
            String ramanombre = rama + "=" + nombreat;
            LDAPSearchResults res = ldap.search(valorat, 2, ramanombre, null, false);
            while (res.hasMoreElements()) {
                LDAPEntry findEntry = null;
                findEntry = res.next();
                LDAPAttributeSet findAttrs = findEntry.getAttributeSet();
                Enumeration enumAttrs = findAttrs.getAttributes();
                LDAPAttribute anAttr = null;
                while (enumAttrs.hasMoreElements()) {
                    anAttr = (LDAPAttribute)enumAttrs.nextElement();
                    String attrName = anAttr.getName();
                    if (!attrName.equalsIgnoreCase("userCertificate;binary")) continue;
                    Enumeration enumVals = anAttr.getByteValues();
                    while (enumVals.hasMoreElements()) {
                        encontrado = true;
                        byte[] aVal = (byte[])enumVals.nextElement();
                        certOut.write(aVal);
                    }
                }
            }
            certOut.close();
            ldap.disconnect();
            if (!encontrado) {
                error = 51;
                return 51;
            }
        }
        catch (LDAPException ldape) {
            error = 36;
            return 36;
        }
        catch (IOException ioe) {
            error = 56;
            return 56;
        }
        return error;
    }

    public PrivateKey getPrivateKeyFromPKCS12File(String path, String fichero, String pass) {
        PrivateKey pKey = null;
        try {
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            File fcertificado = new File(path + fichero);
            FileInputStream ff = new FileInputStream(fcertificado);
            byte[] pkcs12 = new byte[(int)fcertificado.length()];
            ff.read(pkcs12);
            ff.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(pkcs12);
            PKCS12 p12 = new PKCS12((InputStream)bis);
            p12.decrypt(pass.toCharArray());
            CertificateBag[] certBag = p12.getCertificateBags();
            X509Certificate[] certChain = CertificateBag.getCertificates((CertificateBag[])certBag);
            KeyBag kB = p12.getKeyBag();
            pKey = kB.getPrivateKey();
            bis.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (PKCSParsingException ppe) {
        }
        catch (PKCSException pe) {
            // empty catch block
        }
        return pKey;
    }

    public int requestPKCS10(String DNIn, int longitud, ByteArrayOutputStream pkcs10) {
        int error = 0;
        if (this.repositorio == null) {
            error = this.error_keystore != 0 ? this.error_keystore : 63;
            return error;
        }
        Name subject = new Name();
        String todo = DNIn;
        StringTokenizer st = new StringTokenizer(todo, ",");
        String c = "";
        String o = "";
        String ou = "";
        String cn = "";
        String email = "";
        String l = "";
        String prov = "";
        while (st.hasMoreElements()) {
            String valor = "";
            String temporal = (String)st.nextElement();
            String etiqueta = temporal.substring(0, temporal.indexOf("=")).trim();
            if (etiqueta.equalsIgnoreCase("C") || etiqueta.equalsIgnoreCase("Country")) {
                if (temporal.substring(temporal.indexOf("=") + 1, temporal.length()).length() > 2) {
                    error = 62;
                    return 62;
                }
                c = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
            }
            if (etiqueta.equalsIgnoreCase("O") || etiqueta.equalsIgnoreCase("Organization")) {
                o = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
            }
            if (etiqueta.equalsIgnoreCase("OU") || etiqueta.equalsIgnoreCase("Org-unit")) {
                ou = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
            }
            if (etiqueta.equalsIgnoreCase("CN") || etiqueta.equalsIgnoreCase("Common-name")) {
                cn = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
            }
            if ((etiqueta.equalsIgnoreCase("EA") || etiqueta.equalsIgnoreCase("Email")) && ((email = temporal.substring(temporal.indexOf("=") + 1, temporal.length())).indexOf("\u00f1") != -1 || email.indexOf("\u00d1") != -1)) {
                error = 61;
                return 61;
            }
            if (etiqueta.equalsIgnoreCase("L") || etiqueta.equalsIgnoreCase("Locality")) {
                l = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
            }
            if (!etiqueta.equalsIgnoreCase("ST") && !etiqueta.equalsIgnoreCase("State")) continue;
            prov = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
        }
        if (!c.equals("")) {
            subject.addRDN(ObjectID.country, (Object)c);
        }
        if (!o.equals("")) {
            subject.addRDN(ObjectID.organization, (Object)o);
        }
        if (!ou.equals("")) {
            subject.addRDN(ObjectID.organizationalUnit, (Object)ou);
        }
        if (!cn.equals("")) {
            subject.addRDN(ObjectID.commonName, (Object)cn);
        }
        if (!email.equals("")) {
            subject.addRDN(ObjectID.emailAddress, (Object)email);
        }
        if (!l.equals("")) {
            subject.addRDN(ObjectID.locality, (Object)l);
        }
        if (!prov.equals("")) {
            subject.addRDN(ObjectID.stateOrProvince, (Object)prov);
        }
        try {
            AlgoritmosAsimetricos alg = new AlgoritmosAsimetricos();
            alg.setAlgorithm("RSAENCRYPTION");
            KeyPair kp = this.generateKeyPair(alg.getAlgorithm().getImplementationName(), longitud);
            CertificateRequest request = new CertificateRequest(kp.getPublic(), subject);
            Attribute[] attributes = new Attribute[1];
            KeyUsage keyUsage = new KeyUsage(11);
            ExtendedKeyUsage eku = new ExtendedKeyUsage();
            eku.addKeyPurposeID(ExtendedKeyUsage.clientAuth);
            eku.addKeyPurposeID(ExtendedKeyUsage.emailProtection);
            ExtensionRequest extensionRequest = new ExtensionRequest();
            extensionRequest.addExtension((V3Extension)keyUsage);
            extensionRequest.addExtension((V3Extension)eku);
            attributes[0] = new Attribute((AttributeValue)extensionRequest);
            request.setAttributes(attributes);
            request.sign(AlgorithmID.sha1WithRSAEncryption, kp.getPrivate());
            request.writeTo((OutputStream)pkcs10);
            Miscelanea funciones = new Miscelanea();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            AlgoritmosHash alg2 = new AlgoritmosHash();
            alg2.setAlgorithm("SHA");
            funciones.newHash(alg2.getAlgorithm(), kp.getPublic().getEncoded(), baos, true);
            X509Certificate[] chain = new X509Certificate[1];
            X509Certificate x509certp10 = new X509Certificate();
            GregorianCalendar date = new GregorianCalendar();
            x509certp10.setValidNotBefore(date.getTime());
            date.add(1, 1);
            x509certp10.setValidNotAfter(date.getTime());
            x509certp10.setPublicKey(kp.getPublic());
            double doble = Math.random();
            String tempserial = "" + doble;
            x509certp10.setSerialNumber(new BigInteger(tempserial.substring(tempserial.indexOf(".") + 1, tempserial.length())));
            Name issuer = new Name();
            issuer.addRDN(ObjectID.caIssuers, (Object)"Petici\u00f3n de PKCS10");
            x509certp10.setIssuerDN((Principal)issuer);
            x509certp10.setSubjectDN((Principal)subject);
            x509certp10.sign(AlgorithmID.sha1WithRSAEncryption, kp.getPrivate());
            chain[0] = x509certp10;
            this.repositorio.setKeyEntry(baos.toString("ISO8859_1"), kp.getPrivate(), this.passContenedorSeguro.toCharArray(), (Certificate[])chain);
            pkcs10.close();
            baos.close();
            this.recordKeyStore();
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 27;
            return 27;
        }
        catch (InvalidKeyException ike) {
            error = 35;
            return 35;
        }
        catch (CertificateException ce) {
            error = 42;
            return 42;
        }
        catch (X509ExtensionException xee) {
            error = 30;
            return 30;
        }
        catch (CodingException ce) {
            error = 39;
            return 39;
        }
        catch (SignatureException se) {
            error = 34;
            return 34;
        }
        catch (KeyStoreException kse) {
            error = 26;
            return 26;
        }
        catch (IOException ioe) {
            error = 56;
            return 56;
        }
        return error;
    }

    public int requestPKCS10_gestor(String DNIn, int longitud, int tipo, ByteArrayOutputStream pkcs10) {
        int error = 0;
        if (this.repositorio == null) {
            error = this.error_keystore != 0 ? this.error_keystore : 63;
            return error;
        }
        KeyUsage keyUsage = null;
        ExtendedKeyUsage eKeyUsage = null;
        switch (tipo) {
            case 1: {
                keyUsage = new KeyUsage(3);
                eKeyUsage = new ExtendedKeyUsage();
                eKeyUsage.addKeyPurposeID(ExtendedKeyUsage.clientAuth);
                eKeyUsage.addKeyPurposeID(ExtendedKeyUsage.emailProtection);
                break;
            }
            case 2: {
                keyUsage = new KeyUsage(13);
                eKeyUsage = new ExtendedKeyUsage();
                eKeyUsage.addKeyPurposeID(ExtendedKeyUsage.clientAuth);
                eKeyUsage.addKeyPurposeID(ExtendedKeyUsage.emailProtection);
                break;
            }
            case 3: {
                keyUsage = new KeyUsage(13);
                eKeyUsage = new ExtendedKeyUsage();
                eKeyUsage.addKeyPurposeID(ExtendedKeyUsage.clientAuth);
                eKeyUsage.addKeyPurposeID(ExtendedKeyUsage.emailProtection);
                break;
            }
            default: {
                keyUsage = new KeyUsage(13);
            }
        }
        Name subject = new Name();
        String todo = DNIn;
        StringTokenizer st = new StringTokenizer(todo, ",");
        String campo = "";
        while (st.hasMoreElements()) {
            String valor = "";
            String temporal = (String)st.nextElement();
            String etiqueta = temporal.substring(0, temporal.indexOf("=")).trim();
            if (etiqueta.equalsIgnoreCase("C") || etiqueta.equalsIgnoreCase("Country")) {
                if (temporal.substring(temporal.indexOf("=") + 1, temporal.length()).length() > 2) {
                    error = 62;
                    return 62;
                }
                campo = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
                subject.addRDN(ObjectID.country, (Object)campo);
            }
            if (etiqueta.equalsIgnoreCase("O") || etiqueta.equalsIgnoreCase("Organization")) {
                campo = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
                subject.addRDN(ObjectID.organization, (Object)campo);
            }
            if (etiqueta.equalsIgnoreCase("OU") || etiqueta.equalsIgnoreCase("Org-unit")) {
                campo = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
                subject.addRDN(ObjectID.organizationalUnit, (Object)campo);
            }
            if (etiqueta.equalsIgnoreCase("CN") || etiqueta.equalsIgnoreCase("Common-name")) {
                campo = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
                subject.addRDN(ObjectID.commonName, (Object)campo);
            }
            if (etiqueta.equalsIgnoreCase("EA") || etiqueta.equalsIgnoreCase("Email")) {
                campo = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
                if (campo.indexOf("\u00f1") != -1 || campo.indexOf("\u00d1") != -1) {
                    error = 61;
                    return 61;
                }
                subject.addRDN(ObjectID.emailAddress, (Object)campo);
            }
            if (etiqueta.equalsIgnoreCase("L") || etiqueta.equalsIgnoreCase("Locality")) {
                campo = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
                subject.addRDN(ObjectID.locality, (Object)campo);
            }
            if (etiqueta.equalsIgnoreCase("ST") || etiqueta.equalsIgnoreCase("State")) {
                campo = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
                subject.addRDN(ObjectID.stateOrProvince, (Object)campo);
            }
            if (etiqueta.equalsIgnoreCase("DNQ") || etiqueta.equalsIgnoreCase("dnQuailifier")) {
                campo = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
                subject.addRDN(ObjectID.dnQualifier, (Object)campo);
            }
            if (etiqueta.equalsIgnoreCase("GivenName")) {
                campo = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
                subject.addRDN(ObjectID.givenName, (Object)campo);
            }
            if (etiqueta.equalsIgnoreCase("SurName")) {
                campo = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
                subject.addRDN(ObjectID.surName, (Object)campo);
            }
            if (etiqueta.equalsIgnoreCase("SerialNumber")) {
                campo = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
                subject.addRDN(ObjectID.serialNumber, (Object)campo);
            }
            if (!etiqueta.equalsIgnoreCase("1.3.6.1.4.1.18838.1.1")) continue;
            campo = temporal.substring(temporal.indexOf("=") + 1, temporal.length());
            subject.addRDN(new ObjectID("1.3.6.1.4.1.18838.1.1"), (Object)campo);
        }
        try {
            AlgoritmosAsimetricos alg = new AlgoritmosAsimetricos();
            alg.setAlgorithm("RSAENCRYPTION");
            KeyPair kp = this.generateKeyPair(alg.getAlgorithm().getImplementationName(), longitud);
            CertificateRequest request = new CertificateRequest(kp.getPublic(), subject);
            Attribute[] attributes = new Attribute[1];
            ExtensionRequest extensionRequest = new ExtensionRequest();
            extensionRequest.addExtension((V3Extension)keyUsage);
            extensionRequest.addExtension((V3Extension)eKeyUsage);
            attributes[0] = new Attribute((AttributeValue)extensionRequest);
            request.setAttributes(attributes);
            request.sign(AlgorithmID.sha1WithRSAEncryption, kp.getPrivate());
            request.writeTo((OutputStream)pkcs10);
            Miscelanea funciones = new Miscelanea();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            AlgoritmosHash alg2 = new AlgoritmosHash();
            alg2.setAlgorithm("SHA");
            funciones.newHash(alg2.getAlgorithm(), kp.getPublic().getEncoded(), baos, true);
            X509Certificate[] chain = new X509Certificate[1];
            X509Certificate x509certp10 = new X509Certificate();
            GregorianCalendar date = new GregorianCalendar();
            x509certp10.setValidNotBefore(date.getTime());
            date.add(1, 1);
            x509certp10.setValidNotAfter(date.getTime());
            x509certp10.setPublicKey(kp.getPublic());
            double doble = Math.random();
            String tempserial = "" + doble;
            x509certp10.setSerialNumber(new BigInteger(tempserial.substring(tempserial.indexOf(".") + 1, tempserial.length())));
            Name issuer = new Name();
            issuer.addRDN(ObjectID.caIssuers, (Object)"Petici\u00f3n de PKCS10");
            x509certp10.setIssuerDN((Principal)issuer);
            x509certp10.setSubjectDN((Principal)subject);
            x509certp10.sign(AlgorithmID.sha1WithRSAEncryption, kp.getPrivate());
            chain[0] = x509certp10;
            this.repositorio.setKeyEntry(baos.toString("ISO8859_1"), kp.getPrivate(), this.passContenedorSeguro.toCharArray(), (Certificate[])chain);
            pkcs10.close();
            baos.close();
            this.recordKeyStore();
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 27;
            return 27;
        }
        catch (InvalidKeyException ike) {
            error = 35;
            return 35;
        }
        catch (CertificateException ce) {
            error = 42;
            return 42;
        }
        catch (X509ExtensionException xee) {
            error = 30;
            return 30;
        }
        catch (CodingException ce) {
            error = 39;
            return 39;
        }
        catch (SignatureException se) {
            error = 34;
            return 34;
        }
        catch (KeyStoreException kse) {
            error = 26;
            return 26;
        }
        catch (IOException ioe) {
            error = 56;
            return 56;
        }
        return error;
    }

    public int insertPKCS10(X509Certificate pkcs10) {
        int error = 0;
        if (this.repositorio == null) {
            error = this.error_keystore != 0 ? this.error_keystore : 63;
            return error;
        }
        try {
            Miscelanea funciones = new Miscelanea();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            AlgoritmosHash alg2 = new AlgoritmosHash();
            alg2.setAlgorithm("SHA");
            funciones.newHash(alg2.getAlgorithm(), pkcs10.getPublicKey().getEncoded(), baos, true);
            PrivateKey pkey = this.getPrivateKey(baos.toString("ISO8859_1"));
            String aliasp10 = ((Object)pkcs10.getIssuerDN()).toString() + pkcs10.getSerialNumber().toString();
            X509Certificate[] cadena = new X509Certificate[]{pkcs10};
            try {
                pkcs10.checkValidity();
            }
            catch (CertificateExpiredException cee) {
                error = 32;
                return 32;
            }
            catch (CertificateNotYetValidException cnyve) {
                // empty catch block
            }
            error = this.isRevoked(pkcs10);
            if (error != 0) {
                return error;
            }
            this.repositorio.setKeyEntry(aliasp10, pkey, this.passContenedorSeguro.toCharArray(), (Certificate[])cadena);
            this.repositorio.deleteEntry(baos.toString("ISO8859_1"));
            baos.close();
            this.recordKeyStore();
        }
        catch (KeyStoreException kse) {
            error = 26;
            return 26;
        }
        catch (IOException ioe) {
            error = 56;
            return 56;
        }
        return error;
    }

    public int getCertificateChain(X509Certificate cert, Vector cadena) {
        int error = 0;
        if (this.repositorio == null) {
            error = this.error_keystore != 0 ? this.error_keystore : 63;
            return error;
        }
        Vector<X509Certificate> v = new Vector<X509Certificate>();
        boolean encontrado = false;
        try {
            Enumeration<String> aliases = this.repositorio.aliases();
            X509Certificate certAux = new X509Certificate();
            v.addElement(new X509Certificate(cert.toByteArray()));
            while (aliases.hasMoreElements() && !encontrado) {
                String alias = aliases.nextElement();
                certAux = (X509Certificate)this.repositorio.getCertificate(alias);
                if (!((Object)certAux.getSubjectDN()).equals(cert.getIssuerDN())) continue;
                ByteArrayOutputStream aki = this.getAuthorityKeyIdentifier(cert);
                ByteArrayOutputStream ski = this.getSubjectKeyIdentifier(certAux);
                if (aki != null && ski != null) {
                    if (aki.toString("ISO8859_1").equals(ski.toString("ISO8859_1"))) {
                        v.addElement(new X509Certificate(certAux.toByteArray()));
                        if (((Object)certAux.getSubjectDN()).equals(certAux.getIssuerDN())) {
                            encontrado = true;
                        } else {
                            aliases = this.repositorio.aliases();
                            cert = certAux;
                        }
                    }
                    aki.close();
                } else {
                    v.addElement(new X509Certificate(certAux.toByteArray()));
                    if (((Object)certAux.getSubjectDN()).equals(certAux.getIssuerDN())) {
                        encontrado = true;
                    } else {
                        aliases = this.repositorio.aliases();
                        cert = certAux;
                    }
                }
                ski.close();
            }
        }
        catch (KeyStoreException kse) {
            error = 26;
            return 26;
        }
        catch (NullPointerException npe) {
            error = 63;
            return 63;
        }
        catch (IOException ioe) {
            error = 56;
            return 56;
        }
        catch (CertificateException ce) {
            error = 28;
            return 28;
        }
        if (encontrado) {
            for (int j = 0; j < v.size(); ++j) {
                cadena.addElement((X509Certificate)v.elementAt(j));
            }
            return error;
        }
        error = 43;
        return 43;
    }

    public int writeCRL(byte[] crlbyte, String path, String pass) {
        int error = 0;
        try {
            X509CRL x509crl = new X509CRL(crlbyte);
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            String issuer = ((Object)x509crl.getIssuerDN()).toString();
            AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier();
            aki = (AuthorityKeyIdentifier)x509crl.getExtension(AuthorityKeyIdentifier.oid);
            ByteArrayOutputStream cacert = new ByteArrayOutputStream();
            if (aki != null) {
                byte[] authority = aki.getKeyIdentifier();
                error = this.getCAFromKeyStore(issuer, authority, cacert);
            } else {
                error = this.getCAFromKeyStore(issuer, null, cacert);
            }
            if (error == 0 && cacert.size() > 0) {
                X509Certificate x509cert = new X509Certificate(cacert.toByteArray());
                x509crl.verify(x509cert.getPublicKey());
                Vector listacerts = new Vector();
                int errorcarga = this.getCertificateChain(x509crl, listacerts);
                X509Certificate[] cadenacrl = new X509Certificate[listacerts.size()];
                for (int i = 0; i < listacerts.size(); ++i) {
                    cadenacrl[i] = (X509Certificate)listacerts.elementAt(i);
                }
                if (errorcarga == 0) {
                    error = this.comprobar(cadenacrl);
                    if (error == 0) {
                        ByteArrayOutputStream hash = new ByteArrayOutputStream();
                        ByteArrayOutputStream nuevohash64 = new ByteArrayOutputStream();
                        String nombrecrl = ((Object)x509cert.getIssuerDN()).toString() + x509cert.getSerialNumber().toString();
                        Miscelanea funciones = new Miscelanea();
                        AlgoritmosHash alg = new AlgoritmosHash();
                        alg.setAlgorithm("sha");
                        funciones.newHash(alg.getAlgorithm(), nombrecrl.getBytes("ISO8859_1"), hash, true);
                        funciones.binBase64(hash.toByteArray(), nuevohash64);
                        String htemporal = nuevohash64.toString("ISO8859_1");
                        htemporal = htemporal.replace('/', '_');
                        String pathcompleto = path + htemporal + ".crl";
                        File crl = new File(pathcompleto);
                        if (crl.exists()) {
                            error = 201;
                        }
                        hash.close();
                        nuevohash64.close();
                        byte[] tempcrl = crlbyte;
                        ByteArrayInputStream bis = new ByteArrayInputStream(tempcrl);
                        FileOutputStream fi = new FileOutputStream(crl);
                        int linea2 = 0;
                        byte[] temp2 = new byte[4096];
                        while ((linea2 = bis.read(temp2)) != -1) {
                            fi.write(temp2, 0, linea2);
                        }
                        fi.close();
                        bis.close();
                    } else {
                        error = 48;
                    }
                    cacert.close();
                } else {
                    error = 49;
                }
            } else {
                error = 50;
            }
            return error;
        }
        catch (CRLException crle) {
            error = 37;
            return 37;
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 27;
            return 27;
        }
        catch (InvalidKeyException ike) {
            error = 35;
            return 35;
        }
        catch (X509ExtensionInitException xeie) {
            error = 30;
            return 30;
        }
        catch (CertificateException ce) {
            error = 28;
            return 28;
        }
        catch (SignatureException se) {
            error = 34;
            return 34;
        }
        catch (IOException ioe) {
            error = 29;
            return 29;
        }
        catch (NoSuchProviderException nspe) {
            error = 25;
            return 25;
        }
    }

    public int getCertificateChain(X509CRL crl, Vector cadena) {
        int error = 0;
        if (this.repositorio == null) {
            error = this.error_keystore != 0 ? this.error_keystore : 63;
            return error;
        }
        Vector<X509Certificate> v = new Vector<X509Certificate>();
        boolean encontrado = false;
        boolean encontrado2 = false;
        try {
            Enumeration<String> aliases = this.repositorio.aliases();
            X509Certificate certAux = new X509Certificate();
            while (aliases.hasMoreElements() && !encontrado2) {
                certAux = (X509Certificate)this.repositorio.getCertificate(aliases.nextElement());
                if (!((Object)certAux.getSubjectDN()).equals(crl.getIssuerDN())) continue;
                ByteArrayOutputStream aki = this.getAuthorityKeyIdentifierCRL(crl);
                ByteArrayOutputStream ski = this.getSubjectKeyIdentifier(certAux);
                if (aki != null && ski != null) {
                    if (aki.toString("ISO8859_1").equals(ski.toString("ISO8859_1"))) {
                        v.addElement(certAux);
                        encontrado2 = true;
                    }
                    aki.close();
                } else {
                    v.addElement(certAux);
                    encontrado2 = true;
                }
                ski.close();
            }
            X509Certificate cert = certAux;
            aliases = this.repositorio.aliases();
            while (aliases.hasMoreElements() && !encontrado) {
                String alias = aliases.nextElement();
                certAux = (X509Certificate)this.repositorio.getCertificate(alias);
                if (!((Object)certAux.getSubjectDN()).equals(cert.getIssuerDN())) continue;
                ByteArrayOutputStream aki = this.getAuthorityKeyIdentifier(cert);
                ByteArrayOutputStream ski = this.getSubjectKeyIdentifier(certAux);
                if (aki != null && ski != null) {
                    if (aki.toString("ISO8859_1").equals(ski.toString("ISO8859_1"))) {
                        v.addElement(new X509Certificate(certAux.toByteArray()));
                        if (((Object)certAux.getSubjectDN()).equals(certAux.getIssuerDN())) {
                            encontrado = true;
                        } else {
                            aliases = this.repositorio.aliases();
                            cert = certAux;
                        }
                    }
                    aki.close();
                } else {
                    v.addElement(new X509Certificate(certAux.toByteArray()));
                    if (((Object)certAux.getSubjectDN()).equals(certAux.getIssuerDN())) {
                        encontrado = true;
                    } else {
                        aliases = this.repositorio.aliases();
                        cert = certAux;
                    }
                }
                ski.close();
            }
        }
        catch (KeyStoreException kse) {
            error = 26;
            return 26;
        }
        catch (IOException ioe) {
            error = 56;
            return 56;
        }
        catch (CertificateException ce) {
            error = 28;
            return 28;
        }
        if (encontrado) {
            for (int j = 0; j < v.size(); ++j) {
                cadena.addElement((X509Certificate)v.elementAt(j));
            }
            return error;
        }
        error = 43;
        return 43;
    }

    public int getRoot(X509Certificate cert, ByteArrayOutputStream certOut) {
        int error = 0;
        if (this.repositorio == null) {
            error = this.error_keystore != 0 ? this.error_keystore : 63;
            return error;
        }
        X509Certificate certificado = new X509Certificate();
        boolean encontrado = false;
        String alias = "";
        try {
            Enumeration<String> aliases = this.repositorio.aliases();
            while (aliases.hasMoreElements() && !encontrado) {
                alias = aliases.nextElement();
                certificado = (X509Certificate)this.repositorio.getCertificate(alias);
                if (!((Object)certificado.getSubjectDN()).toString().equals(((Object)cert.getIssuerDN()).toString()) || !((Object)certificado.getSubjectDN()).equals(certificado.getIssuerDN())) continue;
                ByteArrayOutputStream aki = this.getAuthorityKeyIdentifier(cert);
                ByteArrayOutputStream ski = this.getSubjectKeyIdentifier(certificado);
                if (ski != null && aki != null) {
                    if (aki.toString("ISO8859_1").equals(ski.toString("ISO8859_1"))) {
                        encontrado = true;
                    }
                    aki.close();
                } else {
                    encontrado = true;
                }
                ski.close();
            }
            if (encontrado) {
                certOut.write(certificado.getEncoded());
                certOut.close();
                return error;
            }
            error = 45;
            return 45;
        }
        catch (KeyStoreException kse) {
            error = 26;
            return 26;
        }
        catch (CertificateEncodingException cee) {
            error = 28;
            return 28;
        }
        catch (IOException ioe) {
            error = 56;
            return 56;
        }
    }

    public int getPKAlias(String issuer, String serial, ByteArrayOutputStream salida) {
        int error = 0;
        if (this.repositorio == null) {
            error = this.error_keystore != 0 ? this.error_keystore : 63;
            return error;
        }
        boolean encontrado = false;
        X509Certificate cert = new X509Certificate();
        String alias = "";
        try {
            Enumeration<String> aliases = this.repositorio.aliases();
            while (aliases.hasMoreElements() && !encontrado) {
                alias = aliases.nextElement();
                cert = (X509Certificate)this.repositorio.getCertificate(alias);
                if (!((Object)cert.getIssuerDN()).toString().equals(issuer) || !cert.getSerialNumber().toString().equals(serial) || !this.repositorio.isKeyEntry(alias)) continue;
                encontrado = true;
            }
            if (encontrado) {
                salida.write(alias.getBytes("ISO8859_1"));
                salida.close();
                return error;
            }
            return error;
        }
        catch (KeyStoreException kse) {
            error = 26;
            return 26;
        }
        catch (IOException ioe) {
            error = 56;
            return 56;
        }
    }

    public int getCertificateAlias(String issuer, String serial, ByteArrayOutputStream salida) {
        int error = 0;
        if (this.repositorio == null) {
            error = this.error_keystore != 0 ? this.error_keystore : 63;
            return error;
        }
        boolean encontrado = false;
        X509Certificate cert = new X509Certificate();
        String alias = "";
        try {
            Enumeration<String> aliases = this.repositorio.aliases();
            while (aliases.hasMoreElements() && !encontrado) {
                alias = aliases.nextElement();
                cert = (X509Certificate)this.repositorio.getCertificate(alias);
                if (!((Object)cert.getIssuerDN()).toString().equals(issuer) || !cert.getSerialNumber().toString().equals(serial)) continue;
                encontrado = true;
            }
            if (encontrado) {
                salida.write(alias.getBytes("ISO8859_1"));
                salida.close();
                return error;
            }
            return error;
        }
        catch (KeyStoreException kse) {
            error = 26;
            return 26;
        }
        catch (IOException ioe) {
            error = 56;
            return 56;
        }
    }

    public int removeTSACertificate() {
        int error = 0;
        try {
            if (this.repositorio == null) {
                error = this.error_keystore != 0 ? this.error_keystore : 63;
                return error;
            }
            if (!this.repositorio.containsAlias("TSACertificate")) {
                error = 58;
                return 58;
            }
            this.repositorio.deleteEntry("TSACertificate");
            this.recordKeyStore();
        }
        catch (KeyStoreException kse) {
            error = 26;
            return 26;
        }
        return error;
    }

    public int getURLTSA(ByteArrayOutputStream url) {
        int error = 0;
        try {
            if (this.repositorio == null) {
                error = this.error_keystore != 0 ? this.error_keystore : 63;
                return error;
            }
            X509Certificate x509tsa = (X509Certificate)this.repositorio.getCertificate("TSACertificate");
            if (x509tsa == null) {
                error = 54;
                return 54;
            }
            SubjectInfoAccess SIA = (SubjectInfoAccess)x509tsa.getExtension(SubjectInfoAccess.oid);
            if (SIA == null) {
                error = 53;
                return 53;
            }
            GeneralName gn = null;
            Enumeration accessDs = SIA.getAccessDescriptions();
            AccessDescription ad = null;
            while (accessDs.hasMoreElements()) {
                ad = (AccessDescription)accessDs.nextElement();
                gn = ad.getAccessLocation();
            }
            url.write(gn.getName().toString().getBytes("ISO8859_1"));
        }
        catch (KeyStoreException kse) {
            error = 26;
            return 26;
        }
        catch (X509ExtensionInitException xeie) {
            error = 30;
            return 30;
        }
        catch (IOException ioe) {
            error = 29;
            return 29;
        }
        return error;
    }

    public int insertTSACertificate(byte[] certificado) {
        int error = 0;
        try {
            if (this.repositorio == null) {
                error = this.error_keystore != 0 ? this.error_keystore : 63;
                return error;
            }
            X509Certificate cert = new X509Certificate(certificado);
            String alias = "TSACertificate";
            SubjectInfoAccess SIA = (SubjectInfoAccess)cert.getExtension(SubjectInfoAccess.oid);
            if (SIA == null) {
                error = 53;
                return 53;
            }
            cert.checkValidity();
            int revocado = this.isRevoked(cert);
            if (revocado != 0) {
                error = revocado;
                return error;
            }
            boolean encontrado = false;
            Vector listaAlias = new Vector();
            error = this.getAliasKeyStore(listaAlias);
            for (int i = 0; i < listaAlias.size(); ++i) {
                if (!alias.equals((String)listaAlias.elementAt(i))) continue;
                encontrado = true;
                break;
            }
            if (!encontrado) {
                this.repositorio.setCertificateEntry(alias, (Certificate)cert);
            } else {
                error = 14;
            }
            this.recordKeyStore();
        }
        catch (CertificateExpiredException cee) {
            error = 32;
            return 32;
        }
        catch (CertificateNotYetValidException cnyve) {
            error = 33;
            return 33;
        }
        catch (CertificateException ce) {
            error = 6;
            return 6;
        }
        catch (KeyStoreException kse) {
            error = 12;
            return 12;
        }
        catch (X509ExtensionInitException xeie) {
            error = 30;
            return 30;
        }
        return error;
    }

    public int mostrarCertificado(byte[] certificado, ByteArrayOutputStream issuer, ByteArrayOutputStream serial, ByteArrayOutputStream subject, ByteArrayOutputStream keyUsage, ByteArrayOutputStream validFromDate, ByteArrayOutputStream expirationDate) {
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            issuer.write(((Object)cert.getIssuerDN()).toString().getBytes("ISO8859_1"));
            serial.write(cert.getSerialNumber().toString().getBytes("ISO8859_1"));
            subject.write(((Object)cert.getSubjectDN()).toString().getBytes("ISO8859_1"));
            validFromDate.write(cert.getNotBefore().toString().getBytes("ISO8859_1"));
            expirationDate.write(cert.getNotAfter().toString().getBytes("ISO8859_1"));
            AutenticacionFuerte af = new AutenticacionFuerte();
            error = af.extractKeyUsage(certificado, keyUsage);
        }
        catch (CertificateException ce) {
            error = 28;
        }
        catch (IOException ioe) {
            error = 29;
        }
        return error;
    }

    public int mostrarCrl(byte[] crl, ByteArrayOutputStream issuer, Vector certsRevoked, ByteArrayOutputStream nextUpdate, ByteArrayOutputStream thisUpdate) {
        int error = 0;
        try {
            X509CRL xCrl = new X509CRL(crl);
            issuer.write(((Object)xCrl.getIssuerDN()).toString().getBytes("ISO8859_1"));
            nextUpdate.write(xCrl.getNextUpdate().toString().getBytes("ISO8859_1"));
            thisUpdate.write(xCrl.getThisUpdate().toString().getBytes("ISO8859_1"));
            Enumeration enum1 = xCrl.listCertificates();
            while (enum1.hasMoreElements()) {
                certsRevoked.addElement(enum1.nextElement());
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (CRLException crle) {
            crle.printStackTrace();
        }
        return error;
    }

    public int extractCrl(String issuer, String sn, ByteArrayOutputStream crlOut) {
        int errorCRL = 0;
        try {
            String nombrecrl = issuer + sn;
            ByteArrayOutputStream hash = new ByteArrayOutputStream();
            ByteArrayOutputStream nuevohash64 = new ByteArrayOutputStream();
            Miscelanea funciones = new Miscelanea();
            AlgoritmosHash alg = new AlgoritmosHash();
            alg.setAlgorithm("sha");
            funciones.newHash(alg.getAlgorithm(), nombrecrl.getBytes("ISO8859_1"), hash, true);
            funciones.binBase64(hash.toByteArray(), nuevohash64);
            String htemporal = nuevohash64.toString("ISO8859_1");
            htemporal = htemporal.replace('/', '_');
            FileInputStream fCrl = new FileInputStream(this.pathContenedorSeguro + htemporal + ".crl");
            X509CRL crl = new X509CRL((InputStream)fCrl);
            crlOut.write(crl.toByteArray());
            nuevohash64.close();
            crlOut.close();
            hash.close();
        }
        catch (FileNotFoundException fnfe) {
            errorCRL = 57;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (CRLException crle) {
            crle.printStackTrace();
        }
        return errorCRL;
    }

    public int listarCAs(Vector issuerOut, Vector snOut) {
        int error = 0;
        if (this.repositorio == null) {
            error = this.error_keystore != 0 ? this.error_keystore : 63;
            return error;
        }
        try {
            Enumeration<String> aliases = this.repositorio.aliases();
            X509Certificate cert = new X509Certificate();
            while (aliases.hasMoreElements()) {
                cert = (X509Certificate)this.repositorio.getCertificate(aliases.nextElement());
                BasicConstraints bc = (BasicConstraints)cert.getExtension(BasicConstraints.oid);
                if (bc == null || !bc.ca()) continue;
                issuerOut.addElement(((Object)cert.getIssuerDN()).toString());
                snOut.addElement(cert.getSerialNumber().toString());
            }
        }
        catch (KeyStoreException kse) {
            kse.printStackTrace();
        }
        catch (X509ExtensionInitException xeie) {
            xeie.printStackTrace();
        }
        return error;
    }

    public int getCertIssuer(X509Certificate cert, Vector cadena) {
        int error = 0;
        if (this.repositorio == null) {
            error = this.error_keystore != 0 ? this.error_keystore : 63;
            return error;
        }
        Vector<X509Certificate> v = new Vector<X509Certificate>();
        boolean encontrado = false;
        try {
            Enumeration<String> aliases = this.repositorio.aliases();
            X509Certificate certAux = new X509Certificate();
            v.addElement(new X509Certificate(cert.toByteArray()));
            while (aliases.hasMoreElements() && !encontrado) {
                String alias = aliases.nextElement();
                certAux = (X509Certificate)this.repositorio.getCertificate(alias);
                if (!((Object)certAux.getSubjectDN()).equals(cert.getIssuerDN())) continue;
                ByteArrayOutputStream aki = this.getAuthorityKeyIdentifier(cert);
                ByteArrayOutputStream ski = this.getSubjectKeyIdentifier(certAux);
                if (aki != null && ski != null) {
                    if (aki.toString("ISO8859_1").equals(ski.toString("ISO8859_1"))) {
                        v.addElement(new X509Certificate(certAux.toByteArray()));
                        encontrado = true;
                    } else {
                        aliases = this.repositorio.aliases();
                        cert = certAux;
                    }
                    aki.close();
                } else {
                    v.addElement(new X509Certificate(certAux.toByteArray()));
                    encontrado = true;
                }
                ski.close();
            }
        }
        catch (KeyStoreException kse) {
            error = 26;
            return 26;
        }
        catch (CertificateException ce) {
            error = 28;
            return 28;
        }
        catch (IOException ioe) {
            error = 56;
            return 56;
        }
        if (encontrado) {
            for (int j = 0; j < v.size(); ++j) {
                cadena.addElement((X509Certificate)v.elementAt(j));
            }
            return error;
        }
        error = 55;
        return 55;
    }

    private int getCertificate(String alias, ByteArrayOutputStream certOut) {
        int error = 0;
        if (this.repositorio == null) {
            error = this.error_keystore != 0 ? this.error_keystore : 63;
            return error;
        }
        X509Certificate x509cert = new X509Certificate();
        try {
            x509cert = (X509Certificate)this.repositorio.getCertificate(alias);
            if (x509cert != null) {
                certOut.write(x509cert.getEncoded());
            }
            certOut.close();
        }
        catch (KeyStoreException kse) {
            kse.printStackTrace();
            error = 26;
            return 26;
        }
        catch (CertificateEncodingException cee) {
            error = 28;
            return 28;
        }
        catch (IOException ioe) {
            error = 56;
            return 56;
        }
        return error;
    }

    private PrivateKey getPrivateKey(String alias) {
        PrivateKey pKey = null;
        try {
            pKey = (PrivateKey)this.repositorio.getKey(alias, this.passContenedorSeguro.toCharArray());
        }
        catch (KeyStoreException kse) {
        }
        catch (NoSuchAlgorithmException nsae) {
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            // empty catch block
        }
        return pKey;
    }

    private KeyPair generateKeyPair(String algorithm, int bits) {
        KeyPairGenerator generator = null;
        try {
            generator = KeyPairGenerator.getInstance(algorithm, "IAIK");
            generator.initialize(bits);
        }
        catch (NoSuchAlgorithmException nsae) {
        }
        catch (NoSuchProviderException nspe) {
            // empty catch block
        }
        generator.initialize(bits);
        KeyPair kp = generator.generateKeyPair();
        return kp;
    }

    private int getAliasKeyStore(Vector listaElementos) {
        int error = 0;
        if (this.repositorio == null) {
            error = this.error_keystore != 0 ? this.error_keystore : 63;
            return error;
        }
        try {
            String elemento = "";
            Enumeration<String> listaCont = this.repositorio.aliases();
            while (listaCont.hasMoreElements()) {
                elemento = listaCont.nextElement();
                listaElementos.addElement(elemento);
            }
        }
        catch (KeyStoreException kse) {
            error = 12;
            return 12;
        }
        catch (NullPointerException npe) {
            error = 6;
            return 6;
        }
        return error;
    }

    private ByteArrayOutputStream getAuthorityKeyIdentifier(X509Certificate cert) {
        AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean encontrado = false;
        try {
            aki = (AuthorityKeyIdentifier)cert.getExtension(AuthorityKeyIdentifier.oid);
            if (aki != null) {
                SubjectKeyIdentifier ski = new SubjectKeyIdentifier(aki.getKeyIdentifier());
                ByteArrayInputStream bais = new ByteArrayInputStream(ski.toString().getBytes("ISO8859_1"));
                StreamCopier sc = new StreamCopier((InputStream)bais, (OutputStream)baos);
                sc.copyStream();
                encontrado = true;
                bais.close();
            }
            baos.close();
        }
        catch (X509ExtensionInitException ei) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
        if (encontrado) {
            return baos;
        }
        return null;
    }

    private ByteArrayOutputStream getAuthorityKeyIdentifierCRL(X509CRL cert) {
        AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean encontrado = false;
        try {
            aki = (AuthorityKeyIdentifier)cert.getExtension(AuthorityKeyIdentifier.oid);
            if (aki != null) {
                SubjectKeyIdentifier ski = new SubjectKeyIdentifier(aki.getKeyIdentifier());
                ByteArrayInputStream bais = new ByteArrayInputStream(ski.toString().getBytes("ISO8859_1"));
                StreamCopier sc = new StreamCopier((InputStream)bais, (OutputStream)baos);
                sc.copyStream();
                encontrado = true;
                bais.close();
            }
            baos.close();
        }
        catch (X509ExtensionInitException ei) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
        if (encontrado) {
            return baos;
        }
        return null;
    }

    private ByteArrayOutputStream getSubjectKeyIdentifier(X509Certificate cert) {
        SubjectKeyIdentifier ski = new SubjectKeyIdentifier();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean encontrado = false;
        try {
            ski = (SubjectKeyIdentifier)cert.getExtension(SubjectKeyIdentifier.oid);
            if (ski != null) {
                ByteArrayInputStream bais = new ByteArrayInputStream(ski.toString().getBytes("ISO8859_1"));
                StreamCopier sc = new StreamCopier((InputStream)bais, (OutputStream)baos);
                sc.copyStream();
                encontrado = true;
                bais.close();
            }
            baos.close();
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (encontrado) {
            return baos;
        }
        return null;
    }

    public boolean existKeyStore() {
        boolean existe = false;
        File ficheroks = new File(this.pathContenedorSeguro + "jce.keystore");
        existe = ficheroks.exists();
        return existe;
    }

    public static String cogerFecha() {
        Calendar c = Calendar.getInstance();
        Date fecha = c.getTime();
        SimpleDateFormat df = new SimpleDateFormat("[HH:mm:ss:SSS] ");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        String time = df.format(fecha);
        return time;
    }

    public void setResponder(String urlOCSP) {
        this.urlOCSP = urlOCSP;
    }

    public void deleteResponder() {
        this.urlOCSP = "";
    }

    public int setResponderTSA(String path, String pass) {
        ByteArrayOutputStream uri;
        GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(path, pass);
        int error = cs.getURLTSA(uri = new ByteArrayOutputStream());
        if (error == 0) {
            try {
                String tempUri = uri.toString("ISO8859_1");
                this.urlOCSP = tempUri.indexOf("tsades") != -1 ? this.urlOCSPDes : this.urlOCSPProd;
            }
            catch (IOException ioe) {
                error = 1024;
                return 1024;
            }
            error = 0;
            return 0;
        }
        return error;
    }

    private boolean isOCSP(byte[] ocspCert) {
        boolean ocspSigning;
        block4: {
            ocspSigning = false;
            try {
                X509Certificate cert = new X509Certificate(ocspCert);
                ExtendedKeyUsage eku = (ExtendedKeyUsage)cert.getExtension(ExtendedKeyUsage.oid);
                if (eku == null) break block4;
                ObjectID[] purposes = eku.getKeyPurposeIDs();
                for (int i = 0; i < purposes.length; ++i) {
                    if (!purposes[i].equals((Object)ExtendedKeyUsage.ocspSigning)) continue;
                    ocspSigning = true;
                    break;
                }
            }
            catch (CertificateException e) {
                return false;
            }
            catch (X509ExtensionInitException e) {
                return false;
            }
        }
        return ocspSigning;
    }
}

