/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.firmacifradodatos;

import com.izenpe.autenticacionfuerte.AutenticacionFuerte;
import com.izenpe.autenticacionfuerte.CtesAutenticacion;
import com.izenpe.gestioncontenedorseguro.GestionContenedorSeguro;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.pkcs.pkcs7.RecipientInfo;
import iaik.pkcs.pkcs7.SignedAndEnvelopedDataStream;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.security.provider.IAIK;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.util.Vector;

public class FirmaCifradoDatos {
    public FirmaCifradoDatos() {
        IAIK iaik = new IAIK();
        IAIK.addAsJDK14Provider();
        IAIK.addAsProvider((boolean)false);
    }

    public int encrypAndSignData(String issuerIn, String serialIn, AlgorithmID aFirma, AlgorithmID aDatos, byte[] certIn, byte[] dataIn, String path, String pass, ByteArrayOutputStream p7) {
        int error = 0;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(dataIn);
            SignedAndEnvelopedDataStream signedandenvelopeddata = new SignedAndEnvelopedDataStream((InputStream)is, aDatos);
            signedandenvelopeddata.setBlockSize(2048);
            X509Certificate cert = new X509Certificate(certIn);
            if (this.canEncrypt(cert)) {
                GestionContenedorSeguro contenedor = GestionContenedorSeguro.getInstance(path, pass);
                Vector listacerts = new Vector();
                PrivateKey pKeyIn = contenedor.getPrivateKeyFromKeyStore(issuerIn, serialIn);
                if (pKeyIn != null) {
                    ByteArrayOutputStream aux = new ByteArrayOutputStream();
                    error = contenedor.getCertCS(issuerIn, serialIn, aux);
                    if (error == 0) {
                        X509Certificate certF = new X509Certificate(aux.toByteArray());
                        if (!this.canSign(certF)) {
                            error = 613;
                            return 613;
                        }
                        Vector chain = new Vector();
                        error = contenedor.getCertificateChain(certF, chain);
                        if (error == 0) {
                            Object[] cadenaCert1 = new X509Certificate[chain.size()];
                            chain.copyInto(cadenaCert1);
                            X509Certificate[] last = new X509Certificate[cadenaCert1.length - 1];
                            for (int z = 0; z < last.length; ++z) {
                                last[z] = cadenaCert1[z];
                            }
                            signedandenvelopeddata.setCertificates(last);
                            IssuerAndSerialNumber issuer = new IssuerAndSerialNumber((java.security.cert.X509Certificate)certF);
                            SignerInfo signerinfo = new SignerInfo(issuer, aFirma, pKeyIn);
                            signedandenvelopeddata.addSignerInfo(signerinfo);
                            RecipientInfo recipient = new RecipientInfo((java.security.cert.X509Certificate)cert, AlgorithmID.rsaEncryption);
                            signedandenvelopeddata.addRecipientInfo(recipient);
                            signedandenvelopeddata.writeTo((OutputStream)p7, signedandenvelopeddata.getBlockSize());
                        } else {
                            error = 611;
                        }
                    }
                    aux.close();
                } else {
                    error = 344;
                }
            } else {
                error = 606;
                return 606;
            }
            is.close();
            p7.close();
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 601;
        }
        catch (CertificateException ce) {
            error = 602;
        }
        catch (IOException ioe) {
            error = 607;
        }
        return error;
    }

    public int verifyEncrypAndSign(byte[] p7, String pathIn, String passIn, ByteArrayOutputStream dataOut, ByteArrayOutputStream certOut) {
        int error = 0;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(p7);
            SignedAndEnvelopedDataStream signedandenvelopeddata = new SignedAndEnvelopedDataStream((InputStream)is);
            int recipientInfoIndex = 0;
            RecipientInfo[] recipients = signedandenvelopeddata.getRecipientInfos();
            IssuerAndSerialNumber iasn = recipients[0].getIssuerAndSerialNumber();
            String issuer = iasn.getIssuer().toString();
            String sn = iasn.getSerialNumber().toString();
            PrivateKey pk = null;
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathIn, passIn);
            pk = cs.getPrivateKeyFromKeyStore(issuer, sn);
            if (pk != null) {
                int r;
                signedandenvelopeddata.setupCipher(pk, recipientInfoIndex);
                InputStream bisTemp = signedandenvelopeddata.getInputStream();
                byte[] buf = new byte[1024];
                while ((r = bisTemp.read(buf)) > 0) {
                    dataOut.write(buf, 0, r);
                }
                bisTemp.close();
                SignerInfo[] signer_infos = signedandenvelopeddata.getSignerInfos();
                for (int i = 0; i < signer_infos.length; ++i) {
                    X509Certificate cert = signedandenvelopeddata.verify(i);
                    if (!this.canSign(cert)) {
                        error = 613;
                        return 613;
                    }
                    Vector salida = new Vector();
                    error = cs.getCertificateChain(cert, salida);
                    if (error != 0) {
                        return error;
                    }
                    Object[] cadena = new X509Certificate[salida.size()];
                    salida.copyInto(cadena);
                    error = cs.comprobar((X509Certificate[])cadena);
                    if (error == 0) continue;
                    return error;
                }
            } else {
                error = 604;
            }
            dataOut.close();
            certOut.close();
            is.close();
        }
        catch (SignatureException se) {
            se.printStackTrace();
            error = 605;
            return 605;
        }
        catch (PKCSParsingException pkcspe) {
            error = 609;
            return 609;
        }
        catch (PKCSException pkcse) {
            error = 610;
            return 610;
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 601;
            return 601;
        }
        catch (InvalidKeyException ike) {
            error = 608;
            return 608;
        }
        catch (IOException ioe) {
            error = 607;
            return 607;
        }
        return error;
    }

    private boolean canSign(X509Certificate cert) {
        boolean digitalSignature = false;
        try {
            boolean[] b = cert.getKeyUsage();
            ByteArrayOutputStream politicaOID = new ByteArrayOutputStream();
            ByteArrayOutputStream userNotice = new ByteArrayOutputStream();
            AutenticacionFuerte af = new AutenticacionFuerte();
            int error = af.extractPolicy(cert.getEncoded(), politicaOID, userNotice);
            String politica = politicaOID.toString("ISO8859_1");
            if (error == 0) {
                digitalSignature = politica.equals(CtesAutenticacion.OID_POLITICA_eDNI_A) || politica.equals(CtesAutenticacion.OID_POLITICA_eDNI_F) ? b[1] : b[0];
            }
        }
        catch (CertificateException ce) {
            System.err.println(ce);
            return false;
        }
        catch (Exception e) {
            System.err.println(e);
            return false;
        }
        return digitalSignature;
    }

    private boolean canEncrypt(X509Certificate cert) {
        boolean can = false;
        boolean[] b = cert.getKeyUsage();
        if (b[3]) {
            can = true;
        }
        return can;
    }
}

