/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.firmaavanzada;

import com.izenpe.accesoocsp.AccesoOCSP;
import com.izenpe.autenticacionfuerte.AutenticacionFuerte;
import com.izenpe.autenticacionfuerte.CtesAutenticacion;
import com.izenpe.constanteserrores.ConstantesErrores;
import com.izenpe.gestioncontenedorseguro.GestionContenedorSeguro;
import com.izenpe.miscelanea.Miscelanea;
import com.izenpe.tsp.TSP;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Name;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.ContentInfoStream;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.pkcs.pkcs7.SignedDataStream;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.security.provider.IAIK;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Vector;

public class FirmaAvanzada {
    protected String urlOCSP = "";
    private String urlOCSPDes = "http://172.19.10.193:8094";
    private String urlOCSPProd = "http://ocsp.izenpe.com:8094";

    public FirmaAvanzada() {
        IAIK iaik = new IAIK();
        IAIK.addAsJDK14Provider();
        IAIK.addAsProvider((boolean)false);
    }

    public int generateESCSignDettached(byte[] p7In, byte[] dataIn, String pathCS, String passwordCS, Vector signerCertsOut, Vector certErrores, ByteArrayOutputStream responseTSTOut, Vector responseOCSPOut, ByteArrayOutputStream stampingDateOut) {
        int error = ConstantesErrores.OK;
        try {
            ByteArrayInputStream signedData = new ByteArrayInputStream(dataIn);
            ByteArrayInputStream baisP7 = new ByteArrayInputStream(p7In);
            AlgorithmID[] aids = new AlgorithmID[]{AlgorithmID.sha1, AlgorithmID.md2, AlgorithmID.md5};
            SignedDataStream p7entrada = new SignedDataStream((InputStream)signedData, aids);
            ContentInfoStream cis = new ContentInfoStream((InputStream)baisP7);
            InputStream dataIs = p7entrada.getInputStream();
            ByteArrayOutputStream baosData = new ByteArrayOutputStream();
            StreamCopier scData = new StreamCopier(dataIs, (OutputStream)baosData);
            scData.copyStream();
            p7entrada.decode(cis.getContentInputStream());
            SignerInfo[] signerInfos = p7entrada.getSignerInfos();
            ByteArrayOutputStream sn = new ByteArrayOutputStream();
            TSP tsp = new TSP();
            error = tsp.requestTSP(p7In, responseTSTOut, stampingDateOut, sn, pathCS, passwordCS);
            if (error != ConstantesErrores.OK) {
                return error;
            }
            X509Certificate certSigner = null;
            AccesoOCSP ao = new AccesoOCSP();
            ao.setResponder(this.urlOCSP);
            ByteArrayOutputStream responseOut = new ByteArrayOutputStream();
            ByteArrayOutputStream responseDateOut = new ByteArrayOutputStream();
            ByteArrayOutputStream responseValueOut = new ByteArrayOutputStream();
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, passwordCS);
            int errorC = ConstantesErrores.OK;
            for (int i = 0; i < signerInfos.length; ++i) {
                responseOut = new ByteArrayOutputStream();
                responseValueOut = new ByteArrayOutputStream();
                responseDateOut = new ByteArrayOutputStream();
                try {
                    certSigner = p7entrada.verify(i);
                    errorC = ao.requestOCSP(certSigner.toByteArray(), pathCS, passwordCS, responseOut, responseDateOut, responseValueOut);
                    if (errorC != 0 && responseOut.size() == 0) {
                        signerCertsOut.removeAllElements();
                        responseOCSPOut.removeAllElements();
                        certErrores.removeAllElements();
                        responseTSTOut.reset();
                        stampingDateOut.reset();
                        return errorC;
                    }
                    if (errorC == ConstantesErrores.OK) {
                        if (this.isDigitalSignature(certSigner.toByteArray())) {
                            Vector<X509Certificate> vChain = new Vector<X509Certificate>();
                            errorC = cs.getCertificateChain(certSigner, vChain);
                            if (errorC == 43) {
                                ByteArrayOutputStream baosRoot;
                                X509Certificate[] chain = this.getCertificateChain(p7entrada.getCertificates(), certSigner);
                                errorC = cs.getRoot(chain[chain.length - 1], baosRoot = new ByteArrayOutputStream());
                                if (errorC == ConstantesErrores.OK) {
                                    for (int j = 0; j < chain.length; ++j) {
                                        vChain.addElement(chain[j]);
                                    }
                                    X509Certificate certRoot = new X509Certificate(baosRoot.toByteArray());
                                    vChain.addElement(certRoot);
                                }
                                baosRoot.close();
                            }
                            if (vChain.size() != 0) {
                                Object[] chainPlusRoot = new X509Certificate[vChain.size()];
                                vChain.copyInto(chainPlusRoot);
                                errorC = this.comprobar((X509Certificate[])chainPlusRoot);
                                if (errorC == ConstantesErrores.OK) {
                                    X509Certificate[] chainSinUser = new X509Certificate[chainPlusRoot.length - 1];
                                    for (int k = 1; k < chainPlusRoot.length; ++k) {
                                        chainSinUser[k - 1] = chainPlusRoot[k];
                                    }
                                    errorC = cs.comprobar(chainSinUser);
                                    if (errorC == ConstantesErrores.OK) {
                                        if (!responseValueOut.toString("ISO8859_1").toUpperCase().equals("GOOD")) {
                                            errorC = ConstantesErrores.CERT_REV;
                                            error = ConstantesErrores.ERR_VERIFYINGSIGN;
                                        }
                                    } else {
                                        error = ConstantesErrores.ERR_VERIFYINGSIGN;
                                    }
                                } else {
                                    error = ConstantesErrores.ERR_VERIFYINGSIGN;
                                }
                            } else {
                                error = ConstantesErrores.ERR_VERIFYINGSIGN;
                            }
                        } else {
                            error = ConstantesErrores.ERR_VERIFYINGSIGN;
                            errorC = ConstantesErrores.NO_DIGITALSIGN;
                        }
                    } else {
                        error = ConstantesErrores.ERR_VERIFYINGSIGN;
                    }
                    signerCertsOut.addElement(certSigner);
                    responseOCSPOut.addElement(responseOut);
                }
                catch (SignatureException se) {
                    error = ConstantesErrores.ERR_VERIFYINGSIGN;
                    errorC = ConstantesErrores.SIGN_ERR;
                    IssuerAndSerialNumber ias = signerInfos[i].getIssuerAndSerialNumber();
                    Name is = ias.getIssuer();
                    BigInteger sn1 = ias.getSerialNumber();
                    X509Certificate[] certsP7 = p7entrada.getCertificates();
                    X509Certificate falled = this.getCertificate((Principal)is, sn1, certsP7);
                    int error2 = ao.requestOCSP(falled.getEncoded(), pathCS, passwordCS, responseOut, responseDateOut, responseValueOut);
                    if (error2 != 0) {
                        error = error2;
                    }
                    responseOCSPOut.addElement(responseOut);
                    signerCertsOut.addElement(falled);
                }
                certErrores.addElement(new Integer(errorC));
            }
            signedData.close();
            baisP7.close();
            baosData.close();
            responseOut.close();
            responseDateOut.close();
            responseValueOut.close();
        }
        catch (MalformedURLException murle) {
            murle.printStackTrace();
        }
        catch (IOException ioe) {
            error = ConstantesErrores.NO_ASN1_OBJECT;
        }
        catch (PKCSParsingException pkcspe) {
            error = ConstantesErrores.INCORRECT_P7;
        }
        catch (CertificateException ce) {
            ce.printStackTrace();
        }
        return error;
    }

    public int generateESCSignDettached(InputStream p7In, InputStream dataIn, String pathCS, String passwordCS, Vector signerCertsOut, Vector certErrores, OutputStream responseTSTOut, Vector responseOCSPOut, OutputStream stampingDateOut) {
        Miscelanea m = new Miscelanea();
        ByteArrayOutputStream responseTSTOut2 = new ByteArrayOutputStream();
        ByteArrayOutputStream stampingDateOut2 = new ByteArrayOutputStream();
        try {
            responseTSTOut.write(responseTSTOut2.toByteArray());
            stampingDateOut.write(stampingDateOut2.toByteArray());
        }
        catch (IOException npe) {
            npe.printStackTrace();
        }
        int error = this.generateESCSignDettached(m.inputStreamToBytes(p7In), m.inputStreamToBytes(dataIn), pathCS, passwordCS, signerCertsOut, certErrores, responseTSTOut2, responseOCSPOut, stampingDateOut2);
        return error;
    }

    public int generateESCSignDettached_NoVerify(byte[] p7In, byte[] dataIn, String pathCS, String passwordCS, Vector signerCertsOut, Vector certErrores, ByteArrayOutputStream responseTSTOut, Vector responseOCSPOut, ByteArrayOutputStream stampingDateOut) {
        int error = ConstantesErrores.OK;
        try {
            ByteArrayInputStream signedData = new ByteArrayInputStream(dataIn);
            ByteArrayInputStream baisP7 = new ByteArrayInputStream(p7In);
            AlgorithmID[] aids = new AlgorithmID[]{AlgorithmID.sha1, AlgorithmID.md2, AlgorithmID.md5};
            SignedDataStream p7entrada = new SignedDataStream((InputStream)signedData, aids);
            ContentInfoStream cis = new ContentInfoStream((InputStream)baisP7);
            InputStream dataIs = p7entrada.getInputStream();
            ByteArrayOutputStream baosData = new ByteArrayOutputStream();
            StreamCopier scData = new StreamCopier(dataIs, (OutputStream)baosData);
            scData.copyStream();
            p7entrada.decode(cis.getContentInputStream());
            SignerInfo[] signerInfos = p7entrada.getSignerInfos();
            ByteArrayOutputStream sn = new ByteArrayOutputStream();
            TSP tsp = new TSP();
            error = tsp.requestTSP_NoVerify(p7In, responseTSTOut, stampingDateOut, sn, pathCS, passwordCS);
            if (error != ConstantesErrores.OK) {
                return error;
            }
            X509Certificate certSigner = null;
            AccesoOCSP ao = new AccesoOCSP();
            ao.setResponder(this.urlOCSP);
            ByteArrayOutputStream responseOut = new ByteArrayOutputStream();
            ByteArrayOutputStream responseDateOut = new ByteArrayOutputStream();
            ByteArrayOutputStream responseValueOut = new ByteArrayOutputStream();
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, passwordCS);
            int errorC = ConstantesErrores.OK;
            for (int i = 0; i < signerInfos.length; ++i) {
                responseOut = new ByteArrayOutputStream();
                responseValueOut = new ByteArrayOutputStream();
                responseDateOut = new ByteArrayOutputStream();
                try {
                    certSigner = p7entrada.verify(i);
                    errorC = ao.requestOCSP_NoVerify(certSigner.toByteArray(), pathCS, passwordCS, responseOut, responseDateOut, responseValueOut);
                    if (errorC != 0 && responseOut.size() == 0) {
                        signerCertsOut.removeAllElements();
                        responseOCSPOut.removeAllElements();
                        certErrores.removeAllElements();
                        responseTSTOut.reset();
                        stampingDateOut.reset();
                        return errorC;
                    }
                    if (errorC == ConstantesErrores.OK) {
                        if (this.isDigitalSignature(certSigner.toByteArray())) {
                            Vector<X509Certificate> vChain = new Vector<X509Certificate>();
                            errorC = cs.getCertificateChain(certSigner, vChain);
                            if (errorC == 43) {
                                ByteArrayOutputStream baosRoot;
                                X509Certificate[] chain = this.getCertificateChain(p7entrada.getCertificates(), certSigner);
                                errorC = cs.getRoot(chain[chain.length - 1], baosRoot = new ByteArrayOutputStream());
                                if (errorC == ConstantesErrores.OK) {
                                    for (int j = 0; j < chain.length; ++j) {
                                        vChain.addElement(chain[j]);
                                    }
                                    X509Certificate certRoot = new X509Certificate(baosRoot.toByteArray());
                                    vChain.addElement(certRoot);
                                }
                                baosRoot.close();
                            }
                            if (vChain.size() != 0) {
                                Object[] chainPlusRoot = new X509Certificate[vChain.size()];
                                vChain.copyInto(chainPlusRoot);
                                errorC = this.comprobar((X509Certificate[])chainPlusRoot);
                                if (errorC == ConstantesErrores.OK) {
                                    X509Certificate[] chainSinUser = new X509Certificate[chainPlusRoot.length - 1];
                                    for (int k = 1; k < chainPlusRoot.length; ++k) {
                                        chainSinUser[k - 1] = chainPlusRoot[k];
                                    }
                                    errorC = cs.comprobar(chainSinUser);
                                    if (errorC == ConstantesErrores.OK) {
                                        if (!responseValueOut.toString("ISO8859_1").toUpperCase().equals("GOOD")) {
                                            errorC = ConstantesErrores.CERT_REV;
                                            error = ConstantesErrores.ERR_VERIFYINGSIGN;
                                        }
                                    } else {
                                        error = ConstantesErrores.ERR_VERIFYINGSIGN;
                                    }
                                } else {
                                    error = ConstantesErrores.ERR_VERIFYINGSIGN;
                                }
                            } else {
                                error = ConstantesErrores.ERR_VERIFYINGSIGN;
                            }
                        } else {
                            error = ConstantesErrores.ERR_VERIFYINGSIGN;
                            errorC = ConstantesErrores.NO_DIGITALSIGN;
                        }
                    } else {
                        error = ConstantesErrores.ERR_VERIFYINGSIGN;
                    }
                    signerCertsOut.addElement(certSigner);
                    responseOCSPOut.addElement(responseOut);
                }
                catch (SignatureException se) {
                    error = ConstantesErrores.ERR_VERIFYINGSIGN;
                    errorC = ConstantesErrores.SIGN_ERR;
                    IssuerAndSerialNumber ias = signerInfos[i].getIssuerAndSerialNumber();
                    Name is = ias.getIssuer();
                    BigInteger sn1 = ias.getSerialNumber();
                    X509Certificate[] certsP7 = p7entrada.getCertificates();
                    X509Certificate falled = this.getCertificate((Principal)is, sn1, certsP7);
                    int error2 = ao.requestOCSP(falled.getEncoded(), pathCS, passwordCS, responseOut, responseDateOut, responseValueOut);
                    if (error2 != 0) {
                        error = error2;
                    }
                    responseOCSPOut.addElement(responseOut);
                    signerCertsOut.addElement(falled);
                }
                certErrores.addElement(new Integer(errorC));
            }
            signedData.close();
            baisP7.close();
            baosData.close();
            responseOut.close();
            responseDateOut.close();
            responseValueOut.close();
        }
        catch (MalformedURLException murle) {
            murle.printStackTrace();
        }
        catch (IOException ioe) {
            error = ConstantesErrores.NO_ASN1_OBJECT;
        }
        catch (PKCSParsingException pkcspe) {
            error = ConstantesErrores.INCORRECT_P7;
        }
        catch (CertificateException ce) {
            ce.printStackTrace();
        }
        return error;
    }

    public int generateESCSignDettached_NoVerify(InputStream p7In, InputStream dataIn, String pathCS, String passwordCS, Vector signerCertsOut, Vector certErrores, OutputStream responseTSTOut, Vector responseOCSPOut, OutputStream stampingDateOut) {
        Miscelanea m = new Miscelanea();
        ByteArrayOutputStream responseTSTOut2 = new ByteArrayOutputStream();
        ByteArrayOutputStream stampingDateOut2 = new ByteArrayOutputStream();
        try {
            responseTSTOut.write(responseTSTOut2.toByteArray());
            stampingDateOut.write(stampingDateOut2.toByteArray());
        }
        catch (IOException npe) {
            npe.printStackTrace();
        }
        int error = this.generateESCSignDettached_NoVerify(m.inputStreamToBytes(p7In), m.inputStreamToBytes(dataIn), pathCS, passwordCS, signerCertsOut, certErrores, responseTSTOut2, responseOCSPOut, stampingDateOut2);
        return error;
    }

    public int generateESCSignAttached(byte[] p7In, String pathCS, String passwordCS, ByteArrayOutputStream dataOut, Vector signerCertsOut, Vector certErrores, ByteArrayOutputStream responseTSTOut, Vector responseOCSPOut, ByteArrayOutputStream stampingDateOut) {
        int error = ConstantesErrores.OK;
        try {
            ByteArrayInputStream baisP7 = new ByteArrayInputStream(p7In);
            ContentInfoStream cis = new ContentInfoStream((InputStream)baisP7);
            SignedDataStream p7entrada = (SignedDataStream)cis.getContent();
            InputStream dataIs = p7entrada.getInputStream();
            StreamCopier scData = new StreamCopier(dataIs, (OutputStream)dataOut);
            scData.copyStream();
            SignerInfo[] signerInfos = p7entrada.getSignerInfos();
            ByteArrayOutputStream sn = new ByteArrayOutputStream();
            TSP tsp = new TSP();
            error = tsp.requestTSP(p7In, responseTSTOut, stampingDateOut, sn, pathCS, passwordCS);
            if (error != ConstantesErrores.OK) {
                return error;
            }
            X509Certificate certSigner = null;
            AccesoOCSP ao = new AccesoOCSP();
            ao.setResponder(this.urlOCSP);
            ByteArrayOutputStream responseOut = new ByteArrayOutputStream();
            ByteArrayOutputStream responseValueOut = new ByteArrayOutputStream();
            ByteArrayOutputStream responseDateOut = new ByteArrayOutputStream();
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, passwordCS);
            int errorC = ConstantesErrores.OK;
            for (int i = 0; i < signerInfos.length; ++i) {
                responseOut = new ByteArrayOutputStream();
                responseValueOut = new ByteArrayOutputStream();
                responseDateOut = new ByteArrayOutputStream();
                try {
                    certSigner = p7entrada.verify(i);
                    errorC = ao.requestOCSP(certSigner.toByteArray(), pathCS, passwordCS, responseOut, responseDateOut, responseValueOut);
                    if (errorC != 0 && responseOut.size() == 0) {
                        signerCertsOut.removeAllElements();
                        responseOCSPOut.removeAllElements();
                        certErrores.removeAllElements();
                        responseTSTOut.reset();
                        stampingDateOut.reset();
                        return errorC;
                    }
                    if (errorC == ConstantesErrores.OK) {
                        if (this.isDigitalSignature(certSigner.toByteArray())) {
                            Vector<X509Certificate> vChain = new Vector<X509Certificate>();
                            errorC = cs.getCertificateChain(certSigner, vChain);
                            if (errorC == 43) {
                                ByteArrayOutputStream baosRoot;
                                X509Certificate[] chain = this.getCertificateChain(p7entrada.getCertificates(), certSigner);
                                errorC = cs.getRoot(chain[chain.length - 1], baosRoot = new ByteArrayOutputStream());
                                if (errorC == ConstantesErrores.OK) {
                                    for (int j = 0; j < chain.length; ++j) {
                                        vChain.addElement(chain[j]);
                                    }
                                    X509Certificate certRoot = new X509Certificate(baosRoot.toByteArray());
                                    vChain.addElement(certRoot);
                                }
                                baosRoot.close();
                            }
                            if (vChain.size() != 0) {
                                Object[] chainPlusRoot = new X509Certificate[vChain.size()];
                                vChain.copyInto(chainPlusRoot);
                                errorC = this.comprobar((X509Certificate[])chainPlusRoot);
                                if (errorC == ConstantesErrores.OK) {
                                    X509Certificate[] chainSinUser = new X509Certificate[chainPlusRoot.length - 1];
                                    for (int k = 1; k < chainPlusRoot.length; ++k) {
                                        chainSinUser[k - 1] = chainPlusRoot[k];
                                    }
                                    errorC = cs.comprobar(chainSinUser);
                                    if (errorC == ConstantesErrores.OK) {
                                        if (!responseValueOut.toString("ISO8859_1").toUpperCase().equals("GOOD")) {
                                            errorC = ConstantesErrores.CERT_REV;
                                            error = ConstantesErrores.ERR_VERIFYINGSIGN;
                                        }
                                    } else {
                                        error = ConstantesErrores.ERR_VERIFYINGSIGN;
                                    }
                                } else {
                                    error = ConstantesErrores.ERR_VERIFYINGSIGN;
                                }
                            } else {
                                error = ConstantesErrores.ERR_VERIFYINGSIGN;
                                errorC = 43;
                            }
                        } else {
                            error = ConstantesErrores.ERR_VERIFYINGSIGN;
                            errorC = ConstantesErrores.NO_DIGITALSIGN;
                        }
                    } else {
                        error = ConstantesErrores.ERR_VERIFYINGSIGN;
                    }
                    signerCertsOut.addElement(certSigner);
                    responseOCSPOut.addElement(responseOut);
                }
                catch (SignatureException se) {
                    errorC = ConstantesErrores.SIGN_ERR;
                    error = ConstantesErrores.ERR_VERIFYINGSIGN;
                    IssuerAndSerialNumber ias = signerInfos[i].getIssuerAndSerialNumber();
                    Name is = ias.getIssuer();
                    BigInteger sn1 = ias.getSerialNumber();
                    X509Certificate[] certsP7 = p7entrada.getCertificates();
                    X509Certificate falled = this.getCertificate((Principal)is, sn1, certsP7);
                    int error2 = ao.requestOCSP(falled.getEncoded(), pathCS, passwordCS, responseOut, responseDateOut, responseValueOut);
                    if (error2 != 0) {
                        error = error2;
                    }
                    responseOCSPOut.addElement(responseOut);
                    signerCertsOut.addElement(falled);
                }
                certErrores.addElement(new Integer(errorC));
            }
            baisP7.close();
            dataIs.close();
            sn.close();
            responseOut.close();
            responseValueOut.close();
            responseDateOut.close();
        }
        catch (MalformedURLException murle) {
            murle.printStackTrace();
        }
        catch (IOException ioe) {
            error = ConstantesErrores.NO_ASN1_OBJECT;
        }
        catch (PKCSParsingException pkcspe) {
            error = ConstantesErrores.INCORRECT_P7;
        }
        catch (CertificateException ce) {
            ce.printStackTrace();
        }
        return error;
    }

    public int generateESCSignAttached(InputStream p7In, String pathCS, String passwordCS, OutputStream dataOut, Vector signerCertsOut, Vector certErrores, OutputStream responseTSTOut, Vector responseOCSPOut, OutputStream stampingDateOut) {
        int error = ConstantesErrores.OK;
        try {
            ContentInfoStream cis = new ContentInfoStream(p7In);
            SignedDataStream p7entrada = (SignedDataStream)cis.getContent();
            InputStream dataIs = p7entrada.getInputStream();
            StreamCopier scData = new StreamCopier(dataIs, dataOut);
            scData.copyStream();
            SignerInfo[] signerInfos = p7entrada.getSignerInfos();
            ByteArrayOutputStream sn = new ByteArrayOutputStream();
            TSP tsp = new TSP();
            error = tsp.requestTSP(p7In, responseTSTOut, stampingDateOut, (OutputStream)sn, pathCS, passwordCS);
            if (error != ConstantesErrores.OK) {
                return error;
            }
            X509Certificate certSigner = null;
            AccesoOCSP ao = new AccesoOCSP();
            ao.setResponder(this.urlOCSP);
            ByteArrayOutputStream responseOut = new ByteArrayOutputStream();
            ByteArrayOutputStream responseValueOut = new ByteArrayOutputStream();
            ByteArrayOutputStream responseDateOut = new ByteArrayOutputStream();
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, passwordCS);
            int errorC = ConstantesErrores.OK;
            for (int i = 0; i < signerInfos.length; ++i) {
                responseOut = new ByteArrayOutputStream();
                responseValueOut = new ByteArrayOutputStream();
                responseDateOut = new ByteArrayOutputStream();
                try {
                    certSigner = p7entrada.verify(i);
                    errorC = ao.requestOCSP(certSigner.toByteArray(), pathCS, passwordCS, responseOut, responseDateOut, responseValueOut);
                    if (errorC != 0 && responseOut.size() == 0) {
                        signerCertsOut.removeAllElements();
                        responseOCSPOut.removeAllElements();
                        certErrores.removeAllElements();
                        return errorC;
                    }
                    if (errorC == ConstantesErrores.OK) {
                        if (this.isDigitalSignature(certSigner.toByteArray())) {
                            Vector<X509Certificate> vChain = new Vector<X509Certificate>();
                            errorC = cs.getCertificateChain(certSigner, vChain);
                            if (errorC == 43) {
                                ByteArrayOutputStream baosRoot;
                                X509Certificate[] chain = this.getCertificateChain(p7entrada.getCertificates(), certSigner);
                                errorC = cs.getRoot(chain[chain.length - 1], baosRoot = new ByteArrayOutputStream());
                                if (errorC == ConstantesErrores.OK) {
                                    for (int j = 0; j < chain.length; ++j) {
                                        vChain.addElement(chain[j]);
                                    }
                                    X509Certificate certRoot = new X509Certificate(baosRoot.toByteArray());
                                    vChain.addElement(certRoot);
                                }
                                baosRoot.close();
                            }
                            if (vChain.size() != 0) {
                                Object[] chainPlusRoot = new X509Certificate[vChain.size()];
                                vChain.copyInto(chainPlusRoot);
                                errorC = this.comprobar((X509Certificate[])chainPlusRoot);
                                if (errorC == ConstantesErrores.OK) {
                                    X509Certificate[] chainSinUser = new X509Certificate[chainPlusRoot.length - 1];
                                    for (int k = 1; k < chainPlusRoot.length; ++k) {
                                        chainSinUser[k - 1] = chainPlusRoot[k];
                                    }
                                    errorC = cs.comprobar(chainSinUser);
                                    if (errorC == ConstantesErrores.OK) {
                                        if (!responseValueOut.toString("ISO8859_1").toUpperCase().equals("GOOD")) {
                                            errorC = ConstantesErrores.CERT_REV;
                                            error = ConstantesErrores.ERR_VERIFYINGSIGN;
                                        }
                                    } else {
                                        error = ConstantesErrores.ERR_VERIFYINGSIGN;
                                    }
                                } else {
                                    error = ConstantesErrores.ERR_VERIFYINGSIGN;
                                }
                            } else {
                                error = ConstantesErrores.ERR_VERIFYINGSIGN;
                                errorC = 43;
                            }
                        } else {
                            error = ConstantesErrores.ERR_VERIFYINGSIGN;
                            errorC = ConstantesErrores.NO_DIGITALSIGN;
                        }
                    } else {
                        error = ConstantesErrores.ERR_VERIFYINGSIGN;
                    }
                    signerCertsOut.addElement(certSigner);
                    responseOCSPOut.addElement(responseOut);
                }
                catch (SignatureException se) {
                    errorC = ConstantesErrores.SIGN_ERR;
                    error = ConstantesErrores.ERR_VERIFYINGSIGN;
                    IssuerAndSerialNumber ias = signerInfos[i].getIssuerAndSerialNumber();
                    Name is = ias.getIssuer();
                    BigInteger sn1 = ias.getSerialNumber();
                    X509Certificate[] certsP7 = p7entrada.getCertificates();
                    X509Certificate falled = this.getCertificate((Principal)is, sn1, certsP7);
                    int error2 = ao.requestOCSP(falled.getEncoded(), pathCS, passwordCS, responseOut, responseDateOut, responseValueOut);
                    if (error2 != 0) {
                        error = error2;
                    }
                    responseOCSPOut.addElement(responseOut);
                    signerCertsOut.addElement(falled);
                }
                certErrores.addElement(new Integer(errorC));
            }
            dataIs.close();
            sn.close();
            responseOut.close();
            responseValueOut.close();
            responseDateOut.close();
        }
        catch (MalformedURLException murle) {
            murle.printStackTrace();
        }
        catch (IOException ioe) {
            error = ConstantesErrores.NO_ASN1_OBJECT;
        }
        catch (PKCSParsingException pkcspe) {
            error = ConstantesErrores.INCORRECT_P7;
        }
        catch (CertificateException ce) {
            ce.printStackTrace();
        }
        return error;
    }

    public int generateESCSignAttached_NoVerify(byte[] p7In, String pathCS, String passwordCS, ByteArrayOutputStream dataOut, Vector signerCertsOut, Vector certErrores, ByteArrayOutputStream responseTSTOut, Vector responseOCSPOut, ByteArrayOutputStream stampingDateOut) {
        int error = ConstantesErrores.OK;
        try {
            ByteArrayInputStream baisP7 = new ByteArrayInputStream(p7In);
            ContentInfoStream cis = new ContentInfoStream((InputStream)baisP7);
            SignedDataStream p7entrada = (SignedDataStream)cis.getContent();
            InputStream dataIs = p7entrada.getInputStream();
            StreamCopier scData = new StreamCopier(dataIs, (OutputStream)dataOut);
            scData.copyStream();
            SignerInfo[] signerInfos = p7entrada.getSignerInfos();
            ByteArrayOutputStream sn = new ByteArrayOutputStream();
            TSP tsp = new TSP();
            error = tsp.requestTSP_NoVerify(p7In, responseTSTOut, stampingDateOut, sn, pathCS, passwordCS);
            if (error != ConstantesErrores.OK) {
                return error;
            }
            X509Certificate certSigner = null;
            AccesoOCSP ao = new AccesoOCSP();
            ao.setResponder(this.urlOCSP);
            ByteArrayOutputStream responseOut = new ByteArrayOutputStream();
            ByteArrayOutputStream responseValueOut = new ByteArrayOutputStream();
            ByteArrayOutputStream responseDateOut = new ByteArrayOutputStream();
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, passwordCS);
            int errorC = ConstantesErrores.OK;
            for (int i = 0; i < signerInfos.length; ++i) {
                responseOut = new ByteArrayOutputStream();
                responseValueOut = new ByteArrayOutputStream();
                responseDateOut = new ByteArrayOutputStream();
                try {
                    certSigner = p7entrada.verify(i);
                    errorC = ao.requestOCSP_NoVerify(certSigner.toByteArray(), pathCS, passwordCS, responseOut, responseDateOut, responseValueOut);
                    if (errorC != 0 && responseOut.size() == 0) {
                        signerCertsOut.removeAllElements();
                        responseOCSPOut.removeAllElements();
                        certErrores.removeAllElements();
                        responseTSTOut.reset();
                        stampingDateOut.reset();
                        return errorC;
                    }
                    if (errorC == ConstantesErrores.OK) {
                        if (this.isDigitalSignature(certSigner.toByteArray())) {
                            Vector<X509Certificate> vChain = new Vector<X509Certificate>();
                            errorC = cs.getCertificateChain(certSigner, vChain);
                            if (errorC == 43) {
                                ByteArrayOutputStream baosRoot;
                                X509Certificate[] chain = this.getCertificateChain(p7entrada.getCertificates(), certSigner);
                                errorC = cs.getRoot(chain[chain.length - 1], baosRoot = new ByteArrayOutputStream());
                                if (errorC == ConstantesErrores.OK) {
                                    for (int j = 0; j < chain.length; ++j) {
                                        vChain.addElement(chain[j]);
                                    }
                                    X509Certificate certRoot = new X509Certificate(baosRoot.toByteArray());
                                    vChain.addElement(certRoot);
                                }
                                baosRoot.close();
                            }
                            if (vChain.size() != 0) {
                                Object[] chainPlusRoot = new X509Certificate[vChain.size()];
                                vChain.copyInto(chainPlusRoot);
                                errorC = this.comprobar((X509Certificate[])chainPlusRoot);
                                if (errorC == ConstantesErrores.OK) {
                                    X509Certificate[] chainSinUser = new X509Certificate[chainPlusRoot.length - 1];
                                    for (int k = 1; k < chainPlusRoot.length; ++k) {
                                        chainSinUser[k - 1] = chainPlusRoot[k];
                                    }
                                    errorC = cs.comprobar(chainSinUser);
                                    if (errorC == ConstantesErrores.OK) {
                                        if (!responseValueOut.toString("ISO8859_1").toUpperCase().equals("GOOD")) {
                                            errorC = ConstantesErrores.CERT_REV;
                                            error = ConstantesErrores.ERR_VERIFYINGSIGN;
                                        }
                                    } else {
                                        error = ConstantesErrores.ERR_VERIFYINGSIGN;
                                    }
                                } else {
                                    error = ConstantesErrores.ERR_VERIFYINGSIGN;
                                }
                            } else {
                                error = ConstantesErrores.ERR_VERIFYINGSIGN;
                                errorC = 43;
                            }
                        } else {
                            error = ConstantesErrores.ERR_VERIFYINGSIGN;
                            errorC = ConstantesErrores.NO_DIGITALSIGN;
                        }
                    } else {
                        error = ConstantesErrores.ERR_VERIFYINGSIGN;
                    }
                    signerCertsOut.addElement(certSigner);
                    responseOCSPOut.addElement(responseOut);
                }
                catch (SignatureException se) {
                    errorC = ConstantesErrores.SIGN_ERR;
                    error = ConstantesErrores.ERR_VERIFYINGSIGN;
                    IssuerAndSerialNumber ias = signerInfos[i].getIssuerAndSerialNumber();
                    Name is = ias.getIssuer();
                    BigInteger sn1 = ias.getSerialNumber();
                    X509Certificate[] certsP7 = p7entrada.getCertificates();
                    X509Certificate falled = this.getCertificate((Principal)is, sn1, certsP7);
                    int error2 = ao.requestOCSP(falled.getEncoded(), pathCS, passwordCS, responseOut, responseDateOut, responseValueOut);
                    if (error2 != 0) {
                        error = error2;
                    }
                    responseOCSPOut.addElement(responseOut);
                    signerCertsOut.addElement(falled);
                }
                certErrores.addElement(new Integer(errorC));
            }
            baisP7.close();
            dataIs.close();
            sn.close();
            responseOut.close();
            responseValueOut.close();
            responseDateOut.close();
        }
        catch (MalformedURLException murle) {
            murle.printStackTrace();
        }
        catch (IOException ioe) {
            error = ConstantesErrores.NO_ASN1_OBJECT;
        }
        catch (PKCSParsingException pkcspe) {
            error = ConstantesErrores.INCORRECT_P7;
        }
        catch (CertificateException ce) {
            ce.printStackTrace();
        }
        return error;
    }

    public int generateESCSignAttached_NoVerify(InputStream p7In, String pathCS, String passwordCS, OutputStream dataOut, Vector signerCertsOut, Vector certErrores, OutputStream responseTSTOut, Vector responseOCSPOut, OutputStream stampingDateOut) {
        int error = ConstantesErrores.OK;
        try {
            ContentInfoStream cis = new ContentInfoStream(p7In);
            SignedDataStream p7entrada = (SignedDataStream)cis.getContent();
            InputStream dataIs = p7entrada.getInputStream();
            StreamCopier scData = new StreamCopier(dataIs, dataOut);
            scData.copyStream();
            SignerInfo[] signerInfos = p7entrada.getSignerInfos();
            ByteArrayOutputStream sn = new ByteArrayOutputStream();
            TSP tsp = new TSP();
            error = tsp.requestTSP_NoVerify(p7In, responseTSTOut, stampingDateOut, (OutputStream)sn, pathCS, passwordCS);
            if (error != ConstantesErrores.OK) {
                return error;
            }
            X509Certificate certSigner = null;
            AccesoOCSP ao = new AccesoOCSP();
            ao.setResponder(this.urlOCSP);
            ByteArrayOutputStream responseOut = new ByteArrayOutputStream();
            ByteArrayOutputStream responseValueOut = new ByteArrayOutputStream();
            ByteArrayOutputStream responseDateOut = new ByteArrayOutputStream();
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, passwordCS);
            int errorC = ConstantesErrores.OK;
            for (int i = 0; i < signerInfos.length; ++i) {
                responseOut = new ByteArrayOutputStream();
                responseValueOut = new ByteArrayOutputStream();
                responseDateOut = new ByteArrayOutputStream();
                try {
                    certSigner = p7entrada.verify(i);
                    errorC = ao.requestOCSP_NoVerify(certSigner.toByteArray(), pathCS, passwordCS, responseOut, responseDateOut, responseValueOut);
                    if (errorC != 0 && responseOut.size() == 0) {
                        signerCertsOut.removeAllElements();
                        responseOCSPOut.removeAllElements();
                        certErrores.removeAllElements();
                        return errorC;
                    }
                    if (errorC == ConstantesErrores.OK) {
                        if (this.isDigitalSignature(certSigner.toByteArray())) {
                            Vector<X509Certificate> vChain = new Vector<X509Certificate>();
                            errorC = cs.getCertificateChain(certSigner, vChain);
                            if (errorC == 43) {
                                ByteArrayOutputStream baosRoot;
                                X509Certificate[] chain = this.getCertificateChain(p7entrada.getCertificates(), certSigner);
                                errorC = cs.getRoot(chain[chain.length - 1], baosRoot = new ByteArrayOutputStream());
                                if (errorC == ConstantesErrores.OK) {
                                    for (int j = 0; j < chain.length; ++j) {
                                        vChain.addElement(chain[j]);
                                    }
                                    X509Certificate certRoot = new X509Certificate(baosRoot.toByteArray());
                                    vChain.addElement(certRoot);
                                }
                                baosRoot.close();
                            }
                            if (vChain.size() != 0) {
                                Object[] chainPlusRoot = new X509Certificate[vChain.size()];
                                vChain.copyInto(chainPlusRoot);
                                errorC = this.comprobar((X509Certificate[])chainPlusRoot);
                                if (errorC == ConstantesErrores.OK) {
                                    X509Certificate[] chainSinUser = new X509Certificate[chainPlusRoot.length - 1];
                                    for (int k = 1; k < chainPlusRoot.length; ++k) {
                                        chainSinUser[k - 1] = chainPlusRoot[k];
                                    }
                                    errorC = cs.comprobar(chainSinUser);
                                    if (errorC == ConstantesErrores.OK) {
                                        if (!responseValueOut.toString("ISO8859_1").toUpperCase().equals("GOOD")) {
                                            errorC = ConstantesErrores.CERT_REV;
                                            error = ConstantesErrores.ERR_VERIFYINGSIGN;
                                        }
                                    } else {
                                        error = ConstantesErrores.ERR_VERIFYINGSIGN;
                                    }
                                } else {
                                    error = ConstantesErrores.ERR_VERIFYINGSIGN;
                                }
                            } else {
                                error = ConstantesErrores.ERR_VERIFYINGSIGN;
                                errorC = 43;
                            }
                        } else {
                            error = ConstantesErrores.ERR_VERIFYINGSIGN;
                            errorC = ConstantesErrores.NO_DIGITALSIGN;
                        }
                    } else {
                        error = ConstantesErrores.ERR_VERIFYINGSIGN;
                    }
                    signerCertsOut.addElement(certSigner);
                    responseOCSPOut.addElement(responseOut);
                }
                catch (SignatureException se) {
                    errorC = ConstantesErrores.SIGN_ERR;
                    error = ConstantesErrores.ERR_VERIFYINGSIGN;
                    IssuerAndSerialNumber ias = signerInfos[i].getIssuerAndSerialNumber();
                    Name is = ias.getIssuer();
                    BigInteger sn1 = ias.getSerialNumber();
                    X509Certificate[] certsP7 = p7entrada.getCertificates();
                    X509Certificate falled = this.getCertificate((Principal)is, sn1, certsP7);
                    int error2 = ao.requestOCSP(falled.getEncoded(), pathCS, passwordCS, responseOut, responseDateOut, responseValueOut);
                    if (error2 != 0) {
                        error = error2;
                    }
                    responseOCSPOut.addElement(responseOut);
                    signerCertsOut.addElement(falled);
                }
                certErrores.addElement(new Integer(errorC));
            }
            dataIs.close();
        }
        catch (MalformedURLException murle) {
            murle.printStackTrace();
        }
        catch (IOException ioe) {
            error = ConstantesErrores.NO_ASN1_OBJECT;
        }
        catch (PKCSParsingException pkcspe) {
            error = ConstantesErrores.INCORRECT_P7;
        }
        catch (CertificateException ce) {
            ce.printStackTrace();
        }
        return error;
    }

    private X509Certificate[] getCertificateChain(X509Certificate[] cadenaIn, X509Certificate cert) {
        Vector<X509Certificate> v = new Vector<X509Certificate>();
        v.addElement(cert);
        try {
            int i = 0;
            while (i < cadenaIn.length) {
                X509Certificate certificado = new X509Certificate(cadenaIn[i].toByteArray());
                if (((Object)cert.getIssuerDN()).equals(certificado.getSubjectDN())) {
                    v.addElement(new X509Certificate(certificado.toByteArray()));
                    if (((Object)certificado.getSubjectDN()).equals(certificado.getIssuerDN())) {
                        v.removeElementAt(v.size() - 1);
                        break;
                    }
                    i = 0;
                    cert = new X509Certificate(certificado.toByteArray());
                    continue;
                }
                ++i;
            }
        }
        catch (CertificateException ce) {
            System.err.println(ce);
        }
        X509Certificate[] cadenaSalida = new X509Certificate[v.size()];
        for (int z = 0; z < v.size(); ++z) {
            cadenaSalida[z] = (X509Certificate)v.elementAt(z);
        }
        return cadenaSalida;
    }

    private X509Certificate getCertificate(Principal is, BigInteger sn, X509Certificate[] certP7) {
        boolean encontrado = false;
        X509Certificate salida = null;
        for (int i = 0; i < certP7.length && !encontrado; ++i) {
            salida = certP7[i];
            if (!((Object)salida.getIssuerDN()).equals(is) || !salida.getSerialNumber().equals(sn)) continue;
            encontrado = true;
        }
        if (encontrado) {
            return salida;
        }
        return null;
    }

    private boolean isDigitalSignature(byte[] certificado) {
        boolean digitalSignature = false;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            boolean[] b = cert.getKeyUsage();
            ByteArrayOutputStream politicaOID = new ByteArrayOutputStream();
            ByteArrayOutputStream userNotice = new ByteArrayOutputStream();
            AutenticacionFuerte af = new AutenticacionFuerte();
            int error = af.extractPolicy(certificado, politicaOID, userNotice);
            String politica = politicaOID.toString("ISO8859_1");
            if (error == 0) {
                digitalSignature = politica.equals(CtesAutenticacion.OID_POLITICA_eDNI_A) || politica.equals(CtesAutenticacion.OID_POLITICA_eDNI_F) ? b[1] : b[0];
            }
        }
        catch (CertificateException ce) {
            System.err.println(ce);
            return false;
        }
        catch (Exception e) {
            System.err.println(e);
            return false;
        }
        return digitalSignature;
    }

    private int comprobar(X509Certificate[] certChain) {
        int error = 0;
        for (int i = 0; i < 1; ++i) {
            try {
                certChain[i].checkValidity();
            }
            catch (CertificateExpiredException cee) {
                error = 32;
            }
            catch (CertificateNotYetValidException cnyve) {
                error = 33;
            }
            try {
                if (i < certChain.length - 1) {
                    certChain[i].verify(certChain[i + 1].getPublicKey());
                    continue;
                }
                certChain[i].verify();
                continue;
            }
            catch (CertificateException ce) {
                error = 28;
                return 28;
            }
            catch (NoSuchAlgorithmException nsae) {
                error = 27;
                return 27;
            }
            catch (InvalidKeyException ike) {
                error = 35;
                return 35;
            }
            catch (NoSuchProviderException nspe) {
                error = 25;
                return 25;
            }
            catch (SignatureException se) {
                error = 34;
                return 34;
            }
        }
        return error;
    }

    public void setResponder(String urlOCSP) {
        this.urlOCSP = urlOCSP;
    }

    public void deleteResponder() {
        this.urlOCSP = "";
    }

    public int setResponderTSA(String path, String pass) {
        ByteArrayOutputStream uri;
        GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(path, pass);
        int error = cs.getURLTSA(uri = new ByteArrayOutputStream());
        if (error == 0) {
            try {
                String tempUri = uri.toString("ISO8859_1");
                this.urlOCSP = tempUri.indexOf("tsades") != -1 ? this.urlOCSPDes : this.urlOCSPProd;
            }
            catch (IOException ioe) {
                error = 1024;
                return 1024;
            }
            error = 0;
            return 0;
        }
        return error;
    }
}

