/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.comprobarcertificados;

import com.izenpe.accesoocsp.AccesoOCSP;
import com.izenpe.gestioncontenedorseguro.GestionContenedorSeguro;
import iaik.pkcs.PKCS7CertList;
import iaik.pkcs.PKCSParsingException;
import iaik.security.provider.IAIK;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.AuthorityKeyIdentifier;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateException;
import java.util.Vector;

public class ComprobarCertificados {
    protected String urlOCSP = "";
    private String urlOCSPDes = "http://172.19.10.193:8094";
    private String urlOCSPProd = "http://ocsp.izenpe.com:8094";

    public ComprobarCertificados() {
        IAIK iaik = new IAIK();
        IAIK.addAsJDK14Provider();
        IAIK.addAsProvider((boolean)false);
    }

    public int verifyCertDER(byte[] certificado, String pathCS, String password) {
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            Vector vChain = new Vector();
            error = cs.getCertificateChain(cert, vChain);
            if (error != 0) {
                return error;
            }
            Object[] certChain = new X509Certificate[vChain.size()];
            vChain.copyInto(certChain);
            error = certChain != null ? cs.comprobar((X509Certificate[])certChain) : 106;
        }
        catch (CertificateException ce) {
            error = 108;
        }
        return error;
    }

    public int verifyCertDEROCSP(byte[] certificado, String pathCS, String password) {
        int error = 0;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            Vector vChain = new Vector();
            error = cs.getCertificateChain(cert, vChain);
            if (error != 0) {
                return error;
            }
            vChain.remove(0);
            Object[] certChain = new X509Certificate[vChain.size()];
            vChain.copyInto(certChain);
            error = certChain != null ? cs.comprobar((X509Certificate[])certChain) : 106;
            AccesoOCSP ao = new AccesoOCSP();
            ao.setResponder(this.urlOCSP);
            ByteArrayOutputStream responseOCSPOut = new ByteArrayOutputStream();
            ByteArrayOutputStream responseDateOut = new ByteArrayOutputStream();
            ByteArrayOutputStream responseValue = new ByteArrayOutputStream();
            error = ao.requestOCSP_NoVerify(certificado, pathCS, password, responseOCSPOut, responseDateOut, responseValue);
            if (error != 0) {
                return error;
            }
            if (!responseValue.toString("ISO8859_1").equalsIgnoreCase("good")) {
                error = 64;
                return 64;
            }
        }
        catch (CertificateException ce) {
            error = 108;
        }
        catch (UnsupportedEncodingException e) {
            error = 105;
            return 105;
        }
        return error;
    }

    public int verifyCertPKCS7(byte[] contentInfo, String pathCS, String password) {
        int error = 0;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(contentInfo);
            PKCS7CertList plist = new PKCS7CertList((InputStream)bais);
            X509Certificate[] x = plist.getCertificateList();
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, password);
            String alias = null;
            Vector<String> issuerBorrar = new Vector<String>();
            Vector<String> snBorrar = new Vector<String>();
            Vector issuers = new Vector();
            Vector serials = new Vector();
            cs.enumCertsCS(issuers, serials);
            for (int i = x.length - 1; i >= 0; --i) {
                ByteArrayOutputStream aliasBaos = new ByteArrayOutputStream();
                error = cs.getCertificateAlias(((Object)x[i].getIssuerDN()).toString(), x[i].getSerialNumber().toString(), aliasBaos);
                alias = aliasBaos.toString("ISO8859_1");
                if (alias.length() != 0) continue;
                BasicConstraints bc = (BasicConstraints)x[i].getExtension(BasicConstraints.oid);
                if (bc != null && !bc.ca()) {
                    error = cs.insertCertificate(x[i].toByteArray());
                    if (error != 0) continue;
                    issuerBorrar.addElement(((Object)x[i].getIssuerDN()).toString());
                    snBorrar.addElement(x[i].getSerialNumber().toString());
                    continue;
                }
                if (((Object)x[i].getIssuerDN()).equals(x[i].getSubjectDN()) || (error = cs.insertRootCertificate(x[i].toByteArray())) != 0) continue;
                issuerBorrar.addElement(((Object)x[i].getIssuerDN()).toString());
                snBorrar.addElement(x[i].getSerialNumber().toString());
            }
            Vector vChain = new Vector();
            error = cs.getCertificateChain(x[0], vChain);
            if (error != 0) {
                return error;
            }
            Object[] certChain = new X509Certificate[vChain.size()];
            vChain.copyInto(certChain);
            issuers = new Vector();
            serials = new Vector();
            cs.enumCertsCS(issuers, serials);
            error = certChain != null ? cs.comprobar((X509Certificate[])certChain) : 106;
            for (int j = 0; j < issuerBorrar.size(); ++j) {
                cs.removeCertCS((String)issuerBorrar.elementAt(j), (String)snBorrar.elementAt(j));
            }
            bais.close();
        }
        catch (IOException ioe) {
            error = 109;
        }
        catch (PKCSParsingException pe) {
            error = 107;
        }
        catch (X509ExtensionInitException ei) {
            ei.printStackTrace();
        }
        return error;
    }

    private ByteArrayOutputStream getAuthorityKeyIdentifier(X509Certificate cert) {
        AuthorityKeyIdentifier aki = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean encontrado = false;
        try {
            aki = (AuthorityKeyIdentifier)cert.getExtension(AuthorityKeyIdentifier.oid);
            if (aki != null) {
                SubjectKeyIdentifier ski = new SubjectKeyIdentifier(aki.getKeyIdentifier());
                ByteArrayInputStream bais = new ByteArrayInputStream(ski.toString().getBytes("ISO8859_1"));
                StreamCopier sc = new StreamCopier((InputStream)bais, (OutputStream)baos);
                sc.copyStream();
                encontrado = true;
            }
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (encontrado) {
            return baos;
        }
        return null;
    }

    private ByteArrayOutputStream getSubjectKeyIdentifier(X509Certificate cert) {
        SubjectKeyIdentifier ski = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean encontrado = false;
        try {
            ski = (SubjectKeyIdentifier)cert.getExtension(SubjectKeyIdentifier.oid);
            if (ski != null) {
                ByteArrayInputStream bais = new ByteArrayInputStream(ski.toString().getBytes("ISO8859_1"));
                StreamCopier sc = new StreamCopier((InputStream)bais, (OutputStream)baos);
                sc.copyStream();
                encontrado = true;
            }
        }
        catch (X509ExtensionInitException ei) {
            System.err.println((Object)ei);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (encontrado) {
            return baos;
        }
        return null;
    }

    public void setResponder(String urlOCSP) {
        this.urlOCSP = urlOCSP;
    }

    public void deleteResponder() {
        this.urlOCSP = "";
    }

    public int setResponderTSA(String path, String pass) {
        ByteArrayOutputStream uri;
        GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(path, pass);
        int error = cs.getURLTSA(uri = new ByteArrayOutputStream());
        if (error == 0) {
            try {
                String tempUri = uri.toString("ISO8859_1");
                this.urlOCSP = tempUri.indexOf("tsades") != -1 ? this.urlOCSPDes : this.urlOCSPProd;
            }
            catch (IOException ioe) {
                error = 1024;
                return 1024;
            }
            error = 0;
            return 0;
        }
        return error;
    }
}

