/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.cifradodatos;

import com.izenpe.gestioncontenedorseguro.GestionContenedorSeguro;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.EnvelopedData;
import iaik.pkcs.pkcs7.EnvelopedDataStream;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.pkcs.pkcs7.RecipientInfo;
import iaik.security.provider.IAIK;
import iaik.utils.StreamCopier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class CifradoDatos {
    public CifradoDatos() {
        IAIK iaik = new IAIK();
        IAIK.addAsJDK14Provider();
        IAIK.addAsProvider((boolean)false);
    }

    public int encryptingData(byte[] dataIn, byte[] certIn, AlgorithmID algoritmo, ByteArrayOutputStream p7, String path, String pass) {
        int error = 0;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(certIn);
            iaik.x509.X509Certificate x509cert = new iaik.x509.X509Certificate(certIn);
            GestionContenedorSeguro contenedor = GestionContenedorSeguro.getInstance(path, pass);
            if (!this.canEncypt(x509cert)) {
                error = 510;
                return 510;
            }
            EnvelopedData sobreDigital = new EnvelopedData(dataIn, algoritmo);
            RecipientInfo[] recipients = new RecipientInfo[]{new RecipientInfo((X509Certificate)x509cert, AlgorithmID.rsaEncryption)};
            sobreDigital.setRecipientInfos(recipients);
            p7.write(sobreDigital.getEncoded());
            bis.close();
            p7.close();
        }
        catch (IOException ioe) {
            error = 511;
            return 511;
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
            error = 504;
            return 504;
        }
        catch (PKCSException pe) {
            error = 505;
            return 505;
        }
        catch (CertificateException ce) {
            error = 506;
            return 506;
        }
        return error;
    }

    public int decryptingData(byte[] p7, ByteArrayOutputStream dataOut, String path, String pass) {
        int error = 0;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(p7);
            EnvelopedDataStream sobreDigital = new EnvelopedDataStream((InputStream)bis);
            RecipientInfo[] recipients = sobreDigital.getRecipientInfos();
            IssuerAndSerialNumber issn = recipients[0].getIssuerAndSerialNumber();
            GestionContenedorSeguro contenedor = GestionContenedorSeguro.getInstance(path, pass);
            PrivateKey p = contenedor.getPrivateKeyFromKeyStore(issn.getIssuer().toString(), issn.getSerialNumber().toString());
            if (p != null) {
                sobreDigital.setupCipher(p, 0);
                InputStream descripcion = sobreDigital.getInputStream();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                StreamCopier sc = new StreamCopier(descripcion, (OutputStream)dataOut);
                sc.copyStream();
                os.close();
                bis.close();
                dataOut.close();
                descripcion.close();
            } else {
                error = 507;
            }
        }
        catch (IOException ioe) {
            error = 511;
            return 511;
        }
        catch (PKCSParsingException ppe) {
            error = 508;
            return 508;
        }
        catch (NoSuchAlgorithmException nsae) {
            error = 504;
            return 504;
        }
        catch (InvalidKeyException ike) {
            error = 509;
            return 509;
        }
        catch (PKCSException pe) {
            error = 505;
            return 505;
        }
        return error;
    }

    private boolean canEncypt(iaik.x509.X509Certificate cert) {
        boolean can = false;
        boolean[] b = cert.getKeyUsage();
        if (b[3]) {
            can = true;
        }
        return can;
    }
}

