/*
 * Decompiled with CFR 0.152.
 */
package com.izenpe.accesoocsp;

import com.izenpe.AlgoritmosHash;
import com.izenpe.autenticacionfuerte.AutenticacionFuerte;
import com.izenpe.autenticacionfuerte.CtesAutenticacion;
import com.izenpe.constanteserrores.ConstantesErrores;
import com.izenpe.gestioncontenedorseguro.GestionContenedorSeguro;
import com.izenpe.miscelanea.Miscelanea;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.Name;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.ContentInfoStream;
import iaik.pkcs.pkcs7.SignedDataStream;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.security.provider.IAIK;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.ExtendedKeyUsage;
import iaik.x509.ocsp.BasicOCSPResponse;
import iaik.x509.ocsp.CertID;
import iaik.x509.ocsp.CertStatus;
import iaik.x509.ocsp.OCSPException;
import iaik.x509.ocsp.OCSPRequest;
import iaik.x509.ocsp.OCSPResponse;
import iaik.x509.ocsp.ReqCert;
import iaik.x509.ocsp.Request;
import iaik.x509.ocsp.RevokedInfo;
import iaik.x509.ocsp.SingleResponse;
import iaik.x509.ocsp.UnknownInfo;
import iaik.x509.ocsp.UnknownResponseException;
import iaik.x509.ocsp.net.HttpOCSPRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AccesoOCSP {
    protected String urlOCSP = "";
    private String urlOCSPDes = "http://172.19.10.193:8094";
    private String urlOCSPProd = "http://ocsp.izenpe.com:8094";

    public AccesoOCSP() {
        IAIK iaik = new IAIK();
        IAIK.addAsJDK14Provider();
        IAIK.addAsProvider((boolean)false);
    }

    public int requestOCSP(byte[] certIn, String pathCS, String passCS, ByteArrayOutputStream responseOCSPOut, ByteArrayOutputStream responseDateOut, ByteArrayOutputStream responseValueOut) {
        int error;
        block31: {
            error = ConstantesErrores.OK;
            try {
                GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, passCS);
                X509Certificate cert = new X509Certificate(certIn);
                Vector vChain = new Vector();
                error = cs.getCertIssuer(cert, vChain);
                if (error != ConstantesErrores.OK) {
                    return error;
                }
                X509Certificate caCert = (X509Certificate)vChain.elementAt(1);
                AlgoritmosHash ah = new AlgoritmosHash();
                ah.setAlgorithm("sha");
                CertID certID = new CertID(ah.getAlgorithm(), caCert, cert);
                ReqCert reqCert = new ReqCert(0, (Object)certID);
                Request request = new Request(reqCert);
                OCSPRequest ocspRequest = new OCSPRequest();
                ocspRequest.setRequestList(new Request[]{request});
                ByteArrayOutputStream servidorOCSP = new ByteArrayOutputStream();
                AutenticacionFuerte af = new AutenticacionFuerte();
                ByteArrayOutputStream politica = new ByteArrayOutputStream();
                ByteArrayOutputStream usernotice = new ByteArrayOutputStream();
                error = af.extractPolicy(certIn, politica, usernotice);
                OCSPResponse ocspResponse = null;
                if (error == 0 && politica.toString("ISO8859_1").trim().equals(CtesAutenticacion.OID_POLITICA_FNMT)) {
                    int salidaOcspResponse = this.requestOCSPWebService(cert, responseOCSPOut, responseDateOut, responseValueOut);
                    if (salidaOcspResponse != 0) {
                        return salidaOcspResponse;
                    }
                    break block31;
                }
                if (error != 0) {
                    error = 0;
                }
                if (this.urlOCSP == null || this.urlOCSP.equals("")) {
                    error = af.getAuthorityInfoAccessOCSP(certIn, servidorOCSP);
                    if (error != 0 || servidorOCSP.toString("ISO8859_1").equals("")) {
                        return error;
                    }
                } else {
                    servidorOCSP.write(this.urlOCSP.getBytes("ISO8859_1"));
                }
                if (error != ConstantesErrores.OK) {
                    return error;
                }
                HttpOCSPRequest httpOCSPRequest = new HttpOCSPRequest(new URL(servidorOCSP.toString("ISO8859_1")));
                httpOCSPRequest.postRequest(ocspRequest);
                ocspResponse = httpOCSPRequest.getOCSPResponse();
                BasicOCSPResponse basicResponse = (BasicOCSPResponse)ocspResponse.getResponse();
                if (ocspResponse.getResponse() == null) break block31;
                SingleResponse singleResponse = basicResponse.getSingleResponse(reqCert);
                ocspResponse.writeTo((OutputStream)responseOCSPOut);
                StreamCopier scDate = new StreamCopier((InputStream)new ByteArrayInputStream(basicResponse.getProducedAt().toString().getBytes("ISO8859_1")), (OutputStream)responseDateOut);
                scDate.copyStream();
                StreamCopier scStatus = new StreamCopier((InputStream)new ByteArrayInputStream(singleResponse.getCertStatus().getCertStatusName().getBytes("ISO8859_1")), (OutputStream)responseValueOut);
                scStatus.copyStream();
                X509Certificate[] tempTodoCerts = basicResponse.getCertificates();
                X509Certificate[] todoCerts = new X509Certificate[tempTodoCerts.length];
                for (int i = 0; i < tempTodoCerts.length; ++i) {
                    todoCerts[i] = tempTodoCerts[i];
                }
                X509Certificate ocspCert = todoCerts[0];
                basicResponse.verify(todoCerts[0].getPublicKey());
                ExtendedKeyUsage eku = (ExtendedKeyUsage)ocspCert.getExtension(ExtendedKeyUsage.oid);
                boolean ocspSigning = false;
                if (eku != null) {
                    ObjectID[] purposes = eku.getKeyPurposeIDs();
                    for (int i = 0; i < purposes.length; ++i) {
                        if (!purposes[i].equals((Object)ExtendedKeyUsage.ocspSigning)) continue;
                        ocspSigning = true;
                        break;
                    }
                }
                if (ocspSigning) {
                    Vector<X509Certificate> vChainOcsp = new Vector<X509Certificate>();
                    error = cs.getCertificateChain(ocspCert, vChainOcsp);
                    if (error != 0) {
                        vChainOcsp.addElement(ocspCert);
                        X509Certificate[] certsResponse = basicResponse.getCertificates();
                        if (certsResponse.length > 1) {
                            for (int j = 1; j < certsResponse.length; ++j) {
                                vChainOcsp.addElement(certsResponse[j]);
                            }
                        }
                        ByteArrayOutputStream ocspRaiz = new ByteArrayOutputStream();
                        error = cs.getRoot((X509Certificate)vChainOcsp.elementAt(vChainOcsp.size() - 1), ocspRaiz);
                        if (error != ConstantesErrores.OK) {
                            error = ConstantesErrores.NO_OCSPCHAIN;
                            return error;
                        }
                        vChainOcsp.addElement(new X509Certificate(ocspRaiz.toByteArray()));
                    }
                    Object[] chainOcsp = new X509Certificate[vChainOcsp.size()];
                    vChainOcsp.copyInto(chainOcsp);
                    error = cs.comprobar((X509Certificate[])chainOcsp);
                    if (error != ConstantesErrores.OK) {
                        if (error == 22) {
                            error = ConstantesErrores.NO_OCSP_CA_EN_KS;
                        }
                        if (error == 34) {
                            error = ConstantesErrores.FIRMA_CADENA_INC;
                        }
                        return error;
                    }
                    break block31;
                }
                error = ConstantesErrores.NO_OCSPSIGNING;
                return error;
            }
            catch (ConnectException coex) {
                error = ConstantesErrores.CONN_REFUSED;
                return error;
            }
            catch (NoRouteToHostException nrthe) {
                error = ConstantesErrores.CONN_REFUSED;
            }
            catch (CertificateException ce) {
                error = ConstantesErrores.CERT_ENTRADA_ERR;
            }
            catch (NoSuchAlgorithmException nsae) {
                error = ConstantesErrores.ERR_VERIFYING_OCSP_SIGN;
            }
            catch (X509ExtensionException ee) {
                error = ConstantesErrores.ERR_VERIFYING_OCSP_SIGN;
            }
            catch (MalformedURLException mue) {
                error = ConstantesErrores.URL_INCORRECTA;
            }
            catch (IOException ioe) {
                error = ConstantesErrores.RESPONSE_INCORRECTA;
            }
            catch (UnknownResponseException ure) {
                error = ConstantesErrores.RESPONSE_INCORRECTA;
            }
            catch (OCSPException oe) {
                error = ConstantesErrores.RESPONSE_INCORRECTA;
            }
            catch (InvalidKeyException ike) {
                error = ConstantesErrores.ERR_VERIFYING_OCSP_SIGN;
            }
            catch (SignatureException se) {
                error = ConstantesErrores.ERR_VERIFYING_OCSP_SIGN;
            }
        }
        return error;
    }

    public int signedRequestOCSP(byte[] certIn, String requestorIssuerIn, String requestorSnIn, String pathCS, String passCS, ByteArrayOutputStream responseOCSPOut, ByteArrayOutputStream responseDateOut, ByteArrayOutputStream responseValueOut) {
        int error;
        block34: {
            error = ConstantesErrores.OK;
            try {
                X509Certificate cert = new X509Certificate(certIn);
                GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, passCS);
                Vector vChain = new Vector();
                error = cs.getCertIssuer(cert, vChain);
                if (error != ConstantesErrores.OK) {
                    return error;
                }
                X509Certificate caCert = (X509Certificate)vChain.elementAt(1);
                PrivateKey requestorPK = cs.getPrivateKeyFromKeyStore(requestorIssuerIn, requestorSnIn);
                if (requestorPK == null) {
                    return ConstantesErrores.PK_NOENC;
                }
                ByteArrayOutputStream requestorCertAux = new ByteArrayOutputStream();
                error = cs.getCertCS(requestorIssuerIn, requestorSnIn, requestorCertAux);
                if (error != ConstantesErrores.OK) {
                    return error;
                }
                X509Certificate requestorCert = new X509Certificate(requestorCertAux.toByteArray());
                if (!this.isDigitalSignature(requestorCert.toByteArray())) {
                    error = ConstantesErrores.NO_FIRMADIGITAL;
                    return error;
                }
                Vector requestorVchain = new Vector();
                error = cs.getCertificateChain(requestorCert, requestorVchain);
                if (error != ConstantesErrores.OK) {
                    error = ConstantesErrores.NO_REQCHAIN;
                    return error;
                }
                Object[] requestorChain = new X509Certificate[requestorVchain.size()];
                requestorVchain.copyInto(requestorChain);
                X509Certificate[] chainSinRoot = new X509Certificate[requestorChain.length - 1];
                for (int i = 0; i < chainSinRoot.length; ++i) {
                    chainSinRoot[i] = requestorChain[i];
                }
                AlgoritmosHash ah = new AlgoritmosHash();
                ah.setAlgorithm("sha");
                CertID certId = new CertID(ah.getAlgorithm(), caCert, cert);
                ReqCert reqCert = new ReqCert(0, (Object)certId);
                Request request = new Request(reqCert);
                OCSPRequest ocspRequest = new OCSPRequest();
                ocspRequest.setRequestList(new Request[]{request});
                ocspRequest.setRequestorName(new GeneralName(4, (Object)requestorChain[0].getSubjectDN()));
                ocspRequest.setCertificates(chainSinRoot);
                ocspRequest.sign(AlgorithmID.sha1WithRSAEncryption, requestorPK);
                ByteArrayOutputStream servidorOCSP = new ByteArrayOutputStream();
                AutenticacionFuerte af = new AutenticacionFuerte();
                ByteArrayOutputStream politica = new ByteArrayOutputStream();
                ByteArrayOutputStream usernotice = new ByteArrayOutputStream();
                error = af.extractPolicy(certIn, politica, usernotice);
                if (error == 0 && politica.toString("ISO8859_1").trim().equals(CtesAutenticacion.OID_POLITICA_FNMT)) {
                    int salidaOcspResponse = this.requestOCSPWebService(cert, responseOCSPOut, responseDateOut, responseValueOut);
                    if (salidaOcspResponse != 0) {
                        return salidaOcspResponse;
                    }
                    break block34;
                }
                if (this.urlOCSP == null || this.urlOCSP.equals("")) {
                    error = af.getAuthorityInfoAccessOCSP(certIn, servidorOCSP);
                    if (error != 0 || servidorOCSP.toString("ISO8859_1").equals("")) {
                        return error;
                    }
                } else {
                    servidorOCSP.write(this.urlOCSP.getBytes("ISO8859_1"));
                }
                if (error != ConstantesErrores.OK) {
                    return error;
                }
                HttpOCSPRequest httpOCSPRequest = new HttpOCSPRequest(new URL(servidorOCSP.toString("ISO8859_1")));
                httpOCSPRequest.postRequest(ocspRequest);
                OCSPResponse ocspResponse = httpOCSPRequest.getOCSPResponse();
                BasicOCSPResponse basicResponse = (BasicOCSPResponse)ocspResponse.getResponse();
                if (ocspResponse.getResponse() == null) break block34;
                SingleResponse singleResponse = basicResponse.getSingleResponse(reqCert);
                ocspResponse.writeTo((OutputStream)responseOCSPOut);
                StreamCopier scDate = new StreamCopier((InputStream)new ByteArrayInputStream(basicResponse.getProducedAt().toString().getBytes("ISO8859_1")), (OutputStream)responseDateOut);
                scDate.copyStream();
                StreamCopier scStatus = new StreamCopier((InputStream)new ByteArrayInputStream(singleResponse.getCertStatus().getCertStatusName().getBytes("ISO8859_1")), (OutputStream)responseValueOut);
                scStatus.copyStream();
                X509Certificate[] tempTodoCerts = basicResponse.getCertificates();
                X509Certificate[] todoCerts = new X509Certificate[tempTodoCerts.length];
                for (int i = 0; i < tempTodoCerts.length; ++i) {
                    todoCerts[i] = tempTodoCerts[i];
                }
                X509Certificate ocspCert = todoCerts[0];
                basicResponse.verify(todoCerts[0].getPublicKey());
                ExtendedKeyUsage eku = (ExtendedKeyUsage)ocspCert.getExtension(ExtendedKeyUsage.oid);
                boolean ocspSigning = false;
                if (eku != null) {
                    ObjectID[] purposes = eku.getKeyPurposeIDs();
                    for (int i = 0; i < purposes.length; ++i) {
                        if (!purposes[i].equals((Object)ExtendedKeyUsage.ocspSigning)) continue;
                        ocspSigning = true;
                        break;
                    }
                }
                if (ocspSigning) {
                    Vector<X509Certificate> vChainOcsp = new Vector<X509Certificate>();
                    error = cs.getCertificateChain(ocspCert, vChainOcsp);
                    if (error != 0) {
                        vChainOcsp.addElement(ocspCert);
                        X509Certificate[] certsResponse = todoCerts;
                        if (certsResponse.length > 1) {
                            for (int j = 1; j < certsResponse.length; ++j) {
                                vChainOcsp.addElement(certsResponse[j]);
                            }
                        }
                        ByteArrayOutputStream ocspRaiz = new ByteArrayOutputStream();
                        error = cs.getRoot((X509Certificate)vChainOcsp.elementAt(vChainOcsp.size() - 1), ocspRaiz);
                        if (error != ConstantesErrores.OK) {
                            error = ConstantesErrores.NO_OCSPCHAIN;
                            return error;
                        }
                        vChainOcsp.addElement(new X509Certificate(ocspRaiz.toByteArray()));
                    }
                    Object[] chainOcsp = new X509Certificate[vChainOcsp.size()];
                    vChainOcsp.copyInto(chainOcsp);
                    error = cs.comprobar((X509Certificate[])chainOcsp);
                    if (error != ConstantesErrores.OK) {
                        if (error == 22) {
                            error = ConstantesErrores.NO_OCSP_CA_EN_KS;
                        }
                        if (error == 34) {
                            error = ConstantesErrores.FIRMA_CADENA_INC;
                        }
                        return error;
                    }
                    break block34;
                }
                error = ConstantesErrores.NO_OCSPSIGNING;
                return error;
            }
            catch (ConnectException coex) {
                error = ConstantesErrores.CONN_REFUSED;
                return error;
            }
            catch (NoRouteToHostException nrthe) {
                error = ConstantesErrores.CONN_REFUSED;
            }
            catch (CertificateException ce) {
                ce.printStackTrace();
                error = ConstantesErrores.CERT_ENTRADA_ERR;
            }
            catch (NoSuchAlgorithmException nsae) {
                error = ConstantesErrores.ERR_VERIFYING_OCSP_SIGN;
            }
            catch (OCSPException oe) {
                error = ConstantesErrores.RESPONSE_INCORRECTA;
            }
            catch (InvalidKeyException ike) {
                error = ConstantesErrores.ERR_VERIFYING_OCSP_SIGN;
            }
            catch (X509ExtensionException ee) {
                error = ConstantesErrores.ERR_VERIFYING_OCSP_SIGN;
            }
            catch (MalformedURLException mue) {
                error = ConstantesErrores.URL_INCORRECTA;
            }
            catch (IOException ioe) {
                error = ConstantesErrores.RESPONSE_INCORRECTA;
            }
            catch (SignatureException se) {
                error = ConstantesErrores.ERR_VERIFYING_OCSP_SIGN;
            }
        }
        return error;
    }

    public int parseResponseOCSP(byte[] responseIn, ByteArrayOutputStream hashAlgorithmOut, ByteArrayOutputStream dnHashCAOut, ByteArrayOutputStream pkHashCAOut, ByteArrayOutputStream snCertOut, ByteArrayOutputStream responseDateOut, ByteArrayOutputStream responseValueOut) {
        int error = ConstantesErrores.OK;
        OCSPResponse ocspResponse = null;
        SingleResponse singleResponse = new SingleResponse();
        BasicOCSPResponse basicResponse = new BasicOCSPResponse();
        boolean single = false;
        try {
            ocspResponse = new OCSPResponse(responseIn);
            basicResponse = (BasicOCSPResponse)ocspResponse.getResponse();
            SingleResponse[] singleResponses = basicResponse.getSingleResponses();
            singleResponse = singleResponses[0];
        }
        catch (Exception e) {
            try {
                ASN1Object asn1br2 = DerCoder.decode((byte[])responseIn);
                singleResponse.decode(asn1br2);
            }
            catch (CodingException e1) {
                error = 1029;
                return 1029;
            }
            single = true;
        }
        try {
            ReqCert reqCert = singleResponse.getReqCert();
            CertID certID = (CertID)reqCert.getReqCert();
            AlgorithmID hash = certID.getHashAlgorithm();
            Date fecha = !single ? basicResponse.getProducedAt() : singleResponse.getThisUpdate();
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            String time = df.format(fecha);
            responseDateOut.write(time.getBytes("ISO8859_1"));
            responseValueOut.write(singleResponse.getCertStatus().getCertStatusName().getBytes("ISO8859_1"));
            dnHashCAOut.write(certID.getIssuerNameHash());
            pkHashCAOut.write(certID.getIssuerKeyHash());
            hashAlgorithmOut.write(hash.toString().getBytes("ISO8859_1"));
            snCertOut.write(certID.getSerialNumber().toByteArray());
            BigInteger snb = new BigInteger(snCertOut.toByteArray());
            snCertOut.reset();
            snCertOut.write(snb.toString().getBytes("ISO8859_1"));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return error;
    }

    public int requestOCSP_NoVerify(byte[] certIn, String pathCS, String passCS, ByteArrayOutputStream responseOCSPOut, ByteArrayOutputStream responseDateOut, ByteArrayOutputStream responseValueOut) {
        int error = ConstantesErrores.OK;
        try {
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, passCS);
            X509Certificate cert = new X509Certificate(certIn);
            Vector vChain = new Vector();
            error = cs.getCertIssuer(cert, vChain);
            if (error != ConstantesErrores.OK) {
                return error;
            }
            X509Certificate caCert = (X509Certificate)vChain.elementAt(1);
            AlgoritmosHash ah = new AlgoritmosHash();
            ah.setAlgorithm("sha");
            CertID certID = new CertID(ah.getAlgorithm(), caCert, cert);
            ReqCert reqCert = new ReqCert(0, (Object)certID);
            Request request = new Request(reqCert);
            OCSPRequest ocspRequest = new OCSPRequest();
            ocspRequest.setRequestList(new Request[]{request});
            ByteArrayOutputStream servidorOCSP = new ByteArrayOutputStream();
            AutenticacionFuerte af = new AutenticacionFuerte();
            ByteArrayOutputStream politica = new ByteArrayOutputStream();
            ByteArrayOutputStream usernotice = new ByteArrayOutputStream();
            error = af.extractPolicy(certIn, politica, usernotice);
            if (error == 0 && politica.toString("ISO8859_1").trim().equals(CtesAutenticacion.OID_POLITICA_FNMT)) {
                int salidaOcspResponse = this.requestOCSPWebService(cert, responseOCSPOut, responseDateOut, responseValueOut);
                if (salidaOcspResponse != 0) {
                    return salidaOcspResponse;
                }
            } else {
                if (this.urlOCSP == null || this.urlOCSP.equals("")) {
                    error = af.getAuthorityInfoAccessOCSP(certIn, servidorOCSP);
                    if (error != 0 || servidorOCSP.toString("ISO8859_1").equals("")) {
                        return error;
                    }
                } else {
                    servidorOCSP.write(this.urlOCSP.getBytes("ISO8859_1"));
                }
                if (error != ConstantesErrores.OK) {
                    return error;
                }
                HttpOCSPRequest httpOCSPRequest = new HttpOCSPRequest(new URL(servidorOCSP.toString("ISO8859_1")));
                httpOCSPRequest.postRequest(ocspRequest);
                OCSPResponse ocspResponse = httpOCSPRequest.getOCSPResponse();
                BasicOCSPResponse basicResponse = (BasicOCSPResponse)ocspResponse.getResponse();
                if (ocspResponse.getResponse() != null) {
                    SingleResponse singleResponse = basicResponse.getSingleResponse(reqCert);
                    ocspResponse.writeTo((OutputStream)responseOCSPOut);
                    StreamCopier scDate = new StreamCopier((InputStream)new ByteArrayInputStream(basicResponse.getProducedAt().toString().getBytes("ISO8859_1")), (OutputStream)responseDateOut);
                    scDate.copyStream();
                    StreamCopier scStatus = new StreamCopier((InputStream)new ByteArrayInputStream(singleResponse.getCertStatus().getCertStatusName().getBytes("ISO8859_1")), (OutputStream)responseValueOut);
                    scStatus.copyStream();
                    X509Certificate[] tempTodoCerts = basicResponse.getCertificates();
                    X509Certificate[] todoCerts = new X509Certificate[tempTodoCerts.length];
                    for (int i = 0; i < tempTodoCerts.length; ++i) {
                        todoCerts[i] = tempTodoCerts[i];
                    }
                    X509Certificate ocspCert = todoCerts[0];
                    basicResponse.verify(ocspCert.getPublicKey());
                }
            }
        }
        catch (ConnectException coex) {
            error = ConstantesErrores.CONN_REFUSED;
            return error;
        }
        catch (UnknownHostException uhe) {
            error = ConstantesErrores.CONN_REFUSED;
            return error;
        }
        catch (NoRouteToHostException nrthe) {
            error = ConstantesErrores.CONN_REFUSED;
        }
        catch (CertificateException ce) {
            ce.printStackTrace();
            error = ConstantesErrores.CERT_ENTRADA_ERR;
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
        }
        catch (MalformedURLException mue) {
            error = ConstantesErrores.URL_INCORRECTA;
        }
        catch (IOException ioe) {
            error = ConstantesErrores.URL_INCORRECTA;
        }
        catch (OCSPException oe) {
            error = ConstantesErrores.RESPONSE_INCORRECTA;
        }
        catch (InvalidKeyException ike) {
            ike.printStackTrace();
        }
        catch (SignatureException se) {
            error = ConstantesErrores.ERR_VERIFYING_OCSP_SIGN;
        }
        return error;
    }

    public int signedRequestOCSP_NoVerify(byte[] certIn, String requestorIssuerIn, String requestorSnIn, String pathCS, String passCS, ByteArrayOutputStream responseOCSPOut, ByteArrayOutputStream responseDateOut, ByteArrayOutputStream responseValueOut) {
        int error = ConstantesErrores.OK;
        try {
            X509Certificate cert = new X509Certificate(certIn);
            GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(pathCS, passCS);
            Vector vChain = new Vector();
            error = cs.getCertIssuer(cert, vChain);
            if (error != ConstantesErrores.OK) {
                return error;
            }
            X509Certificate caCert = (X509Certificate)vChain.elementAt(1);
            PrivateKey requestorPK = cs.getPrivateKeyFromKeyStore(requestorIssuerIn, requestorSnIn);
            if (requestorPK == null) {
                return ConstantesErrores.PK_NOENC;
            }
            ByteArrayOutputStream requestorCertAux = new ByteArrayOutputStream();
            error = cs.getCertCS(requestorIssuerIn, requestorSnIn, requestorCertAux);
            if (error != ConstantesErrores.OK) {
                return error;
            }
            X509Certificate requestorCert = new X509Certificate(requestorCertAux.toByteArray());
            if (!this.isDigitalSignature(requestorCert.toByteArray())) {
                error = ConstantesErrores.NO_FIRMADIGITAL;
                return error;
            }
            Vector requestorVchain = new Vector();
            error = cs.getCertificateChain(requestorCert, requestorVchain);
            if (error != ConstantesErrores.OK) {
                error = ConstantesErrores.NO_REQCHAIN;
                return error;
            }
            Object[] requestorChain = new X509Certificate[requestorVchain.size()];
            requestorVchain.copyInto(requestorChain);
            X509Certificate[] chainSinRoot = new X509Certificate[requestorChain.length - 1];
            for (int i = 0; i < chainSinRoot.length; ++i) {
                chainSinRoot[i] = requestorChain[i];
            }
            AlgoritmosHash ah = new AlgoritmosHash();
            ah.setAlgorithm("sha");
            CertID certId = new CertID(ah.getAlgorithm(), caCert, cert);
            ReqCert reqCert = new ReqCert(0, (Object)certId);
            Request request = new Request(reqCert);
            OCSPRequest ocspRequest = new OCSPRequest();
            ocspRequest.setRequestList(new Request[]{request});
            ocspRequest.setRequestorName(new GeneralName(4, (Object)requestorChain[0].getSubjectDN()));
            ocspRequest.setCertificates(chainSinRoot);
            ocspRequest.sign(AlgorithmID.sha1WithRSAEncryption, requestorPK);
            ByteArrayOutputStream servidorOCSP = new ByteArrayOutputStream();
            AutenticacionFuerte af = new AutenticacionFuerte();
            ByteArrayOutputStream politica = new ByteArrayOutputStream();
            ByteArrayOutputStream usernotice = new ByteArrayOutputStream();
            error = af.extractPolicy(certIn, politica, usernotice);
            if (error == 0 && politica.toString("ISO8859_1").trim().equals(CtesAutenticacion.OID_POLITICA_FNMT)) {
                int salidaOcspResponse = this.requestOCSPWebService(cert, responseOCSPOut, responseDateOut, responseValueOut);
                if (salidaOcspResponse != 0) {
                    return salidaOcspResponse;
                }
            } else {
                if (this.urlOCSP == null || this.urlOCSP.equals("")) {
                    error = af.getAuthorityInfoAccessOCSP(certIn, servidorOCSP);
                    if (error != 0 || servidorOCSP.toString("ISO8859_1").equals("")) {
                        return error;
                    }
                } else {
                    servidorOCSP.write(this.urlOCSP.getBytes("ISO8859_1"));
                }
                if (error != ConstantesErrores.OK) {
                    return error;
                }
                HttpOCSPRequest httpOCSPRequest = new HttpOCSPRequest(new URL(servidorOCSP.toString("ISO8859_1")));
                httpOCSPRequest.postRequest(ocspRequest);
                OCSPResponse ocspResponse = httpOCSPRequest.getOCSPResponse();
                BasicOCSPResponse basicResponse = (BasicOCSPResponse)ocspResponse.getResponse();
                if (ocspResponse.getResponse() != null) {
                    SingleResponse singleResponse = basicResponse.getSingleResponse(reqCert);
                    ocspResponse.writeTo((OutputStream)responseOCSPOut);
                    StreamCopier scDate = new StreamCopier((InputStream)new ByteArrayInputStream(basicResponse.getProducedAt().toString().getBytes("ISO8859_1")), (OutputStream)responseDateOut);
                    scDate.copyStream();
                    StreamCopier scStatus = new StreamCopier((InputStream)new ByteArrayInputStream(singleResponse.getCertStatus().getCertStatusName().getBytes("ISO8859_1")), (OutputStream)responseValueOut);
                    scStatus.copyStream();
                    X509Certificate[] tempTodoCerts = basicResponse.getCertificates();
                    X509Certificate[] todoCerts = new X509Certificate[tempTodoCerts.length];
                    for (int i = 0; i < tempTodoCerts.length; ++i) {
                        todoCerts[i] = tempTodoCerts[i];
                    }
                    X509Certificate ocspCert = todoCerts[0];
                    basicResponse.verify(ocspCert.getPublicKey());
                }
            }
        }
        catch (ConnectException coex) {
            error = ConstantesErrores.CONN_REFUSED;
            return error;
        }
        catch (NoRouteToHostException nrthe) {
            error = ConstantesErrores.CONN_REFUSED;
        }
        catch (CertificateException ce) {
            ce.printStackTrace();
            error = ConstantesErrores.CERT_ENTRADA_ERR;
        }
        catch (NoSuchAlgorithmException nsae) {
            error = ConstantesErrores.RESPONSE_INCORRECTA;
        }
        catch (OCSPException oe) {
            error = ConstantesErrores.RESPONSE_INCORRECTA;
        }
        catch (InvalidKeyException ike) {
            error = ConstantesErrores.RESPONSE_INCORRECTA;
        }
        catch (MalformedURLException mue) {
            error = ConstantesErrores.URL_INCORRECTA;
        }
        catch (IOException ioe) {
            error = ConstantesErrores.RESPONSE_INCORRECTA;
        }
        catch (SignatureException se) {
            error = ConstantesErrores.RESPONSE_INCORRECTA;
        }
        return error;
    }

    public int checkOCSPResponse(Vector vecOcspresponses, byte[] pkcs7, Vector vecCertificados, Vector vecDates, Vector vecErrores) {
        int error = 0;
        Miscelanea funciones = new Miscelanea();
        try {
            ByteArrayInputStream baisP7 = new ByteArrayInputStream(pkcs7);
            ContentInfoStream cis = new ContentInfoStream((InputStream)baisP7);
            SignedDataStream p7entrada = (SignedDataStream)cis.getContent();
            ByteArrayOutputStream certstream = new ByteArrayOutputStream();
            InputStream is2 = p7entrada.getInputStream();
            if (is2 != null) {
                StreamCopier scp = new StreamCopier(is2, (OutputStream)certstream);
                scp.copyStream();
                ByteArrayInputStream certificado = new ByteArrayInputStream(certstream.toByteArray());
            }
            X509Certificate[] cadenacert = p7entrada.getCertificates();
            SignerInfo[] signeres = p7entrada.getSignerInfos();
            Vector<X509Certificate> vectorCertificados = new Vector<X509Certificate>();
            for (int k = 0; k < cadenacert.length; ++k) {
                X509Certificate certPrueba = new X509Certificate();
                certPrueba = cadenacert[k];
                BasicConstraints bc = (BasicConstraints)certPrueba.getExtension(BasicConstraints.oid);
                if (bc != null && bc.ca()) continue;
                vectorCertificados.addElement(certPrueba);
            }
            for (int i = 0; i < vecOcspresponses.size(); ++i) {
                ByteArrayOutputStream valueOut;
                ByteArrayOutputStream dateOut;
                ByteArrayOutputStream snCert;
                ByteArrayOutputStream pbkHash;
                ByteArrayOutputStream hasCA;
                ByteArrayOutputStream hashAlg;
                ByteArrayOutputStream dateSalida = new ByteArrayOutputStream();
                byte[] ocspresponse = (byte[])vecOcspresponses.elementAt(i);
                error = this.parseResponseOCSP(ocspresponse, hashAlg = new ByteArrayOutputStream(), hasCA = new ByteArrayOutputStream(), pbkHash = new ByteArrayOutputStream(), snCert = new ByteArrayOutputStream(), dateOut = new ByteArrayOutputStream(), valueOut = new ByteArrayOutputStream());
                if (error != 0) {
                    return error;
                }
                dateSalida.write(dateOut.toByteArray());
                ByteArrayOutputStream hasCAB64 = new ByteArrayOutputStream();
                error = funciones.binBase64(hasCA.toByteArray(), hasCAB64);
                if (error != 0) {
                    return error;
                }
                boolean encontrado = false;
                for (int j = 0; j < vectorCertificados.size(); ++j) {
                    X509Certificate cert = new X509Certificate();
                    cert = (X509Certificate)vectorCertificados.elementAt(j);
                    AlgoritmosHash algm = new AlgoritmosHash();
                    algm.setAlgorithm("SHA");
                    Name issuerName = (Name)cert.getIssuerDN();
                    byte[] encodedIssuerName = issuerName.getEncoded();
                    ByteArrayOutputStream salidaHash = new ByteArrayOutputStream();
                    error = funciones.newHash(algm.getAlgorithm(), encodedIssuerName, salidaHash);
                    if (error != 0) {
                        return error;
                    }
                    if (!salidaHash.toString("ISO8859_1").equals(hasCAB64.toString("ISO8859_1")) || !cert.getSerialNumber().toString().equals(snCert.toString("ISO8859_1"))) continue;
                    encontrado = true;
                    if (valueOut.toString("ISO8859_1").equalsIgnoreCase("REVOKED")) {
                        vecErrores.addElement("1022");
                    }
                    if (valueOut.toString("ISO8859_1").equalsIgnoreCase("UNKNOWN")) {
                        vecErrores.addElement("1023");
                    }
                    if (valueOut.toString("ISO8859_1").equalsIgnoreCase("GOOD")) {
                        vecErrores.addElement("0");
                    }
                    vecDates.addElement(dateSalida);
                    vecCertificados.addElement(cert);
                }
                if (encontrado) continue;
                vecErrores.addElement("1018");
                vecDates.addElement(dateSalida);
                vecCertificados.addElement("-1");
            }
            if (vectorCertificados.size() != vecOcspresponses.size()) {
                error = 1021;
            }
            for (int h = 0; h < vecErrores.size(); ++h) {
                if (vecErrores.elementAt(h).toString().equals("0")) continue;
                error = 1019;
                return 1019;
            }
        }
        catch (X509ExtensionInitException xe) {
            error = 1020;
            return 1020;
        }
        catch (PKCSParsingException pkcspe) {
            error = 1020;
            return 1020;
        }
        catch (IOException coe) {
            error = 1019;
            return 1019;
        }
        return error;
    }

    private boolean isDigitalSignature(byte[] certificado) {
        boolean digitalSignature = false;
        try {
            X509Certificate cert = new X509Certificate(certificado);
            boolean[] b = cert.getKeyUsage();
            ByteArrayOutputStream politicaOID = new ByteArrayOutputStream();
            ByteArrayOutputStream userNotice = new ByteArrayOutputStream();
            AutenticacionFuerte af = new AutenticacionFuerte();
            int error = af.extractPolicy(certificado, politicaOID, userNotice);
            String politica = politicaOID.toString("ISO8859_1");
            if (error == 0) {
                digitalSignature = politica.equals(CtesAutenticacion.OID_POLITICA_eDNI_A) || politica.equals(CtesAutenticacion.OID_POLITICA_eDNI_F) ? b[1] : b[0];
            }
        }
        catch (CertificateException ce) {
            System.err.println(ce);
            return false;
        }
        catch (Exception e) {
            System.err.println(e);
            return false;
        }
        return digitalSignature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int requestOCSPWebService(X509Certificate cert, ByteArrayOutputStream salidaSingle, ByteArrayOutputStream dateOut, ByteArrayOutputStream estadoOut) {
        Properties webServicesProperties;
        boolean existeProperties;
        int error;
        block61: {
            InputStream in;
            block60: {
                File fil = new File("c:/temp/archiv.txt");
                error = 0;
                existeProperties = false;
                in = AccesoOCSP.class.getResourceAsStream("webservices.properties");
                webServicesProperties = new Properties();
                if (in == null) {
                    in = AccesoOCSP.class.getResourceAsStream("/webservices.properties");
                }
                if (in == null) {
                    in = Thread.currentThread().getContextClassLoader().getResourceAsStream("webservices.properties");
                }
                if (in == null) {
                    in = ClassLoader.getSystemClassLoader().getResourceAsStream("webservices.properties");
                }
                if (in != null) {
                    webServicesProperties.load(in);
                    break block60;
                }
                existeProperties = false;
            }
            Object var12_10 = null;
            if (in == null) break block61;
            existeProperties = true;
            try {
                in.close();
            }
            catch (Throwable ignore) {}
            break block61;
            {
                catch (Exception e) {
                    e.printStackTrace();
                    var12_10 = null;
                    if (in != null) {
                        existeProperties = true;
                        try {
                            in.close();
                        }
                        catch (Throwable ignore) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                if (in != null) {
                    existeProperties = true;
                    try {
                        in.close();
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        Properties systemSettings = System.getProperties();
        Properties restoreSettings = (Properties)systemSettings.clone();
        String endpoint = "";
        if (!existeProperties) {
            systemSettings.put("proxySet", "true");
            systemSettings.put("proxyHost", "10.252.196.143");
            systemSettings.put("proxyPort", "8080");
            systemSettings.put("http.proxySet", "true");
            systemSettings.put("http.proxyHost", "10.252.196.143");
            systemSettings.put("http.proxyPort", "8080");
            endpoint = "http://afirma.redinteradministrativa.es:8080/afirmaws/services/ValidarCertificado";
        } else {
            if (webServicesProperties.getProperty("proxySet") != null) {
                systemSettings.put("proxySet", webServicesProperties.getProperty("proxySet").trim());
            } else {
                systemSettings.put("proxySet", "true");
            }
            if (webServicesProperties.getProperty("proxyHost") != null) {
                systemSettings.put("proxyHost", webServicesProperties.getProperty("proxyHost").trim());
            } else {
                systemSettings.put("proxyHost", "10.252.196.143");
            }
            if (webServicesProperties.getProperty("proxyPort") != null) {
                systemSettings.put("proxyPort", webServicesProperties.getProperty("proxyPort").trim());
            } else {
                systemSettings.put("proxyPort", "8080");
            }
            if (webServicesProperties.getProperty("http.proxySet") != null) {
                systemSettings.put("http.proxySet", webServicesProperties.getProperty("http.proxySet").trim());
            } else {
                systemSettings.put("http.proxySet", "true");
            }
            if (webServicesProperties.getProperty("http.proxyHost") != null) {
                systemSettings.put("http.proxyHost", webServicesProperties.getProperty("http.proxyHost").trim());
            } else {
                systemSettings.put("http.proxyHost", "10.252.196.143");
            }
            if (webServicesProperties.getProperty("http.proxyPort") != null) {
                systemSettings.put("http.proxyPort", webServicesProperties.getProperty("http.proxyPort").trim());
            } else {
                systemSettings.put("http.proxyPort", "8080");
            }
            endpoint = webServicesProperties.getProperty("endpoint") != null ? webServicesProperties.getProperty("endpoint").trim() : "http://afirma.redinteradministrativa.es:8080/afirmaws/services/ValidarCertificado";
        }
        System.setProperties(systemSettings);
        Service service = new Service();
        Call call = null;
        String result = "";
        try {
            call = (Call)service.createCall();
            call.setTargetEndpointAddress(new URL(endpoint));
            call.setOperationName(new QName("http://soapinterop.org", "ValidarCertificado"));
            String cabecera = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><mensajeEntrada xmlns=\"https://afirmaws/ws/validacion\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:SchemaLocation=\"https://localhost/afirmaws/xsd/mvalidacion/ws.xsd\"><peticion>ValidarCertificado</peticion><versionMsg>1.0</versionMsg><parametros><certificado><![CDATA[";
            String pie = "]]></certificado><idAplicacion>gvasco.izenpe.izenpe001</idAplicacion><modoValidacion>1</modoValidacion><obtenerInfo>true</obtenerInfo></parametros></mensajeEntrada>";
            Miscelanea funciones = new Miscelanea();
            ByteArrayOutputStream b64Out = new ByteArrayOutputStream();
            funciones.binBase64_NoLineBreaks(cert.getEncoded(), b64Out);
            result = (String)call.invoke(new Object[]{cabecera + b64Out.toString("UTF-8") + pie});
            System.setProperties(systemSettings);
        }
        catch (MalformedURLException e1) {
            error = 1025;
            int pie = 1025;
            return pie;
        }
        catch (ServiceException e1) {
            error = 1025;
            int pie = 1025;
            return pie;
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
            error = 1025;
            int pie = 1025;
            return pie;
        }
        catch (CertificateEncodingException e) {
            error = 1025;
            int pie = 1025;
            return pie;
        }
        catch (UnsupportedEncodingException e) {
            error = 1025;
            int pie = 1025;
            return pie;
        }
        finally {
            System.setProperties(restoreSettings);
        }
        Document xmlDocument = null;
        try {
            ByteArrayInputStream bs = new ByteArrayInputStream(result.getBytes("UTF-8"));
            xmlDocument = new DocumentBuilderFactoryImpl().newDocumentBuilder().parse(bs);
        }
        catch (SAXException e1) {
            error = 1026;
        }
        catch (IOException e1) {
            error = 1026;
        }
        catch (ParserConfigurationException e1) {
            error = 1026;
        }
        String estadoCert = "";
        Date fecha = new Date();
        try {
            NodeList resultados = xmlDocument.getElementsByTagName("InfoMetodoVerificacion");
            Node resultado = resultados.item(0);
            NodeList listacodigo = resultado.getChildNodes();
            for (int i = 0; i < listacodigo.getLength(); ++i) {
                Node codigo = listacodigo.item(i);
                if (!codigo.getNodeName().equalsIgnoreCase("estado")) continue;
                estadoCert = codigo.getFirstChild().getNodeValue();
            }
        }
        catch (Exception e) {
            error = 1026;
        }
        String estadoCertificado = "";
        if (estadoCert == null) {
            error = 1028;
            return 1028;
        }
        if (estadoCert.equals("0")) {
            estadoCertificado = "good";
        }
        if (estadoCert.equals("1")) {
            estadoCertificado = "revoked";
        }
        if (!estadoCert.equals("0") && !estadoCert.equals("1")) {
            estadoCertificado = "unknown";
        }
        try {
            estadoOut.write(estadoCertificado.getBytes("ISO8859_1"));
            dateOut.write(fecha.toString().getBytes("ISO8859_1"));
        }
        catch (UnsupportedEncodingException e) {
            error = 1027;
        }
        catch (IOException e) {
            error = 1027;
        }
        AlgorithmID hashAlgorithm = AlgorithmID.sha1;
        Name issuerName = (Name)cert.getIssuerDN();
        PublicKey issuerKey = cert.getPublicKey();
        BigInteger serialNumber = cert.getSerialNumber();
        CertID certID = null;
        try {
            certID = new CertID(hashAlgorithm, issuerName, issuerKey, serialNumber);
        }
        catch (NoSuchAlgorithmException e) {
            // empty catch block
        }
        ReqCert reqCert = new ReqCert(0, certID);
        CertStatus certStatus = null;
        certStatus = estadoCert.equals("0") ? new CertStatus() : (estadoCert.equals("1") ? new CertStatus(new RevokedInfo(new Date())) : new CertStatus(new UnknownInfo()));
        SingleResponse singleResponse = new SingleResponse(reqCert, certStatus, fecha);
        try {
            ASN1Object asn1sr = singleResponse.toASN1Object();
            byte[] encoding = DerCoder.encode((ASN1Object)asn1sr);
            salidaSingle.write(encoding);
        }
        catch (CodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return error;
    }

    public void setResponder(String urlOCSP) {
        this.urlOCSP = urlOCSP;
    }

    public void deleteResponder() {
        this.urlOCSP = "";
    }

    public int setResponderTSA(String path, String pass) {
        ByteArrayOutputStream uri;
        GestionContenedorSeguro cs = GestionContenedorSeguro.getInstance(path, pass);
        int error = cs.getURLTSA(uri = new ByteArrayOutputStream());
        if (error == 0) {
            try {
                String tempUri = uri.toString("ISO8859_1");
                this.urlOCSP = tempUri.indexOf("tsades") != -1 ? this.urlOCSPDes : this.urlOCSPProd;
            }
            catch (IOException ioe) {
                error = 1024;
                return 1024;
            }
            error = 0;
            return 0;
        }
        return error;
    }
}

