/*
 * Decompiled with CFR 0.152.
 */
package w11.com.ejie.y31.service.impl;

import com.ejie.w43ta.clients.W43taMomoCustomMap;
import com.ejie.w43ta.clients.W43taMomoTraceClient;
import com.ejie.y31.vo.Y31JanoServiceTrace;
import w11.com.ejie.y31.util.Y31Properties;

public class Y31PIBManager {
    private static final String MOMO_SERVICE = "MOMO_SERVICE";
    private static final String MOMO_APP = "MOMO_APP";
    private static final String MOMO_TOKEN = "MOMO_TOKEN";
    private static final String MOMO_ENDPOINT = "MOMO_ENDPOINT";
    private static final String MOMO_PORT = "MOMO_PORT";
    private static final String MOMO_ISLOCAL = "MOMO_ISLOCAL";
    private static final String service = Y31Properties.properties.getProperty("MOMO_SERVICE");
    private static final String application = Y31Properties.properties.getProperty("MOMO_APP");
    private static final String token = Y31Properties.properties.getProperty("MOMO_TOKEN");
    private static final String endpoint = Y31Properties.properties.getProperty("MOMO_ENDPOINT");
    private static final Integer port = Integer.parseInt(Y31Properties.properties.getProperty("MOMO_PORT"));
    private static final Boolean islocal = Boolean.parseBoolean(Y31Properties.properties.getProperty("MOMO_ISLOCAL"));
    public static final W43taMomoTraceClient _log = W43taMomoTraceClient.getInstance((String)service, (String)application, (String)token, (String)endpoint, (int)port, (boolean)islocal);

    public static void insert(Y31JanoServiceTrace item) {
        if (item != null) {
            if (item.isSuccess().booleanValue()) {
                _log.info(Y31PIBManager.item2Message(item), Long.valueOf(item.getDuration()), Y31PIBManager.item2Custom(item));
            } else if (item.getErrorMessage() != null) {
                _log.error(Y31PIBManager.item2Message(item), (Throwable)new ExceptionWrapper(item), Long.valueOf(item.getDuration()), Y31PIBManager.item2Custom(item));
            } else {
                _log.error(Y31PIBManager.item2Message(item), null, Long.valueOf(item.getDuration()), Y31PIBManager.item2Custom(item));
            }
        }
    }

    private static W43taMomoCustomMap item2Custom(Y31JanoServiceTrace item) {
        W43taMomoCustomMap a = W43taMomoCustomMap.getInstance();
        if (item.getOperationType() != null) {
            a.add("operationtype_lt", item.getOperationType());
        }
        if (item.getPathFrom() != null) {
            a.add("pathfrom_lt", item.getPathFrom());
        }
        if (item.getPathTo() != null) {
            a.add("pathto_lt", item.getPathTo());
        }
        if (item.getSize() != null && item.getSize() > 0L) {
            a.add("size_li", item.getSize());
        }
        if (item.getTstart() > 0L) {
            a.add("tstart_li", Long.valueOf(item.getTstart()));
        }
        if (item.getTend() > 0L) {
            a.add("tend_li", Long.valueOf(item.getTend()));
        }
        if (item.getFileOriginalName() != null) {
            a.add("fileoriginalname_lt", item.getFileOriginalName());
        }
        if (item.getOriginId() != null) {
            a.add("originid_lt", item.getOriginId());
        }
        if (item.getTtl() != null && item.getTtl() > 0L) {
            a.add("ttl_li", item.getTtl());
        }
        return a;
    }

    private static String parse(String s) {
        if (s == null) {
            return "n/a";
        }
        return s;
    }

    private static String parse(long s) {
        if (s < 0L) {
            return "n/a";
        }
        return s + "";
    }

    private static String item2Message(Y31JanoServiceTrace item) {
        String s = null;
        if (item.getOperationType().equalsIgnoreCase("move")) {
            s = "MOVE (from:" + Y31PIBManager.parse(item.getPathFrom()) + ") (to:" + Y31PIBManager.parse(item.getPathTo()) + ") in " + Y31PIBManager.parse(item.getDuration()) + "ms by " + Y31PIBManager.parse(item.getOriginId() + "(size:" + Y31PIBManager.parse(item.getSize()) + ")");
        } else if (item.getOperationType().equalsIgnoreCase("put")) {
            s = "PUT (from:" + Y31PIBManager.parse(item.getPathFrom()) + ") (to:" + Y31PIBManager.parse(item.getPathTo()) + ") in " + Y31PIBManager.parse(item.getDuration()) + "ms by " + Y31PIBManager.parse(item.getOriginId() + "(size:" + Y31PIBManager.parse(item.getSize()) + ")");
        } else if (item.getOperationType().equalsIgnoreCase("get")) {
            s = "GET (from:" + Y31PIBManager.parse(item.getPathFrom()) + ") (to:" + Y31PIBManager.parse(item.getPathTo()) + ") in " + Y31PIBManager.parse(item.getDuration()) + "ms by " + Y31PIBManager.parse(item.getOriginId() + "(size:" + Y31PIBManager.parse(item.getSize()) + ")");
        } else if (item.getOperationType().equalsIgnoreCase("copy")) {
            s = "COPY (from:" + Y31PIBManager.parse(item.getPathFrom()) + ") (to:" + Y31PIBManager.parse(item.getPathTo()) + ") in " + Y31PIBManager.parse(item.getDuration()) + "ms by " + Y31PIBManager.parse(item.getOriginId() + "(size:" + Y31PIBManager.parse(item.getSize()) + ")");
        } else if (item.getOperationType().equalsIgnoreCase("info")) {
            s = "INFO (from:" + Y31PIBManager.parse(item.getPathFrom()) + ") (to:" + Y31PIBManager.parse(item.getPathTo()) + ") in " + Y31PIBManager.parse(item.getDuration()) + "ms by " + Y31PIBManager.parse(item.getOriginId() + "(size:" + Y31PIBManager.parse(item.getSize()) + ")");
        } else if (item.getOperationType().equalsIgnoreCase("list")) {
            s = "LIST (from:" + Y31PIBManager.parse(item.getPathFrom()) + ") (to:" + Y31PIBManager.parse(item.getPathTo()) + ") in " + Y31PIBManager.parse(item.getDuration()) + "ms by " + Y31PIBManager.parse(item.getOriginId() + "(size:" + Y31PIBManager.parse(item.getSize()) + ")");
        } else if (item.getOperationType().equalsIgnoreCase("upload-js")) {
            s = "UPLOAD-JS (from:" + Y31PIBManager.parse(item.getPathFrom()) + ") (to:" + Y31PIBManager.parse(item.getPathTo()) + ") in " + Y31PIBManager.parse(item.getDuration()) + "ms by " + Y31PIBManager.parse(item.getOriginId() + "(size:" + Y31PIBManager.parse(item.getSize()) + ")");
        } else if (item.getOperationType().equalsIgnoreCase("delete")) {
            s = "DELETE (from:" + Y31PIBManager.parse(item.getPathFrom()) + ") (to:" + Y31PIBManager.parse(item.getPathTo()) + ") in " + Y31PIBManager.parse(item.getDuration()) + "ms by " + Y31PIBManager.parse(item.getOriginId() + "(size:" + Y31PIBManager.parse(item.getSize()) + ")");
        } else if (item.getOperationType().equalsIgnoreCase("create-tmp-token")) {
            s = "CREATE-TMP-TOKEN (from:" + Y31PIBManager.parse(item.getPathFrom()) + ") (to:" + Y31PIBManager.parse(item.getPathTo()) + ") in " + Y31PIBManager.parse(item.getDuration()) + "ms by " + Y31PIBManager.parse(item.getOriginId() + "(size:" + Y31PIBManager.parse(item.getSize()) + ")");
        }
        return s;
    }

    private static class ExceptionWrapper
    extends Throwable {
        private static final long serialVersionUID = 3957249338695920352L;

        public ExceptionWrapper(Y31JanoServiceTrace item) {
            super(item.getErrorMessage());
        }
    }
}

