/*
 * Decompiled with CFR 0.152.
 */
package w11.com.ejie.y31.service.impl;

import com.ejie.y31.exception.Y31JanoServiceAccesDeniedException;
import com.ejie.y31.service.Y31JanoServiceTool;
import com.ejie.y31.vo.Y31SecurityTmpToken;
import com.ejie.y31.vo.Y31XlnetsInfoBean;
import flexjson.JSONDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.TransformerException;
import n38a.exe.N38APISesion;
import n38c.exe.N38API;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import w11.com.ejie.y31.api.securitytoken.SecurityTokenUtil;
import w11.com.ejie.y31.service.impl.Y31JanoServiceAccessRightsBean;
import w11.com.ejie.y31.service.impl.Y31JanoServiceImpl;

public class Y31JanoServiceSecurityTool {
    public static final Boolean STRICT_SECURITY_CHECKER;
    public static String JANO_OPERATION_SUFIX;
    private static Properties properties;

    public static void checkSecuritySesionValid(Node nodo) throws Y31JanoServiceAccesDeniedException {
        String INFO = "informacion";
        String WARN = "warning";
        String ERROR = "error";
        String FILTRO_WARNING = "/n38/warning";
        String FILTRO_ERROR = "/n38/error";
        String FILTRO_INFO = "/n38/informacion";
        String FILTRO_DESCRIPCION_CA = "/descripcionCA/text()";
        String FILTRO_MOTIVO = "/motivo/text()";
        String FILTRO_CODIGO = "/@codigo";
        if (null != nodo) {
            try {
                Node nodoN38 = XPathAPI.selectSingleNode((Node)nodo, (String)"/n38");
                Node node = nodoN38.getFirstChild();
                if (node.getNodeName().equalsIgnoreCase("informacion")) {
                    String codigo = XPathAPI.selectSingleNode((Node)node, (String)"/n38/informacion/@codigo").getNodeValue();
                    String descripcion = XPathAPI.selectSingleNode((Node)node, (String)"/n38/informacion/descripcionCA/text()").getNodeValue();
                    String motivo = XPathAPI.selectSingleNode((Node)node, (String)"/n38/informacion/motivo/text()").getNodeValue();
                    throw new Y31JanoServiceAccesDeniedException("Codigo '" + codigo + "': " + descripcion + " -- " + motivo);
                }
                if (node.getNodeName().equalsIgnoreCase("warning")) {
                    String codigo = XPathAPI.selectSingleNode((Node)node, (String)"/n38/warning/@codigo").getNodeValue();
                    String descripcion = XPathAPI.selectSingleNode((Node)node, (String)"/n38/warning/descripcionCA/text()").getNodeValue();
                    String motivo = XPathAPI.selectSingleNode((Node)node, (String)"/n38/warning/motivo/text()").getNodeValue();
                    throw new Y31JanoServiceAccesDeniedException("Codigo '" + codigo + "': " + descripcion + " -- " + motivo);
                }
                if (node.getNodeName().equalsIgnoreCase("error")) {
                    String codigo = XPathAPI.selectSingleNode((Node)node, (String)"/n38/error/@codigo").getNodeValue();
                    String descripcion = XPathAPI.selectSingleNode((Node)node, (String)"/n38/error/descripcionCA/text()").getNodeValue();
                    String motivo = XPathAPI.selectSingleNode((Node)node, (String)"/n38/error/motivo/text()").getNodeValue();
                    throw new Y31JanoServiceAccesDeniedException("Codigo '" + codigo + "': " + descripcion + " -- " + motivo);
                }
            }
            catch (TransformerException e) {
                throw new Y31JanoServiceAccesDeniedException((Throwable)e);
            }
        }
    }

    protected static Y31XlnetsInfoBean getXlnetsAuditInfo(Document token) throws Y31JanoServiceAccesDeniedException {
        return Y31JanoServiceSecurityTool.getXlnetsAuditInfo(SecurityTokenUtil.xlnetsToken2String(token), false);
    }

    public static Y31XlnetsInfoBean getXlnetsAuditInfo(String token, Boolean isTmpToken) throws Y31JanoServiceAccesDeniedException {
        Y31XlnetsInfoBean a = null;
        if (token == null) {
            throw new Y31JanoServiceAccesDeniedException("No se ha suministrado un token valido " + token);
        }
        if (isTmpToken != null && isTmpToken.booleanValue()) {
            Y31SecurityTmpToken st = SecurityTokenUtil.getToken(token, JANO_OPERATION_SUFIX);
            String dni = st.getId();
            String n38personauid = st.getId() + "-" + st.getWho();
            String n38puestouid = st.getId() + "-" + st.getWhom();
            boolean isLogginApp = false;
            a = new Y31XlnetsInfoBean(n38puestouid, n38personauid, dni, Boolean.valueOf(isLogginApp));
        } else {
            try {
                String n38puestouid = null;
                String n38personauid = null;
                String dni = null;
                String n38crearsesionapp = null;
                Document sesion = SecurityTokenUtil.xlnetsToken2Document(token);
                try {
                    if (STRICT_SECURITY_CHECKER.booleanValue()) {
                        N38API n38API = new N38API(sesion);
                        sesion = n38API.n38ItemSesion();
                        Y31JanoServiceSecurityTool.checkSecuritySesionValid(sesion);
                    }
                    try {
                        dni = XPathAPI.selectSingleNode((Node)sesion, (String)"/n38/elementos/elemento/parametro[@id='dni']/valor/text()").getNodeValue();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        n38personauid = XPathAPI.selectSingleNode((Node)sesion, (String)"/n38/elementos/elemento/parametro[@id='n38personauid']/valor/text()").getNodeValue();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        n38puestouid = XPathAPI.selectSingleNode((Node)sesion, (String)"/n38/elementos/elemento/parametro[@id='n38puestouid']/valor/text()").getNodeValue();
                    }
                    catch (Exception e) {
                        throw new Y31JanoServiceAccesDeniedException("-------------->" + token + "<--------No se ha suministrado un token de xlnets valido que contenga info relativa a n38crearsesionapp ");
                    }
                    try {
                        n38crearsesionapp = XPathAPI.selectSingleNode((Node)sesion, (String)"/n38/elementos/elemento/parametro[@id='n38crearsesionapp']/valor/text()").getNodeValue();
                    }
                    catch (Exception e) {
                        throw new Y31JanoServiceAccesDeniedException("-------------->" + token + "<--------No se ha suministrado un token de xlnets valido que contenga info relativa a n38crearsesionapp ");
                    }
                }
                catch (NullPointerException e) {
                    throw new Y31JanoServiceAccesDeniedException("No se ha suministrado un token de xlnets valido que contenga info relativa a  n38puestouid personauid o dni los tres valores son nulos <---" + token + " --->" + e.getMessage());
                }
                catch (Exception e) {
                    throw new Y31JanoServiceAccesDeniedException("No se ha suministrado un token de xlnets valido que contenga info relativa a  n38puestouid personauid o dni los tres valores son nulos -->" + token + "<---" + e.getMessage());
                }
                if (n38personauid == null && n38puestouid == null && dni == null) {
                    throw new Y31JanoServiceAccesDeniedException("-------------->" + token + "<--------No se ha suministrado un token de xlnets valido que contenga info relativa a n38puestouid personauid o dni los tres valores son nulos, aunque si que contiene elementos ");
                }
                try {
                    a = new Y31XlnetsInfoBean(n38puestouid, n38personauid, dni, Boolean.valueOf(Boolean.parseBoolean(n38crearsesionapp)));
                }
                catch (Exception e) {
                    throw new Y31JanoServiceAccesDeniedException("No se ha podido crear el objeto de seguridad porquen 38crearsesionapp Boolean.parseBoolean(n38crearsesionapp), es null " + n38crearsesionapp + "\n\n" + token);
                }
            }
            catch (NoClassDefFoundError e) {
                String url = Y31JanoServiceImpl.JANO_REST_END_POINT + "/" + "Y31JanoServiceXlnetsDocumentValidatorServlet" + Y31JanoServiceImpl.JANO_OPERATION_SUFIX;
                PostMethod method = null;
                try {
                    HttpClient client = new HttpClient();
                    method = new PostMethod(url);
                    method.addParameter(new NameValuePair("xlnets_token", token));
                    int statusCode = -1;
                    statusCode = client.executeMethod((HttpMethod)method);
                    if (statusCode != 200) {
                        throw new Y31JanoServiceAccesDeniedException("Error en la comunicacion remota con " + url + " " + method.getStatusLine() + " token suministrado no valido \n" + token);
                    }
                    String responseBody = method.getResponseBodyAsString();
                    a = (Y31XlnetsInfoBean)new JSONDeserializer().use(null, Y31XlnetsInfoBean.class).deserialize(responseBody);
                }
                catch (HttpException e2) {
                    throw new Y31JanoServiceAccesDeniedException((Throwable)e2);
                }
                catch (IOException e2) {
                    throw new Y31JanoServiceAccesDeniedException((Throwable)e2);
                }
                finally {
                    if (method != null) {
                        method.releaseConnection();
                    }
                }
            }
            catch (Exception e) {
                throw new Y31JanoServiceAccesDeniedException((Throwable)e);
            }
        }
        return a;
    }

    public static final Document getUserToken(String user, String password, HttpServletRequest httpRequest) {
        Document d = null;
        try {
            N38APISesion a = new N38APISesion(httpRequest);
            Document dup = a.n38APISesionCrearUP(user, password);
            try {
                Y31JanoServiceSecurityTool.checkSecuritySesionValid(dup);
                d = dup;
            }
            catch (Y31JanoServiceAccesDeniedException e) {
                e.printStackTrace();
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return d;
    }

    public static final Document getAppToken(String user, HttpServletRequest httpRequest) {
        return Y31JanoServiceSecurityTool.getAppToken(user, null, httpRequest);
    }

    public static final Document getAppToken(String user, String password, HttpServletRequest httpRequest) {
        boolean sino = false;
        Document d = null;
        try {
            N38APISesion a = new N38APISesion();
            Document dap = password == null ? a.n38APISesionCrearApp(user) : a.n38APISesionCrearApp(user, password);
            try {
                Y31JanoServiceSecurityTool.checkSecuritySesionValid(dap);
                d = dap;
            }
            catch (Y31JanoServiceAccesDeniedException e) {
                e.printStackTrace();
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return d;
    }

    protected static void validateWriteAccess(String pathTo, Y31XlnetsInfoBean xlnets, FileSystem fs, String token, boolean isTmpToken) throws Y31JanoServiceAccesDeniedException {
        String a = pathTo;
        a = Y31JanoServiceTool.cleanAllPath((String)a);
        if (isTmpToken) {
            SecurityTokenUtil.isWriteabe(SecurityTokenUtil.getToken(token, JANO_OPERATION_SUFIX), null, pathTo);
        } else {
            String[] sa = a.split("/");
            if (sa.length >= 3) {
                String validUsers;
                String pathPattern = "/" + sa[1] + "/" + sa[2];
                FSDataInputStream fsdata = null;
                PropertyResourceBundle r = null;
                try {
                    fsdata = fs.open(new Path("/security/permissions.properties"));
                    r = new PropertyResourceBundle((InputStream)fsdata);
                }
                catch (IOException e) {
                    throw new Y31JanoServiceAccesDeniedException("No se ha podido acceder al fichero de seguridad de hadoop /security/security-rules.properties " + e.getMessage());
                }
                finally {
                    try {
                        if (fsdata != null) {
                            fsdata.close();
                        }
                    }
                    catch (IOException e) {}
                }
                if (r.containsKey(pathPattern) && !(validUsers = r.getString(pathPattern)).contains(xlnets.getN38personauid().toLowerCase())) {
                    throw new Y31JanoServiceAccesDeniedException("Esta intentando depositar un fichero en la carpeta " + pathPattern + " que esta protegia por la regla " + pathPattern + "=" + validUsers);
                }
            }
        }
    }

    public static String getEjieBoxBasePath(Document xlnetsToken) throws Y31JanoServiceAccesDeniedException {
        Y31XlnetsInfoBean infobean = Y31JanoServiceSecurityTool.getXlnetsAuditInfo(xlnetsToken);
        if (infobean.getIsLogginApp().booleanValue()) {
            return "/" + infobean.getN38personauid().toLowerCase();
        }
        return "/user/" + infobean.getN38personauid().toLowerCase();
    }

    public static boolean isAppLogin(Document xlnetsToken) throws Y31JanoServiceAccesDeniedException {
        Y31XlnetsInfoBean infobean = Y31JanoServiceSecurityTool.getXlnetsAuditInfo(xlnetsToken);
        return infobean.getIsLogginApp();
    }

    public static boolean isPersonaLogin(Document xlnetsToken) throws Y31JanoServiceAccesDeniedException {
        return !Y31JanoServiceSecurityTool.isAppLogin(xlnetsToken);
    }

    public static String getEjieBoxLoginName(Document xlnetsToken) throws Y31JanoServiceAccesDeniedException {
        Y31XlnetsInfoBean infobean = Y31JanoServiceSecurityTool.getXlnetsAuditInfo(xlnetsToken);
        if (infobean.getIsLogginApp().booleanValue()) {
            return infobean.getN38personauid();
        }
        return infobean.getN38personauid();
    }

    protected static void validateReadAccess(String pathFrom, Y31XlnetsInfoBean xlnets, String token, boolean isTmpToken) throws Y31JanoServiceAccesDeniedException {
        String a = pathFrom;
        a = Y31JanoServiceTool.cleanAllPath((String)a);
        String camino = a = Y31JanoServiceTool.cleanUserPath((String)a);
        if (camino.length() == 0) {
            camino = "/";
        }
        if (isTmpToken) {
            SecurityTokenUtil.isReadable(SecurityTokenUtil.getToken(token, JANO_OPERATION_SUFIX), null, pathFrom);
        } else {
            String userId = xlnets.getN38personauid();
            ArrayList<Y31JanoServiceAccessRightsBean> permissions = new ArrayList<Y31JanoServiceAccessRightsBean>();
            try {
                String whiteListTxt = (String)properties.get("Y31_WHITELIST");
                String[] accessRule = whiteListTxt.split(",");
                for (int i = 0; i < accessRule.length; ++i) {
                    String[] accessData = accessRule[i].split(";");
                    Y31JanoServiceAccessRightsBean a1 = new Y31JanoServiceAccessRightsBean(accessData[0], accessData[1].toLowerCase());
                    permissions.add(a1);
                }
            }
            catch (Exception e1) {
                System.out.println("No se podido cargar la whitelist de accesos del properties | " + e1.toString());
            }
            for (Y31JanoServiceAccessRightsBean c : permissions) {
                if (!camino.matches("^" + c.getPath() + "|^" + c.getPath() + ".*") || !userId.equalsIgnoreCase(c.getUser())) continue;
                return;
            }
            String s = null;
            int index = camino.indexOf("/", 1);
            if (index < 0) {
                index = camino.length();
            }
            try {
                s = camino.substring(1, index);
            }
            catch (Exception e) {
                throw new Y31JanoServiceAccesDeniedException((Throwable)e);
            }
            if (!s.equalsIgnoreCase(userId)) {
                throw new Y31JanoServiceAccesDeniedException("Esta intentando acceder a un recurso al que no tiene persmisos para acceder recurso,n38puestouid " + camino + "," + xlnets.getN38personauid());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        JANO_OPERATION_SUFIX = "";
        Boolean PRE_STRICT_SECURITY_CHECKER = true;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = Y31JanoServiceImpl.class.getClassLoader();
            }
            InputStream inputStream = null;
            inputStream = cl.getResourceAsStream("w11/com/ejie/y31/service/impl/y31.properties");
            if (inputStream == null) {
                inputStream = cl.getResourceAsStream("y31/y31.properties");
            }
            properties = new Properties();
            try {
                if (inputStream != null) {
                    properties.load(inputStream);
                    if (properties.getProperty("STRICT_SECURITY_CHECKER") != null && properties.getProperty("STRICT_SECURITY_CHECKER").length() > 0) {
                        PRE_STRICT_SECURITY_CHECKER = Boolean.parseBoolean(properties.getProperty("STRICT_SECURITY_CHECKER"));
                    }
                    if (properties.getProperty("JANO_OPERATION_SUFIX") != null && properties.getProperty("JANO_OPERATION_SUFIX").length() > 0) {
                        JANO_OPERATION_SUFIX = properties.getProperty("JANO_OPERATION_SUFIX");
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            STRICT_SECURITY_CHECKER = PRE_STRICT_SECURITY_CHECKER;
        }
    }
}

