/*
 * Decompiled with CFR 0.152.
 */
package w11.com.ejie.y31.api.securitytoken;

import com.ejie.y31.exception.Y31JanoServiceAccesDeniedException;
import com.ejie.y31.exception.Y31JanoServiceDestinationPathException;
import com.ejie.y31.exception.Y31JanoServiceEventJmsException;
import com.ejie.y31.exception.Y31JanoServiceFileAlreadyExistException;
import com.ejie.y31.exception.Y31JanoServiceFileNameFormatException;
import com.ejie.y31.exception.Y31JanoServiceFileNotFoundException;
import com.ejie.y31.exception.Y31JanoServiceGenericException;
import com.ejie.y31.exception.Y31JanoServiceMongoDbGenericException;
import com.ejie.y31.exception.Y31JanoServiceTraceJmsException;
import com.ejie.y31.exception.Y31RemoteExceptionAbstractFactory;
import com.ejie.y31.service.Y31JanoServiceTool;
import com.ejie.y31.vo.Y31SecurityTmpToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import w11.com.ejie.y31.service.impl.Y31JanoServiceImpl;

public class SecurityTokenUtil {
    private static DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    public static final String JANO_REST_GET_TMP_TOKEN_OPERATION = "Y31JanoServiceGetTokenServlet";
    public static final String HTTP_UUID_PARAM_NAME = "hadoop_uuid_tmp_token";

    public static String xlnetsToken2String(Document token) throws Y31JanoServiceAccesDeniedException {
        OutputFormat format = new OutputFormat(token);
        StringWriter stringOut = new StringWriter();
        XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
        try {
            serial.serialize(token);
        }
        catch (IOException e) {
            throw new Y31JanoServiceAccesDeniedException((Throwable)e);
        }
        return stringOut.toString();
    }

    public static Document xlnetsToken2Document(String token) throws Y31JanoServiceAccesDeniedException {
        Document d = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            d = db.parse(new ByteArrayInputStream(token.getBytes()));
        }
        catch (Exception e) {
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                d = db.parse(new ByteArrayInputStream(token.getBytes("UTF-8")));
            }
            catch (Exception e2) {
                try {
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    d = db.parse(new ByteArrayInputStream(token.getBytes("ISO-8859-1")));
                }
                catch (Exception e3) {
                    throw new Y31JanoServiceAccesDeniedException("No se ha suministrado un token valido " + token);
                }
            }
        }
        return d;
    }

    public static String xlnetsDocument2Token(Document document) throws Y31JanoServiceAccesDeniedException {
        OutputFormat format = new OutputFormat(document);
        StringWriter stringOut = new StringWriter();
        XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
        try {
            serial.serialize(document);
        }
        catch (IOException e) {
            throw new Y31JanoServiceAccesDeniedException((Throwable)e);
        }
        return stringOut.toString();
    }

    public static String getUUID() {
        UUID uuid = UUID.randomUUID();
        return String.valueOf(uuid);
    }

    public static void isReadable(Y31SecurityTmpToken st, String action, String path) throws Y31JanoServiceAccesDeniedException {
        String path2 = Y31JanoServiceTool.cleanAllPath((String)path);
        Pattern p = Pattern.compile("^" + st.getPathFrom() + ".*$");
        Matcher m = p.matcher(path2);
        if (!m.matches()) {
            throw new Y31JanoServiceAccesDeniedException("El token suministrado no es v\u00c3\u00a1lido " + st.toString() + " para leer de " + path2);
        }
    }

    public static void isWriteabe(Y31SecurityTmpToken st, String action, String path) throws Y31JanoServiceAccesDeniedException {
        String path2 = Y31JanoServiceTool.cleanAllPath((String)path);
        Pattern p = Pattern.compile("^" + st.getPathTo() + ".*$");
        Matcher m = p.matcher(path2);
        if (!m.matches()) {
            throw new Y31JanoServiceAccesDeniedException("El token suministrado no es v\u00c3\u00a1lido " + st.toString() + " para escribir en " + path2);
        }
    }

    public static void main(String[] args) {
        String pathTo = "^/t17i/upload-test/.*$";
        String path = "/t17i/upload-test/putty.exe";
        Pattern p = Pattern.compile(pathTo);
        Matcher m = p.matcher(path);
    }

    public static String document2String(Document xml) throws Y31JanoServiceAccesDeniedException {
        OutputFormat format = new OutputFormat(xml);
        StringWriter stringOut = new StringWriter();
        XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
        try {
            serial.serialize(xml);
        }
        catch (IOException e) {
            throw new Y31JanoServiceAccesDeniedException((Throwable)e);
        }
        return stringOut.toString();
    }

    public static Y31SecurityTmpToken getToken(String uuid, String sufix) throws Y31JanoServiceAccesDeniedException {
        Y31SecurityTmpToken a;
        block20: {
            String url = Y31JanoServiceImpl.JANO_REST_END_POINT + "/" + JANO_REST_GET_TMP_TOKEN_OPERATION + sufix;
            HttpClient client = new HttpClient();
            PostMethod method = new PostMethod(url);
            int statusCode = -1;
            Y31SecurityTmpToken bean = null;
            a = null;
            boolean success = true;
            String errorMessge = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(baos, true);
            try {
                method = new PostMethod(url);
                method.addParameter(HTTP_UUID_PARAM_NAME, uuid);
                statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode != 200) {
                    success = false;
                    errorMessge = "Error en la comunicacion remota con " + url + " " + method.getStatusLine();
                    try {
                        String ccc = null;
                        if (method.getResponseHeader("HTTP_ERROR_CODE_TRANSLATE") != null) {
                            ccc = method.getResponseHeader("HTTP_ERROR_CODE_TRANSLATE").getValue();
                        }
                        Y31RemoteExceptionAbstractFactory.buildException((int)statusCode, (String)method.getResponseBodyAsString(), (String)ccc);
                        break block20;
                    }
                    catch (Y31JanoServiceDestinationPathException e) {
                        throw new Y31JanoServiceAccesDeniedException((Throwable)e);
                    }
                    catch (Y31JanoServiceFileAlreadyExistException e) {
                        throw new Y31JanoServiceAccesDeniedException((Throwable)e);
                    }
                    catch (Y31JanoServiceTraceJmsException e) {
                        throw new Y31JanoServiceAccesDeniedException((Throwable)e);
                    }
                    catch (Y31JanoServiceFileNotFoundException e) {
                        throw new Y31JanoServiceAccesDeniedException((Throwable)e);
                    }
                    catch (Y31JanoServiceEventJmsException e) {
                        throw new Y31JanoServiceAccesDeniedException((Throwable)e);
                    }
                    catch (Y31JanoServiceMongoDbGenericException e) {
                        throw new Y31JanoServiceAccesDeniedException((Throwable)e);
                    }
                    catch (Y31JanoServiceFileNameFormatException e) {
                        throw new Y31JanoServiceAccesDeniedException((Throwable)e);
                    }
                    catch (Y31JanoServiceGenericException e) {
                        throw new Y31JanoServiceAccesDeniedException((Throwable)e);
                    }
                }
                String responseBody = method.getResponseBodyAsString();
                JSONObject jsonObject = (JSONObject)JSONSerializer.toJSON((Object)responseBody);
                JsonConfig jsonConfig = new JsonConfig();
                jsonConfig.setRootClass(Y31SecurityTmpToken.class);
                bean = (Y31SecurityTmpToken)JSONSerializer.toJava((JSON)jsonObject, (JsonConfig)jsonConfig);
            }
            catch (HttpException e) {
                success = false;
                e.printStackTrace(pw);
                throw new Y31JanoServiceAccesDeniedException((Throwable)e);
            }
            catch (IOException e) {
                success = false;
                e.printStackTrace(pw);
                throw new Y31JanoServiceAccesDeniedException((Throwable)e);
            }
            catch (Y31JanoServiceAccesDeniedException e) {
                e.printStackTrace(pw);
                success = false;
                throw new Y31JanoServiceAccesDeniedException((Throwable)e);
            }
            finally {
                method.releaseConnection();
                if (!success && errorMessge == null) {
                    errorMessge = ((Object)baos).toString();
                }
                if (bean != null) {
                    a = bean;
                }
            }
        }
        return a;
    }
}

