/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.w43ta.metrics;

import com.ejie.w43ta.clients.W43taMomoTraceClient;
import com.ejie.w43ta.exceptions.MomoClientRuntimeException;
import com.ejie.w43ta.pojo.httpclient.utils.AvroBinaryHttpEntity;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class W43taMetricHttpClient {
    private ExecutorService pool;
    private String serviceEndPoint;
    private int port;
    private int poolSize;
    private boolean islocal;
    private String token;
    private String service;
    private CloseableHttpClient httpClient;
    private static final String SERVICE_PATH_PREFIX = "/w43taMetricApiWAR/metricservice/sync/avro";
    private static final String SERVICE_PATH_SUFFIX = "add";
    private static final String SERVICE_PROTOCOL = "http";
    private static W43taMetricHttpClient singleton = null;

    private W43taMetricHttpClient(String service, String token, String serviceEndPoint, int port, boolean islocal) {
        this.islocal = islocal;
        this.poolSize = 10;
        if (islocal) {
            this.poolSize = 2;
        }
        this.token = token;
        this.service = service;
        try {
            this.setPool(serviceEndPoint, port);
        }
        catch (MalformedURLException e) {
            throw new MomoClientRuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new MomoClientRuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new MomoClientRuntimeException(e);
        }
    }

    public static synchronized W43taMetricHttpClient getInstance(String service, String token, String serviceEndPoint, int port, boolean islocal) {
        if (singleton == null) {
            singleton = new W43taMetricHttpClient(service, token, serviceEndPoint, port, islocal);
        }
        return singleton;
    }

    private void setPool(String server, int port) throws MalformedURLException, InterruptedException, ExecutionException {
        this.pool = Executors.newFixedThreadPool(this.poolSize);
        this.serviceEndPoint = server;
        this.port = port;
        if (!this.islocal) {
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
            SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(false).setSoTimeout(1000).setSoKeepAlive(true).setSoLinger(1000).setSoReuseAddress(true).build();
            cm.setMaxTotal(20);
            cm.setDefaultMaxPerRoute(15);
            cm.setDefaultSocketConfig(socketConfig);
            HttpHost serverHost = new HttpHost(this.serviceEndPoint, port);
            cm.setMaxPerRoute(new HttpRoute(serverHost), 15);
            this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        }
    }

    public void asyncSend(byte[] message, W43taMomoTraceClient.METRIC_TYPE metricType) {
        try {
            if (!this.islocal) {
                Future<Integer> a = this.futureSendApacheHttp(message, metricType);
            }
        }
        catch (IOException e) {
            throw new MomoClientRuntimeException(e);
        }
    }

    private Future<Integer> futureSendApacheHttp(final byte[] avroMessageBytes, final W43taMomoTraceClient.METRIC_TYPE metricType) throws IOException {
        return this.pool.submit(new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws Exception {
                CloseableHttpResponse response;
                int i;
                block9: {
                    i = -1;
                    response = null;
                    HttpEntity entity = null;
                    String url = "http://" + W43taMetricHttpClient.this.serviceEndPoint + ":" + W43taMetricHttpClient.this.port + W43taMetricHttpClient.SERVICE_PATH_PREFIX + "/" + metricType.toString().toLowerCase() + "/" + W43taMetricHttpClient.SERVICE_PATH_SUFFIX;
                    HttpPost httpost = new HttpPost(url);
                    HttpClientContext context = HttpClientContext.create();
                    try {
                        httpost.setEntity((HttpEntity)new AvroBinaryHttpEntity(avroMessageBytes));
                        response = W43taMetricHttpClient.this.httpClient.execute((HttpUriRequest)httpost, (HttpContext)context);
                        entity = response.getEntity();
                        i = response.getStatusLine().getStatusCode();
                        if (i != 204 && i != 200) {
                            System.out.println("TA: Error al realizar el env\u00c3\u00ado de la petci\u00c3\u00b3n al servicio de metricas httpcode=" + i + " url " + url);
                        }
                        if (entity == null) break block9;
                    }
                    catch (Exception e) {
                        block10: {
                            try {
                                System.out.println("TA: Error al realizar el env\u00c3\u00ado de la petci\u00c3\u00b3n al servicio de metricas " + e.getMessage() + " url " + url);
                                if (entity == null) break block10;
                            }
                            catch (Throwable throwable) {
                                if (entity != null) {
                                    EntityUtils.consume(entity);
                                }
                                if (response != null) {
                                    response.close();
                                }
                                throw throwable;
                            }
                            EntityUtils.consume((HttpEntity)entity);
                        }
                        if (response != null) {
                            response.close();
                        }
                    }
                    EntityUtils.consume((HttpEntity)entity);
                }
                if (response != null) {
                    response.close();
                }
                return i;
            }
        });
    }
}

