/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.y31.vo;

import com.ejie.y31.service.Y31JanoServiceTool;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Y31AttachmentBean
implements Serializable {
    private String originalFileName;
    private String fileName;
    private String filePath;
    private String contentType;
    private Map attributes = new HashMap();
    private Long size;
    private Long ttl = new Long(-1L);
    private boolean success = true;
    private boolean directory = false;
    private boolean readPermission = false;
    private boolean writePermission = false;
    private boolean deletePermission = false;
    private Date creationDate = null;
    private Date modificationDate = null;
    private boolean hasSubDirs = false;
    private String userData;
    private static String ONLINE_EDIT_BASE_URL;
    public static final String Y31_EDIT_ON_LINE_BASE_URL = "Y31_EDIT_ON_LINE_BASE_URL";

    public Y31AttachmentBean() {
    }

    public Y31AttachmentBean(String fileName, String filePath, String contentType, Long size, Long ttl, Map attributes, boolean directory, boolean read, boolean write, boolean delete, Date creationDate, Date modificationDate, String userData, boolean hasSubDirs, String originalPath) {
        this.userData = userData != null ? userData : "n/a";
        this.originalFileName = originalPath != null ? Y31JanoServiceTool.cleanDataPath(originalPath) : "n/a";
        this.fileName = fileName != null ? Y31JanoServiceTool.cleanDataPath(fileName) : null;
        this.filePath = filePath != null ? Y31JanoServiceTool.cleanDataPath(filePath) : null;
        this.contentType = contentType;
        this.size = size;
        if (attributes != null) {
            this.attributes = attributes;
        }
        this.ttl = ttl;
        this.success = true;
        this.directory = directory;
        this.readPermission = read;
        this.writePermission = write;
        this.deletePermission = delete;
        this.creationDate = creationDate;
        this.modificationDate = modificationDate;
        this.hasSubDirs = hasSubDirs;
    }

    public String getOriginalFileNameISO8859() {
        return this.getOriginalFileName("ISO-8859-1");
    }

    public String getOriginalFileName(String encoding) {
        try {
            if (this.getOriginalFileName() != null) {
                return new String(this.getOriginalFileName().getBytes("UTF-8"), encoding);
            }
            return this.filePath;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return this.filePath;
        }
    }

    public String getOnlineEditUrl() {
        if (!this.getFilePath().startsWith("/user/")) {
            return "n/a";
        }
        String s = "spif://" + ONLINE_EDIT_BASE_URL + this.getFilePath();
        return s;
    }

    public String getSharedDownloadUrl() {
        return this.getSharedDownloadUrl("");
    }

    public String getSharedDownloadUrl(String tmpToken) {
        String s = "https://" + ONLINE_EDIT_BASE_URL.replace("y31dWebDavUserWAR", "y31ApiJSWAR/Y31JanoServiceGetServlet") + "?" + "hadoop_file_path" + "=" + this.getFilePath() + "&" + "xlnets_token" + "=" + tmpToken;
        return s;
    }

    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String userName) {
        this.userData = userName == null ? "n/a" : userName;
    }

    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public void setOriginalFileName(String originalFileName) {
        this.originalFileName = originalFileName == null ? "n/a" : originalFileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map attributes) {
        this.attributes = attributes;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setfileName(String fileName) {
        this.fileName = fileName;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
    }

    public boolean isReadPermission() {
        return this.readPermission;
    }

    public void setReadPermission(boolean readPermission) {
        this.readPermission = readPermission;
    }

    public boolean isWritePermission() {
        return this.writePermission;
    }

    public void setWritePermission(boolean writePermission) {
        this.writePermission = writePermission;
    }

    public boolean isDeletePermission() {
        return this.deletePermission;
    }

    public void setDeletePermission(boolean deletePermission) {
        this.deletePermission = deletePermission;
    }

    public Long getTtl() {
        return this.ttl;
    }

    public void setTtl(Long ttl) {
        this.ttl = ttl;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean getHasSubDirs() {
        return this.hasSubDirs;
    }

    public boolean hasSubDirs() {
        return this.hasSubDirs;
    }

    public void setHasSubDirs(boolean hasSubDirs) {
        this.hasSubDirs = hasSubDirs;
    }

    public boolean equals(Object o) {
        if (o instanceof Y31AttachmentBean) {
            return ((Y31AttachmentBean)o).getFilePath().equals(this.getFilePath());
        }
        return false;
    }

    public int hashCode() {
        return this.filePath.hashCode();
    }

    public String toString() {
        StringBuffer txt = new StringBuffer();
        txt.append(this.getFilePath());
        return txt.toString();
    }

    static {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = Y31AttachmentBean.class.getClassLoader();
        }
        InputStream inputStream = null;
        inputStream = cl.getResourceAsStream("w11/com/ejie/y31/service/impl/y31.properties");
        if (inputStream == null) {
            inputStream = cl.getResourceAsStream("y31/y31.properties");
        }
        Properties properties = new Properties();
        try {
            if (inputStream != null) {
                properties.load(inputStream);
                if (properties.getProperty(Y31_EDIT_ON_LINE_BASE_URL) != null && properties.getProperty(Y31_EDIT_ON_LINE_BASE_URL).length() > 0) {
                    ONLINE_EDIT_BASE_URL = properties.getProperty(Y31_EDIT_ON_LINE_BASE_URL);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

