/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.y31.util.servlet;

import com.ejie.y31.exception.Y31JanoServiceAccesDeniedException;
import com.ejie.y31.exception.Y31JanoServiceFileNameFormatException;
import com.ejie.y31.exception.Y31JanoServiceFileNotFoundException;
import com.ejie.y31.exception.Y31JanoServiceGenericException;
import com.ejie.y31.exception.Y31JanoServiceMongoDbGenericException;
import com.ejie.y31.exception.Y31JanoServiceOracleGenericException;
import com.ejie.y31.factory.Y31JanoServiceAbstractFactory;
import com.ejie.y31.service.Y31JanoService;
import com.ejie.y31.vo.Y31AttachmentBean;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;

public abstract class Y31JanoServiceDownloadAbstractServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public abstract Document getXlnetToken(HttpServletRequest var1) throws Y31JanoServiceGenericException;

    public abstract boolean checkSecurity(HttpServletRequest var1) throws Y31JanoServiceGenericException;

    public abstract String getDownloadFilePath(HttpServletRequest var1) throws Y31JanoServiceGenericException;

    public void onAccessAccesDeniedException(HttpServletRequest request, HttpServletResponse response) {
        response.setStatus(403);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block26: {
            long l0 = System.currentTimeMillis();
            try {
                this.prepare(request, response);
            }
            catch (Y31JanoServiceFileNotFoundException e) {
                e.printStackTrace();
                response.setStatus(518);
            }
            catch (Y31JanoServiceGenericException e1) {
                e1.printStackTrace();
                response.setStatus(523);
            }
            catch (Y31JanoServiceAccesDeniedException e) {
                e.printStackTrace();
                response.setStatus(401);
            }
            try {
                if (this.checkSecurity(request)) {
                    ServletOutputStream out = null;
                    try {
                        out = response.getOutputStream();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        response.setStatus(500);
                    }
                    String path = this.getDownloadFilePath(request);
                    InputStream is = null;
                    try {
                        is = Y31JanoServiceAbstractFactory.getInstance().get(this.getXlnetToken(request), path);
                        IOUtils.copy((InputStream)is, (OutputStream)out);
                    }
                    catch (Y31JanoServiceGenericException e) {
                        e.printStackTrace();
                        response.setStatus(523);
                    }
                    catch (Y31JanoServiceFileNameFormatException e) {
                        response.setStatus(517);
                        e.printStackTrace();
                    }
                    catch (Y31JanoServiceFileNotFoundException e) {
                        response.setStatus(518);
                        e.printStackTrace();
                    }
                    catch (Y31JanoServiceMongoDbGenericException e) {
                        response.setStatus(520);
                        e.printStackTrace();
                    }
                    catch (Y31JanoServiceOracleGenericException e) {
                        response.setStatus(521);
                        e.printStackTrace();
                    }
                    catch (Y31JanoServiceAccesDeniedException e) {
                        this.onAccessAccesDeniedException(request, response);
                        e.printStackTrace();
                    }
                    finally {
                        if (is != null) {
                            is.close();
                            out.flush();
                            out.close();
                            response.setStatus(200);
                        }
                    }
                    long l1 = System.currentTimeMillis();
                    break block26;
                }
                response.setStatus(403);
            }
            catch (Y31JanoServiceGenericException e) {
                e.printStackTrace();
                response.setStatus(523);
            }
        }
    }

    protected static String getMimeTypeFromCompletePath(String path) throws Y31JanoServiceFileNameFormatException {
        File f = new File(path);
        String m = new MimetypesFileTypeMap().getContentType(f);
        return m;
    }

    public void prepare(HttpServletRequest request, HttpServletResponse response) throws Y31JanoServiceGenericException, Y31JanoServiceAccesDeniedException, Y31JanoServiceFileNotFoundException {
        Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();
        try {
            Y31AttachmentBean attachment = service.info(this.getXlnetToken(request), this.getDownloadFilePath(request));
            response.setHeader("Content-Length", String.valueOf(attachment.getSize()));
            response.setContentType(attachment.getContentType());
        }
        catch (Y31JanoServiceFileNameFormatException e) {
            e.printStackTrace();
            throw new Y31JanoServiceGenericException(e);
        }
        catch (Y31JanoServiceMongoDbGenericException e) {
            e.printStackTrace();
            throw new Y31JanoServiceGenericException(e);
        }
        catch (Y31JanoServiceAccesDeniedException e) {
            e.printStackTrace();
            throw e;
        }
        response.setHeader("Content-disposition", "attachment; filename=" + this.downloadName(this.getDownloadFilePath(request)));
    }

    private String downloadName(String path) {
        return path.substring(path.lastIndexOf("/") + 1, path.length());
    }
}

