package com.gfi.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Agrupa utilidades especificas de parte WEB.
 * 
 * @author Jorge_Hidalgo
 * 
 */
public class UtilWeb {
	private static final Logger logger = LoggerFactory.getLogger(UtilWeb.class);

	private static final String DEFAULT_CONTENTTYPE = "application/octet-stream";
	private static final int LENGTH_AVG_TRAZA = 128;

	/**
	 * Constructor privado sin parametros
	 */
	private UtilWeb() {
	}

	/**
	 * Carga un archivo en la response, para que se pueda descargar desde el
	 * navegador. Acepta definicion de cookie para descarga ajax.
	 * 
	 * @param filename
	 *            String
	 * @param contenttype
	 *            String
	 * @param size
	 *            long
	 * @param inputcontent
	 *            InputStream
	 * @param response
	 *            HttpServletResponse
	 * @param cookie
	 *            String (Ej.: "ajaxDownloadFile=true; path=/")
	 * @throws IOException
	 *             e
	 */
	public static void downloadFile(String filename, String contenttype,
			long size, InputStream inputcontent, HttpServletResponse response,
			String cookie) throws IOException {
		if (UtilWeb.logger.isTraceEnabled()) {
			final String sT = ", ";
			StringBuilder traza = new StringBuilder(UtilWeb.LENGTH_AVG_TRAZA);
			traza.append("downloadFile [");
			traza.append(filename).append(sT);
			traza.append(contenttype).append(sT);
			traza.append(size).append(sT);
			traza.append(inputcontent).append(sT);
			traza.append(response).append("]");
			UtilWeb.logger.trace(traza.toString());
		}
		if (size != 0) {
			response.addHeader("Content-Length", Long.toString(size));
		}

		if (!Utilities.isEmpty(contenttype)) {
			response.setContentType(contenttype);
		} else {
			response.setContentType(UtilWeb.DEFAULT_CONTENTTYPE);
		}
		response.setHeader(
				"Content-Disposition",
				new StringBuilder().append("attachment; filename=\"")
						.append(filename).append("\"").toString());

		// Cookie para descarga Ajax
		if (Utilities.isEmpty(cookie)) {
			response.setHeader("Set-Cookie", cookie);
		}
		if (inputcontent != null) {
			UtilFiles.stream(inputcontent, response.getOutputStream());
		}
	}

	/**
	 * Recoge el valor de un parametro de la request que acaba con el nombre
	 * especifiado.<br/>
	 * Util para objetos que pueden ser atributos de varios objetos a la vez.
	 * 
	 * @param paramNameEnding
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	public static String getRequestParamEndsLike(String paramNameEnding,
			HttpServletRequest request) {
		String resultado = null;
		@SuppressWarnings(value = "unchecked")
		Enumeration<String> parameters = request.getParameterNames();
		String auxName;
		while (parameters.hasMoreElements() && resultado == null) {
			auxName = parameters.nextElement();
			if (auxName.endsWith(paramNameEnding)) {
				resultado = request.getParameter(auxName);
			}
		}
		return resultado;
	}
}
