package com.gfi.utils;

import java.math.BigInteger;
import java.security.SecureRandom;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Almacena utilidades relacionadas con la seguridad de una aplicacion.
 * 
 * @author GFI-NORTE
 * 
 */
public class UtilSecurity {
	private static final Logger logger = LoggerFactory
			.getLogger(UtilSecurity.class);

	/**
	 * Constructor privado
	 */
	private UtilSecurity() {
	}

	/**
	 * Genera una cadena alfanumerica aleatoria, con la longitud deseada.<br/>
	 * Utiliza la clase {@link SecureRandom}.
	 * 
	 * @param length
	 *            Numero de caracteres de la cadena.
	 * @return String
	 */
	public static String randomString(int length) {
		UtilSecurity.logger.trace("randomString {}", length);
		int bits = length * BITS_BY_CHAR;
		BigInteger b = new BigInteger(bits, SEC_RANDOM);
		String result = b.toString(SEC_RANDOM_CHARS);
		if (UtilSecurity.logger.isTraceEnabled()) {
			UtilSecurity.logger.trace("randomString, resultado: {}", result);
		}
		return result;
	}

	private static final SecureRandom SEC_RANDOM = new SecureRandom();
	private static final int BITS_BY_CHAR = 5;
	private static final int SEC_RANDOM_CHARS = 32;// Alfanumeric string
}
