package com.gfi.utils;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

import com.gfi.constants.Constants;

/**
 * Agrupa utilidades para el manejo de fechas
 * 
 * @author GFI-NORTE
 * 
 */
public class UtilDate {

	private static final Logger logger = LoggerFactory
			.getLogger(UtilDate.class);

	/**
	 * Constructor privado
	 */
	private UtilDate() {
	}

	private static final Calendar CALENDAR = Calendar.getInstance();

	/**
	 * Obtiene el formatter de fecha, correspondiente al idioma en curso.
	 * 
	 * @param isDateTime
	 *            boolean
	 * @return DateFormat
	 */
	public static DateFormat getDateFormatter(boolean isDateTime) {
		DateFormat df = isDateTime ? Constants.DATETIME_FORMATTERS
				.get(LocaleContextHolder.getLocale().getLanguage())
				: Constants.DATE_FORMATTERS.get(LocaleContextHolder.getLocale()
						.getLanguage());
		return df != null ? df : (isDateTime ? Constants.DATETIME_FORMATTERS
				.get(Constants.ES) : Constants.DATE_FORMATTERS
				.get(Constants.ES));
	}

	/**
	 * Funcion que encapsula la obtencion de la fecha actual del sistema
	 * 
	 * @return Date
	 */
	public static Date currentDate() {
		Date result = UtilDate.CALENDAR.getTime();
		UtilDate.logger.trace("currentDate, resultado: {}", result);
		return result;
	}
}