package com.gfi.spring;

import javax.annotation.Resource;

import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/**
 * Clase para obtener el contexto de Spring y asi poder obtener instancias
 * dinamicamente
 * 
 * @author GFI-Norte
 * 
 */
@Resource
public class ApplicationContextProvider implements ApplicationContextAware {

	private static ApplicationContext context;

	/**
	 * Obtiene el contexto de la aplicacion para poder instanciar nuevos beans
	 * 
	 * @return contexto de la aplicacion
	 */
	public static ApplicationContext getApplicationContext() {
		return ApplicationContextProvider.context;
	}

	/**
	 * Recupera un bean del contexto de Spring.
	 * 
	 * @param <T>
	 *            Tipo del bean que se quiere recuperar
	 * @param clazz
	 *            Clase del bean que se quiere recuperar
	 * @return Bean del contexto de Spring
	 */
	public static <T> T getBean(Class<T> clazz) {
		return ApplicationContextProvider.context.getBean(clazz);
	}

	/**
	 * Recupera un bean del contexto de Spring.
	 * 
	 * @param beanName
	 *            nombre del bean que se quiere recuperar
	 * @return Bean del contexto de Spring
	 */
	public static Object getBean(String beanName) {
		return ApplicationContextProvider.context.getBean(beanName);
	}

	@Override
	public void setApplicationContext(ApplicationContext ctx) {
		ApplicationContextProvider.context = ctx;
	}
}