package com.gfi.serializer;

import java.io.IOException;
import java.math.BigDecimal;

import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

import com.gfi.constants.Constants;
import com.gfi.utils.Utilities;

/**
 * JsonImporteSerializer.
 * 
 * @author GFI
 */
public class JsonImporteSerializer extends JsonSerializer<BigDecimal> {

	/**
	 * Serializador para importes. Siempre serializa importes con dos decimales.
	 * 
	 * @param importe
	 *            BigDecimal
	 * @param jsonGenerator
	 *            JsonGenerator
	 * @param paramSerializerProvider
	 *            SerializerProvider
	 * @throws IOException
	 *             e
	 * @throws JsonProcessingException
	 *             e
	 * 
	 */
	public void serialize(BigDecimal importe, JsonGenerator jsonGenerator,
			SerializerProvider paramSerializerProvider) throws IOException,
			JsonProcessingException {
		jsonGenerator.writeString(Utilities.formatImporteToString(importe,
				Constants.DECIMALES_EURO));
	}
}