package com.gfi.serializer;

import java.io.IOException;
import java.math.BigDecimal;

import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;

import com.gfi.utils.Utilities;

/**
 * JsonBigDecimalDeserializer.
 * 
 * @author GFI
 */
public class JsonImporteDeserializer extends JsonDeserializer<BigDecimal> {

	/**
	 * DesSerializador para importes.
	 * 
	 * @param jsonParser
	 *            JsonParser
	 * @param ctx
	 *            DeserializationContext
	 * @return BigDecimal
	 * @throws IOException
	 *             e
	 * @throws JsonProcessingException
	 *             e
	 * 
	 */
	public BigDecimal deserialize(JsonParser jsonParser,
			DeserializationContext ctx) throws IOException,
			JsonProcessingException {
		return Utilities.formatStringToImporte(jsonParser.getText());
	}
}