package com.gfi.constants;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/**
 * Agrupa las constantes basicas de las utilidades
 * 
 * @author GFI-NORTE
 */
public class Constants {

	/**
	 * Constructor protected
	 */
	protected Constants() {
		super();
	}

	public static final String UTF8 = "UTF-8";
	public static final String ISO_8859_1 = "ISO-8859-1";

	// Constantes para el Idioma
	public static final String EU = com.ejie.x38.util.Constants.EUSKARA;
	public static final String ES = com.ejie.x38.util.Constants.CASTELLANO;
	public static final Locale LOCALE_ES = new Locale(Constants.ES, "", "");
	public static final Locale LOCALE_EU = new Locale(Constants.EU, "", "");

	// Formatters por idioma: Map(language, dateFormat)
	public static final Map<String, DateFormat> DATE_FORMATTERS = new HashMap<String, DateFormat>();
	public static final Map<String, DateFormat> DATETIME_FORMATTERS = new HashMap<String, DateFormat>();
	static {
		// Formatters de fechas
		Constants.DATE_FORMATTERS.put(Constants.ES, new SimpleDateFormat(
				"dd/MM/yyyy", Constants.LOCALE_ES));
		Constants.DATE_FORMATTERS.put(Constants.EU, new SimpleDateFormat(
				"yyyy/MM/dd", Constants.LOCALE_EU));
		Constants.DATETIME_FORMATTERS.put(Constants.ES, new SimpleDateFormat(
				"dd/MM/yyyy HH:mm", Constants.LOCALE_ES));
		Constants.DATETIME_FORMATTERS.put(Constants.EU, new SimpleDateFormat(
				"yyyy/MM/dd HH:mm", Constants.LOCALE_EU));
	}

	// StringBuilder Initilization Value
	public static final int STRING_BUILDER_INIT = 4096;

	// Separadores de los Importes
	public static final String SEPARADOR_MILES = ".";
	public static final String SEPARADOR_DECIMALES = ",";
	// Decimales de los Importes
	public static final int DECIMALES_EURO = 2;
}