/*
 * Decompiled with CFR 0.152.
 */
package com.softwarefactory.reporting.core.jasper;

import com.softwarefactory.reporting.core.jasper.JasperReportService;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JasperReportServiceImpl
implements JasperReportService {
    private static final Logger logger = LoggerFactory.getLogger(JasperReportServiceImpl.class);

    @Override
    public void generateDocFromJrxmlFile(Map<String, Object> reportMap, List<?> reportModel, InputStream template, OutputStream out) throws Exception {
        this.generateDocxFromJrxmlFile(reportMap, reportModel, template, out);
    }

    @Override
    public void generateDocFromJrxmlFile(Map<String, Object> reportMap, List<?> reportModel, List<InputStream> templates, OutputStream out) throws Exception {
        this.generateDocxFromJrxmlFile(reportMap, reportModel, templates, out);
    }

    @Override
    public void generateRtfFromJrxmlFile(Map<String, Object> reportMap, List<?> reportModel, InputStream template, OutputStream out) throws Exception {
        JRRtfExporter exporter = new JRRtfExporter();
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.configureJasperPrint(reportMap, reportModel, template, out, false)));
        exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput(out));
        exporter.exportReport();
    }

    @Override
    public void generateRtfFromJrxmlFile(Map<String, Object> reportMap, List<?> reportModel, List<InputStream> templates, OutputStream out) throws Exception {
        JRRtfExporter exporter = new JRRtfExporter();
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.configureJasperPrint(reportMap, reportModel, templates, out, false)));
        exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput(out));
        exporter.exportReport();
    }

    @Override
    public void generateDocxFromJrxmlFile(Map<String, Object> reportMap, List<?> reportModel, InputStream template, OutputStream out) throws Exception {
        JRDocxExporter exporter = new JRDocxExporter();
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.configureJasperPrint(reportMap, reportModel, template, out, false)));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(out));
        exporter.exportReport();
    }

    @Override
    public void generateDocxFromJrxmlFile(Map<String, Object> reportMap, List<?> reportModel, List<InputStream> templates, OutputStream out) throws Exception {
        JRDocxExporter exporter = new JRDocxExporter();
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.configureJasperPrint(reportMap, reportModel, templates, out, false)));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(out));
        exporter.exportReport();
    }

    @Override
    public void generateXlsFromJrxmlFile(Map<String, Object> reportMap, List<?> reportModel, InputStream template, OutputStream out) throws Exception {
        JRXlsExporter exporter = new JRXlsExporter();
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.configureJasperPrint(reportMap, reportModel, template, out, false)));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(out));
        exporter.exportReport();
    }

    @Override
    public void generateXlsFromJrxmlFile(Map<String, Object> reportMap, List<?> reportModel, List<InputStream> templates, OutputStream out) throws Exception {
        JRXlsExporter exporter = new JRXlsExporter();
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.configureJasperPrint(reportMap, reportModel, templates, out, false)));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(out));
        exporter.exportReport();
    }

    @Override
    public void generateXlsxFromJrxmlFile(Map<String, Object> reportMap, List<?> reportModel, InputStream template, OutputStream out) throws Exception {
        JRXlsxExporter exporter = new JRXlsxExporter();
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.configureJasperPrint(reportMap, reportModel, template, out, false)));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(out));
        exporter.exportReport();
    }

    @Override
    public void generateXlsxFromJrxmlFile(Map<String, Object> reportMap, List<?> reportModel, List<InputStream> templates, OutputStream out) throws Exception {
        JRXlsxExporter exporter = new JRXlsxExporter();
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.configureJasperPrint(reportMap, reportModel, templates, out, false)));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(out));
        exporter.exportReport();
    }

    @Override
    public void generatePdfFromJrxmlFile(Map<String, Object> reportMap, List<?> reportModel, InputStream template, OutputStream out) throws Exception {
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.configureJasperPrint(reportMap, reportModel, template, out, false)));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(out));
        exporter.exportReport();
    }

    @Override
    public void generatePdfFromJrxmlFile(Map<String, Object> reportMap, List<?> reportModel, List<InputStream> templates, OutputStream out) throws Exception {
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.configureJasperPrint(reportMap, reportModel, templates, out, false)));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(out));
        exporter.exportReport();
    }

    @Override
    public void generateDocFromJasperFile(Map<String, Object> reportMap, List<?> reportModel, InputStream template, OutputStream out) throws Exception {
        this.generateDocxFromJasperFile(reportMap, reportModel, template, out);
    }

    @Override
    public void generateDocFromJasperFile(Map<String, Object> reportMap, List<?> reportModel, List<InputStream> templates, OutputStream out) throws Exception {
        this.generateDocxFromJasperFile(reportMap, reportModel, templates, out);
    }

    @Override
    public void generateRtfFromJasperFile(Map<String, Object> reportMap, List<?> reportModel, InputStream template, OutputStream out) throws Exception {
        JRRtfExporter exporter = new JRRtfExporter();
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.configureJasperPrint(reportMap, reportModel, template, out, true)));
        exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput(out));
        exporter.exportReport();
    }

    @Override
    public void generateRtfFromJasperFile(Map<String, Object> reportMap, List<?> reportModel, List<InputStream> templates, OutputStream out) throws Exception {
        JRRtfExporter exporter = new JRRtfExporter();
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.configureJasperPrint(reportMap, reportModel, templates, out, true)));
        exporter.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput(out));
        exporter.exportReport();
    }

    @Override
    public void generateDocxFromJasperFile(Map<String, Object> reportMap, List<?> reportModel, InputStream template, OutputStream out) throws Exception {
        JRDocxExporter exporter = new JRDocxExporter();
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.configureJasperPrint(reportMap, reportModel, template, out, true)));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(out));
        exporter.exportReport();
    }

    @Override
    public void generateDocxFromJasperFile(Map<String, Object> reportMap, List<?> reportModel, List<InputStream> templates, OutputStream out) throws Exception {
        JRDocxExporter exporter = new JRDocxExporter();
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.configureJasperPrint(reportMap, reportModel, templates, out, true)));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(out));
        exporter.exportReport();
    }

    @Override
    public void generateXlsFromJasperFile(Map<String, Object> reportMap, List<?> reportModel, InputStream template, OutputStream out) throws Exception {
        JRXlsExporter exporter = new JRXlsExporter();
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.configureJasperPrint(reportMap, reportModel, template, out, true)));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(out));
        exporter.exportReport();
    }

    @Override
    public void generateXlsFromJasperFile(Map<String, Object> reportMap, List<?> reportModel, List<InputStream> templates, OutputStream out) throws Exception {
        JRXlsExporter exporter = new JRXlsExporter();
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.configureJasperPrint(reportMap, reportModel, templates, out, true)));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(out));
        exporter.exportReport();
    }

    @Override
    public void generateXlsxFromJasperFile(Map<String, Object> reportMap, List<?> reportModel, InputStream template, OutputStream out) throws Exception {
        JRXlsxExporter exporter = new JRXlsxExporter();
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.configureJasperPrint(reportMap, reportModel, template, out, true)));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(out));
        exporter.exportReport();
    }

    @Override
    public void generateXlsxFromJasperFile(Map<String, Object> reportMap, List<?> reportModel, List<InputStream> templates, OutputStream out) throws Exception {
        JRXlsxExporter exporter = new JRXlsxExporter();
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.configureJasperPrint(reportMap, reportModel, templates, out, true)));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(out));
        exporter.exportReport();
    }

    @Override
    public void generatePdfFromJasperFile(Map<String, Object> reportMap, List<?> reportModel, InputStream template, OutputStream out) throws Exception {
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.configureJasperPrint(reportMap, reportModel, template, out, true)));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(out));
        exporter.exportReport();
    }

    @Override
    public void generatePdfFromJasperFile(Map<String, Object> reportMap, List<?> reportModel, List<InputStream> templates, OutputStream out) throws Exception {
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.configureJasperPrint(reportMap, reportModel, templates, out, true)));
        exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(out));
        exporter.exportReport();
    }

    private List<JasperPrint> configureJasperPrint(Map<String, Object> reportMap, List<?> reportModel, InputStream template, OutputStream out, boolean isJasperFile) throws Exception {
        logger.info("Configuring JasperPrint component...");
        JRBeanCollectionDataSource jrxmlds = new JRBeanCollectionDataSource(reportModel);
        JasperPrint jasperPrint = null;
        if (isJasperFile) {
            jasperPrint = JasperFillManager.fillReport((InputStream)template, reportMap, (JRDataSource)jrxmlds);
        } else {
            JasperReport jasperReport = JasperCompileManager.compileReport((InputStream)template);
            jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, reportMap, (JRDataSource)jrxmlds);
        }
        ArrayList<JasperPrint> jasperPrintList = new ArrayList<JasperPrint>();
        jasperPrintList.add(jasperPrint);
        logger.info("Configuring JasperPrint component finished");
        return jasperPrintList;
    }

    private List<JasperPrint> configureJasperPrint(Map<String, Object> reportMap, List<?> reportModel, List<InputStream> templates, OutputStream out, boolean isJasperFile) throws Exception {
        logger.info("Configuring JasperPrint component...");
        JRBeanCollectionDataSource jrxmlds = new JRBeanCollectionDataSource(reportModel);
        ArrayList<JasperPrint> jasperPrintList = new ArrayList<JasperPrint>();
        for (int i = 0; i < templates.size(); ++i) {
            JasperPrint jasperPrint = null;
            if (isJasperFile) {
                jasperPrint = JasperFillManager.fillReport((InputStream)templates.get(i), reportMap, (JRDataSource)jrxmlds);
                jrxmlds.moveFirst();
            } else {
                JasperReport jasperReport = JasperCompileManager.compileReport((InputStream)templates.get(i));
                jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, reportMap, (JRDataSource)jrxmlds);
                jrxmlds.moveFirst();
            }
            jasperPrintList.add(jasperPrint);
        }
        logger.info("Configuring JasperPrint component finished");
        return jasperPrintList;
    }
}

