/*
 * Decompiled with CFR 0.152.
 */
package com.softwarefactory.reporting.core.jasper.dynamicreports.table.generator;

import com.softwarefactory.reporting.core.jasper.dynamicreports.table.configuration.BodyConfiguration;
import com.softwarefactory.reporting.core.jasper.dynamicreports.table.configuration.ColumStyle;
import com.softwarefactory.reporting.core.jasper.dynamicreports.table.configuration.HeaderConfiguration;
import com.softwarefactory.reporting.core.jasper.dynamicreports.table.configuration.TableConfiguration;
import com.softwarefactory.reporting.core.jasper.dynamicreports.table.template.TableTemplate;
import java.util.ArrayList;
import java.util.List;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.report.base.expression.AbstractSimpleExpression;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.column.TextColumnBuilder;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.SubreportBuilder;
import net.sf.dynamicreports.report.builder.grid.ColumnGridComponentBuilder;
import net.sf.dynamicreports.report.builder.style.ReportStyleBuilder;
import net.sf.dynamicreports.report.builder.style.StyleBuilder;
import net.sf.dynamicreports.report.constant.HorizontalAlignment;
import net.sf.dynamicreports.report.datasource.DRDataSource;
import net.sf.dynamicreports.report.definition.ReportParameters;
import net.sf.dynamicreports.report.definition.datatype.DRIDataType;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;
import net.sf.jasperreports.engine.JRDataSource;

public class TableGenerator {
    private static final String ID_COLUMN_DESCRIPTOR = "column_";

    public SubreportBuilder generate(List<List<String>> reportModel, TableConfiguration configuration) throws Exception {
        BodyConfiguration configurationBody = configuration.getBodyConfiguration();
        HeaderConfiguration configurationHead = configuration.getHeaderConfiguration();
        TextColumnBuilder<String>[] columns = this.createColumns(reportModel.get(0), configurationBody, configurationHead);
        JRDataSource datasource = this.createDataSource(reportModel);
        JasperReportBuilder jasperReportBuilder = this.getJasperReportBuilder(columns, datasource);
        if (configuration.isPagination() && configuration.getRowsPagination() != 0) {
            jasperReportBuilder.detailFooter(new ComponentBuilder[]{DynamicReports.cmp.pageBreak().setPrintWhenExpression((DRIExpression)new PrintWhenExpression(configuration.getRowsPagination()))});
        }
        SubreportBuilder subreport = DynamicReports.cmp.subreport(jasperReportBuilder).setDataSource(datasource);
        return subreport;
    }

    private JasperReportBuilder getJasperReportBuilder(TextColumnBuilder<String>[] columns, JRDataSource datasource) {
        JasperReportBuilder jasperReport = DynamicReports.report();
        ((JasperReportBuilder)((JasperReportBuilder)((JasperReportBuilder)jasperReport.setTemplate(TableTemplate.reportTemplate)).columns(columns)).columnGrid(new ColumnGridComponentBuilder[]{DynamicReports.grid.horizontalFlowColumnGridList(columns)})).setDataSource(datasource);
        return jasperReport;
    }

    private JRDataSource createDataSource(List<List<String>> reportModel) {
        if (reportModel != null && reportModel.size() > 0 && reportModel.get(0) != null && reportModel.get(0).size() > 0) {
            String[] columns = new String[reportModel.get(0).size()];
            int posColumn = 0;
            while (posColumn < columns.length) {
                columns[posColumn] = ID_COLUMN_DESCRIPTOR + posColumn;
                ++posColumn;
            }
            DRDataSource dataSource = new DRDataSource(columns);
            boolean isColumnRow = true;
            for (List<String> row : reportModel) {
                if (isColumnRow) {
                    isColumnRow = false;
                    continue;
                }
                Object[] values = new String[columns.length];
                int posValue = 0;
                for (String column : row) {
                    values[posValue] = column;
                    ++posValue;
                }
                dataSource.add(values);
            }
            return dataSource;
        }
        return null;
    }

    private TextColumnBuilder<String>[] createColumns(List<String> rowColumns, BodyConfiguration configurationBody, HeaderConfiguration configurationHeader) {
        List<Object> configurationColumHeaderList = new ArrayList();
        if (configurationHeader != null) {
            configurationColumHeaderList = configurationHeader.getColumStyleList();
        }
        List<Object> configurationColumList = new ArrayList();
        if (configurationBody != null) {
            configurationColumList = configurationBody.getColumStyleList();
        }
        if (rowColumns != null && rowColumns.size() > 0) {
            TextColumnBuilder[] columns = new TextColumnBuilder[rowColumns.size()];
            int posColumn = 0;
            for (String column : rowColumns) {
                TextColumnBuilder itemColumn = DynamicReports.col.column(column, ID_COLUMN_DESCRIPTOR + posColumn, (DRIDataType)DynamicReports.type.stringType());
                if (configurationColumHeaderList != null && posColumn < configurationColumHeaderList.size()) {
                    ColumStyle configurationColumHeader = (ColumStyle)configurationColumHeaderList.get(posColumn);
                    StyleBuilder styleColumnHeader = DynamicReports.stl.style((ReportStyleBuilder)TableTemplate.columnTitleStyle);
                    styleColumnHeader = this.configurateStyleColumns(configurationColumHeader, styleColumnHeader);
                    itemColumn.setTitleStyle((ReportStyleBuilder)styleColumnHeader);
                }
                if (configurationColumList != null && posColumn < configurationColumList.size()) {
                    ColumStyle configurationColum = (ColumStyle)configurationColumList.get(posColumn);
                    StyleBuilder styleColumnBody = DynamicReports.stl.style((ReportStyleBuilder)TableTemplate.columnStyle);
                    styleColumnBody = this.configurateStyleColumns(configurationColum, styleColumnBody);
                    itemColumn.setStyle((ReportStyleBuilder)styleColumnBody);
                }
                int columnWidth = 100 / rowColumns.size();
                itemColumn.setWidth(Integer.valueOf(columnWidth));
                columns[posColumn] = itemColumn;
                ++posColumn;
            }
            return columns;
        }
        return null;
    }

    private StyleBuilder configurateStyleColumns(ColumStyle configurationColum, StyleBuilder styleColumn) {
        if (configurationColum != null) {
            if (ColumStyle.Aling.LEFT.equals((Object)configurationColum.getAling())) {
                styleColumn.setHorizontalAlignment(HorizontalAlignment.LEFT);
            } else if (ColumStyle.Aling.CENTER.equals((Object)configurationColum.getAling())) {
                styleColumn.setHorizontalAlignment(HorizontalAlignment.CENTER);
            } else {
                styleColumn.setHorizontalAlignment(HorizontalAlignment.RIGHT);
            }
            if (ColumStyle.FormatFont.BOLD.equals((Object)configurationColum.getFormatFont())) {
                styleColumn.setBold(Boolean.valueOf(true));
                styleColumn.setItalic(Boolean.valueOf(false));
                styleColumn.setUnderline(Boolean.valueOf(false));
            } else if (ColumStyle.FormatFont.ITALICS.equals((Object)configurationColum.getFormatFont())) {
                styleColumn.setBold(Boolean.valueOf(false));
                styleColumn.setUnderline(Boolean.valueOf(false));
                styleColumn.setItalic(Boolean.valueOf(true));
            } else if (ColumStyle.FormatFont.UNDERLINE.equals((Object)configurationColum.getFormatFont())) {
                styleColumn.setBold(Boolean.valueOf(false));
                styleColumn.setItalic(Boolean.valueOf(false));
                styleColumn.setUnderline(Boolean.valueOf(true));
            } else {
                styleColumn.setBold(Boolean.valueOf(false));
                styleColumn.setItalic(Boolean.valueOf(false));
                styleColumn.setUnderline(Boolean.valueOf(false));
            }
        }
        return styleColumn;
    }

    private class PrintWhenExpression
    extends AbstractSimpleExpression<Boolean> {
        private static final long serialVersionUID = 1L;
        private int rowsPage;

        public PrintWhenExpression(int rowsPage) {
            this.rowsPage = rowsPage;
        }

        public Boolean evaluate(ReportParameters reportParameters) {
            if (reportParameters.getPageRowNumber() == this.rowsPage) {
                return true;
            }
            return false;
        }
    }
}

