/*
 * Decompiled with CFR 0.152.
 */
package com.softwarefactory.reporting.core.jasper.dynamicreports.table;

import com.softwarefactory.reporting.core.jasper.dynamicreports.table.DynamicReportTableService;
import com.softwarefactory.reporting.core.jasper.dynamicreports.table.configuration.TableConfiguration;
import com.softwarefactory.reporting.core.jasper.dynamicreports.table.generator.FilterGenerator;
import com.softwarefactory.reporting.core.jasper.dynamicreports.table.generator.TableGenerator;
import com.softwarefactory.reporting.core.jasper.dynamicreports.table.template.TableTemplate;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperCsvExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperDocxExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperHtmlExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperOdsExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperPdfExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperRtfExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperXlsExporterBuilder;
import net.sf.dynamicreports.jasper.builder.export.JasperXlsxExporterBuilder;
import net.sf.dynamicreports.report.builder.DynamicReports;
import net.sf.dynamicreports.report.builder.component.ComponentBuilder;
import net.sf.dynamicreports.report.builder.component.HorizontalListBuilder;
import net.sf.dynamicreports.report.builder.component.SubreportBuilder;
import net.sf.dynamicreports.report.builder.component.VerticalListBuilder;
import net.sf.dynamicreports.report.constant.PageOrientation;
import net.sf.dynamicreports.report.constant.PageType;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;

public class DynamicReportTableServiceImpl
implements DynamicReportTableService {
    public void generateViewer(TableConfiguration configuration, List<List<String>> reportModel, InputStream template) throws Exception {
        JasperReportBuilder jasperReport = this.getJasperReportBuilder(configuration, reportModel, template);
        jasperReport.show();
    }

    @Override
    public void generateDoc(TableConfiguration configuration, List<List<String>> reportModel, InputStream template, OutputStream out) throws Exception {
        this.generateDocx(configuration, reportModel, template, out);
    }

    @Override
    public void generateRtf(TableConfiguration configuration, List<List<String>> reportModel, InputStream template, OutputStream out) throws Exception {
        JasperReportBuilder jasperReport = this.getJasperReportBuilder(configuration, reportModel, template);
        JasperRtfExporterBuilder docxExporter = DynamicReports.export.rtfExporter(out);
        jasperReport.toRtf(docxExporter);
    }

    @Override
    public void generateDocx(TableConfiguration configuration, List<List<String>> reportModel, InputStream template, OutputStream out) throws Exception {
        JasperReportBuilder jasperReport = this.getJasperReportBuilder(configuration, reportModel, template);
        JasperDocxExporterBuilder docxExporter = DynamicReports.export.docxExporter(out);
        jasperReport.toDocx(docxExporter);
    }

    @Override
    public void generateXls(TableConfiguration configuration, List<List<String>> reportModel, InputStream template, OutputStream out) throws Exception {
        JasperReportBuilder jasperReport = this.getJasperReportBuilder(configuration, reportModel, template);
        JasperXlsExporterBuilder xlsExporter = DynamicReports.export.xlsExporter(out);
        jasperReport.toXls(xlsExporter);
    }

    @Override
    public void generateXlsx(TableConfiguration configuration, List<List<String>> reportModel, InputStream template, OutputStream out) throws Exception {
        JasperReportBuilder jasperReport = this.getJasperReportBuilder(configuration, reportModel, template);
        JasperXlsxExporterBuilder xlsxExporter = DynamicReports.export.xlsxExporter(out);
        jasperReport.toXlsx(xlsxExporter);
    }

    @Override
    public void generatePdf(TableConfiguration configuration, List<List<String>> reportModel, InputStream template, OutputStream out) throws Exception {
        JasperReportBuilder jasperReport = this.getJasperReportBuilder(configuration, reportModel, template);
        JasperPdfExporterBuilder pdfExporter = DynamicReports.export.pdfExporter(out);
        jasperReport.toPdf(pdfExporter);
    }

    @Override
    public void generateHtml(TableConfiguration configuration, List<List<String>> reportModel, InputStream template, OutputStream out) throws Exception {
        JasperReportBuilder jasperReport = this.getJasperReportBuilder(configuration, reportModel, template);
        JasperHtmlExporterBuilder htmlExporter = DynamicReports.export.htmlExporter(out);
        jasperReport.toHtml(htmlExporter);
    }

    @Override
    public void generateCsv(TableConfiguration configuration, List<List<String>> reportModel, InputStream template, OutputStream out) throws Exception {
        JasperReportBuilder jasperReport = this.getJasperReportBuilder(configuration, reportModel, template);
        JasperCsvExporterBuilder csvExporter = DynamicReports.export.csvExporter(out);
        jasperReport.toCsv(csvExporter);
    }

    @Override
    public void generateOds(TableConfiguration configuration, List<List<String>> reportModel, InputStream template, OutputStream out) throws Exception {
        JasperReportBuilder jasperReport = this.getJasperReportBuilder(configuration, reportModel, template);
        JasperOdsExporterBuilder odsExporter = DynamicReports.export.odsExporter(out);
        jasperReport.toOds(odsExporter);
    }

    private JasperReportBuilder getJasperReportBuilder(TableConfiguration configuration, List<List<String>> reportModel, InputStream template) throws Exception {
        JasperReportBuilder jasperReport = DynamicReports.report();
        ((JasperReportBuilder)jasperReport.setTemplate(TableTemplate.reportTemplate)).setTemplateDesign(template);
        jasperReport.setPageFormat(PageType.A4, PageOrientation.PORTRAIT);
        jasperReport.setIgnorePagination(Boolean.valueOf(false));
        if (configuration.getReportName() != null) {
            jasperReport.setReportName(configuration.getReportName());
        }
        if (configuration.getParameters() != null) {
            jasperReport.setParameters(configuration.getParameters());
        }
        SubreportBuilder tableDetail = this.getDetail(jasperReport, reportModel, configuration);
        if (TableConfiguration.Alignment_Type.PORTRAIT.equals((Object)configuration.getAlignment())) {
            jasperReport.setPageFormat(PageType.A4, PageOrientation.PORTRAIT);
        } else {
            jasperReport.setPageFormat(PageType.A4, PageOrientation.LANDSCAPE);
        }
        if (configuration.isPagination()) {
            jasperReport.setIgnorePagination(Boolean.valueOf(false));
        } else {
            jasperReport.setIgnorePagination(Boolean.valueOf(true));
        }
        if (configuration.getWidthRelative() > 0 && configuration.getWidthRelative() <= 100) {
            int tableWidthPorc = configuration.getWidthRelative();
            int pageWidth = jasperReport.getReport().getPage().getWidth();
            int tableWidth = pageWidth / 100 * tableWidthPorc;
            tableDetail.setFixedWidth(Integer.valueOf(tableWidth));
        }
        VerticalListBuilder detail = null;
        HorizontalListBuilder tabledetailCmp = DynamicReports.cmp.centerHorizontal((ComponentBuilder)tableDetail);
        if (reportModel != null && reportModel.size() > 0) {
            FilterGenerator filtergenerator = new FilterGenerator();
            HorizontalListBuilder filterdetailCmp = filtergenerator.generate(configuration.getFilterTitle(), configuration.getFilter());
            int pageWidth = jasperReport.getReport().getPage().getWidth();
            filterdetailCmp.setFixedWidth(Integer.valueOf(pageWidth * 85 / 100));
            detail = DynamicReports.cmp.centerVertical((ComponentBuilder)DynamicReports.cmp.centerHorizontal((ComponentBuilder)filterdetailCmp)).add(Integer.valueOf(20), new ComponentBuilder[]{tabledetailCmp});
        } else {
            detail = DynamicReports.cmp.verticalList();
            detail.add(new ComponentBuilder[]{tabledetailCmp});
        }
        jasperReport.addDetail(new ComponentBuilder[]{detail});
        jasperReport.setDataSource((JRDataSource)new JREmptyDataSource());
        return jasperReport;
    }

    private SubreportBuilder getDetail(JasperReportBuilder jasperReport, List<List<String>> reportModel, TableConfiguration configuration) throws Exception {
        TableGenerator tableGenerator = new TableGenerator();
        SubreportBuilder table = tableGenerator.generate(reportModel, configuration);
        return table;
    }
}

