package weblogic.webservice.tools.stubgen;

import java.util.Iterator;
import weblogic.webservice.Operation;
import weblogic.webservice.Port;
import weblogic.webservice.Part;
public class Stub extends weblogic.webservice.tools.stubgen.StubGen{
  public void generate() 
   throws weblogic.webservice.util.jspgen.ScriptException{
  out.print( "package " );

 out.print( packageName );  out.print( ";" );

 String portTypeName = helper.getJAXRPCClassName( port.getTypeName() );   out.print( "\n" );
  out.print( "/**" );
  out.print( "\n" );
  out.print( " * Generated class, do not edit." );
  out.print( "\n" );
  out.print( " *" );
  out.print( "\n" );
  out.print( " * This stub class was generated by weblogic" );
  out.print( "\n" );
  out.print( " * webservice stub gen on " );

 out.print(  new java.util.Date()  );  out.print( " */" );
  out.print( "\n" );
  out.print( "\n" );
  out.print( "public class " );

 out.print( portTypeName );  out.print( "_Stub " );
  out.print( "\n" );
  out.print( "     extends weblogic.webservice.core.rpc.StubImpl " );
  out.print( "\n" );
  out.print( "     implements  " );

 out.print( packageName );  out.print( "." );

 out.print( portTypeName );  out.print( "{" );
  out.print( "\n" );
  out.print( "\n" );
  out.print( "  public " );

 out.print( portTypeName );  out.print( "_Stub( weblogic.webservice.Port _port ){" );
  out.print( "\n" );
  out.print( "    super( _port, " );

 out.print( packageName );  out.print( "." );

 out.print( portTypeName );  out.print( ".class );" );
  out.print( "\n" );
  out.print( "  }" );
  out.print( "\n" );

 boolean isWritingInterface = false;

   for( Iterator it=port.getOperations(); it.hasNext(); ){
     Operation operation = (Operation)it.next(); 

   boolean canWriteConvenienceMethod = 
     helper.canWriteConvenienceMethod( operation );
     
   boolean writeStubMethod = true; 
   
  if( writeStubMethod ){ 
 Part returnPart = helper.getReturnPart( operation );   out.print( "\n" );
  out.print( "  /**" );
  out.print( "\n" );
  out.print( "   * " );

 out.print( operation.getName() );  out.print( " " );
  out.print( "\n" );
  out.print( "   */" );
  out.print( "\n" );
  out.print( "\n" );
  out.print( "  public " );

 out.print( helper.getTypeFromPart(returnPart) );  out.print( " " );

 out.print( helper.getJAXRPCMethodName(operation.getName()) );  out.print( "(" );

 out.print( helper.getArgStatement( operation ) );  out.print( ") " );
  out.print( "\n" );
  out.print( "       " );

 out.print( helper.throwException( operation ) );
 if( isWritingInterface ){  out.print( ";" );


       }else{  out.print( "{" );
  out.print( "\n" );
  out.print( "\n" );
  out.print( "    java.util.HashMap _args = new java.util.HashMap();" );
  out.print( "\n" );

 for( Iterator parts = helper.getAllParamParts( operation ); parts.hasNext(); ){
         Part part = (Part)parts.next();  out.print( "    _args.put( \"" );

 out.print( part.getName() );  out.print( "\", _wrap( " );

 out.print( helper.getJavaName(part.getName()) );  out.print( " ) );" );
  out.print( "\n" );
  out.print( "       " );

}  out.print( "    try{" );
  out.print( "\n" );
  out.print( "      java.lang.Object _result = _invoke( \"" );

 out.print( operation.getName() );  out.print( "\", _args );" );
  out.print( "\n" );
  out.print( "      " );

 out.print( helper.getReturnStatement( returnPart ) );  out.print( "    " );

 out.print( helper.getThrowCustomerException(operation) );  out.print( "    } catch (javax.xml.rpc.JAXRPCException e) {" );
  out.print( "\n" );
  out.print( "      " );

 out.print( helper.getThrowJAXRPCException() );  out.print( "    } catch (javax.xml.rpc.soap.SOAPFaultException e) {" );
  out.print( "\n" );
  out.print( "      " );

 out.print( helper.getThrowSOAPFaultException( operation ) );  out.print( "    } catch (java.lang.Throwable e) {" );
  out.print( "\n" );
  out.print( "      " );

 out.print( helper.getThrowAllException() );  out.print( "    }" );
  out.print( "\n" );
  out.print( "  }" );

}
  }
  if( canWriteConvenienceMethod ){ 

  Class returnType = null;
  String returnName = null;
  Part outPart = helper.getBodyPart( operation.getOutput() ); 

  Iterator nats = helper.getNameAndTypesFromPart( outPart );

  if( nats.hasNext() ){
    Object[] returnValue = (Object[])nats.next();
    returnType = (Class)returnValue[1];
    returnName = (String)returnValue[0];
  }

  Part inputPart = helper.getBodyPart( operation.getInput() );
  out.print( "\n" );
  out.print( "  /**" );
  out.print( "\n" );
  out.print( "   * Convenience method for " );

 out.print( operation.getName() );  out.print( " " );
  out.print( "\n" );
  out.print( "   */" );
  out.print( "\n" );
  out.print( "\n" );
  out.print( "  public " );

 out.print( helper.getJavaTypeName(returnType) );  out.print( " " );

 out.print( helper.getJAXRPCMethodName(operation.getName()) );  out.print( "(" );

 out.print( helper.getConvenienceArgs(operation) );  out.print( ")" );
  out.print( "\n" );
  out.print( "       " );

 out.print( helper.throwException( operation ) );
 if( isWritingInterface ){  out.print( ";" );


         }else{  out.print( "{" );
  out.print( "\n" );
  out.print( "\n" );
  out.print( "    " );

 out.print( inputPart.getJavaType().getName() );  out.print( " _input = " );
  out.print( "\n" );
  out.print( "         new " );

 out.print( inputPart.getJavaType().getName() );  out.print( "();" );
  out.print( "\n" );
  out.print( "\n" );
  out.print( "    " );

 out.print( helper.setConvenienceArgs( inputPart ) );  out.print( "      " );
  out.print( "\n" );
  out.print( "    " );

 out.print( outPart.getJavaType().getName() );  out.print( " _result = " );

 out.print( helper.getJAXRPCMethodName(operation.getName()) );  out.print( "( _input" );

 out.print( helper.getHeaderConvenienceArgNames(operation) );  out.print( " );" );
  out.print( "\n" );
  out.print( "\n" );
  out.print( "    " );

 if( returnType != null ){   out.print( "    return _result.get" );

 out.print( helper.makeFirstCharBig(returnName) );  out.print( "();" );
  out.print( "\n" );
  out.print( "    " );

}  out.print( "  }" );

}
    if(generateAsyncMethods){ 

  returnType = null;
  returnName = null;
  outPart = helper.getBodyPart( operation.getOutput() ); 

  nats = helper.getNameAndTypesFromPart( outPart );

  if( nats.hasNext() ){
    Object[] returnValue = (Object[])nats.next();
    returnType = (Class)returnValue[1];
    returnName = (String)returnValue[0];
  }

  inputPart = helper.getBodyPart( operation.getInput() );
  out.print( "\n" );
  out.print( "  /**" );
  out.print( "\n" );
  out.print( "   * Async Convenience method for " );

 out.print( operation.getName() );  out.print( " " );
  out.print( "\n" );
  out.print( "   */" );
  out.print( "\n" );
  out.print( "\n" );
  out.print( "  public weblogic.webservice.async.FutureResult start" );

 out.print( firstLetterCap(helper.getJAXRPCMethodName(operation.getName())) );  out.print( "(" );

 out.print( helper.getAsyncConvenienceArgs(operation) );  out.print( ")" );
  out.print( "\n" );
  out.print( "       " );

 out.print( helper.throwException( operation ) );
 if( isWritingInterface ){  out.print( ";" );


         }else{  out.print( "{" );
  out.print( "\n" );
  out.print( "\n" );
  out.print( "    " );

 out.print( inputPart.getJavaType().getName() );  out.print( " _input = " );
  out.print( "\n" );
  out.print( "         new " );

 out.print( inputPart.getJavaType().getName() );  out.print( "();" );
  out.print( "\n" );
  out.print( "\n" );
  out.print( "    " );

 out.print( helper.setConvenienceArgs( inputPart ) );  out.print( "      " );
  out.print( "\n" );
  out.print( "    return start" );

 out.print( firstLetterCap(helper.getJAXRPCMethodName(operation.getName())) );  out.print( "( _input" );

 out.print( helper.getHeaderConvenienceArgNames(operation) );  out.print( ", asyncInfo );" );
  out.print( "\n" );
  out.print( "  }" );

}  out.print( "\n" );
  out.print( "  public " );

 out.print( helper.getJavaTypeName(returnType) );  out.print( " endConvenience" );

 out.print( firstLetterCap(helper.getJAXRPCMethodName(operation.getName())) );  out.print( "( weblogic.webservice.async.FutureResult _futureResult )" );
  out.print( "\n" );
  out.print( "       " );

 out.print( helper.throwException( operation ) );
 if( isWritingInterface ){  out.print( ";" );


         }else{  out.print( "{" );
  out.print( "\n" );
  out.print( "\n" );
  out.print( "    " );

 out.print( outPart.getJavaType().getName() );  out.print( " _result = end" );

 out.print( firstLetterCap(helper.getJAXRPCMethodName(operation.getName())) );  out.print( "( _futureResult );" );
  out.print( "\n" );
  out.print( "\n" );
  out.print( "    " );

 if( returnType != null ){   out.print( "    return _result.get" );

 out.print( helper.makeFirstCharBig(returnName) );  out.print( "();" );
  out.print( "\n" );
  out.print( "    " );

}  out.print( "  }" );

}
    } 
  } 
  if(generateAsyncMethods){ 
 Part returnPart = helper.getReturnPart( operation );   out.print( "\n" );
  out.print( "  /**" );
  out.print( "\n" );
  out.print( "   * Async methods for operation[ " );

 out.print( operation.getName() );  out.print( " ] " );
  out.print( "\n" );
  out.print( "   */" );
  out.print( "\n" );
  out.print( "\n" );
  out.print( "  public weblogic.webservice.async.FutureResult start" );

 out.print( firstLetterCap(helper.getJAXRPCMethodName(operation.getName())) );  out.print( "(" );

 out.print( helper.getAsyncArgStatement( operation ) );  out.print( ") " );
  out.print( "\n" );
  out.print( "       " );

 out.print( helper.throwException( operation ) );
 if( isWritingInterface ){  out.print( ";" );


       }else{  out.print( "{" );
  out.print( "\n" );
  out.print( "\n" );
  out.print( "    java.util.HashMap _args = new java.util.HashMap();" );
  out.print( "\n" );

 for( Iterator parts = helper.getAllParamParts( operation ); parts.hasNext(); ){
         Part part = (Part)parts.next();  out.print( "    _args.put( \"" );

 out.print( part.getName() );  out.print( "\", _wrap( " );

 out.print( helper.getJavaName(part.getName()) );  out.print( " ) );" );
  out.print( "\n" );
  out.print( "       " );

}  out.print( "    try{" );
  out.print( "\n" );
  out.print( "      return _startAsyncInvoke( \"" );

 out.print( operation.getName() );  out.print( "\", _args, asyncInfo );" );
  out.print( "\n" );
  out.print( "    }catch( javax.xml.rpc.JAXRPCException e ){" );
  out.print( "\n" );
  out.print( "      " );

 out.print( helper.getThrowJAXRPCException() );  out.print( "    }catch( javax.xml.rpc.soap.SOAPFaultException e ){" );
  out.print( "\n" );
  out.print( "      " );

 out.print( helper.getThrowSOAPFaultException( operation ) );  out.print( "    }" );
  out.print( "\n" );
  out.print( "  }" );

}  out.print( "\n" );
  out.print( "\n" );
  out.print( "  public " );

 out.print( helper.getTypeFromPart(returnPart) );  out.print( " end" );

 out.print( firstLetterCap(helper.getJAXRPCMethodName(operation.getName())) );  out.print( "(weblogic.webservice.async.FutureResult _futureResult ) " );
  out.print( "\n" );
  out.print( "       " );

 out.print( helper.throwException( operation ) );
 if( isWritingInterface ){  out.print( ";" );


       }else{  out.print( "{" );
  out.print( "\n" );
  out.print( "\n" );
  out.print( "    try{" );
  out.print( "\n" );
  out.print( "      java.lang.Object _result = _futureResult.getResult(); " );
  out.print( "\n" );
  out.print( "      " );

 out.print( helper.getReturnStatement( returnPart ) );  out.print( "    }catch( javax.xml.rpc.JAXRPCException e ){" );
  out.print( "\n" );
  out.print( "      " );

 out.print( helper.getThrowJAXRPCException() );  out.print( "    }catch( javax.xml.rpc.soap.SOAPFaultException e ){" );
  out.print( "\n" );
  out.print( "      " );

 out.print( helper.getThrowSOAPFaultException( operation ) );  out.print( "    }" );
  out.print( "\n" );
  out.print( "  }" );

}
  } 
}  out.print( "\n" );
  out.print( "}" );
  }
}