package weblogic.webservice.dd.verify;

import java.text.MessageFormat;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import weblogic.i18n.Localizer;
import weblogic.i18ntools.L10nLookup;
 
/** 
 * Copyright (c) 2004 by BEA Inc. All Rights Reserved.
 * @exclude
 */
public class WebServiceComplianceTextFormatter {
  private Localizer l10n;
  private boolean format=false;
  // constructors

  public WebServiceComplianceTextFormatter() {
    l10n = L10nLookup.getLocalizer(Locale.getDefault(), "weblogic.webservice.dd.verify.WebServiceComplianceTextLocalizer");
  }

  public WebServiceComplianceTextFormatter(Locale l) {
    l10n = L10nLookup.getLocalizer(l, "weblogic.webservice.dd.verify.WebServiceComplianceTextLocalizer");
  }

  public static WebServiceComplianceTextFormatter getInstance() {
    return new WebServiceComplianceTextFormatter();
  }

  public static WebServiceComplianceTextFormatter getInstance(Locale l) {
    return new WebServiceComplianceTextFormatter(l);
  }

  public void setExtendedFormat(boolean fmt) {
    format = fmt;
  }

  public boolean getExtendedFormat() { return format; }


  /**
   * ERROR: A handler-chain was defined in the web services deployment descriptor without a Name attribute or with an empty Name attribute. Handler Chains must include a name.
   */
  public String noHandlerChainName()  {
    String fmt  = "";
    String id = "noHandlerChainName" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = {  };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * ERROR: The handler-chain {0} contains a handler without a class-name attribute. Every handler must contain a class-name attribute.
   */
  public String noHandlerClassName(String arg0)  {
    String fmt  = "";
    String id = "noHandlerClassName" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = { arg0 };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * The handler-chain {0} does not contain any handlers.
   */
  public String noHandlersInChain(String arg0)  {
    String fmt  = "";
    String id = "noHandlersInChain" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = { arg0 };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * ERROR: The handler class: {1} from handler-chain: {0} does not extend weblogic.webservice.Handler. All handler classes must extend weblogic.webservice.Handler.
   */
  public String doesntExtendHandler(String arg0, String arg1)  {
    String fmt  = "";
    String id = "doesntExtendHandler" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = { arg0, arg1 };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * ERROR: The handler class: {1} from handler-chain: {0} could not be loaded. Please ensure that this class name is correct and is included in the web service.
   */
  public String cantLoadHandlerClass(String arg0, String arg1)  {
    String fmt  = "";
    String id = "cantLoadHandlerClass" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = { arg0, arg1 };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * ERROR: The handler class: {1} from handler-chain: {0} does not have a public, no-argument constructor.
   */
  public String handlerNeedsDefaultCtor(String arg0, String arg1)  {
    String fmt  = "";
    String id = "handlerNeedsDefaultCtor" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = { arg0, arg1 };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * ERROR: The java component class: {1} from the component named: {0} could not be loaded.
   */
  public String javaComponentClassNotFound(String arg0, String arg1)  {
    String fmt  = "";
    String id = "javaComponentClassNotFound" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = { arg0, arg1 };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * ERROR: The java component class: {1} from the component named: {0} does not have a public, no-argument constructor.
   */
  public String javaComponentNeedsDefaultCtor(String arg0, String arg1)  {
    String fmt  = "";
    String id = "javaComponentNeedsDefaultCtor" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = { arg0, arg1 };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * The EJB component named: {0} does not specify a JNDI name or an EJB link. An EJB component must specify a JNDI name or an EJB link.
   */
  public String mustSpecifyJNDIOrEJBLink(String arg0)  {
    String fmt  = "";
    String id = "mustSpecifyJNDIOrEJBLink" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = { arg0 };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * ERROR: The EJB component named: {0} specified an ejb-link to {1}, but this ejb-link could not be found in JNDI. Please ensure that this ejb-link refers to a valid EJB, and this EJB has already deployed. The exception was: {2}
   */
  public String couldntFindEJBLink(String arg0, String arg1, Exception arg2)  {
    String fmt  = "";
    String id = "couldntFindEJBLink" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = { arg0, arg1, arg2 };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * ERROR: The EJB component named: {0} specified a JNDI name: {1}, but this name could not be found in JNDI. Please ensure that this JNDI name refers to a valid EJB, and this EJB has already deployed. The exception was: {2}
   */
  public String couldntFindJNDIName(String arg0, String arg1, Exception arg2)  {
    String fmt  = "";
    String id = "couldntFindJNDIName" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = { arg0, arg1, arg2 };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * ERROR: The EJB component named: {0} specified an ejb-link: {1}, but this ejb-link resolves to a JNDI name that does not refer to an EJBHome. Please ensure that the destination EJB exists, and this ejb-link points to an object implementing javax.ejb.EJBHome.
   */
  public String ejbLinkWasNotEJBHome(String arg0, String arg1)  {
    String fmt  = "";
    String id = "ejbLinkWasNotEJBHome" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = { arg0, arg1 };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * ERROR: The EJB component named: {0} specified a JNDI name: {1}, but this resolves to a JNDI name that does not refer to an EJBHome. Please ensure that the destination EJB exists, and this JNDI name points to an object implementing javax.ejb.EJBHome.
   */
  public String jndiNameWasNotEJBHome(String arg0, String arg1)  {
    String fmt  = "";
    String id = "jndiNameWasNotEJBHome" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = { arg0, arg1 };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * ERROR: The EJB component named: {0} specified an ejb-link: {1}, but the target EJB is not a stateless session EJB.
   */
  public String ejbLinkWasNotStateless(String arg0, String arg1)  {
    String fmt  = "";
    String id = "ejbLinkWasNotStateless" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = { arg0, arg1 };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * ERROR: The EJB component named: {0} specified a JNDI name: {1}, but this JNDI name does not refer to a stateless session EJB.
   */
  public String jndiNameWasNotStateless(String arg0, String arg1)  {
    String fmt  = "";
    String id = "jndiNameWasNotStateless" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = { arg0, arg1 };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * ERROR: There were no web services defined in this module.
   */
  public String noWebServices()  {
    String fmt  = "";
    String id = "noWebServices" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = {  };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * ERROR: The file or directory provided [{0}] does not exist or could not be read.
   */
  public String noFileOrDirectorNamed(String arg0)  {
    String fmt  = "";
    String id = "noFileOrDirectorNamed" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = { arg0 };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * ERROR: The file or directory provided [{0}] was found, but it could not be read. Please check the permission on this file or directory and ensure that it can be ready by this process.
   */
  public String noReadPermission(String arg0)  {
    String fmt  = "";
    String id = "noReadPermission" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = { arg0 };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * ERROR: The file named: {0} was found, but its format could not be recognized. Please ensure that its filename ends with .ear, .war, or .xml
   */
  public String unrecognizedFileType(String arg0)  {
    String fmt  = "";
    String id = "unrecognizedFileType" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = { arg0 };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * INFORMATION: The goal of the Compliance Checker to allow the user to catch and correct build time problems induced during the creation, implementation or configuration of the Webservice, rather than at deploy time. By definition, this tool in intended to verify the contract between the developer and the implicit WLS Webservice runtime environment. The web services may be verified from a WAR file, an EAR file, or a directory containing an extracted EAR or WAR file.
   */
  public String complianceCheckerHelp()  {
    String fmt  = "";
    String id = "complianceCheckerHelp" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = {  };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * weblogic.webservice.tools.cchecker.ComplianceChecker (EAR, WAR, or expanded directory)
   */
  public String noFilesGiven()  {
    String fmt  = "";
    String id = "noFilesGiven" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = {  };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * ERROR: Invalid command arguments given to the Compliance Checker.
   */
  public String invalidArgsGiven()  {
    String fmt  = "";
    String id = "invalidArgsGiven" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = {  };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * All messages have been reported, the ComplianceChecker has ended normally.
   */
  public String normalCompletion()  {
    String fmt  = "";
    String id = "normalCompletion" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = {  };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * ERROR: Could not create the required WebService Context for the given file [{0}].
   */
  public String noWebServiceMbean(String arg0)  {
    String fmt  = "";
    String id = "noWebServiceMbean" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = { arg0 };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * ERROR: Could not create the required WebService ClassLoader for the given file [{0}].
   */
  public String noWebServiceClassLoader(String arg0)  {
    String fmt  = "";
    String id = "noWebServiceClassLoader" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = { arg0 };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * ERROR: Could not locate the WebService WAR file in the given EAR file [{0}].
   */
  public String couldNotFindWARinEAR(String arg0)  {
    String fmt  = "";
    String id = "couldNotFindWARinEAR" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = { arg0 };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }

  /**
   * ERROR: Reliable delivery cannot be set for operation [{0}] that contains return parameter.
   */
  public String returnParamIsNotAllowed(String arg0)  {
    String fmt  = "";
    String id = "returnParamIsNotAllowed" ;
    String subsystem = "WebService Compliance" ;
    Object [] args = { arg0 };
    String output =  MessageFormat.format(l10n.get(id) , args);
    if (getExtendedFormat()) {
      DateFormat dformat = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, 
                                             DateFormat.LONG);
      fmt = "<"+dformat.format(new Date())+"><"+subsystem+"><"+id+"> ";
    }
    return fmt+output;
  }


}
