package weblogic.webservice;

import weblogic.logging.MessageLogger;
import weblogic.logging.Loggable;
 
/** 
 * Copyright (c) 2004 by BEA Systems, Inc. All Rights Reserved.
 * @exclude
 */
public class WebServiceLogger
{
private static final String LOCALIZER_CLASS = "weblogic.i18n.WebServiceLogLocalizer";
  /**
   * WebService Startup.
   *
   * messageid:  220000
   * severity:   info
   */
  public static String logWebServiceStartup()  {
    Object [] args = {  };
    MessageLogger.log(
	"220000",
	args,
	LOCALIZER_CLASS);
    return "220000";
  }




  /**
   * The server at {0} did not provide a valid HTTP response: {1}
   *
   * messageid:  220001
   * severity:   emergency
   */
  public static String logInvalidHttpResponse1(String arg0, String arg1)  {
    Object [] args = { arg0, arg1 };
    MessageLogger.log(
	"220001",
	args,
	LOCALIZER_CLASS);
    return "220001";
  }




  /**
   * The server at {0} did not provide a valid HTTP response: {1}
   *
   * messageid:  220002
   * severity:   emergency
   */
  public static String logInvalidHttpResponse2(String arg0, String arg1)  {
    Object [] args = { arg0, arg1 };
    MessageLogger.log(
	"220002",
	args,
	LOCALIZER_CLASS);
    return "220002";
  }




  /**
   * The server at {0} did not provide a valid HTTP response: {1}
   *
   * messageid:  220003
   * severity:   emergency
   */
  public static String logInvalidHttpResponse3(String arg0, String arg1)  {
    Object [] args = { arg0, arg1 };
    MessageLogger.log(
	"220003",
	args,
	LOCALIZER_CLASS);
    return "220003";
  }




  /**
   * The server at {0} did not provide a valid HTTP response: {1}
   *
   * messageid:  220004
   * severity:   emergency
   */
  public static String logInvalidHttpResponse4(String arg0, String arg1)  {
    Object [] args = { arg0, arg1 };
    MessageLogger.log(
	"220004",
	args,
	LOCALIZER_CLASS);
    return "220004";
  }




  /**
   * The server at {0} did not provide a valid HTTP response: {1}.
   *
   * messageid:  220005
   * severity:   emergency
   */
  public static String logInvalidHttpResponse5(String arg0, String arg1)  {
    Object [] args = { arg0, arg1 };
    MessageLogger.log(
	"220005",
	args,
	LOCALIZER_CLASS);
    return "220005";
  }




  /**
   * Content-Length was speified but no value was provided.
   *
   * messageid:  220006
   * severity:   emergency
   */
  public static String logInvalidHttpResponse6()  {
    Object [] args = {  };
    MessageLogger.log(
	"220006",
	args,
	LOCALIZER_CLASS);
    return "220006";
  }




  /**
   * The specified Content-Length {0} is invalid.
   *
   * messageid:  220007
   * severity:   emergency
   */
  public static String logInvalidHttpResponse7(String arg0)  {
    Object [] args = { arg0 };
    MessageLogger.log(
	"220007",
	args,
	LOCALIZER_CLASS);
    return "220007";
  }




  /**
   * HTTP Keep-alive was specified, but the Content-Length was not set.
   *
   * messageid:  220008
   * severity:   emergency
   */
  public static String logInvalidHttpResponse8()  {
    Object [] args = {  };
    MessageLogger.log(
	"220008",
	args,
	LOCALIZER_CLASS);
    return "220008";
  }




  /**
   * Received EOF before reading the entire message from server.
   *
   * messageid:  220009
   * severity:   emergency
   */
  public static String logInvalidHttpResponse9()  {
    Object [] args = {  };
    MessageLogger.log(
	"220009",
	args,
	LOCALIZER_CLASS);
    return "220009";
  }




  /**
   * A MIME encoded SOAP response must include a Content-Type MimeHeader specifying the MIME start and boundary.
   *
   * messageid:  220010
   * severity:   emergency
   */
  public static String logInvalidHttpServerBinding1()  {
    Object [] args = {  };
    MessageLogger.log(
	"220010",
	args,
	LOCALIZER_CLASS);
    return "220010";
  }




  /**
   * A bad value was provided for {0} : {1}. The default value will be used: {2}.
   *
   * messageid:  220011
   * severity:   warning
   */
  public static String logInvalidKeepAlive(String arg0, String arg1, String arg2)  {
    Object [] args = { arg0, arg1, arg2 };
    MessageLogger.log(
	"220011",
	args,
	LOCALIZER_CLASS);
    return "220011";
  }




  /**
   * The ID may not be null.
   *
   * messageid:  220012
   * severity:   emergency
   */
  public static String logXMLidrefIsNull()  {
    Object [] args = {  };
    MessageLogger.log(
	"220012",
	args,
	LOCALIZER_CLASS);
    return "220012";
  }




  /**
   * The ID referenced by {0} is unknown.
   *
   * messageid:  220013
   * severity:   emergency
   */
  public static String logXMLidrefIsUnknown(String arg0)  {
    Object [] args = { arg0 };
    MessageLogger.log(
	"220013",
	args,
	LOCALIZER_CLASS);
    return "220013";
  }




  /**
   * Incorrect XML stream open. Use open(XMLNode node) to open this stream.
   *
   * messageid:  220014
   * severity:   emergency
   */
  public static String logOpenXMLNodeStreamFailure1()  {
    Object [] args = {  };
    MessageLogger.log(
	"220014",
	args,
	LOCALIZER_CLASS);
    return "220014";
  }




  /**
   * Incorrect XML stream open. Use open(XMLNode node) to open this stream.
   *
   * messageid:  220015
   * severity:   emergency
   */
  public static String logOpenXMLNodeStreamFailure2()  {
    Object [] args = {  };
    MessageLogger.log(
	"220015",
	args,
	LOCALIZER_CLASS);
    return "220015";
  }




  /**
   * The start element was not found.
   *
   * messageid:  220016
   * severity:   emergency
   */
  public static String logFailedStartNotFound()  {
    Object [] args = {  };
    MessageLogger.log(
	"220016",
	args,
	LOCALIZER_CLASS);
    return "220016";
  }




  /**
   * Element {0} is not a start element.
   *
   * messageid:  220017
   * severity:   emergency
   */
  public static String logFailedNotAStartElement(String arg0)  {
    Object [] args = { arg0 };
    MessageLogger.log(
	"220017",
	args,
	LOCALIZER_CLASS);
    return "220017";
  }




  /**
   * The handler class:{0} threw an exception from its destroy method. This exception is ignored. The exception was: {1}.
   *
   * messageid:  220018
   * severity:   info
   */
  public static String logIgnoringHandlerDestoryException(String arg0, String arg1)  {
    Object [] args = { arg0, arg1 };
    MessageLogger.log(
	"220018",
	args,
	LOCALIZER_CLASS);
    return "220018";
  }




  /**
   * The Web Services server responded with an empty HTTP response. The Content-Length of the response was 0.
   *
   * messageid:  220019
   * severity:   info
   */
  public static String logZeroLengthHttpResponse()  {
    Object [] args = {  };
    MessageLogger.log(
	"220019",
	args,
	LOCALIZER_CLASS);
    return "220019";
  }




  /**
   * The Web Services call to {0}://{1}:{2} received an unexpected end of file (EOF) after reading {3} bytes.
   *
   * messageid:  220020
   * severity:   info
   */
  public static String logUnexpectedEOF(String arg0, String arg1, int arg2, int arg3)  {
    Object [] args = { arg0, arg1, new Integer(arg2), new Integer(arg3) };
    MessageLogger.log(
	"220020",
	args,
	LOCALIZER_CLASS);
    return "220020";
  }




  /**
   * The Web Services call to {0} received an unexpected HTTP version {1}.{2} in the response:{3}.
   *
   * messageid:  220021
   * severity:   info
   */
  public static String logUnexpectedHTTPVersion(String arg0, int arg1, int arg2, String arg3)  {
    Object [] args = { arg0, new Integer(arg1), new Integer(arg2), arg3 };
    MessageLogger.log(
	"220021",
	args,
	LOCALIZER_CLASS);
    return "220021";
  }




  /**
   * Error reading the response from: {0}. Please ensure that this is a valid SOAP response. The message was: \n\n{1}
   *
   * messageid:  220022
   * severity:   info
   */
  public static String logNotSOAPResponse(String arg0, String arg1)  {
    Object [] args = { arg0, arg1 };
    MessageLogger.log(
	"220022",
	args,
	LOCALIZER_CLASS);
    return "220022";
  }




  /**
   * Ignoring an exception in destroy() from Handler: {0}. The exception was:\n{1}.
   *
   * messageid:  220023
   * severity:   info
   */
  public static String logIgnoringDestroyException(String arg0, Throwable arg1)  {
    Object [] args = { arg0, arg1 };
    MessageLogger.log(
	"220023",
	args,
	LOCALIZER_CLASS);
    return "220023";
  }




  /**
   * Handler {0} threw an exception from its handleRequest method. The exception was:\n{1}.
   *
   * messageid:  220024
   * severity:   info
   */
  public static String logExceptionInRequestHandler(String arg0, Throwable arg1)  {
    Object [] args = { arg0, arg1 };
    MessageLogger.log(
	"220024",
	args,
	LOCALIZER_CLASS);
    return "220024";
  }




  /**
   * Handler {0} threw an exception from its handleResponse method. The exception was:\n{1}.
   *
   * messageid:  220025
   * severity:   info
   */
  public static String logExceptionInResponseHandler(String arg0, Throwable arg1)  {
    Object [] args = { arg0, arg1 };
    MessageLogger.log(
	"220025",
	args,
	LOCALIZER_CLASS);
    return "220025";
  }




  /**
   * Handler {0} threw an exception from its handleFault method. The exception was:\n{1}.
   *
   * messageid:  220026
   * severity:   info
   */
  public static String logExceptionInFaultHandler(String arg0, Throwable arg1)  {
    Object [] args = { arg0, arg1 };
    MessageLogger.log(
	"220026",
	args,
	LOCALIZER_CLASS);
    return "220026";
  }




  /**
   * Web Service reliable agents are started on the server.
   *
   * messageid:  220027
   * severity:   info
   */
  public static String logSAFStarted()  {
    Object [] args = {  };
    MessageLogger.log(
	"220027",
	args,
	LOCALIZER_CLASS);
    return "220027";
  }




  /**
   * Web Service reliable agents are suspended.
   *
   * messageid:  220028
   * severity:   info
   */
  public static String logSAFSuspended()  {
    Object [] args = {  };
    MessageLogger.log(
	"220028",
	args,
	LOCALIZER_CLASS);
    return "220028";
  }




  /**
   * Web Service reliable agents are shut down.
   *
   * messageid:  220029
   * severity:   info
   */
  public static String logSAFShutdown()  {
    Object [] args = {  };
    MessageLogger.log(
	"220029",
	args,
	LOCALIZER_CLASS);
    return "220029";
  }




  /**
   * Failed to create Web Service reliable agents. {0}.
   *
   * messageid:  220030
   * severity:   error
   */
  public static String logErrorCreateSAF(Exception arg0)  {
    Object [] args = { arg0 };
    MessageLogger.log(
	"220030",
	args,
	LOCALIZER_CLASS);
    return "220030";
  }




  /**
   * The server does not support reliable SOAP messaging.
   *
   * messageid:  220031
   * severity:   info
   */
  public static String logRDNotSupported()  {
    Object [] args = {  };
    MessageLogger.log(
	"220031",
	args,
	LOCALIZER_CLASS);
    return "220031";
  }




  /**
   * Failed to create MessageContext after a SOAP message is recovered from the storage. {0}.
   *
   * messageid:  220032
   * severity:   error
   */
  public static String logFailedCreateContext(Exception arg0)  {
    Object [] args = { arg0 };
    MessageLogger.log(
	"220032",
	args,
	LOCALIZER_CLASS);
    return "220032";
  }




  /**
   * Failed to access the store for reliable delivery. {0}.
   *
   * messageid:  220033
   * severity:   error
   */
  public static String logFailedAccessStore(Exception arg0)  {
    Object [] args = { arg0 };
    MessageLogger.log(
	"220033",
	args,
	LOCALIZER_CLASS);
    return "220033";
  }




  /**
   * A stack trace associated with message {0} follows: \n
   *
   * messageid:  220034
   * severity:   info
   */
  public static String logStackTrace(String arg0, Throwable arg1)  {
    Object [] args = { arg0, arg1 };
    MessageLogger.log(
	"220034",
	args,
	LOCALIZER_CLASS);
    return "220034";
  }




  /**
   * A naming exception was thrown while obtaining the intial context.
   *
   * messageid:  220035
   * severity:   info
   */
  public static String logJMSTopicNamingException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220035",
	args,
	LOCALIZER_CLASS);
    return "220035";
  }




  /**
   * A exception was thrown while obtaining the JMS connection factory.
   *
   * messageid:  220036
   * severity:   info
   */
  public static String logJMSTopicFactoryException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220036",
	args,
	LOCALIZER_CLASS);
    return "220036";
  }




  /**
   * A exception was thrown while obtaining the JMS initial context.
   *
   * messageid:  220037
   * severity:   info
   */
  public static String logJMSTopicContextException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220037",
	args,
	LOCALIZER_CLASS);
    return "220037";
  }




  /**
   * A exception was thrown from the onMessage JMS.
   *
   * messageid:  220038
   * severity:   info
   */
  public static String logJMSTopicJMSException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220038",
	args,
	LOCALIZER_CLASS);
    return "220038";
  }




  /**
   * A naming exception was thrown from the JMS send message.
   *
   * messageid:  220039
   * severity:   info
   */
  public static String logJMSSendNamingException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220039",
	args,
	LOCALIZER_CLASS);
    return "220039";
  }




  /**
   * A exception was thrown from JMS obtaining the initial factory.
   *
   * messageid:  220040
   * severity:   info
   */
  public static String logJMSSendFactoryException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220040",
	args,
	LOCALIZER_CLASS);
    return "220040";
  }




  /**
   * A exception was thrown from JMS sending to the destination.
   *
   * messageid:  220041
   * severity:   info
   */
  public static String logJMSSendDestinationException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220041",
	args,
	LOCALIZER_CLASS);
    return "220041";
  }




  /**
   * A naming exception was thrown from JMS for this queue.
   *
   * messageid:  220042
   * severity:   info
   */
  public static String logJMSQueueNamingException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220042",
	args,
	LOCALIZER_CLASS);
    return "220042";
  }




  /**
   * An exception was thrown from JMS obtaining the factory.
   *
   * messageid:  220043
   * severity:   info
   */
  public static String logJMSQueueFactoryException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220043",
	args,
	LOCALIZER_CLASS);
    return "220043";
  }




  /**
   * A exception was thrown from JMS locating this queue.
   *
   * messageid:  220044
   * severity:   info
   */
  public static String logJMSQueueLocateException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220044",
	args,
	LOCALIZER_CLASS);
    return "220044";
  }




  /**
   * A exception was thrown getting the conversational state.
   *
   * messageid:  220045
   * severity:   info
   */
  public static String logConversationException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220045",
	args,
	LOCALIZER_CLASS);
    return "220045";
  }




  /**
   * A remote exception was thrown getting the conversational state.
   *
   * messageid:  220046
   * severity:   info
   */
  public static String logConversationRemoteException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220046",
	args,
	LOCALIZER_CLASS);
    return "220046";
  }




  /**
   * A exception was thrown from callReceive in the Client Dispatcher.
   *
   * messageid:  220047
   * severity:   info
   */
  public static String logClientDispatcherException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220047",
	args,
	LOCALIZER_CLASS);
    return "220047";
  }




  /**
   * A exception was thrown from the client handler sending a JAXM message.
   *
   * messageid:  220048
   * severity:   info
   */
  public static String logJAXMClientHandlerException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220048",
	args,
	LOCALIZER_CLASS);
    return "220048";
  }




  /**
   * A SOAP exception was thrown from the client conversation handler.
   *
   * messageid:  220049
   * severity:   info
   */
  public static String logClientConversationSoapException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220049",
	args,
	LOCALIZER_CLASS);
    return "220049";
  }




  /**
   * A SOAP exception was thrown from the server conversation handler.
   *
   * messageid:  220050
   * severity:   info
   */
  public static String logServerConversationSoapException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220050",
	args,
	LOCALIZER_CLASS);
    return "220050";
  }




  /**
   * A SOAP exception was thrown from the Invoke handler.
   *
   * messageid:  220051
   * severity:   info
   */
  public static String logInvokeHandlerSoapException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220051",
	args,
	LOCALIZER_CLASS);
    return "220051";
  }




  /**
   * The target endpoint is a malformed URL.
   *
   * messageid:  220052
   * severity:   info
   */
  public static String logStubImplMalformedURLException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220052",
	args,
	LOCALIZER_CLASS);
    return "220052";
  }




  /**
   * An unexpected exception was caught in the SOAP Envelope InputStream.
   *
   * messageid:  220053
   * severity:   info
   */
  public static String logSoapEnvelopeInputException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220053",
	args,
	LOCALIZER_CLASS);
    return "220053";
  }




  /**
   * An unexpected exception was caught in the SOAP Envelope Reader.
   *
   * messageid:  220054
   * severity:   info
   */
  public static String logSoapEnvelopeReaderException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220054",
	args,
	LOCALIZER_CLASS);
    return "220054";
  }




  /**
   * A parse exception was caught in the SOAP Message content.
   *
   * messageid:  220055
   * severity:   info
   */
  public static String logSoapMessageContentException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220055",
	args,
	LOCALIZER_CLASS);
    return "220055";
  }




  /**
   * A parse exception was caught in the get SOAP Message content.
   *
   * messageid:  220056
   * severity:   info
   */
  public static String logSoapMessageGetContentException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220056",
	args,
	LOCALIZER_CLASS);
    return "220056";
  }




  /**
   * A messaging exception was caught processing MIME SOAP Message content.
   *
   * messageid:  220057
   * severity:   info
   */
  public static String logSoapMessageMimeException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220057",
	args,
	LOCALIZER_CLASS);
    return "220057";
  }




  /**
   * A messaging exception was caught writing MIME SOAP Message content.
   *
   * messageid:  220058
   * severity:   info
   */
  public static String logSoapMessageWriteMimeException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220058",
	args,
	LOCALIZER_CLASS);
    return "220058";
  }




  /**
   * A SOAP header exception was caught in setMustUnderstand.
   *
   * messageid:  220059
   * severity:   info
   */
  public static String logSoapHeaderMustUnderException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220059",
	args,
	LOCALIZER_CLASS);
    return "220059";
  }




  /**
   * A SOAP header exception was caught in setActor.
   *
   * messageid:  220060
   * severity:   info
   */
  public static String logSoapHeaderActorException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220060",
	args,
	LOCALIZER_CLASS);
    return "220060";
  }




  /**
   * A Naming Exception was caught in the deployment descriptor verify.
   *
   * messageid:  220061
   * severity:   info
   */
  public static String logDDverifyStatelessNamingException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220061",
	args,
	LOCALIZER_CLASS);
    return "220061";
  }




  /**
   * A Message Exception was caught in the Image Encoding Codec.
   *
   * messageid:  220062
   * severity:   info
   */
  public static String logImageEncodingMessageException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220062",
	args,
	LOCALIZER_CLASS);
    return "220062";
  }




  /**
   * A IO Exception was caught in the Image Encoding Codec.
   *
   * messageid:  220063
   * severity:   info
   */
  public static String logImageEncodingIOException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220063",
	args,
	LOCALIZER_CLASS);
    return "220063";
  }




  /**
   * A Message Exception was caught in the XML Source Encoding Codec.
   *
   * messageid:  220064
   * severity:   info
   */
  public static String logXMLSourceEncodingMessageException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220064",
	args,
	LOCALIZER_CLASS);
    return "220064";
  }




  /**
   * A IO Exception was caught in the XML Source Encoding Codec.
   *
   * messageid:  220065
   * severity:   info
   */
  public static String logXMLSourceEncodingIOException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220065",
	args,
	LOCALIZER_CLASS);
    return "220065";
  }




  /**
   * An InvalidAttributeValue Exception was caught trying to create the JMS Queue.
   *
   * messageid:  220066
   * severity:   info
   */
  public static String logSAFInvalidAttributeException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220066",
	args,
	LOCALIZER_CLASS);
    return "220066";
  }




  /**
   * A JMS Exception was caught when the listener was being closed.
   *
   * messageid:  220067
   * severity:   info
   */
  public static String logJMSCloseListenerException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220067",
	args,
	LOCALIZER_CLASS);
    return "220067";
  }




  /**
   * A Exception was caught when introspecting the component.
   *
   * messageid:  220068
   * severity:   info
   */
  public static String logComponentIntrospectorException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220068",
	args,
	LOCALIZER_CLASS);
    return "220068";
  }




  /**
   * A Naming Exception was caught trying to locate the JMS transport.
   *
   * messageid:  220069
   * severity:   info
   */
  public static String logJMSListenerNamingException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220069",
	args,
	LOCALIZER_CLASS);
    return "220069";
  }




  /**
   * A JMS Exception was caught trying to create the JMS queue.
   *
   * messageid:  220070
   * severity:   info
   */
  public static String logJMSListenerJMSException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220070",
	args,
	LOCALIZER_CLASS);
    return "220070";
  }




  /**
   * A SOAPException was caught in the onMessage listening to the JMS queue.
   *
   * messageid:  220071
   * severity:   info
   */
  public static String logJMSonMessageSOAPException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220071",
	args,
	LOCALIZER_CLASS);
    return "220071";
  }




  /**
   * An IOException was caught in the onMessage listening to the JMS queue.
   *
   * messageid:  220072
   * severity:   info
   */
  public static String logJMSonMessageIOException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220072",
	args,
	LOCALIZER_CLASS);
    return "220072";
  }




  /**
   * A SOAPException was caught in the servlet base unable to invoke the service.
   *
   * messageid:  220073
   * severity:   info
   */
  public static String logServletBaseSoapException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220073",
	args,
	LOCALIZER_CLASS);
    return "220073";
  }




  /**
   * A SOAPException was caught in the servlet base unable to send to the client.
   *
   * messageid:  220074
   * severity:   info
   */
  public static String logServletBaseSoapSendException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220074",
	args,
	LOCALIZER_CLASS);
    return "220074";
  }




  /**
   * A SOAPException was caught in the servlet base unauthorized to send to the client.
   *
   * messageid:  220075
   * severity:   info
   */
  public static String logServletBaseSoapAuthException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220075",
	args,
	LOCALIZER_CLASS);
    return "220075";
  }




  /**
   * An Exception was caught in the Web Service servlet initialization.
   *
   * messageid:  220076
   * severity:   info
   */
  public static String logWebServiceServletException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220076",
	args,
	LOCALIZER_CLASS);
    return "220076";
  }




  /**
   * An Exception was caught in processing the Web Service deployment descriptor.
   *
   * messageid:  220077
   * severity:   info
   */
  public static String logWebServiceServletDDProcException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220077",
	args,
	LOCALIZER_CLASS);
    return "220077";
  }




  /**
   * An Exception was caught in configuration of the Web Service servlet.
   *
   * messageid:  220078
   * severity:   info
   */
  public static String logWebServiceServletDDConfigException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220078",
	args,
	LOCALIZER_CLASS);
    return "220078";
  }




  /**
   * An Interrupt Exception was caught waiting to send Mail from the queue.
   *
   * messageid:  220079
   * severity:   info
   */
  public static String logMailInterruptedException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220079",
	args,
	LOCALIZER_CLASS);
    return "220079";
  }




  /**
   * An error was reported from the SMTP Gateway.
   *
   * messageid:  220080
   * severity:   info
   */
  public static String logSMTPGatewayError()  {
    Object [] args = {  };
    MessageLogger.log(
	"220080",
	args,
	LOCALIZER_CLASS);
    return "220080";
  }




  /**
   * An IOException was reported from the SMTP quit command.
   *
   * messageid:  220081
   * severity:   info
   */
  public static String logSMTPquitCommandIOException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220081",
	args,
	LOCALIZER_CLASS);
    return "220081";
  }




  /**
   * An IOException was reported from the SMTP process read command.
   *
   * messageid:  220082
   * severity:   info
   */
  public static String logSMTPprocessReadIOException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220082",
	args,
	LOCALIZER_CLASS);
    return "220082";
  }




  /**
   * An IOException was reported from the SMTP process close command.
   *
   * messageid:  220083
   * severity:   info
   */
  public static String logSMTPprocessCloseIOException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220083",
	args,
	LOCALIZER_CLASS);
    return "220083";
  }




  /**
   * A Binding Exception was thrown while trying to generate the implementation class.
   *
   * messageid:  220084
   * severity:   info
   */
  public static String logToolWsdlcClassBindingException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220084",
	args,
	LOCALIZER_CLASS);
    return "220084";
  }




  /**
   * A JAXRPC Exception was thrown while trying to generate the implementation class.
   *
   * messageid:  220085
   * severity:   info
   */
  public static String logToolWsdlcClassJAXRPCException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220085",
	args,
	LOCALIZER_CLASS);
    return "220085";
  }




  /**
   * A IOException was thrown while trying to generate the implementation class.
   *
   * messageid:  220086
   * severity:   info
   */
  public static String logToolWsdlcClassIOException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220086",
	args,
	LOCALIZER_CLASS);
    return "220086";
  }




  /**
   * A Binding Exception was thrown while trying to generate the EJB implementation.
   *
   * messageid:  220087
   * severity:   info
   */
  public static String logToolWsdlcEJBBindingException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220087",
	args,
	LOCALIZER_CLASS);
    return "220087";
  }




  /**
   * A JAXRPC Exception was thrown while trying to generate the EJB implementation.
   *
   * messageid:  220088
   * severity:   info
   */
  public static String logToolWsdlcEJBJAXRPCException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220088",
	args,
	LOCALIZER_CLASS);
    return "220088";
  }




  /**
   * A IOException was thrown while trying to generate the EJB implementation.
   *
   * messageid:  220089
   * severity:   info
   */
  public static String logToolWsdlcEJBIOException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220089",
	args,
	LOCALIZER_CLASS);
    return "220089";
  }




  /**
   * A Binding Exception was thrown while trying to generate the client implementation.
   *
   * messageid:  220090
   * severity:   info
   */
  public static String logToolWsdlcClientBindingException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220090",
	args,
	LOCALIZER_CLASS);
    return "220090";
  }




  /**
   * A JAXRPC Exception was thrown while trying to generate the client implementation.
   *
   * messageid:  220091
   * severity:   info
   */
  public static String logToolWsdlcClientJAXRPCException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220091",
	args,
	LOCALIZER_CLASS);
    return "220091";
  }




  /**
   * A IOException was thrown while trying to generate the client implementation.
   *
   * messageid:  220092
   * severity:   info
   */
  public static String logToolWsdlcClientIOException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220092",
	args,
	LOCALIZER_CLASS);
    return "220092";
  }




  /**
   * A naming exception was thrown while trying to check compliance of the given EJB.
   *
   * messageid:  220093
   * severity:   info
   */
  public static String logComplianceCheckerNamingException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220093",
	args,
	LOCALIZER_CLASS);
    return "220093";
  }




  /**
   * An IOException was thrown trying to access the WSDL at the given URL.
   *
   * messageid:  220094
   * severity:   info
   */
  public static String logDefinitionFactoryIOException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220094",
	args,
	LOCALIZER_CLASS);
    return "220094";
  }




  /**
   * An IOException was thrown converting the file to a string.
   *
   * messageid:  220095
   * severity:   info
   */
  public static String logfileToStringIOException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220095",
	args,
	LOCALIZER_CLASS);
    return "220095";
  }




  /**
   * A naming exception was thrown from JMS for this queue.
   *
   * messageid:  220096
   * severity:   info
   */
  public static String logJMSQueueNamingWarning()  {
    Object [] args = {  };
    MessageLogger.log(
	"220096",
	args,
	LOCALIZER_CLASS);
    return "220096";
  }




  /**
   * An exception was thrown from JMS obtaining the factory.
   *
   * messageid:  220097
   * severity:   info
   */
  public static String logJMSQueueFactoryWarning()  {
    Object [] args = {  };
    MessageLogger.log(
	"220097",
	args,
	LOCALIZER_CLASS);
    return "220097";
  }




  /**
   * An exception was thrown from JMS locating this queue.
   *
   * messageid:  220098
   * severity:   info
   */
  public static String logJMSQueueLocateWarning()  {
    Object [] args = {  };
    MessageLogger.log(
	"220098",
	args,
	LOCALIZER_CLASS);
    return "220098";
  }




  /**
   * Webservice for webapp named {0} contextPath {1} with webservices {2} has been initialized.
   *
   * messageid:  220099
   * severity:   info
   */
  public static String logSuccessfulDeployment(String arg0, String arg1, String arg2)  {
    Object [] args = { arg0, arg1, arg2 };
    MessageLogger.log(
	"220099",
	args,
	LOCALIZER_CLASS);
    return "220099";
  }




  /**
   * An error occurred while registering this webservice for monitoring. Though this does not affect the Webservice itself, monitoring information about it may be unavailable.
   *
   * messageid:  220100
   * severity:   warning
   */
  public static String logManagementException()  {
    Object [] args = {  };
    MessageLogger.log(
	"220100",
	args,
	LOCALIZER_CLASS);
    return "220100";
  }





}
