package eu.europa.ec.publications.esentool.rest.client;

import java.util.Date;

public class SearchNoticeParams {
    private NoticeInformation.NoticeStatus noticeStatus;
    private Date receivedFrom;
    private Date receivedTo;
    private int page = 0;
    private int pageSize = 10;
    private String sort;
    private SortDirection sortDirection = SortDirection.ASC;

    public NoticeInformation.NoticeStatus getNoticeStatus() {
        return noticeStatus;
    }

    public SearchNoticeParams withNoticeStatus(NoticeInformation.NoticeStatus noticeStatus) {
        this.noticeStatus = noticeStatus;
        return this;
    }

    public Date getReceivedFrom() {
        return receivedFrom;
    }

    public SearchNoticeParams withReceivedFrom(Date receivedFrom) {
        this.receivedFrom = receivedFrom;
        return this;
    }

    public Date getReceivedTo() {
        return receivedTo;
    }

    public SearchNoticeParams withReceivedTo(Date receivedTo) {
        this.receivedTo = receivedTo;
        return this;
    }

    public int getPage() {
        return page;
    }

    public SearchNoticeParams withPage(int page) {
        this.page = page;
        return this;
    }

    public int getPageSize() {
        return pageSize;
    }

    public SearchNoticeParams withPageSize(int size) {
        this.pageSize = size;
        return this;
    }

    public String getSort() {
        return sort;
    }

    public SearchNoticeParams withSort(String sort) {
        this.sort = sort;
        return this;
    }

    public SortDirection getSortDirection() {
        return sortDirection;
    }

    public SearchNoticeParams withSortDirection(SortDirection sortDirection) {
        this.sortDirection = sortDirection;
        return this;
    }

    public enum SortDirection {ASC, DESC}
}
