/**
 * Project: ESENTOOL
 * Contractor: ARHS-Developments
 */
package eu.europa.ec.publications.esentool.rest.client;

import java.util.Date;
import java.util.List;

public class NoticeInformation {
    private String submissionId;
    private Date receivedAt;
    private NoticeStatus status;
    private String reasonCode;
    private Date statusUpdatedAt;
    private String noDocExt;
    private String form;
    private List<String> languages;
    private PublicationInfo publicationInfo;
    private ValidationReport technicalValidationReport;
    private ValidationReport validationRulesReport;
    private ValidationReport qualityControlReport;
    private String refSubmissionId;
    private String refNoDocOjs;

    public void setSubmissionId(String submissionId) {
        this.submissionId = submissionId;
    }

    public void setReceivedAt(Date receivedAt) {
        this.receivedAt = receivedAt;
    }

    public void setStatus(NoticeStatus status) {
        this.status = status;
    }

    public void setStatusUpdatedAt(Date statusUpdatedAt) {
        this.statusUpdatedAt = statusUpdatedAt;
    }

    public void setNoDocExt(String noDocExt) {
        this.noDocExt = noDocExt;
    }

    public void setForm(String form) {
        this.form = form;
    }

    public void setLanguages(List<String> languages) {
        this.languages = languages;
    }

    public void setPublicationInfo(PublicationInfo publicationInfo) {
        this.publicationInfo = publicationInfo;
    }

    public void setValidationRulesReport(ValidationReport validationRulesReport) {
        this.validationRulesReport = validationRulesReport;
    }

    public void setQualityControlReport(ValidationReport qualityControlReport) {
        this.qualityControlReport = qualityControlReport;
    }

    public String getSubmissionId() {
        return submissionId;
    }

    public Date getReceivedAt() {
        return receivedAt;
    }

    public NoticeStatus getStatus() {
        return status;
    }

    public Date getStatusUpdatedAt() {
        return statusUpdatedAt;
    }

    public String getNoDocExt() {
        return noDocExt;
    }

    public String getForm() {
        return form;
    }

    public List<String> getLanguages() {
        return languages;
    }

    public PublicationInfo getPublicationInfo() {
        return publicationInfo;
    }

    public ValidationReport getTechnicalValidationReport() {
        return technicalValidationReport;
    }

    public void setTechnicalValidationReport(ValidationReport technicalValidationReport) {
        this.technicalValidationReport = technicalValidationReport;
    }

    public ValidationReport getValidationRulesReport() {
        return validationRulesReport;
    }

    public ValidationReport getQualityControlReport() {
        return qualityControlReport;
    }

    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    public String getReasonCode() {
        return reasonCode;
    }

    public String getRefNoDocOjs() {
        return refNoDocOjs;
    }

    public String getRefSubmissionId() {
        return refSubmissionId;
    }

    public void setRefNoDocOjs(String refNoDocOjs) {
        this.refNoDocOjs = refNoDocOjs;
    }

    public void setRefSubmissionId(String refSubmissionId) {
        this.refSubmissionId = refSubmissionId;
    }

    public enum NoticeStatus {
        RECEIVED,
        RECEPTION_ERROR,
        QUALIFICATION_ERROR,
        VALIDATION_ACCEPTED,
        QUALITY_ACCEPTED,
        QUALITY_SKIPPED,
        IN_PROGRESS,
        PUBLISHED,
        NOT_PUBLISHED,
        WAITING_FOR_INFORMATION;
    }
}
