/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pooling;

import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import oracle.jdbc.pooling.Pool;
import oracle.jdbc.pooling.PoolIterator;
import oracle.jdbc.pooling.PoolIteratorQueue;
import oracle.jdbc.pooling.RevisitQueue;

final class LinkedListPool<T>
implements Pool<T> {
    private final AtomicLong elementsInstantiated = new AtomicLong(0L);
    private long listLength = 1L;
    private final Element listHead = new Element();
    private final AtomicReference<Element> fillRef = new AtomicReference<Element>(this.listHead);

    final long elementsInstantiated() {
        return this.elementsInstantiated.get();
    }

    final long listLength() {
        return this.listLength;
    }

    LinkedListPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T t2) {
        Element element = this.fillRef.get();
        Element element2 = null;
        while (true) {
            if (element.tryReserve()) {
                try {
                    if (element.data == null) {
                        element.data = t2;
                        this.fillRef.set(element);
                        return;
                    }
                }
                finally {
                    element.release();
                }
            }
            if (element.next.get() == null && element2 == null) {
                element2 = new Element(t2);
            }
            if (element.next.compareAndSet(null, element2)) {
                this.fillRef.set(element2);
                ++this.listLength;
                return;
            }
            element = (Element)element.next.get();
        }
    }

    @Override
    public PoolIterator<T> iterator(final boolean bl) {
        final Thread thread = Thread.currentThread();
        return new PoolIterator<T>(){
            volatile Element listElement;
            volatile Element currentElement;
            volatile boolean outerReservation;
            volatile boolean nextReserved;
            final AtomicBoolean released;
            private boolean sleeping;
            private final RevisitQueue<Element> revisitQueue;
            {
                this.listElement = LinkedListPool.this.listHead;
                this.currentElement = null;
                this.outerReservation = false;
                this.nextReserved = false;
                this.released = new AtomicBoolean(false);
                this.sleeping = false;
                this.revisitQueue = new RevisitQueue();
            }

            @Override
            public boolean isAlive() {
                return !this.released.get() && thread.isAlive();
            }

            @Override
            public boolean isSleeping() {
                return this.sleeping;
            }

            private void throwIfWrongThread() {
                if (thread != Thread.currentThread()) {
                    throw new IllegalStateException("PoolIterator has been run by a wrong thread");
                }
            }

            private boolean preReserved(Element element) {
                return element.reserved.get() == Thread.currentThread();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Element reserveNext() {
                while (this.listElement != null) {
                    if (this.listElement.tryReserve()) {
                        if (this.listElement.data != null) {
                            Element element = this.listElement;
                            this.listElement = (Element)this.listElement.next.get();
                            return element;
                        }
                        this.listElement.release();
                    } else if (this.preReserved(this.listElement)) {
                        if (this.listElement.data != null) {
                            Element element = this.listElement;
                            this.listElement = (Element)this.listElement.next.get();
                            this.outerReservation = true;
                            return element;
                        }
                    } else if (bl) {
                        this.listElement.poolIteratorQueue.enqueue(this);
                        this.revisitQueue.enqueue(this.listElement);
                    }
                    this.listElement = (Element)this.listElement.next.get();
                }
                Element element = null;
                Element element2;
                while ((element2 = this.revisitQueue.dequeue()) != null) {
                    if (element2 == element) {
                        element = null;
                        try {
                            this.sleeping = true;
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            this.sleeping = false;
                        }
                    }
                    if (null == element) {
                        element = element2;
                    }
                    if (element2.poolIteratorQueue.peek(this)) {
                        if (element2.tryReserve()) {
                            element2.poolIteratorQueue.disable(this);
                            if (element2.data != null) {
                                return element2;
                            }
                            element2.release();
                            continue;
                        }
                        this.revisitQueue.enqueue(element2);
                        continue;
                    }
                    this.revisitQueue.enqueue(element2);
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                this.throwIfWrongThread();
                if (this.nextReserved) {
                    return true;
                }
                if (this.currentElement != null) {
                    if (this.outerReservation) {
                        this.outerReservation = false;
                    } else {
                        this.currentElement.release();
                    }
                }
                this.nextReserved = (this.currentElement = this.reserveNext()) != null;
                return this.nextReserved;
            }

            @Override
            public T next() {
                this.throwIfWrongThread();
                if (this.hasNext()) {
                    Object t2 = this.currentElement.data;
                    this.nextReserved = false;
                    return t2;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                this.throwIfWrongThread();
                if (this.currentElement != null) {
                    this.currentElement.data = null;
                    if (this.currentElement.id < ((Element)LinkedListPool.this.fillRef.get()).id) {
                        LinkedListPool.this.fillRef.set(this.currentElement);
                    }
                } else {
                    throw new IllegalStateException();
                }
            }

            @Override
            public void release() {
                this.throwIfWrongThread();
                if (this.released.compareAndSet(false, true)) {
                    this.revisitQueue.clear();
                    if (this.currentElement != null) {
                        if (this.outerReservation) {
                            this.outerReservation = false;
                        } else {
                            this.currentElement.release();
                        }
                        this.currentElement = null;
                    }
                }
            }
        };
    }

    private final class Element {
        private final long id;
        private final AtomicReference<Thread> reserved = new AtomicReference<Object>(null);
        private final AtomicReference<Element> next = new AtomicReference<Object>(null);
        volatile T data;
        private final PoolIteratorQueue<T> poolIteratorQueue = new PoolIteratorQueue();

        private Element() {
            this((Object)null);
        }

        private Element(T t2) {
            this.data = t2;
            this.id = LinkedListPool.this.elementsInstantiated.getAndIncrement();
        }

        private boolean tryReserve() {
            return this.reserved.compareAndSet(null, Thread.currentThread());
        }

        private void release() {
            Thread thread = Thread.currentThread();
            if (!this.reserved.compareAndSet(thread, null)) {
                throw new IllegalStateException("element is released by wrong thread: " + thread);
            }
        }
    }
}

